/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.parser;

import java.util.StringTokenizer;
import jd.xml.util.XmlUtil;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xslt.parser.AttributeIterator;
import jd.xml.xslt.parser.PatternParser;
import jd.xml.xslt.parser.XsltParseContext;
import jd.xml.xslt.parser.XsltParseException;

public abstract class Parser {
    protected XsltParseContext context_;
    protected PatternParser patternParser_;

    protected Parser(PatternParser patternParser) {
        this.patternParser_ = patternParser;
        this.context_ = this.patternParser_.getXsltParseContext();
    }

    protected AttributeIterator setCurrentElement(XPathNode xPathNode, boolean bl) throws XsltParseException {
        this.context_.setCurrentElement(xPathNode);
        if (xPathNode == null) {
            return null;
        }
        return new AttributeIterator(this.patternParser_, this.context_, xPathNode.getAttributes(), bl);
    }

    protected AttributeIterator setCurrentElement(XPathNode xPathNode) throws XsltParseException {
        return this.setCurrentElement(xPathNode, true);
    }

    public boolean isStylesheetNode(XPathNode xPathNode) {
        return this.context_.isStylesheetNode(xPathNode);
    }

    protected boolean isStylesheetElement(XPathNode xPathNode) {
        return xPathNode.getType() == 0 && this.isStylesheetNode(xPathNode);
    }

    public boolean isStylesheetElement(XPathNode xPathNode, String string) {
        return this.isStylesheetElement(xPathNode) && xPathNode.getLocalName().equals(string);
    }

    protected XPathNode getStylesheetNode(XPathNode xPathNode) {
        while (xPathNode != null && (xPathNode.getType() == 4 || xPathNode.getType() == 5)) {
            xPathNode = xPathNode.getNextSibling();
        }
        return xPathNode;
    }

    protected XPathNode getFirstStylesheetChild(XPathNode xPathNode) {
        return this.getStylesheetNode(xPathNode.getFirstChild());
    }

    protected XPathNode getNextStylesheetSibling(XPathNode xPathNode) {
        return this.getStylesheetNode(xPathNode.getNextSibling());
    }

    protected void parseExcludeResultPrefixes(XPathNode xPathNode) throws XsltParseException {
        this.context_.setCurrentAttribute(xPathNode);
        StringTokenizer stringTokenizer = new StringTokenizer(xPathNode.getValue());
        while (stringTokenizer.hasMoreTokens()) {
            String string = this.parseNamespacePrefix(stringTokenizer.nextToken());
            this.context_.setExcludedNamespace(string);
        }
        this.context_.setCurrentAttribute(null);
    }

    protected void parseExtensionElementPrefixes(XPathNode xPathNode) throws XsltParseException {
        this.context_.setCurrentAttribute(xPathNode);
        StringTokenizer stringTokenizer = new StringTokenizer(xPathNode.getValue());
        while (stringTokenizer.hasMoreTokens()) {
            String string = this.parseNamespacePrefix(stringTokenizer.nextToken());
            this.context_.setExtensionNamespace(string);
        }
        this.context_.setCurrentAttribute(null);
    }

    protected String parseNamespacePrefix(String string) {
        return string.equals("#default") ? "" : string;
    }

    protected void throwException(String string) throws XsltParseException {
        throw this.context_.createException(string);
    }

    protected void reportMissingAttribute(String string) throws XsltParseException {
        throw this.context_.createException("element has no '" + string + "' attribute");
    }

    protected void reportInvalidChild(XPathNode xPathNode, boolean bl) throws XsltParseException {
        if (this.context_.processForwardsCompatible()) {
            return;
        }
        if (bl && xPathNode.getType() == 1 && XmlUtil.isWhitespaceString(xPathNode.getValue())) {
            return;
        }
        String string = xPathNode.getName();
        if (string == null) {
            string = xPathNode.getValue();
        }
        throw this.context_.createException("invalid child node '" + string + "' for a '" + xPathNode.getParent().getName() + "' element");
    }
}

