# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class KeyCredential(Model):
    """Active Directory Key Credential information.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param start_date: Start date.
    :type start_date: datetime
    :param end_date: End date.
    :type end_date: datetime
    :param value: Key value.
    :type value: str
    :param key_id: Key ID.
    :type key_id: str
    :param usage: Usage. Acceptable values are 'Verify' and 'Sign'.
    :type usage: str
    :param type: Type. Acceptable values are 'AsymmetricX509Cert' and
     'Symmetric'.
    :type type: str
    :param custom_key_identifier: Custom Key Identifier
    :type custom_key_identifier: bytearray
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'start_date': {'key': 'startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'endDate', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'str'},
        'key_id': {'key': 'keyId', 'type': 'str'},
        'usage': {'key': 'usage', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'custom_key_identifier': {'key': 'customKeyIdentifier', 'type': 'bytearray'},
    }

    def __init__(self, **kwargs):
        super(KeyCredential, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.value = kwargs.get('value', None)
        self.key_id = kwargs.get('key_id', None)
        self.usage = kwargs.get('usage', None)
        self.type = kwargs.get('type', None)
        self.custom_key_identifier = kwargs.get('custom_key_identifier', None)
