# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class FacebookPage(Model):
    """A Facebook page for Facebook channel registration.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Page id
    :type id: str
    :param access_token: Required. Facebook application access token. Value
     only returned through POST to the action Channel List API, otherwise
     empty.
    :type access_token: str
    """

    _validation = {
        'id': {'required': True},
        'access_token': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'access_token': {'key': 'accessToken', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FacebookPage, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.access_token = kwargs.get('access_token', None)
