# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DnsConfiguration(Model):
    """DNS configuration for the container group.

    All required parameters must be populated in order to send to Azure.

    :param name_servers: Required. The DNS servers for the container group.
    :type name_servers: list[str]
    :param search_domains: The DNS search domains for hostname lookup in the
     container group.
    :type search_domains: str
    :param options: The DNS options for the container group.
    :type options: str
    """

    _validation = {
        'name_servers': {'required': True},
    }

    _attribute_map = {
        'name_servers': {'key': 'nameServers', 'type': '[str]'},
        'search_domains': {'key': 'searchDomains', 'type': 'str'},
        'options': {'key': 'options', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DnsConfiguration, self).__init__(**kwargs)
        self.name_servers = kwargs.get('name_servers', None)
        self.search_domains = kwargs.get('search_domains', None)
        self.options = kwargs.get('options', None)
