# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AddStorageAccountWithAccountParameters(Model):
    """The parameters used to add a new Azure Storage account while creating a new
    Data Lake Analytics account.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The unique name of the Azure Storage account to
     add.
    :type name: str
    :param access_key: Required. The access key associated with this Azure
     Storage account that will be used to connect to it.
    :type access_key: str
    :param suffix: The optional suffix for the storage account.
    :type suffix: str
    """

    _validation = {
        'name': {'required': True},
        'access_key': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'access_key': {'key': 'properties.accessKey', 'type': 'str'},
        'suffix': {'key': 'properties.suffix', 'type': 'str'},
    }

    def __init__(self, *, name: str, access_key: str, suffix: str=None, **kwargs) -> None:
        super(AddStorageAccountWithAccountParameters, self).__init__(**kwargs)
        self.name = name
        self.access_key = access_key
        self.suffix = suffix
