# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .migrate_schema_sql_server_sql_db_task_output import MigrateSchemaSqlServerSqlDbTaskOutput


class MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel(MigrateSchemaSqlServerSqlDbTaskOutput):
    """MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier
    :vartype id: str
    :param result_type: Required. Constant filled by server.
    :type result_type: str
    :ivar database_name: The name of the database
    :vartype database_name: str
    :ivar state: State of the schema migration for this database. Possible
     values include: 'None', 'InProgress', 'Failed', 'Warning', 'Completed',
     'Skipped', 'Stopped'
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar stage: Schema migration stage for this database. Possible values
     include: 'NotStarted', 'ValidatingInputs', 'CollectingObjects',
     'DownloadingScript', 'GeneratingScript', 'UploadingScript',
     'DeployingSchema', 'Completed', 'CompletedWithWarnings', 'Failed'
    :vartype stage: str or
     ~azure.mgmt.datamigration.models.SchemaMigrationStage
    :ivar started_on: Migration start time
    :vartype started_on: datetime
    :ivar ended_on: Migration end time
    :vartype ended_on: datetime
    :ivar database_error_result_prefix: Prefix string to use for querying
     errors for this database
    :vartype database_error_result_prefix: str
    :ivar schema_error_result_prefix: Prefix string to use for querying schema
     errors for this database
    :vartype schema_error_result_prefix: str
    :ivar number_of_successful_operations: Number of successful operations for
     this database
    :vartype number_of_successful_operations: long
    :ivar number_of_failed_operations: Number of failed operations for this
     database
    :vartype number_of_failed_operations: long
    :ivar file_id: Identifier for the file resource containing the schema of
     this database
    :vartype file_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'database_name': {'readonly': True},
        'state': {'readonly': True},
        'stage': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'database_error_result_prefix': {'readonly': True},
        'schema_error_result_prefix': {'readonly': True},
        'number_of_successful_operations': {'readonly': True},
        'number_of_failed_operations': {'readonly': True},
        'file_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'database_error_result_prefix': {'key': 'databaseErrorResultPrefix', 'type': 'str'},
        'schema_error_result_prefix': {'key': 'schemaErrorResultPrefix', 'type': 'str'},
        'number_of_successful_operations': {'key': 'numberOfSuccessfulOperations', 'type': 'long'},
        'number_of_failed_operations': {'key': 'numberOfFailedOperations', 'type': 'long'},
        'file_id': {'key': 'fileId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel, self).__init__(**kwargs)
        self.database_name = None
        self.state = None
        self.stage = None
        self.started_on = None
        self.ended_on = None
        self.database_error_result_prefix = None
        self.schema_error_result_prefix = None
        self.number_of_successful_operations = None
        self.number_of_failed_operations = None
        self.file_id = None
        self.result_type = 'DatabaseLevelOutput'
