# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ControllerConnectionDetails(Model):
    """ControllerConnectionDetails.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar auth_key: Authentication key for communicating with services.
    :vartype auth_key: str
    :ivar workspace_storage_account_name: Workspace storage account name.
    :vartype workspace_storage_account_name: str
    :ivar workspace_storage_sas_token: Workspace storage account SAS token.
    :vartype workspace_storage_sas_token: str
    :param orchestrator_specific_connection_details:
    :type orchestrator_specific_connection_details:
     ~azure.mgmt.devspaces.models.OrchestratorSpecificConnectionDetails
    """

    _validation = {
        'auth_key': {'readonly': True},
        'workspace_storage_account_name': {'readonly': True},
        'workspace_storage_sas_token': {'readonly': True},
    }

    _attribute_map = {
        'auth_key': {'key': 'authKey', 'type': 'str'},
        'workspace_storage_account_name': {'key': 'workspaceStorageAccountName', 'type': 'str'},
        'workspace_storage_sas_token': {'key': 'workspaceStorageSasToken', 'type': 'str'},
        'orchestrator_specific_connection_details': {'key': 'orchestratorSpecificConnectionDetails', 'type': 'OrchestratorSpecificConnectionDetails'},
    }

    def __init__(self, *, orchestrator_specific_connection_details=None, **kwargs) -> None:
        super(ControllerConnectionDetails, self).__init__(**kwargs)
        self.auth_key = None
        self.workspace_storage_account_name = None
        self.workspace_storage_sas_token = None
        self.orchestrator_specific_connection_details = orchestrator_specific_connection_details
