# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .workflow_parameter_py3 import WorkflowParameter


class WorkflowOutputParameter(WorkflowParameter):
    """The workflow output parameter.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param type: The type. Possible values include: 'NotSpecified', 'String',
     'SecureString', 'Int', 'Float', 'Bool', 'Array', 'Object', 'SecureObject'
    :type type: str or ~azure.mgmt.logic.models.ParameterType
    :param value: The value.
    :type value: object
    :param metadata: The metadata.
    :type metadata: object
    :param description: The description.
    :type description: str
    :ivar error: Gets the error.
    :vartype error: object
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'ParameterType'},
        'value': {'key': 'value', 'type': 'object'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'description': {'key': 'description', 'type': 'str'},
        'error': {'key': 'error', 'type': 'object'},
    }

    def __init__(self, *, type=None, value=None, metadata=None, description: str=None, **kwargs) -> None:
        super(WorkflowOutputParameter, self).__init__(type=type, value=value, metadata=metadata, description=description, **kwargs)
        self.error = None
