# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Encryption(Model):
    """The encryption settings on the storage account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param services: List of services which support encryption.
    :type services: ~azure.mgmt.storage.v2016_01_01.models.EncryptionServices
    :ivar key_source: Required. The encryption keySource (provider). Possible
     values (case-insensitive):  Microsoft.Storage. Default value:
     "Microsoft.Storage" .
    :vartype key_source: str
    """

    _validation = {
        'key_source': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'services': {'key': 'services', 'type': 'EncryptionServices'},
        'key_source': {'key': 'keySource', 'type': 'str'},
    }

    key_source = "Microsoft.Storage"

    def __init__(self, **kwargs):
        super(Encryption, self).__init__(**kwargs)
        self.services = kwargs.get('services', None)
