% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer.R
\name{step_integer}
\alias{step_integer}
\alias{tidy.step_integer}
\title{Convert values to predefined integers}
\usage{
step_integer(recipe, ..., role = "predictor", trained = FALSE,
  strict = FALSE, zero_based = FALSE, key = NULL, skip = FALSE,
  id = rand_id("integer"))

\method{tidy}{step_integer}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables will be used to create the integer variables. See
\code{\link[=selections]{selections()}} for more details. For the \code{tidy} method, these
are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be
used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{strict}{A logical for whether the values should be returned as
integers (as opposed to double).}

\item{zero_based}{A logical for whether the integers should start at zero and
new values be appended as the largest integer.}

\item{key}{A list that contains the information needed to
create integer variables for each variable contained in
\code{terms}. This is \code{NULL} until the step is trained by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_integer} object.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any). For the \code{tidy}
method, a tibble with columns \code{terms} (the selectors or
variables selected) and \code{value} is a \emph{list column} with the
conversion key.
}
\description{
\code{step_integer} creates a a \emph{specification} of a recipe
step that will convert new data into a set of integers based
on the original data values.
}
\details{
\code{step_integer} will determine the unique values of
each variable from the training set (excluding missing values),
order them, and then assign integers to each value. When baked,
each data point is translated to its corresponding integer or a
value of zero for yet unseen data (although see the \code{zero_based}
argument above). Missing values propagate.

Factor inputs are ordered by their levels. All others are
ordered by \code{sort}.

Despite the name, the new values are returned as numeric unless
\code{strict = TRUE}, which will coerce the results to integers.
}
\examples{
data(okc)

okc$location <- factor(okc$location)

okc_tr <- okc[1:100, ]
okc_tr$age[1] <- NA

okc_te <- okc[101:105, ]
okc_te$age[1] <- NA
okc_te$diet[1] <- "fast food"
okc_te$diet[2] <- NA

rec <- recipe(Class ~ ., data = okc_tr) \%>\%
  step_integer(all_predictors()) \%>\%
  prep(training = okc_tr, retain = TRUE)

bake(rec, okc_te, all_predictors())
tidy(rec, number = 1)
}
\seealso{
\code{\link[=step_factor2string]{step_factor2string()}}, \code{\link[=step_string2factor]{step_string2factor()}},
\code{\link[=step_regex]{step_regex()}}, \code{\link[=step_count]{step_count()}},
\code{\link[=step_ordinalscore]{step_ordinalscore()}}, \code{\link[=step_unorder]{step_unorder()}}, \code{\link[=step_other]{step_other()}}
\code{\link[=step_novel]{step_novel()}}, \code{\link[=step_dummy]{step_dummy()}}
}
\concept{preprocessing variable_encodings}
\keyword{datagen}
