% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repair-names.R
\name{tidy_names}
\alias{tidy_names}
\alias{set_tidy_names}
\alias{repair_names}
\title{Retired functions for name repair}
\usage{
tidy_names(name, syntactic = FALSE, quiet = FALSE)

set_tidy_names(x, syntactic = FALSE, quiet = FALSE)

repair_names(x, prefix = "V", sep = "")
}
\arguments{
\item{name}{A \code{names} attribute, usually a character vector.}

\item{syntactic}{Should names be made syntactically valid? If \code{FALSE}, uses
same logic as \code{.name_repair = "unique"}. If \code{TRUE}, uses same logic as
\code{.name_repair = "universal"}.}

\item{quiet}{Whether to suppress messages about name repair.}

\item{x}{A vector.}

\item{prefix}{A string, the prefix to use for new column names.}

\item{sep}{A string inserted between the column name and de-duplicating
number.}
}
\value{
\code{x} with repaired names or a repaired version of \code{name}.
}
\description{
\Sexpr[results=rd, stage=render]{tibble:::lifecycle("soft-deprecated")}

\code{tidy_names()}, \code{set_tidy_names()}, and \code{repair_names()} were early efforts
to facilitate \emph{post hoc} name repair in tibble, given that \code{\link[=tibble]{tibble()}} and
\code{\link[=as_tibble]{as_tibble()}} did not do this.

From tibble v2.0.0, the \code{.name_repair} argument gives direct access to three
specific levels of name repair: \code{minimal}, \code{unique}, and \code{universal}. We
recommend that new code use this instead of \code{tidy_names()},
\code{set_tidy_names()}, or \code{repair_names()}. After a period of use, the repair
stategies behind \code{minimal}, \code{unique}, and \code{universal} are likely to be
exposed in standalone functions and this could affect the behaviour of
\code{tidy_names()}. \code{repair_names()} should be considered deprecated.\preformatted{tibble(..., `.name_repair = "unique"`)
## is preferred to
df <- tibble(...)
set_tidy_names(df, syntactic = FALSE)

tibble(..., `.name_repair = "universal"`)
## is preferred to
df <- tibble(...)
set_tidy_names(df, syntactic = TRUE)
}
}
\keyword{internal}
