#include "tb_donwload_task_status.h"
#include <QSqlDatabase>
#include <QDebug>
#include <QtSql/qsqlquery.h>
#include <QSqlError>

extern QSqlDatabase database ;

Tb_Donwload_Task_Status::Tb_Donwload_Task_Status()
{

}
Tb_Donwload_Task_Status::Tb_Donwload_Task_Status(QString task_id,int download_status,QDateTime modify_time,QString compeletedLength, QString download_speed,QString totalLength,int percent,int totalFromSource ,QDateTime finish_time)
{
    this->task_id = task_id;
    this->download_status = download_status;
    this->modify_time.setDate(modify_time.date());
    this->modify_time.setTime(modify_time.time());
    this->compeletedLength = compeletedLength ;
    this->download_speed = download_speed;
    this->totalLength = totalLength;
    if(percent < 0 || percent > 100 )
    {
        this->percent  = 0;
    }
    else
    {
        this->percent = percent;
    }
    this->totalFromSource = totalFromSource;
    this->finish_time = finish_time;
}

//添加任务
bool Tb_Donwload_Task_Status::addTbDownloadTaskStatus(Tb_Donwload_Task_Status * task_status)
{
    if(database.open())
    {
        QSqlQuery sql_query;

        sql_query.prepare("insert into download_task_status values (?,?,?,?,?,?,?,?,?);");

        sql_query.addBindValue(task_status->task_id);
        sql_query.addBindValue(task_status->download_status);
        sql_query.addBindValue(task_status->modify_time);
        sql_query.addBindValue(task_status->compeletedLength);
        sql_query.addBindValue(task_status->download_speed);
        sql_query.addBindValue(task_status->totalLength);
        sql_query.addBindValue(task_status->percent);
        sql_query.addBindValue(task_status->totalFromSource);
        sql_query.addBindValue(task_status->finish_time);


        if(!sql_query.exec())
        {
            QSqlError error = sql_query.lastError();
            qWarning()<<"insert download_task_status failed : " << sql_query.lastError();
            database.close();
            return false;
        }
        database.close();
        sql_query.clear();
        return true;
    }

    return false;

}
//更新任务状态表通过task_id
bool Tb_Donwload_Task_Status::updateTbDownloadStatusByTaskId(Tb_Donwload_Task_Status *task_status)
{
    if(database.open())
    {
        QSqlQuery sql_query;

        sql_query.prepare("update  download_task_status set  download_status=? , modify_time=? ,compeletedLength=? , download_speed=? , totalLength=? ,percent=? , totalFromSource=? ,finish_time=? where task_id= ?");

        sql_query.addBindValue(task_status->download_status);
        sql_query.addBindValue(task_status->modify_time);
        sql_query.addBindValue(task_status->compeletedLength);
        sql_query.addBindValue(task_status->download_speed);
        sql_query.addBindValue(task_status->totalLength);
        sql_query.addBindValue(task_status->percent);
        sql_query.addBindValue(task_status->totalFromSource);
        sql_query.addBindValue(task_status->finish_time);
        sql_query.addBindValue(task_status->task_id);


        if(!sql_query.exec())
        {
            qWarning()<<"update download_task_status failed : " << sql_query.lastError();
            database.close();
            return false;
        }
        database.close();
        sql_query.clear();
        return true;
    }

    return false;
}


Tb_Donwload_Task_Status * Tb_Donwload_Task_Status::getTbDownloadStatusByTaskId(QString task_id)
{
    Tb_Donwload_Task_Status * tb_task_status =NULL;
    if(database.open())
    {
        QString select_all_sql = "select * from download_task_status where task_id='"+task_id+"';";
        QSqlQuery sql_query;
        sql_query.prepare(select_all_sql);
        if(!sql_query.exec())
        {
            qWarning()<<"update download_task_status failed : " << sql_query.lastError();
            return NULL;
        }
        else
        {

            while(sql_query.next())
            {

                QString task_id = sql_query.value(0).toString();
                int download_status = sql_query.value(1).toInt(); //下载状态
                QDateTime modify_time = sql_query.value(2).toDateTime();
                QString compeletedLength = sql_query.value(3).toString();
                QString download_speed = sql_query.value(4).toString();
                QString totalLength = sql_query.value(5).toString();
                int percent = sql_query.value(6).toInt();
                int totalFromSource = sql_query.value(7).toInt();
                QDateTime finish_time = sql_query.value(8).toDateTime();

                tb_task_status = new Tb_Donwload_Task_Status( task_id,download_status ,modify_time,compeletedLength,download_speed,totalLength,percent,totalFromSource,finish_time);

            }
            database.close();
            sql_query.clear();

            return tb_task_status;

        }
    }
    return NULL;
}

//获取所有任务状态信息
 QList<Tb_Donwload_Task_Status *> Tb_Donwload_Task_Status::getAllTbDownloadTaskStatus()
 {
      QList<Tb_Donwload_Task_Status *> list;
      if(!database.open())
      {

              qWarning()<<"get all download_task_status failed : " << database.lastError();
              qFatal("database failed to connect.") ;

              return list;
      }
      else
      {
          QString select_all_sql = "select * from download_task_status;";
          QSqlQuery sql_query;
          sql_query.prepare(select_all_sql);
          if(!sql_query.exec())
          {
              qWarning()<<"get all download_task_status failed : " << sql_query.lastError();
              return list;
          }
          else
          {
              while(sql_query.next())
              {

                  QString task_id = sql_query.value(0).toString();
                  int download_status = sql_query.value(1).toInt(); //下载状态
                  QDateTime modify_time  = sql_query.value(2).toDateTime();
                  QString compeletedLength = sql_query.value(3).toString();
                  QString download_speed = sql_query.value(4).toString();
                  QString totalLength = sql_query.value(5).toString();
                  int percent = sql_query.value(6).toInt();
                  int totalFromSource = sql_query.value(7).toInt();
                  QDateTime finish_time = sql_query.value(8).toDateTime();


                  Tb_Donwload_Task_Status * tb_task_status = new Tb_Donwload_Task_Status( task_id,download_status ,modify_time,compeletedLength,download_speed,totalLength,percent,totalFromSource,finish_time);

                  list.append(tb_task_status);
              }
          }

          database.close();
          sql_query.clear();

          return list;
      }
 }

  bool Tb_Donwload_Task_Status::deleteTbTaskStauts(QString task_id)
  {
          bool status = true;
          if(database.open())
          {
              QSqlQuery sql_query;

              sql_query.prepare("delete  from download_task_status where task_id=? ;");

              sql_query.addBindValue(task_id);

              if(!sql_query.exec())
              {
                  QSqlError error = sql_query.lastError();

                  qWarning()<<"delete download_task_status failed : " << sql_query.lastError();

                  status = false;

              }

              sql_query.clear();
              sql_query.prepare("delete  from download_task where task_id=? ;");
              sql_query.addBindValue(task_id);
              if(!sql_query.exec())
              {
                  QSqlError error = sql_query.lastError();


                  status = false;


              }
              database.close();
              sql_query.clear();

          }

          return status;

  }

bool Tb_Donwload_Task_Status::deleteAllTbTaskStatus()
{
    if(database.open())
    {
        QSqlQuery sql_query;

        sql_query.prepare("delete  from download_task_status ;");

        if(!sql_query.exec())
        {
            qWarning()<<"delete download_task_status failed : " << sql_query.lastError();

            database.close();
            return false;
        }
        database.close();
        sql_query.clear();
        return true;
    }

return false;
}

