#include "deleteitemthread.h"
#include <QDebug>
#include <QFile>
#include <QDir>

DeleteItemThread::DeleteItemThread()
{

}

DeleteItemThread::DeleteItemThread(QList<DelDataItem>recycle_delete_list,TableView *recycle_tableview,Aria2cInterface *aria2c,bool ifDeleteLocal,QString deleteType)
{
    this->recycle_delete_list = recycle_delete_list;
    this->recycle_tableview = recycle_tableview;
    this->aria2c = aria2c;
    this->ifDeleteLocal = ifDeleteLocal;
    this->deleteType = deleteType;
}
DeleteItemThread::DeleteItemThread( QList<DataItem> delete_list,TableView *downloading_tableview,Aria2cInterface *aria2c ,bool ifDeleteLocal,QString deleteType)
{
    this->delete_list = delete_list;
    this->downloading_tableview = downloading_tableview;
    this->aria2c = aria2c;
    this->ifDeleteLocal = ifDeleteLocal;
    this->deleteType = deleteType;
}

//删除文件夹
bool DeleteItemThread::DelDir(const QString &path)
{
    if (path.isEmpty()){
        return false;
    }
    QDir dir(path);
    if(!dir.exists()){
        return true;
    }
    dir.setFilter(QDir::AllEntries | QDir::NoDotAndDotDot); //设置过滤
    QFileInfoList fileList = dir.entryInfoList(); // 获取所有的文件信息
    foreach (QFileInfo file, fileList){ //遍历文件信息
        if (file.isFile()){ // 是文件，删除
            file.dir().remove(file.fileName());
        }else{ // 递归删除
            DelDir(file.absoluteFilePath());
        }
    }
    return dir.rmpath(dir.absolutePath()); // 删除文件夹
}

void DeleteItemThread::delete_recycle_data()
{
    for(int i=0;i<recycle_delete_list.size();i++)
    {

         QString save_path= recycle_delete_list.at(i).savePath;
         QString gid = recycle_delete_list.at(i).gid;
         QString taskId = recycle_delete_list.at(i).taskId;
         QString filename = recycle_delete_list.at(i).fileName;


         if(ifDeleteLocal)
         {
              if(save_path!="")
              {
                  QFileInfo fileinfo(save_path);
                  if(fileinfo.isDir() && save_path.contains(filename) && ! filename.isEmpty())
                  {
                      QDir tar(recycle_delete_list.at(i).savePath);
                      tar.removeRecursively();
                  }
                  else
                  {
                      QString aria_temp_file=save_path+".aria2";
                      if(!save_path.isEmpty())
                      {
                          QFile::remove(save_path);
                          if(QFile::exists(aria_temp_file))
                          {
                              QThread::sleep(1);
                              QFile::remove(aria_temp_file);
                          }
                      }
                  }
              }

         }
     }
}
void DeleteItemThread::delete_download_data()
{
     for(int i = 0; i < delete_list.size(); ++i)
     {
          QString gid = delete_list.at(i).gid;
          QString task_id = delete_list.at(i).taskId;
          QString save_path = delete_list.at(i).savePath;
          QString filename = delete_list.at(i).fileName;
          emit signal_aria2_remove(delete_list.at(i).gid, "");

         if(ifDeleteLocal)
         {
             aria2c->pause(gid,task_id);

             if(save_path != "")
             {
                 QFileInfo fileinfo(save_path);
                 if(fileinfo.isDir() && save_path.contains(filename) && ! filename.isEmpty())
                 {
                     QDir tar(save_path);
                     tar.removeRecursively();
                 }
                 else
                 {
                     QString aria_temp_file=save_path+".aria2";
                      if(!save_path.isEmpty())
                       {

                            QFile::remove(save_path);
                            if(QFile::exists(aria_temp_file))
                            {
                                QThread::sleep(1);
                                 QFile::remove(aria_temp_file);

                             }

                        }
                 }

             }

         }


         //aria2c->remove(data->gid);

     }
}
void DeleteItemThread::run()
{
    if(deleteType == "recycle_delete")
    {
        delete_recycle_data();
    }
    if(deleteType == "download_delete")
    {
        delete_download_data();
    }

}

