/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DTK_SCREEN_ACE_H
#define DTK_SCREEN_ACE_H

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <stdint.h>

/*! \file dtk_screen_ace.h */

/*! \class PolkitProhibitedDBus
 *  \brief set window be protected or not(either root window) by dbus
 *  \author xinbo wang
 *  \date 2023
 */

#ifdef __cplusplus
extern "C" {
#endif

typedef int (*InitBackendPtr)();
typedef void (*DestroyBackendPtr)();
typedef bool (*SetProtectedWindowPtr)(int32_t /*window*/);
typedef bool (*RemoveProtectedWindowPtr)(int32_t /*window*/);
typedef bool (*SetScreenShotToolsPtr)(const char* /*name*/);
typedef bool (*RemoveScreenShotToolsPtr)(char* /*name*/);
typedef void (*FreeScreenShotToolsPtr)();
typedef void (*SetProhibitedPtr)(const char* /*white_lists*/, bool /*prohibit*/);

typedef struct _Screen_Ace {
    void *backend;
    bool isWayland;
    char *xdgSessionType;

    // init and destory
    InitBackendPtr InitBackend;
    DestroyBackendPtr DestroyBackend;

    SetProtectedWindowPtr SetProtectedWindow;
    RemoveProtectedWindowPtr RemoveProtectedWindow;
    SetScreenShotToolsPtr SetScreenShotTools;
    RemoveScreenShotToolsPtr RemoveScreenShotTools;
    FreeScreenShotToolsPtr FreeScreenShotTools;
    SetProhibitedPtr SetProhibited;
} ScreenAce;

typedef struct _Screen_Ace *ScreenAcePtr;
extern ScreenAcePtr pScreenAce;

/**
 * @brief init dtkdisplay content
 */
int InitDtkDisplay();

/**
 * @brief destory dtkdisplay content
 */
void DestoryDtkDisplay();

/**
 * @brief set protected windowid to prohibit screenshot
 * @param window: window id
 * @return true: success
 */
bool SetProtectedWindow(int32_t window);

/**
 * @brief remove protected windowid to enable screenshot
 * @param window: window id
 * @return true: success
 */
bool RemoveProtectedWindow(int32_t window);

/**
 * @brief set screenshot tools blacklist
 * @param name: blacklist
 * @return true: success
 */
bool SetScreenShotTools(const char *name);

/**
 * @brief remove screenshot tools blacklist
 * @param name: blacklist
 * @return true: success
 */
bool RemoveScreenShotTools(char *name);

/**
 * @brief free screenshot tools pointer
 */
void FreeScreenShotTools();

/**
 * @brief set prohibited
 */
void SetProhibited(const char* white_lists, bool prohibit);

#ifdef __cplusplus
}
#endif

#endif
