<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Contact/RelationshipCache.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:9170513963860f5b9cadce190a68b8bf)
 */

/**
 * Database access object for the RelationshipCache entity.
 */
class CRM_Contact_DAO_RelationshipCache extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '5.29';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_relationship_cache';

  /**
   * Icon associated with this entity.
   *
   * @var string
   */
  public static $_icon = 'fa-handshake-o';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/contact/view/rel?cid=[near_contact_id]&action=add&reset=1',
    'view' => 'civicrm/contact/view/rel?action=view&reset=1&cid=[near_contact_id]&id=[relationship_id]',
    'update' => 'civicrm/contact/view/rel?action=update&reset=1&cid=[near_contact_id]&id=[relationship_id]&rtype=[orientation]',
    'delete' => 'civicrm/contact/view/rel?action=delete&reset=1&cid=[near_contact_id]&id=[relationship_id]',
  ];

  /**
   * Relationship Cache ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * id of the relationship (FK to civicrm_relationship.id)
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $relationship_id;

  /**
   * id of the relationship type
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $relationship_type_id;

  /**
   * The cache record is a permutation of the original relationship record. The orientation indicates whether it is forward (a_b) or reverse (b_a) relationship.
   *
   * @var string
   *   (SQL type: char(3))
   *   Note that values will be retrieved from the database as a string.
   */
  public $orientation;

  /**
   * id of the first contact
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $near_contact_id;

  /**
   * name for relationship of near_contact to far_contact.
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $near_relation;

  /**
   * id of the second contact
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $far_contact_id;

  /**
   * name for relationship of far_contact to near_contact.
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $far_relation;

  /**
   * is the relationship active ?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * date when the relationship started
   *
   * @var string|null
   *   (SQL type: date)
   *   Note that values will be retrieved from the database as a string.
   */
  public $start_date;

  /**
   * date when the relationship ended
   *
   * @var string|null
   *   (SQL type: date)
   *   Note that values will be retrieved from the database as a string.
   */
  public $end_date;

  /**
   * FK to civicrm_case
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $case_id;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_relationship_cache';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Related Contacts') : ts('Related Contact');
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'relationship_id', 'civicrm_relationship', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'relationship_type_id', 'civicrm_relationship_type', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'near_contact_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'far_contact_id', 'civicrm_contact', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'case_id', 'civicrm_case', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Relationship Cache ID'),
          'description' => ts('Relationship Cache ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.id',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'relationship_id' => [
          'name' => 'relationship_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Relationship ID'),
          'description' => ts('id of the relationship (FK to civicrm_relationship.id)'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.relationship_id',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Relationship',
          'html' => [
            'label' => ts("Relationship"),
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'relationship_type_id' => [
          'name' => 'relationship_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Relationship Type ID'),
          'description' => ts('id of the relationship type'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.relationship_type_id',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_RelationshipType',
          'html' => [
            'label' => ts("Relationship Type"),
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'orientation' => [
          'name' => 'orientation',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Orientation (a_b or b_a)'),
          'description' => ts('The cache record is a permutation of the original relationship record. The orientation indicates whether it is forward (a_b) or reverse (b_a) relationship.'),
          'required' => TRUE,
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.orientation',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::relationshipOrientation',
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'near_contact_id' => [
          'name' => 'near_contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID (Near side)'),
          'description' => ts('id of the first contact'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.near_contact_id',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Contact (Near side)"),
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'near_relation' => [
          'name' => 'near_relation',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Relationship Name (to related contact)'),
          'description' => ts('name for relationship of near_contact to far_contact.'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.near_relation',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Relationship to contact"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_PseudoConstant::relationshipTypeOptions',
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'far_contact_id' => [
          'name' => 'far_contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID (Far side)'),
          'description' => ts('id of the second contact'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.far_contact_id',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Contact (Far side)"),
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'far_relation' => [
          'name' => 'far_relation',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Relationship Name (from related contact)'),
          'description' => ts('name for relationship of far_contact to near_contact.'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.far_relation',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Relationship from contact"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_PseudoConstant::relationshipTypeOptions',
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Relationship Is Active'),
          'description' => ts('is the relationship active ?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.is_active',
          'default' => '1',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'relationship_start_date' => [
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Relationship Start Date'),
          'description' => ts('date when the relationship started'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.start_date',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDate',
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'relationship_end_date' => [
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Relationship End Date'),
          'description' => ts('date when the relationship ended'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.end_date',
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDate',
          ],
          'readonly' => TRUE,
          'add' => '5.29',
        ],
        'case_id' => [
          'name' => 'case_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Case ID'),
          'description' => ts('FK to civicrm_case'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_relationship_cache.case_id',
          'default' => NULL,
          'table_name' => 'civicrm_relationship_cache',
          'entity' => 'RelationshipCache',
          'bao' => 'CRM_Contact_BAO_RelationshipCache',
          'localizable' => 0,
          'FKClassName' => 'CRM_Case_DAO_Case',
          'component' => 'CiviCase',
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Case"),
          ],
          'readonly' => TRUE,
          'add' => '5.44',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'relationship_cache', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'relationship_cache', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_relationship' => [
        'name' => 'UI_relationship',
        'field' => [
          0 => 'relationship_id',
          1 => 'orientation',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_relationship_cache::1::relationship_id::orientation',
      ],
      'index_nearid_nearrelation' => [
        'name' => 'index_nearid_nearrelation',
        'field' => [
          0 => 'near_contact_id',
          1 => 'near_relation',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_relationship_cache::0::near_contact_id::near_relation',
      ],
      'index_nearid_farrelation' => [
        'name' => 'index_nearid_farrelation',
        'field' => [
          0 => 'near_contact_id',
          1 => 'far_relation',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_relationship_cache::0::near_contact_id::far_relation',
      ],
      'index_near_relation' => [
        'name' => 'index_near_relation',
        'field' => [
          0 => 'near_relation',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_relationship_cache::0::near_relation',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
