/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "dtk_screen_ace.h"
#include "dtk_screenace_wayland.h"
#include "dtk_screenace_x11.h"
#include <X11/Xlib.h>
#include <X11/X.h>
#include "uace/src/ext/uaceExt.h"

#include "log.h"

#include <string.h>

ScreenAcePtr pScreenAce;

bool isWaylandSession()
{
    if (!pScreenAce)
        return pScreenAce->isWayland;

    return false;
}

int InitDtkDisplay()
{
    pScreenAce = (ScreenAcePtr)malloc(sizeof(ScreenAce));
    memset(pScreenAce, 0, sizeof(ScreenAce));

    if (!pScreenAce) {
        log_error("malloc dnd security failed \n");
        return -1;
    }

    if (!pScreenAce->xdgSessionType) {
        pScreenAce->xdgSessionType = getenv("XDG_SESSION_TYPE");
        pScreenAce->isWayland = (pScreenAce->xdgSessionType && strcmp(pScreenAce->xdgSessionType, "wayland") == 0 ? true : false);
    }

    if(pScreenAce->isWayland) {
        log_debug("current enviroment is wayland");
        pScreenAce->InitBackend             = initWaylandScreenAce;
        pScreenAce->DestroyBackend          = destoryWaylandScreenAce;
        pScreenAce->SetProtectedWindow      = wSetProtectedWindow;
        pScreenAce->RemoveProtectedWindow   = wRemoveProtectedWindow;
        pScreenAce->SetScreenShotTools      = wSetScreenShotTools;
        pScreenAce->RemoveScreenShotTools   = wRemoveScreenShotTools;
        pScreenAce->FreeScreenShotTools     = wFreeScreenShotTools;
        pScreenAce->SetProhibited           = wSetProhibited;
    } else {
        log_debug("current enviroment is x11");
        pScreenAce->InitBackend             = initX11ScreenAce;
        pScreenAce->DestroyBackend          = destoryX11ScreenAce;
        pScreenAce->SetProtectedWindow      = xSetProtectedWindow;
        pScreenAce->RemoveProtectedWindow   = xRemoveProtectedWindow;
        pScreenAce->SetScreenShotTools      = xSetScreenShotTools;
        pScreenAce->RemoveScreenShotTools   = xRemoveScreenShotTools;
        pScreenAce->FreeScreenShotTools     = xFreeScreenShotTools;
        pScreenAce->SetProhibited           = xSetProhibited;
    }

    return pScreenAce->InitBackend();
}

void DestoryDtkDisplay()
{
    if (!pScreenAce) {
        log_error("dnd security has been destroyed \n");
        return;
    }

    pScreenAce->DestroyBackend();
    free(pScreenAce);
    memset(pScreenAce, 0, sizeof(ScreenAce));
}

bool SetProtectedWindow(int32_t window)
{
    return pScreenAce->SetProtectedWindow(window);
}

bool RemoveProtectedWindow(int32_t window)
{
    return pScreenAce->RemoveProtectedWindow(window);
}


bool SetScreenShotTools(const char *name)
{
    return pScreenAce->SetScreenShotTools(name);
}

bool RemoveScreenShotTools(char *name)
{
    return pScreenAce->RemoveScreenShotTools(name);
}

void FreeScreenShotTools()
{
    pScreenAce->FreeScreenShotTools();
}

void SetProhibited(const char* white_lists, bool prohibit)
{
    pScreenAce->SetProhibited(white_lists, prohibit);
}