/*
 * Copyright (C) 2022 ~ 2024 Deepin Technology Co., Ltd.
 *
 * Author:     xupeidong <xupeidong@uniontech.com>
 *
 * Maintainer: xupeidong <xupeidong@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef DEEPINWATERMARK_H
#define DEEPINWATERMARK_H

#include "watermark.h"
class DeepinWatermark : public QObject
{
    Q_OBJECT

public:
    explicit DeepinWatermark();
    ~DeepinWatermark();

private:
    bool m_isCompositor{false};
    Watermark *m_watermark{nullptr};
    QList<Watermark *> m_watermarkList;
    QSet<QString> m_whiteProcess;
private:
    void releaseWatermarks();
    void resetWaterMarkArea();
    void readConfig();
    void writeConfig();
    bool isValidInvoker(const uint &pid);
public:
    void setScreenWatermark(const QString &strPolicy);
    bool watermarkStatus() const;
    void clearConfig();
    bool isAccessible(const uint pid);
    void initConfig();

private Q_SLOTS:
    void compositingSetup();
    void compositingToggled(bool active);
    void desktopResize(QRect rect);
    void displayMode(QRect rect);
    void displayProperty(QString type, QVariantMap map, QStringList list);

private:
    bool m_isAvailabeWaterMark = true;
    bool m_isReset = false;
    QTimer *m_showTimer;
};

#endif // DEEPINWATERMARK_H
