/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// ResourceReference struct for ResourceReference
type ResourceReference struct {
	// The resource's unique identifier.
	Id *string `json:"id"`
	// The type of object that has been created.
	Type *Type `json:"type,omitempty"`
	// URL to the object representation (absolute path).
	Href *string `json:"href,omitempty"`
}

// NewResourceReference instantiates a new ResourceReference object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewResourceReference(id string) *ResourceReference {
	this := ResourceReference{}

	this.Id = &id

	return &this
}

// NewResourceReferenceWithDefaults instantiates a new ResourceReference object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewResourceReferenceWithDefaults() *ResourceReference {
	this := ResourceReference{}
	return &this
}

// GetId returns the Id field value
// If the value is explicit nil, nil is returned
func (o *ResourceReference) GetId() *string {
	if o == nil {
		return nil
	}

	return o.Id

}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceReference) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Id, true
}

// SetId sets field value
func (o *ResourceReference) SetId(v string) {

	o.Id = &v

}

// HasId returns a boolean if a field has been set.
func (o *ResourceReference) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// GetType returns the Type field value
// If the value is explicit nil, nil is returned
func (o *ResourceReference) GetType() *Type {
	if o == nil {
		return nil
	}

	return o.Type

}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceReference) GetTypeOk() (*Type, bool) {
	if o == nil {
		return nil, false
	}

	return o.Type, true
}

// SetType sets field value
func (o *ResourceReference) SetType(v Type) {

	o.Type = &v

}

// HasType returns a boolean if a field has been set.
func (o *ResourceReference) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

// GetHref returns the Href field value
// If the value is explicit nil, nil is returned
func (o *ResourceReference) GetHref() *string {
	if o == nil {
		return nil
	}

	return o.Href

}

// GetHrefOk returns a tuple with the Href field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceReference) GetHrefOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Href, true
}

// SetHref sets field value
func (o *ResourceReference) SetHref(v string) {

	o.Href = &v

}

// HasHref returns a boolean if a field has been set.
func (o *ResourceReference) HasHref() bool {
	if o != nil && o.Href != nil {
		return true
	}

	return false
}

func (o ResourceReference) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}

	if o.Type != nil {
		toSerialize["type"] = o.Type
	}

	if o.Href != nil {
		toSerialize["href"] = o.Href
	}

	return json.Marshal(toSerialize)
}

type NullableResourceReference struct {
	value *ResourceReference
	isSet bool
}

func (v NullableResourceReference) Get() *ResourceReference {
	return v.value
}

func (v *NullableResourceReference) Set(val *ResourceReference) {
	v.value = val
	v.isSet = true
}

func (v NullableResourceReference) IsSet() bool {
	return v.isSet
}

func (v *NullableResourceReference) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableResourceReference(val *ResourceReference) *NullableResourceReference {
	return &NullableResourceReference{value: val, isSet: true}
}

func (v NullableResourceReference) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableResourceReference) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
