import {styleTags, tags as t} from "@lezer/highlight"

export const phpHighlighting = styleTags({
  "Visibility abstract final static": t.modifier,
  "for foreach while do if else elseif switch try catch finally return throw break continue default case": t.controlKeyword,
  "endif endfor endforeach endswitch endwhile declare enddeclare goto match": t.controlKeyword,
  "and or xor yield unset clone instanceof insteadof": t.operatorKeyword,
  "function fn class trait implements extends const enum global interface use var": t.definitionKeyword,
  "include include_once require require_once namespace": t.moduleKeyword,
  "new from echo print array list as": t.keyword,
  null: t.null,
  Boolean: t.bool,
  VariableName: t.variableName,
  "NamespaceName/...": t.namespace,
  "NamedType/...": t.typeName,
  Name: t.name,
  "CallExpression/Name": t.function(t.variableName),
  "LabelStatement/Name": t.labelName,
  "MemberExpression/Name": t.propertyName,
  "MemberExpression/VariableName": t.special(t.propertyName),
  "ScopedExpression/ClassMemberName/Name": t.propertyName,
  "ScopedExpression/ClassMemberName/VariableName": t.special(t.propertyName),
  "CallExpression/MemberExpression/Name": t.function(t.propertyName),
  "CallExpression/ScopedExpression/ClassMemberName/Name": t.function(t.propertyName),
  "MethodDeclaration/Name": t.function(t.definition(t.variableName)),
  "FunctionDefinition/Name": t.function(t.definition(t.variableName)),
  "ClassDeclaration/Name": t.definition(t.className),
  UpdateOp: t.updateOperator,
  ArithOp: t.arithmeticOperator,
  LogicOp: t.logicOperator,
  BitOp: t.bitwiseOperator,
  CompareOp: t.compareOperator,
  ControlOp: t.controlOperator,
  AssignOp: t.definitionOperator,
  "$ ConcatOp": t.operator,
  LineComment: t.lineComment,
  BlockComment: t.blockComment,
  Integer: t.integer,
  Float: t.float,
  String: t.string,
  ShellExpression: t.special(t.string),
  "=> ->": t.punctuation,
  "( )": t.paren,
  "#[ [ ]": t.squareBracket,
  "${ { }": t.brace,
  "-> ?->": t.derefOperator,
  ", ; :: : \\": t.separator,
  "PhpOpen PhpClose": t.processingInstruction,
})
