/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.RasterDestination;
import java.awt.image.WritableRaster;

final class SubsamplingDestination
extends RasterDestination {
    private final int xsub;
    private final int ysub;
    private final int xoff;
    private final int yoff;
    private final int[] singlePixel;

    public SubsamplingDestination(WritableRaster raster, int sourceWidth, int xsub, int ysub, int xoff, int yoff) {
        super(raster, sourceWidth);
        this.xsub = xsub;
        this.ysub = ysub;
        this.xoff = xoff;
        this.yoff = yoff;
        this.singlePixel = new int[raster.getNumBands()];
    }

    public void setPixels(int x, int y, int w, int[] pixels) {
        if ((y - this.yoff) % this.ysub == 0) {
            int xdst = (x - this.xoff) / this.xsub;
            int ydst = (y - this.yoff) / this.ysub;
            int startSrc = xdst * this.xsub + this.xoff;
            if (startSrc < x) {
                ++xdst;
                startSrc += this.xsub;
            }
            int samples = this.raster.getNumBands();
            int end = x + w;
            for (int i = startSrc - x; i < end; i += this.xsub) {
                System.arraycopy(pixels, i * samples, this.singlePixel, 0, samples);
                super.setPixel(xdst++, ydst, this.singlePixel);
            }
        }
    }

    public void setPixel(int x, int y, int[] pixel) {
        if ((x -= this.xoff) % this.xsub == 0 && (y -= this.yoff) % this.ysub == 0) {
            super.setPixel(x / this.xsub, y / this.ysub, pixel);
        }
    }

    public void getPixel(int x, int y, int[] pixel) {
        throw new UnsupportedOperationException();
    }
}

