% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPerCellQCMetrics.R
\name{addPerCellQCMetrics}
\alias{addPerCellQCMetrics}
\alias{addPerFeatureQCMetrics}
\alias{addPerCellQC}
\alias{addPerFeatureQC}
\title{Add QC metrics to a SummarizedExperiment}
\usage{
addPerCellQCMetrics(x, subsets = NULL, ..., subset.prefix = "subsets_")

addPerFeatureQCMetrics(x, ...)

addPerCellQC(x, subsets = NULL, ..., subset.prefix = "subsets_")

addPerFeatureQC(x, ...)
}
\arguments{
\item{x}{A \linkS4class{SummarizedExperiment} object or one of its subclasses.}

\item{subsets}{A named list containing one or more vectors 
(a character vector of feature names, a logical vector, or a numeric vector of indices),
used to identify interesting feature subsets such as ERCC spike-in transcripts or mitochondrial genes.}

\item{...}{For \code{addPerCellQCMetrics}, further arguments to pass to \code{\link{perCellQCMetrics}}.

For \code{addPerFeatureQCMetrics}, further arguments to pass to \code{\link{perFeatureQCMetrics}}.}

\item{subset.prefix}{String containing the prefix for the names of the columns of \code{\link{rowData}} that specify which genes belong to each subset.
If \code{NULL}, these subset identity columns are not added to the \code{\link{rowData}}.}
}
\value{
\code{x} is returned with the QC metrics added to the row or column metadata.
}
\description{
Convenient utilities to compute QC metrics and add them to a \linkS4class{SummarizedExperiment}'s row or column metadata.
}
\details{
These functions are simply wrappers around \code{\link{perCellQCMetrics}} and \code{\link{perFeatureQCMetrics}}, respectively.
The computed QC metrics are automatically appended onto the existing \code{\link{colData}} or \code{\link{rowData}}.
No protection is provided against duplicated column names.

\code{addPerCellQC} and \code{addPerFeatureQC} are exactly the same functions, \emph{sans} the \code{Metrics} at the end of their names.
They were added in the tempestuous youth of this package when naming was fast and loose.
These can be considered to be soft-deprecated in favor of the longer forms.
}
\examples{
example_sce <- mockSCE()
example_sce <- addPerCellQCMetrics(
     example_sce,
     subsets = list(group1 = 1:5, group2 = c("Gene_0001", "Gene_2000"))
)
colData(example_sce)
rowData(example_sce)

example_sce <- addPerFeatureQCMetrics(example_sce)
rowData(example_sce)

}
\seealso{
\code{\link{perCellQCMetrics}} and \code{\link{perFeatureQCMetrics}}, which do the actual work.
}
\author{
Aaron Lun, Lluís Revilla Sancho
}
