% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clone.R
\name{clone}
\alias{clone}
\alias{clone.default}
\title{Cloning ff and ram objects}
\usage{
clone(x, ...)

\method{clone}{default}(x, ...)
}
\arguments{
\item{x}{\code{x} an R object}

\item{...}{further arguments to the generic}
}
\value{
an object that is a deep copy of x
}
\description{
\code{clone} physically duplicates objects and can additionally change
some features, e.g. length.
}
\details{
\code{clone} is generic.  \code{clone.default} handles ram objects.
Further methods are provided in package 'ff'.
\code{still.identical} returns TRUE if the two atomic arguments still
point to the same memory.
}
\section{Methods (by class)}{
\itemize{
\item \code{clone(default)}: default method uses R's C-API 'duplicate()'

}}
\examples{

  x <- 1:12
  y <- x
  still.identical(x, y)
  y[1] <- y[1]
  still.identical(x, y)
  y <- clone(x)
  still.identical(x, y)
  rm(x, y); gc()

}
\seealso{
\code{clone.ff}, \code{\link[=copy_vector]{copy_vector()}}
}
\author{
Jens Oehlschlägel
}
\keyword{IO}
\keyword{data}
