% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_sparse_bayes_pca.R
\name{prior_slab_dispersion}
\alias{prior_slab_dispersion}
\alias{prior_mixture_threshold}
\title{Bayesian PCA parameters}
\usage{
prior_slab_dispersion(range = c(-1/2, log10(3)), trans = transform_log10())

prior_mixture_threshold(range = c(0, 1), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
A numeric parameter function representing parameters for the spike-and-slab
prior used by \code{embed::step_pca_sparse_bayes()}.
}
\details{
\code{prior_slab_dispersion()} is related to the prior for the case where a PCA
loading is selected (i.e. non-zero). Smaller values result in an increase in
zero coefficients.

\code{prior_mixture_threshold()} is used to threshold the prior to determine which
parameters are non-zero or zero. Increasing this parameter increases the
number of zero coefficients.
}
\examples{
mixture()
}
