% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse.R
\name{glimpse}
\alias{glimpse}
\title{Get a glimpse of your data}
\usage{
glimpse(x, width = getOption("width"), ...)
}
\arguments{
\item{x}{An object to glimpse at.}

\item{width}{\code{integer(1)}. Width of the output.}

\item{...}{Additional parameters to pass to \code{\link[utils:str]{utils::str()}}.}
}
\value{
\code{x}, invisibly.
}
\description{
\code{glimpse()} is like a transposed version of print(): columns run down the page, and data runs across. This makes it
possible to see every column in a \code{data.frame}. It is no more than a wrapper around \code{\link[utils:str]{utils::str()}} only it returns
the input (invisibly) meaning it can be used within a data pipeline.
}
\examples{
glimpse(mtcars)

}
