% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_dev.R
\name{agg_png}
\alias{agg_png}
\title{Draw to a PNG file}
\usage{
agg_png(
  filename = "Rplot\%03d.png",
  width = 480,
  height = 480,
  units = "px",
  pointsize = 12,
  background = "white",
  res = 72,
  scaling = 1,
  snap_rect = TRUE,
  bitsize = 8,
  bg
)
}
\arguments{
\item{filename}{The name of the file. Follows the same semantics as the file
naming in \code{\link[grDevices:png]{grDevices::png()}}, meaning that you can provide a \code{\link[=sprintf]{sprintf()}}
compliant string format to name multiple plots (such as the default value)}

\item{width, height}{The dimensions of the device}

\item{units}{The unit \code{width} and \code{height} is measured in, in either pixels
(\code{'px'}), inches (\code{'in'}), millimeters (\code{'mm'}), or centimeter (\code{'cm'}).}

\item{pointsize}{The default pointsize of the device in pt. This will in
general not have any effect on grid graphics (including ggplot2) as text
size is always set explicitly there.}

\item{background}{The background colour of the device}

\item{res}{The resolution of the device. This setting will govern how device
dimensions given in inches, centimeters, or millimeters will be converted
to pixels. Further, it will be used to scale text sizes and linewidths}

\item{scaling}{A scaling factor to apply to the rendered line width and text
size. Useful for getting the right dimensions at the resolution that you
need. If e.g. you need to render a plot at 4000x3000 pixels for it to fit
into a layout, but you find that the result appears to small, you can
increase the \code{scaling} argument to make everything appear bigger at the
same resolution.}

\item{snap_rect}{Should axis-aligned rectangles drawn with only fill snap to
the pixel grid. This will prevent anti-aliasing artifacts when two
rectangles are touching at their border.}

\item{bitsize}{Should the device record colour as 8 or 16bit}

\item{bg}{Same as \code{background} for compatibility with old graphic device APIs}
}
\description{
The PNG (Portable Network Graphic) format is one of the most ubiquitous
today, due to its versatiliity
and widespread support. It supports transparency as well as both 8 and 16 bit
colour. The device uses default compression and filtering and will not use a
colour palette as this is less useful for antialiased data. This means that
it might be possible to compress the resulting image even more if size is of
concern (though the defaults are often very good). In contrast to
\code{\link[grDevices:png]{grDevices::png()}} the date and time will not be written to the file, meaning
that similar plot code will produce identical files (a good feature if used
with version control). It will, however, write in the dimensions of the image
based on the \code{res} argument.
}
\examples{
file <- tempfile(fileext = '.png')
agg_png(file)
plot(sin, -pi, 2*pi)
dev.off()

}
