% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_umap.R
\name{register_umap}
\alias{register_umap}
\alias{umap}
\title{Register Seriation Based on 1D UMAP}
\usage{
register_umap()
}
\value{
Nothing.
}
\description{
Use uniform manifold approximation and projection (UMAP) to embed the data
on the number line and create a order for \code{\link[=seriate]{seriate()}}.
}
\details{
Registers the method \code{"umap"} for \code{\link[=seriate]{seriate()}}. This method applies
1D UMAP to a data matrix or a distance matrix and extracts the order from
the 1D embedding.

Control parameter \code{n_epochs} can be increased to find a better embedding.

The returned seriation permutation vector has an attribute named
\code{embedding} containing the umap embedding.

\bold{Note:} Package \pkg{umap} needs to be installed.
}
\examples{

\dontrun{
register_umap()

## distances
get_seriation_method("dist", "umap")

data(SupremeCourt)
d <- as.dist(SupremeCourt)

o <- seriate(d, method = "umap", verbose = TRUE)
pimage(d, o)

# look at the returned embedding and plot it
attr(o[[1]], "configuration")
plot_config(o)

## matrix
get_seriation_method("matrix", "umap")

data("Zoo")
Zoo[,"legs"] <- (Zoo[,"legs"] > 0)
x <- as.matrix(Zoo[,-17])
label <- rownames(Zoo)
class <- Zoo$class

o <- seriate(x, method = "umap", verbose = TRUE)
pimage(x, o)

plot_config(o[[1]], col = class)
}
}
\references{
McInnes, L and Healy, J, UMAP: Uniform Manifold Approximation and
Projection for Dimension Reduction, ArXiv e-prints 1802.03426, 2018.
}
\seealso{
\code{\link[umap:umap]{umap::umap()}} in \pkg{umap}.

Other seriation: 
\code{\link{register_DendSer}()},
\code{\link{register_GA}()},
\code{\link{register_optics}()},
\code{\link{register_smacof}()},
\code{\link{register_tsne}()},
\code{\link{registry_for_seriation_methods}},
\code{\link{seriate}()},
\code{\link{seriate_best}()}
}
\concept{seriation}
\keyword{cluster}
\keyword{optimize}
