/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ContextFreeAtomicValue;
import net.sf.saxon.value.Whitespace;

public final class BooleanValue
extends AtomicValue
implements XPathComparable,
AtomicMatchKey,
ContextFreeAtomicValue {
    private final boolean value;
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);

    private BooleanValue(boolean value) {
        this.value = value;
        this.typeLabel = BuiltInAtomicType.BOOLEAN;
    }

    public static BooleanValue get(boolean value) {
        return value ? TRUE : FALSE;
    }

    public BooleanValue(boolean value, AtomicType typeLabel) {
        this.value = value;
        this.typeLabel = typeLabel;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        BooleanValue v = new BooleanValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public static ConversionResult fromString(UnicodeString s2) {
        long start = Whitespace.trimmedStart(s2);
        long end = Whitespace.trimmedEnd(s2);
        if (start >= 0L) {
            long len = end - start;
            if (len == 1L) {
                int first = s2.codePointAt(start);
                if (first == 48) {
                    return FALSE;
                }
                if (first == 49) {
                    return TRUE;
                }
            } else if (len == 4L) {
                if (s2.codePointAt(start++) == 116 && s2.codePointAt(start++) == 114 && s2.codePointAt(start++) == 117 && s2.codePointAt(start) == 101) {
                    return TRUE;
                }
            } else if (len == 5L && s2.codePointAt(start++) == 102 && s2.codePointAt(start++) == 97 && s2.codePointAt(start++) == 108 && s2.codePointAt(start++) == 115 && s2.codePointAt(start) == 101) {
                return FALSE;
            }
        }
        ValidationFailure err = new ValidationFailure("The string " + Err.wrap(s2, 4) + " cannot be cast to a boolean");
        err.setErrorCode("FORG0001");
        return err;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public boolean effectiveBooleanValue() {
        return this.value;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        return this.value ? StringConstants.TRUE : StringConstants.FALSE;
    }

    @Override
    public AtomicMatchKey getXPathMatchKey(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable() {
        return this;
    }

    @Override
    public int compareTo(XPathComparable other) {
        if (other instanceof BooleanValue) {
            if (this.value == ((BooleanValue)other).value) {
                return 0;
            }
            if (this.value) {
                return 1;
            }
            return -1;
        }
        throw new ClassCastException("Cannot compare xs:boolean to " + other);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof BooleanValue && this.value == ((BooleanValue)other).value;
    }

    @Override
    public int hashCode() {
        return this.value ? 0 : 1;
    }

    @Override
    public String show() {
        return this.getUnicodeStringValue() + "()";
    }
}

