// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

package pinyin

var PinyinDataMap = map[string]string{
	"50CA": "xian",
	"5EBA": "song",
	"5EEB": "liao",
	"718C": "kao",
	"5130": "wei",
	"5E0F": "wei",
	"697C": "lou",
	"6B5F": "yu",
	"6E47": "qi",
	"75C3": "xuan;xian",
	"79A4": "xuan",
	"8EF2": "gu",
	"90F2": "lai",
	"56A2": "nang",
	"6A48": "rao;nao",
	"74B1": "se",
	"7634": "zhang",
	"7A64": "nuo",
	"7D00": "ji",
	"671D": "chao;zhao",
	"7C5B": "jian",
	"8027": "lou",
	"9460": "shuo",
	"6B9A": "dan",
	"6E0B": "se",
	"6FB0": "lian",
	"704B": "fa",
	"732C": "wei",
	"7530": "tian",
	"7C9A": "li",
	"84D9": "none",
	"9376": "si",
	"9AFE": "shao",
	"5A45": "ju",
	"640D": "sun",
	"734C": "man",
	"7833": "le",
	"5A1A": "nan",
	"7260": "ta",
	"7C8C": "yin",
	"80FD": "neng",
	"83B5": "tu",
	"8790": "wu",
	"98DB": "fei",
	"6926": "none",
	"8463": "dong",
	"8DA4": "dang",
	"9CC4": "e",
	"5F42": "fa",
	"60C9": "chan",
	"6EBF": "pan",
	"70BA": "wei",
	"8C79": "bao",
	"95FA": "gui",
	"5C06": "jiang;qiang",
	"6207": "zhuang",
	"8270": "jian",
	"8A68": "jiao",
	"93FF": "cheng",
	"97C2": "chan",
	"4F7B": "tiao",
	"5C05": "ke",
	"64DE": "sou",
	"934F": "wei",
	"9828": "pian",
	"9A4C": "su",
	"9B8C": "gun",
	"9D75": "tu",
	"56D9": "yin",
	"68C8": "qian",
	"86B7": "ju",
	"963E": "ling",
	"97DF": "gao",
	"988E": "jiong",
	"5282": "jue",
	"59B6": "xuan",
	"5B0A": "yan",
	"7603": "zhu",
	"7D77": "zhi",
	"8066": "cong",
	"9F4F": "ji",
	"4F84": "zhi",
	"52AE": "yi",
	"5E96": "pao",
	"67A4": "none",
	"7CCB": "jian",
	"7D73": "jiang",
	"818D": "pi",
	"84A5": "liu",
	"86A7": "jie",
	"9DF5": "tu",
	"6898": "jian",
	"6D3E": "pai",
	"74BD": "xi",
	"7999": "none",
	"95C0": "xiang",
	"9831": "le",
	"9908": "ci",
	"990C": "er",
	"561A": "de;dei",
	"99AA": "bin",
	"4F56": "bi",
	"6936": "zong",
	"797E": "ling",
	"86FA": "jia",
	"8F59": "yi",
	"9C60": "kuai",
	"589E": "zeng",
	"65CC": "jing",
	"65F5": "chan",
	"75FA": "bi",
	"7BC4": "fan",
	"85ED": "qiong",
	"871A": "fei",
	"9EB3": "lai",
	"64C4": "lu",
	"6D9E": "lai",
	"7146": "ya",
	"80D6": "pang",
	"9496": "yang",
	"9F89": "yu",
	"750B": "di",
	"858F": "yi",
	"6306": "duo",
	"69B7": "que",
	"7169": "fan",
	"7D5A": "geng",
	"6442": "she",
	"6E77": "chui",
	"7666": "none",
	"7EF8": "chou",
	"80C7": "fei",
	"982A": "lei",
	"9A41": "ao",
	"6FBD": "ju",
	"8AEA": "ting",
	"9275": "tong",
	"60D0": "yu",
	"67AE": "xian",
	"77DD": "lin",
	"5301": "none",
	"5CF8": "cheng",
	"90C9": "xing",
	"9C28": "ta",
	"632A": "nuo",
	"648E": "yi",
	"7CEF": "nuo",
	"7FC5": "chi",
	"843B": "an",
	"85FA": "lin",
	"8E6B": "ju",
	"9821": "jie;xie",
	"9C14": "jian",
	"52A5": "keng",
	"5F4D": "kuo",
	"4E64": "none",
	"730C": "yin",
	"9EFE": "min;mian",
	"6425": "chui",
	"682A": "zhu",
	"6A9D": "ji",
	"76B1": "zhou",
	"786E": "que",
	"8366": "luo",
	"9CFF": "yu",
	"553B": "lai",
	"572D": "gui",
	"5F7F": "fu",
	"6E7F": "shi",
	"729F": "jiang",
	"942D": "yu",
	"97D8": "she",
	"6B04": "lan",
	"888E": "yao",
	"50D7": "lao",
	"6506": "nian",
	"69F3": "jiang",
	"7367": "juan",
	"82ED": "yao",
	"9A00": "e",
	"6934": "duan",
	"8922": "huai",
	"8A53": "qu",
	"9039": "da",
	"94BB": "zuan",
	"8960": "dang",
	"8A64": "huang",
	"8A9C": "shua",
	"90FE": "yan",
	"6620": "ying",
	"7C60": "long",
	"4ED8": "fu",
	"59D1": "gu",
	"62A4": "hu",
	"746F": "lang",
	"7FA0": "yi",
	"85BE": "er",
	"8974": "lan",
	"8B22": "hu",
	"8EF8": "zhou;zhu",
	"9BF1": "none",
	"5683": "ta",
	"6250": "le",
	"6712": "nu",
	"86E6": "yi",
	"9456": "mie",
	"9611": "lan",
	"9E55": "hu",
	"6A1C": "shu",
	"6A63": "ning",
	"6F0F": "lou",
	"733E": "hua",
	"7981": "jin",
	"800A": "die",
	"89D6": "jue",
	"8C23": "yao",
	"9957": "xiang",
	"9B58": "yan",
	"7DBC": "bei",
	"8709": "fu",
	"56FB": "guo",
	"615B": "cui",
	"8F5C": "er",
	"5F76": "ji",
	"6CC3": "ju",
	"6D3D": "qia;xia",
	"6D68": "lan",
	"7591": "yi",
	"4E6D": "shi",
	"86F1": "jia",
	"8B3B": "yi",
	"9D89": "chun",
	"52AC": "qu",
	"589D": "qiao",
	"596B": "yun",
	"6271": "xi",
	"8299": "fu",
	"8759": "bian",
	"9D52": "yu",
	"5184": "ran",
	"536B": "wei",
	"8DB8": "dun",
	"97D7": "xun",
	"5B7A": "ru",
	"6864": "qi",
	"6C84": "yun",
	"6F8E": "peng",
	"70F4": "jing;ting",
	"83FB": "lin",
	"9578": "chang;zhang",
	"9DB5": "chu",
	"5037": "nai",
	"5EA6": "du;duo",
	"6A47": "qiao;cui",
	"99F4": "xie",
	"54B1": "zan",
	"559B": "huan",
	"5FE7": "you",
	"9B51": "chi",
	"5404": "ge",
	"5503": "gu",
	"67F1": "zhu",
	"6C2B": "qing",
	"6EC1": "chu",
	"78FA": "huang",
	"790A": "huo",
	"8F33": "cou",
	"91D5": "liao",
	"518F": "jiong",
	"5EBD": "yu",
	"643D": "cha",
	"6922": "kui",
	"6B28": "xu",
	"7D1F": "jin",
	"8121": "ting",
	"887D": "ren",
	"94A5": "yao;yue",
	"5C21": "none",
	"6B2D": "yi",
	"7BDF": "qian",
	"88D1": "shen",
	"89B2": "jin",
	"8ED8": "tun",
	"9AC8": "bang",
	"53A3": "yan",
	"88EA": "tao",
	"930F": "ya",
	"9387": "mei",
	"984F": "yan",
	"9986": "guan",
	"9F4A": "qi;zhai",
	"8AC1": "chuo",
	"8ECC": "gui",
	"9A5D": "tuo",
	"9B08": "quan;qian",
	"71CD": "si",
	"850B": "di",
	"8E1D": "huai",
	"950C": "xin",
	"96CC": "ci",
	"4E4B": "zhi",
	"8210": "shi",
	"8400": "hu",
	"5685": "ru",
	"627E": "zhao",
	"713F": "none",
	"75DD": "mang",
	"85B4": "neng",
	"8E0E": "none",
	"98BD": "kai",
	"4E07": "wan;mo",
	"7FC8": "xia",
	"8ED0": "xin",
	"62AD": "yao",
	"8016": "chao",
	"9666": "zhi",
	"9867": "gu",
	"5F6C": "bin",
	"7179": "wei",
	"7FE0": "cui",
	"80CE": "tai",
	"8143": "juan",
	"875F": "wei",
	"9228": "none",
	"6A76": "ji",
	"8011": "zhuan;duan",
	"8B61": "dang",
	"9627": "dou",
	"9A42": "can",
	"4E10": "gai",
	"5191": "zhou",
	"5DC9": "chan",
	"7AC1": "cui",
	"8384": "geng",
	"86B6": "han",
	"927B": "ge",
	"9CE1": "gan",
	"9F0E": "ding",
	"4F00": "zhong",
	"6877": "jue",
	"71A0": "yi",
	"824E": "huang",
	"50FC": "feng",
	"5147": "xiong",
	"7FB8": "lei",
	"9B37": "zong",
	"6288": "yue",
	"938E": "xi",
	"9C6E": "xu",
	"6788": "bi",
	"70D3": "wei",
	"8184": "shou",
	"59AE": "ni",
	"6228": "ge",
	"6A87": "zui",
	"8C3D": "han",
	"91F1": "di",
	"5070": "xie",
	"73C1": "ci",
	"8815": "ru;ruan",
	"9288": "ji",
	"940C": "xiang",
	"4FFA": "an",
	"5D70": "qian",
	"662A": "bian",
	"8B23": "yu",
	"94B9": "bo",
	"568B": "chou",
	"60ED": "can",
	"780D": "kan",
	"8B16": "su",
	"9213": "ren",
	"9849": "qin",
	"4E62": "gai",
	"785D": "xiao",
	"8F3F": "yu",
	"9DD2": "zhuan",
	"58DB": "yan",
	"59B1": "zhao",
	"78AD": "dang",
	"84AF": "kuai",
	"8872": "na",
	"9497": "chai",
	"9594": "min",
	"9822": "gua",
	"5422": "qin",
	"568E": "hao",
	"5C52": "chen",
	"869B": "zhong",
	"5785": "long",
	"5314": "qiong",
	"5327": "qie",
	"5707": "lun",
	"85F4": "yun",
	"95F7": "men",
	"5343": "qian",
	"7A71": "jue",
	"840E": "wei",
	"8F77": "hu",
	"9678": "lu;liu",
	"9702": "mu",
	"983B": "pin",
	"52B8": "wa",
	"63AA": "cuo",
	"65AA": "qu;ju",
	"796E": "gao",
	"834A": "jing",
	"8DF7": "qiao",
	"52C9": "mian",
	"707B": "chi",
	"7392": "hong",
	"7A3E": "gao",
	"7F7A": "chao",
	"8BCA": "zhen",
	"6210": "cheng",
	"7D53": "gua",
	"8329": "gou",
	"6457": "none",
	"67B7": "jia",
	"6A5F": "ji",
	"6F4C": "zhi",
	"7C4C": "chou",
	"8CEA": "zhi",
	"8FF4": "hui",
	"59C1": "xu",
	"5A31": "yu",
	"64B3": "qin",
	"6BD3": "yu",
	"76C0": "qi",
	"792A": "li",
	"7BCC": "hou",
	"84C7": "gu",
	"8554": "bao",
	"8D39": "fei",
	"8F10": "huan",
	"71D6": "xun",
	"71E1": "yi",
	"786F": "yan",
	"80BE": "shen",
	"5452": "m",
	"607B": "ce",
	"631E": "ta",
	"812C": "pao",
	"9B6F": "lu",
	"5F75": "tuo",
	"61A4": "fen",
	"7476": "yao",
	"77EE": "ai",
	"7E60": "rui",
	"9181": "lu",
	"93F6": "ji",
	"9DC6": "tian",
	"5BC9": "he",
	"9E0D": "mi",
	"6525": "zuan",
	"804B": "long",
	"9419": "deng",
	"7375": "lie",
	"8BF6": "ei;ai",
	"9ADC": "qiao",
	"5DEF": "qiu",
	"5F3B": "bi",
	"7138": "yan",
	"91FC": "jian",
	"9DEC": "huang",
	"57B3": "none",
	"5BD5": "ning",
	"66E8": "long",
	"778A": "dang",
	"7B34": "ge",
	"83EF": "hua",
	"86E8": "mo",
	"51E3": "fan",
	"907B": "wu",
	"9109": "xiang",
	"9E46": "yu",
	"94B8": "bu",
	"5F62": "xing",
	"8B2F": "zha",
	"9B7D": "han",
	"566E": "yuan",
	"679F": "yun",
	"7259": "ya",
	"79E5": "nian",
	"8CBC": "tie",
	"9C4F": "xun",
	"4F04": "diao",
	"54D6": "none",
	"6667": "hao",
	"743A": "fa",
	"7704": "mian",
	"8020": "huo",
	"9120": "hu",
	"97EA": "wei",
	"5D25": "pi",
	"6177": "kang",
	"6DA7": "jian",
	"708B": "pi",
	"804C": "zhi",
	"873C": "wei",
	"8B1B": "jiang",
	"9E92": "qi",
	"6A6D": "gu;ku",
	"90C3": "he",
	"732A": "zhu",
	"75C8": "yong",
	"7886": "bo",
	"7E61": "xiu",
	"8B8D": "e",
	"55EA": "qin",
	"5EE7": "qiang",
	"6244": "shang",
	"86C0": "zhu",
	"89E8": "huan",
	"8C12": "ye",
	"635F": "sun",
	"7D28": "fu",
	"9423": "none",
	"9DD4": "ao",
	"508C": "ma",
	"5D38": "dun",
	"6ED5": "teng",
	"9385": "jie",
	"4F64": "wa",
	"63C9": "rou",
	"7C67": "qu",
	"8295": "sui",
	"82C0": "hang",
	"8D46": "jin",
	"9100": "ruo",
	"9A54": "tan",
	"9D8B": "ju",
	"514D": "mian;wen",
	"4EDA": "xian",
	"5AB5": "ying",
	"7CC6": "mian",
	"89B9": "wei",
	"9567": "lan",
	"99E0": "liu",
	"6AA1": "zhe",
	"7ECE": "yi",
	"8DBC": "jian",
	"9811": "wan",
	"705C": "none",
	"7170": "gao",
	"9787": "yin",
	"502D": "wo",
	"5627": "mi",
	"6B97": "ye",
	"6FCD": "song",
	"7338": "mei",
	"74A7": "bi",
	"7756": "ling",
	"7056": "mi",
	"70DD": "zheng",
	"788B": "he",
	"85BC": "chen",
	"85D3": "xian;li",
	"897F": "xi",
	"8CF0": "shun",
	"95D8": "dou",
	"51F2": "gan",
	"5953": "she",
	"5F13": "gong",
	"7894": "wu",
	"7E5A": "liao",
	"8838": "quan",
	"4E11": "chou",
	"5281": "qiao",
	"7CD0": "fu",
	"7F29": "suo",
	"83B9": "ying",
	"96EC": "fou",
	"58D0": "mi",
	"6756": "zhang",
	"7C25": "qiao",
	"8B18": "chi",
	"5DBF": "none",
	"6AC9": "chu",
	"6F09": "lu",
	"70CF": "wu",
	"7ACA": "qie",
	"7C3E": "lian",
	"81CA": "sao",
	"90E7": "yun",
	"978A": "ji",
	"570A": "qing",
	"5BDD": "qin",
	"7903": "zhang",
	"7EE6": "tao",
	"98E9": "tun",
	"58C2": "dian",
	"72A1": "li",
	"7678": "gui",
	"7773": "hui",
	"82F9": "ping",
	"91B9": "ru",
	"5EEA": "lin",
	"648A": "xian",
	"7238": "ba",
	"7EA1": "yu",
	"93DC": "tang",
	"54DA": "duo",
	"5916": "wai",
	"6191": "ping",
	"7212": "liao",
	"75BF": "fei",
	"7C38": "bo",
	"54E5": "ge",
	"7649": "dan",
	"7FB1": "yuan",
	"912E": "mao",
	"95D4": "he",
	"9F3C": "yao",
	"5BF7": "feng",
	"5D39": "ti",
	"9531": "zi",
	"9835": "jun",
	"9940": "tao",
	"5FB3": "de",
	"812E": "nei",
	"828D": "shao",
	"8527": "hui",
	"8787": "xi",
	"8CD5": "qiu",
	"9B34": "fu",
	"5341": "shi",
	"8DBD": "fang",
	"972F": "deng",
	"4EF4": "wan",
	"596E": "fen",
	"5A2B": "yan",
	"6417": "dao",
	"747C": "zhuan",
	"77DE": "yu",
	"7AE0": "zhang",
	"7E09": "jin",
	"8132": "niao",
	"9246": "zhan",
	"5695": "lu",
	"5772": "fo",
	"6275": "yu",
	"7D84": "wan",
	"9E91": "ni",
	"5330": "dan",
	"56D1": "zhu",
	"7A4A": "ji",
	"8478": "xi",
	"89EB": "su",
	"98CD": "biao",
	"7B3E": "bian",
	"9B8A": "ba",
	"88B0": "none",
	"8E66": "beng",
	"8E6D": "ceng",
	"63F4": "yuan",
	"7624": "liu",
	"7D0F": "tou",
	"944A": "huo",
	"543F": "gao;gu",
	"795B": "qu",
	"8D9F": "tang",
	"92A1": "ji",
	"57ED": "dai",
	"7B70": "zuo",
	"8A83": "chi",
	"8E15": "jie",
	"522C": "chan",
	"5DE1": "xun",
	"6C44": "ze",
	"6D4B": "ce",
	"7008": "hui",
	"73FB": "mei",
	"943B": "ju",
	"4F03": "yu",
	"588A": "dian",
	"6A2A": "heng",
	"7018": "lu",
	"735A": "huang",
	"76CB": "bo",
	"7EEA": "xu",
	"9A4A": "hua",
	"9B2D": "dou",
	"522F": "gen",
	"5EA7": "zuo",
	"63CD": "zou",
	"8388": "mo",
	"534C": "xi",
	"5F25": "mi",
	"78D8": "qing",
	"7AE4": "hong",
	"8B63": "qian",
	"6683": "none",
	"6B3D": "qin",
	"7FBE": "gong",
	"583E": "chuan",
	"592B": "fu",
	"6DCA": "han",
	"6E5C": "shi",
	"4E39": "dan",
	"7B8F": "zheng",
	"8313": "xue",
	"848A": "none",
	"8D6C": "cheng",
	"92CD": "bo",
	"9591": "xian",
	"9868": "xun",
	"989B": "zhuan",
	"5382": "chang",
	"6446": "bai",
	"6478": "mo",
	"7EC0": "gan",
	"932E": "gu",
	"9C09": "huang",
	"53C2": "can;cen;shen",
	"6725": "none",
	"5EDD": "si",
	"6274": "jia",
	"66BB": "jing",
	"7B85": "bi",
	"8851": "ling",
	"9C51": "huang",
	"6AEA": "li",
	"6F3E": "yang",
	"7D9E": "duo",
	"96A0": "yin",
	"9758": "qing",
	"5141": "yun",
	"5CDB": "li",
	"65A0": "jiao",
	"66B2": "zhang",
	"79F4": "he",
	"8B4F": "ji",
	"59CF": "qian",
	"653D": "ban",
	"6984": "lan",
	"95C8": "wei",
	"7077": "zhuan",
	"71B9": "xi",
	"7739": "zhen",
	"8E0A": "yong",
	"91AA": "lao",
	"9311": "lei",
	"9486": "ga",
	"61AB": "min",
	"7CEA": "bo",
	"885B": "wei",
	"886B": "shan",
	"5AC4": "yuan",
	"610B": "xuan",
	"68C9": "mian",
	"7134": "yu",
	"722B": "lan",
	"7714": "da",
	"8E89": "dun",
	"5B1A": "lian",
	"62D8": "ju",
	"8832": "juan",
	"9175": "jiao;xiao",
	"6916": "peng",
	"8069": "kui",
	"821B": "chuan",
	"836A": "sun",
	"88F1": "biao",
	"8F60": "lei",
	"8FE0": "che",
	"971A": "wu",
	"9D47": "none",
	"6DAD": "shou",
	"79CA": "nian",
	"5607": "san",
	"9865": "hao",
	"6542": "kou",
	"69EE": "sen",
	"7A87": "bao",
	"7FC2": "fen",
	"4FC2": "xi",
	"57DC": "ye",
	"8BB7": "ne",
	"6C77": "zhong",
	"6C8F": "qi",
	"744E": "xie",
	"8256": "cha",
	"5FB5": "zhi;zheng",
	"81D2": "huo",
	"8B56": "jian;zen",
	"9590": "san",
	"9D9B": "jie",
	"9E30": "ling",
	"9ECC": "hong",
	"5347": "sheng",
	"5E93": "ku",
	"64F1": "ge",
	"6C3F": "gui",
	"7CE0": "kang",
	"8819": "bin",
	"6571": "ai",
	"6CCA": "bo;po",
	"8F62": "li",
	"9D00": "fou",
	"9D72": "que;qiao",
	"6A6A": "ran",
	"7263": "ren",
	"7E03": "xu",
	"59C8": "ling",
	"62D3": "tuo;ta",
	"6668": "chen",
	"8D3B": "yi",
	"594D": "none",
	"75ED": "peng",
	"7F0C": "si",
	"8863": "yi",
	"57A6": "ken",
	"5C9A": "lan",
	"6115": "e",
	"7C15": "le",
	"5274": "kai",
	"5E46": "yi",
	"7518": "gan",
	"9D8D": "none",
	"9E1D": "li",
	"687C": "qi",
	"7CC8": "xu",
	"7DCA": "jin",
	"57E0": "bu",
	"6508": "jun",
	"65A9": "zhan",
	"66E5": "lu",
	"7DD0": "fan",
	"88D9": "qun",
	"8FBC": "none",
	"9282": "zhou",
	"50F0": "bo",
	"51CD": "dong",
	"5B20": "can",
	"5EF7": "ting",
	"6305": "duo",
	"55EB": "nie",
	"60A5": "yi",
	"6655": "yun",
	"739A": "yang;chang",
	"7754": "hun",
	"787D": "yan",
	"7A28": "bian",
	"7CE3": "san",
	"96F5": "yang",
	"9BD3": "ni",
	"9EF9": "zhi",
	"5033": "zi",
	"539E": "fei",
	"5562": "liang",
	"662E": "zong",
	"6ED2": "ge",
	"7750": "lai",
	"833D": "zhong",
	"8818": "jie",
	"9C19": "ruo",
	"5097": "chu",
	"7A0B": "cheng",
	"59E7": "jian",
	"643C": "quan",
	"7775": "none",
	"7800": "dang",
	"9A29": "kui",
	"6CA2": "ze",
	"8D49": "lai",
	"9E7D": "yan",
	"5083": "su",
	"55C8": "yong",
	"6174": "zhe",
	"6A49": "lin",
	"75E0": "suan",
	"87BC": "qin",
	"8E2A": "zong",
	"52AB": "jie",
	"66EC": "shai",
	"7FA1": "xian",
	"5160": "dou",
	"56FD": "guo",
	"5924": "yin",
	"68F5": "ke",
	"6FC1": "zhuo",
	"8197": "chuai",
	"8659": "fu",
	"8CF3": "zai",
	"9C36": "ji",
	"9D67": "bing",
	"5CBD": "dong",
	"703F": "fan",
	"52B7": "yang",
	"81DC": "za",
	"9044": "chuan",
	"9412": "lao",
	"6902": "lu",
	"6EED": "bi",
	"7CAA": "fen",
	"7D41": "shi",
	"85C2": "cong",
	"9195": "chun",
	"972C": "yi",
	"6664": "wu",
	"67D9": "xia",
	"69FB": "gui",
	"6EFA": "you",
	"912F": "shan",
	"94F0": "jiao",
	"501F": "jie",
	"8C40": "xi",
	"501E": "jing;liang",
	"5073": "duan",
	"765D": "lin",
	"9A86": "luo",
	"51D4": "cang",
	"8B6E": "hua",
	"9F95": "kan",
	"570B": "guo",
	"5C0A": "zun",
	"7717": "ju",
	"920C": "jue",
	"9A83": "yin",
	"70C7": "quan",
	"8092": "huan",
	"8FC9": "qi",
	"5CE2": "li",
	"6085": "yue",
	"7D4C": "jing",
	"8078": "dan",
	"9077": "qian",
	"93B2": "tang",
	"4FE0": "xia",
	"5C4E": "shi",
	"6E07": "ke",
	"77E3": "yi",
	"7ADC": "long",
	"82A6": "lu",
	"93C6": "guan",
	"668A": "fu",
	"6CB8": "fei",
	"74D8": "guan",
	"9563": "liao",
	"6533": "xin",
	"6B0A": "quan",
	"71B4": "none",
	"8FA3": "la",
	"714D": "jiao",
	"8FF0": "shu",
	"9F2D": "shi",
	"53B5": "yuan",
	"6155": "mu",
	"9E89": "jian;qian",
	"614B": "tai",
	"67FB": "cha;zha",
	"7127": "cong",
	"9BEC": "li",
	"5CE4": "jiao;qiao",
	"7C94": "ju",
	"83A4": "you",
	"6015": "pa",
	"7DA7": "zhun",
	"4FA1": "jia;jie",
	"5448": "cheng",
	"5965": "ao",
	"6245": "yi",
	"63D8": "heng",
	"649B": "lin",
	"797D": "zui",
	"4FD3": "jing",
	"54AB": "zhi",
	"66D0": "xing",
	"7036": "lin",
	"787E": "zhui",
	"7957": "zhi",
	"7F13": "huan",
	"4E05": "xia",
	"5044": "nuan",
	"568F": "ti",
	"5918": "mao",
	"5F31": "ruo",
	"64B8": "lu",
	"9034": "chuo",
	"6194": "qiao",
	"62F7": "kao",
	"640B": "chuai",
	"73EF": "none",
	"7747": "di",
	"9900": "hai",
	"57F7": "zhi",
	"5A2E": "yan",
	"62AB": "pi",
	"8ACD": "zheng",
	"95AF": "sha",
	"98DC": "fan",
	"58A6": "fan",
	"64E1": "tai",
	"6F00": "qing",
	"781A": "yan",
	"863E": "huai",
	"8CF5": "feng",
	"9191": "xu",
	"9699": "xi",
	"51BA": "min",
	"7786": "kui",
	"7829": "fu;fei",
	"7B43": "yin",
	"8200": "yao",
	"95BD": "hun",
	"9879": "xiang",
	"54F9": "fou",
	"6B03": "chan",
	"743F": "hun;hui",
	"9422": "none",
	"976C": "jian",
	"7E20": "hu",
	"91A9": "zao",
	"516F": "none",
	"51DB": "lin",
	"64AF": "zhuo",
	"689B": "nuo",
	"6A6B": "heng",
	"7012": "se",
	"79DE": "you",
	"9869": "qian",
	"9F42": "xi",
	"9F5D": "chi",
	"9F68": "jiu",
	"63BC": "guan",
	"6FF0": "wei",
	"7011": "pu;bao",
	"87CD": "li",
	"987C": "xu",
	"54B9": "e",
	"6E0C": "lu",
	"6E2A": "ru",
	"736E": "xian",
	"77F7": "zi",
	"8E29": "cai",
	"98A6": "pin",
	"9C8C": "ba;bo",
	"63B4": "guai;guo",
	"6965": "xuan",
	"7253": "bang",
	"8775": "qiu",
	"8FAC": "ban",
	"920E": "gou",
	"5391": "none",
	"844E": "lu",
	"8782": "lang",
	"9B23": "lie",
	"61AC": "jing",
	"6A85": "sui",
	"6F4A": "xu",
	"9698": "ai",
	"5178": "dian",
	"6606": "kun",
	"9539": "qiao",
	"6B24": "yu",
	"8F1A": "zhan",
	"9BD9": "chun",
	"6429": "jie",
	"7396": "jiu",
	"7DFD": "cheng",
	"830D": "gou",
	"93C5": "xiu",
	"4ECC": "bing",
	"58AA": "dun",
	"636A": "min",
	"7871": "kun",
	"7B52": "tong",
	"878C": "ban",
	"5A59": "jing",
	"6E90": "yuan",
	"82F7": "gan",
	"9D4F": "bu",
	"4EAB": "xiang",
	"5791": "chi",
	"740A": "ya;ye",
	"79BD": "qin",
	"86A8": "fu",
	"5C00": "po",
	"5EFC": "nai",
	"6435": "wen",
	"6DAB": "guan",
	"6E2E": "ge",
	"7EAC": "wei",
	"89BF": "di",
	"92D7": "xuan",
	"94F4": "tang",
	"9657": "qiao",
	"5028": "ju",
	"62F9": "xie",
	"6ED8": "jiao",
	"8B81": "zhe",
	"5704": "yu",
	"5A68": "lun",
	"6BD7": "pi",
	"7925": "xian",
	"7DDE": "duan",
	"8007": "gou",
	"85E1": "di",
	"8F96": "xia",
	"921D": "yin",
	"4FE1": "xin;shen",
	"5F9C": "chang",
	"6BD5": "bi",
	"6D61": "bo",
	"931F": "tan",
	"971E": "xia",
	"8114": "luan",
	"85C5": "fa",
	"53D0": "ba",
	"53D1": "fa",
	"5B3F": "yan",
	"5E81": "ting",
	"5FC2": "qu",
	"64F7": "xie",
	"6E32": "xuan",
	"710F": "qi",
	"7AC2": "piao",
	"9305": "li",
	"99EE": "bo",
	"70D4": "tong",
	"770B": "kan",
	"95E9": "shuan",
	"5C65": "lu",
	"62C1": "jia",
	"6611": "qin",
	"6729": "deng",
	"673E": "ting",
	"6A34": "zhi",
	"6BAE": "lian",
	"7214": "xi",
	"7F9E": "xiu",
	"8D97": "cu",
	"916F": "zhi",
	"52C6": "lang",
	"5833": "mei",
	"5E51": "hui",
	"63FD": "lan",
	"85CF": "zang;cang",
	"91A3": "tang",
	"8827": "du",
	"8D62": "ying",
	"533F": "ni",
	"58E2": "li",
	"5925": "huo",
	"67AC": "nan",
	"8356": "lao;pei",
	"9118": "yong",
	"593E": "jia",
	"6DC3": "juan",
	"71B1": "re",
	"88A9": "chan",
	"90E4": "xi",
	"9C27": "teng",
	"4F32": "ni",
	"74FB": "chi",
	"874E": "xie;he",
	"98B0": "fa",
	"5801": "ke",
	"5904": "chu",
	"6344": "jiu",
	"66FB": "sheng",
	"6765": "lai",
	"7FA6": "huan",
	"9F45": "xiu",
	"535D": "kuang",
	"6D92": "tun",
	"713B": "chang",
	"92A8": "an",
	"97D4": "chang",
	"5AA3": "ran",
	"5B21": "ai",
	"620C": "xu;qu",
	"665C": "kun",
	"6C36": "zheng",
	"72B7": "guang",
	"88F0": "duo",
	"8AF8": "zhu",
	"925C": "fu",
	"970F": "fei",
	"4E1D": "si",
	"5859": "qiao",
	"6142": "yong",
	"72C9": "pi",
	"7866": "long",
	"9677": "xian",
	"5940": "en;mang",
	"75E9": "shou",
	"79AE": "li",
	"8582": "xi",
	"97A8": "he",
	"4FF2": "xiao",
	"549A": "dong",
	"68AB": "cen",
	"78AB": "duan",
	"95A3": "ge",
	"624A": "yan",
	"82B3": "fang",
	"8A06": "jiao",
	"9394": "rong",
	"9F52": "chi",
	"61F6": "lan",
	"68AC": "ying",
	"6C24": "yin",
	"8835": "xi",
	"52B0": "mo",
	"589C": "zhui",
	"8E63": "man;pan",
	"8ED1": "di",
	"7E9D": "lei",
	"99BC": "wen",
	"5966": "wu",
	"6005": "chang",
	"6B98": "can",
	"77C6": "huo",
	"867C": "ge",
	"57EB": "zhong",
	"966F": "lun",
	"9C9B": "jiao",
	"9FA2": "he",
	"8B79": "hao",
	"8E80": "kuang",
	"9A9B": "wu",
	"4F50": "zuo",
	"7B65": "ju",
	"93F4": "lu",
	"4F28": "xun",
	"6656": "hui",
	"8A48": "li",
	"8B2C": "miu",
	"90D7": "xi",
	"9AF4": "fu;fo",
	"60DC": "xi",
	"654D": "xu",
	"67FF": "shi",
	"6DB3": "kong",
	"80B6": "pi",
	"91E7": "chuan",
	"9F34": "yan",
	"73FE": "xian",
	"8383": "xi",
	"9144": "huan",
	"4F3A": "si;ci",
	"55B1": "li",
	"6F67": "zhen",
	"7AFE": "chi",
	"7CDB": "tang",
	"7E1E": "gao",
	"87C3": "wan",
	"5350": "wan",
	"703A": "chan",
	"83BC": "chun",
	"8F6D": "e",
	"8FC2": "yu",
	"9872": "lan",
	"5DF4": "ba",
	"62C3": "zha",
	"78FD": "qiao",
	"9232": "gu",
	"93B8": "juan",
	"5E30": "gui",
	"75AF": "feng",
	"7852": "xi",
	"7F99": "gao",
	"8B03": "none",
	"94C9": "xuan",
	"98F9": "liu",
	"5EF1": "yong",
	"8480": "yun",
	"88BA": "jie",
	"9BDC": "qie",
	"9C5F": "hou",
	"60D8": "wang",
	"78AE": "ti",
	"97CD": "fu",
	"9C61": "zei",
	"57C7": "yong",
	"634B": "lu;luo",
	"7574": "chou",
	"7605": "dan",
	"87C2": "jiao",
	"90B1": "qiu",
	"6D51": "hun",
	"7744": "shao",
	"7BF9": "cuan",
	"8B36": "zhuo",
	"6563": "san",
	"9EC7": "tian",
	"532A": "fei",
	"83E4": "juan",
	"8AF1": "hui",
	"92DA": "tiao",
	"943F": "yi",
	"94EE": "zheng",
	"5EFA": "jian",
	"6846": "kuang",
	"7715": "zhen",
	"7C7D": "zi",
	"8AD3": "jian",
	"8EF4": "zhu",
	"50D6": "xi",
	"5AFA": "xian",
	"60AD": "qian",
	"6DBB": "gan",
	"7677": "none",
	"7DC4": "gun",
	"8ACB": "qing",
	"8CFB": "fu",
	"56DC": "nin",
	"87EB": "yin",
	"9C5E": "guan",
	"5497": "zuo",
	"61BA": "dan",
	"6D27": "wei",
	"7113": "han",
	"8246": "lang",
	"835A": "jia",
	"92E2": "none",
	"58E4": "rang",
	"7158": "chan",
	"71C0": "chan",
	"7250": "tou",
	"8396": "jing",
	"916D": "you",
	"9995": "nang",
	"9AD3": "sui",
	"9B94": "ju",
	"5244": "jing",
	"6F97": "jian",
	"7B78": "gan",
	"963B": "zu",
	"9D13": "mie",
	"6A94": "dang",
	"9163": "han",
	"9948": "xiu",
	"645A": "cheng",
	"64B4": "dun",
	"6AD5": "cuan",
	"7C22": "min",
	"7F16": "bian",
	"9F92": "long",
	"5302": "none",
	"6E25": "wo",
	"70BC": "lian",
	"4FAB": "ning",
	"6297": "kang",
	"720E": "none",
	"7519": "dai",
	"8FFB": "yi",
	"90B7": "wa",
	"9560": "liu",
	"4E5F": "ye",
	"83D5": "lun",
	"5289": "liu",
	"575A": "jian",
	"5A25": "e",
	"62AA": "pu",
	"74F4": "ling",
	"7DB6": "guo",
	"838E": "sha;suo",
	"899A": "jue;jiao",
	"900F": "tou",
	"5EE3": "guang",
	"6C62": "none",
	"7B9C": "kong",
	"7CA9": "none",
	"93DA": "qi",
	"9773": "jin",
	"7D39": "shao",
	"9DAE": "ge",
	"9F1E": "tang",
	"4F34": "ban",
	"56E9": "yun",
	"63FF": "qin",
	"6970": "yu",
	"6A7C": "yuan",
	"6E91": "suo",
	"7D6D": "quan",
	"80B5": "jin",
	"8A10": "jie",
	"5E9E": "pang",
	"7A48": "men",
	"95F1": "wei",
	"759C": "xia",
	"81BC": "gua",
	"851A": "yu;wei",
	"5D83": "zhan",
	"6BF6": "none",
	"6E89": "gai",
	"76A8": "xing",
	"9A24": "kui",
	"688B": "xuan",
	"79DA": "ban",
	"8B41": "hua",
	"8FF6": "you",
	"5679": "dang",
	"750A": "lou",
	"87EF": "rao;nao",
	"8C1E": "xu",
	"55FD": "sou",
	"748F": "wei",
	"84D2": "xian",
	"53DE": "yu",
	"55AA": "sang",
	"67B1": "tai",
	"816F": "tu",
	"4F9E": "ru",
	"50DD": "chan",
	"52F8": "quan",
	"5356": "mai",
	"5CE8": "e",
	"5CF7": "shen",
	"6140": "xie",
	"6A3C": "zhen",
	"724B": "jian",
	"83B8": "you",
	"59BD": "shen",
	"6EA5": "pu",
	"8AE5": "zhong",
	"9086": "deng",
	"99F1": "luo",
	"5688": "yan",
	"5E62": "chuang;zhuang",
	"6038": "xi",
	"7642": "liao",
	"768A": "ling",
	"8DAD": "yao",
	"9E37": "zhi",
	"501C": "ti",
	"595B": "huang",
	"6560": "duo",
	"69BA": "sheng",
	"6DC8": "gu",
	"7EF3": "sheng",
	"930B": "peng",
	"7D4F": "xie",
	"7DAF": "tao",
	"86B4": "you",
	"86BE": "bo",
	"91E6": "kou",
	"5F4B": "hong",
	"654C": "di",
	"7114": "yan",
	"8C8E": "ni",
	"54EC": "he",
	"6FA2": "dang",
	"928C": "cun",
	"99F5": "liu",
	"6418": "zhi",
	"6EC7": "dian",
	"7078": "jiu",
	"70B5": "tong;dong",
	"7611": "gua",
	"7D60": "gai",
	"9202": "chen",
	"55DA": "wu",
	"673C": "bi",
	"6F79": "chan",
	"70D8": "hong",
	"8162": "ou",
	"8A32": "yi",
	"4E68": "shi",
	"5D40": "zhu",
	"6AF4": "lai",
	"6DF1": "shen",
	"78D0": "pan",
	"7B6D": "suan",
	"7EFD": "zhan",
	"8C93": "mao",
	"9814": "di",
	"9B28": "hong",
	"6071": "yue",
	"62F6": "zan",
	"7096": "dun",
	"7415": "bing",
	"7C32": "pai",
	"8C3A": "ya",
	"5B32": "niao",
	"68DB": "yu",
	"89D5": "cu",
	"656B": "jiao",
	"9C0E": "jian",
	"5CBB": "chi",
	"7C41": "lai",
	"9454": "cha",
	"94D5": "you",
	"51AD": "tai",
	"553F": "hu",
	"8A94": "ting",
	"9301": "guo",
	"98D6": "yao",
	"5478": "pei",
	"700A": "pan",
	"922F": "tu",
	"4E6A": "nang",
	"66DC": "yao;yue",
	"6D29": "xie",
	"7529": "shuai",
	"9B5A": "yu",
	"6158": "can",
	"735B": "bu",
	"7B9D": "qian",
	"7D42": "zhong",
	"9492": "fan",
	"611C": "qie",
	"7F05": "mian",
	"8CFF": "liao",
	"9D11": "nu",
	"9226": "tai",
	"52B5": "juan",
	"5A4A": "biao",
	"5CC6": "he",
	"7B57": "zhong",
	"86F9": "yong",
	"8A58": "chu;qu",
	"99CC": "yuan",
	"6866": "hua",
	"7105": "xun",
	"7140": "none",
	"866C": "qiu",
	"9E1B": "guan",
	"4E0D": "bu;fou",
	"5F37": "qiang;jiang",
	"6346": "kun",
	"6F78": "shan",
	"751D": "han",
	"9355": "rou",
	"653A": "gai",
	"6997": "jian",
	"756F": "jun",
	"7663": "xuan",
	"88D7": "liu",
	"8A77": "tong",
	"651C": "xie",
	"6A98": "bi",
	"7ADA": "zhu",
	"53A5": "jue",
	"5872": "chang",
	"6540": "bo",
	"6CC5": "qiu",
	"5B53": "jue",
	"5EF2": "li",
	"68B6": "wei",
	"6F8D": "shu",
	"811C": "you",
	"8A2B": "xin",
	"8AF3": "an",
	"588B": "chen",
	"5D2A": "zu",
	"627C": "e",
	"734A": "chuang",
	"76F5": "qi",
	"7F0A": "yun",
	"7FD4": "xiang",
	"8ECD": "jun",
	"7136": "ran",
	"76AC": "he",
	"8547": "dian",
	"9609": "yan",
	"5822": "bao",
	"59CD": "shan",
	"6FBC": "pi",
	"7B55": "hang",
	"5C14": "er",
	"6F55": "wu",
	"7D37": "ling",
	"56D8": "hui",
	"7319": "zheng",
	"8F57": "kan",
	"913D": "chan",
	"59C4": "ni",
	"6D62": "dou",
	"6DE3": "ni",
	"7DA8": "qi",
	"841F": "none",
	"9691": "gai",
	"97F8": "peng",
	"520F": "ji",
	"775D": "li",
	"8660": "jiao",
	"7A86": "bian",
	"9D3D": "ru",
	"5E47": "bang",
	"95A5": "fa",
	"99E6": "teng",
	"9BF3": "none",
	"5597": "yun",
	"71A8": "yun",
	"786D": "mang",
	"94AD": "tou",
	"95D3": "kai",
	"9ED2": "hei",
	"50B5": "zhai",
	"5979": "ta",
	"75CA": "quan",
	"7DCC": "rui",
	"8860": "zhun",
	"8C07": "sui",
	"9CA7": "gun",
	"5F99": "xi",
	"64EE": "ji",
	"5131": "long",
	"6998": "ju",
	"7802": "sha",
	"8B39": "jin",
	"5E1C": "zhi",
	"5FF1": "chen",
	"70A0": "xia",
	"851D": "mi",
	"88A7": "kou",
	"5B05": "hua",
	"9162": "zuo;cu",
	"9381": "ye",
	"958A": "none",
	"9C77": "e",
	"59FD": "gui",
	"610A": "bi",
	"834E": "chi",
	"61C9": "ying",
	"6316": "wa",
	"6C7C": "none",
	"8F0B": "ju",
	"9866": "qiao",
	"5042": "qian",
	"5864": "xun;xuan",
	"5B0E": "fan",
	"6A99": "ding",
	"8A3B": "zhu",
	"94A3": "ban",
	"9C15": "ha;xia",
	"508A": "yun",
	"66B4": "bao;pu",
	"675A": "gu",
	"7597": "liao",
	"7A68": "tui",
	"85C8": "kui",
	"5E65": "none",
	"8DF6": "da",
	"5813": "an",
	"5E66": "mi",
	"66AA": "men",
	"6AAD": "yin",
	"8265": "jie",
	"9767": "hui",
	"9DB3": "shi",
	"56C0": "zhuan",
	"638F": "tao",
	"6AF9": "xiao",
	"94BD": "tan",
	"6489": "dun",
	"9D2A": "yu",
	"5296": "chan",
	"5441": "jun",
	"5DA9": "nao",
	"62F1": "gong",
	"699A": "yao",
	"7B32": "fan",
	"7BBD": "dong",
	"80E2": "ke",
	"94C5": "qian;yan",
	"9564": "pu",
	"9D9D": "fu",
	"4E33": "chan",
	"5AE1": "di",
	"73F4": "e",
	"8F0A": "zhi",
	"938B": "xia",
	"9398": "ge",
	"5B81": "ning",
	"626E": "ban",
	"6974": "di",
	"6A3A": "hua",
	"8A90": "e",
	"8E5E": "kui",
	"959D": "ling",
	"975C": "jing",
	"6659": "jun",
	"6DEA": "lun",
	"6FD1": "lai",
	"50B3": "chuan;zhuan",
	"6954": "xie",
	"75AA": "bi",
	"8B6B": "zhan",
	"8FC7": "guo",
	"9E78": "jian",
	"5285": "zhuo",
	"5962": "she",
	"6688": "yun",
	"6BA6": "diao",
	"7FC9": "pen",
	"95E5": "ta",
	"9D17": "li",
	"6F1A": "ou",
	"88E0": "qun",
	"95EB": "yan",
	"502F": "song",
	"7BA3": "ce",
	"8885": "niao",
	"5540": "ai",
	"55F5": "tong",
	"5CCC": "die",
	"5FFA": "xian",
	"6BE6": "er",
	"8386": "pu",
	"83FD": "shu",
	"96B3": "hui",
	"9A11": "fei",
	"9CB4": "gu",
	"6B4C": "ge",
	"6FD4": "mi",
	"86D8": "yang",
	"9575": "chan",
	"9891": "pin",
	"4F15": "fu",
	"7C6B": "zuan",
	"7C77": "zhe",
	"96FB": "dian",
	"50D2": "jiong",
	"530B": "tao",
	"9A82": "ma",
	"5574": "tan;chan",
	"5C50": "ji",
	"610C": "huan",
	"7305": "han",
	"9A3E": "luo",
	"9D15": "tuo",
	"7EDD": "jue",
	"8B91": "yao",
	"9DA8": "dun",
	"9ED9": "mo",
	"6B0C": "none",
	"71AD": "wei",
	"8259": "cang",
	"6E0D": "zi",
	"6E35": "mao",
	"78D5": "ke",
	"8546": "chan",
	"9135": "cao",
	"56AD": "pi",
	"58EB": "shi",
	"5692": "none",
	"87EA": "hui",
	"69FD": "cao",
	"7D43": "xian",
	"81C5": "chu",
	"8C5B": "yi",
	"59D7": "shan",
	"5C3A": "chi;che",
	"61CF": "jun",
	"7B4D": "sun",
	"84B4": "shuo",
	"5FDA": "xi",
	"64E9": "ru",
	"65FF": "wu",
	"9544": "fei",
	"9B85": "bi",
	"4EA9": "mu",
	"56E1": "nan",
	"63FE": "wen",
	"8041": "none",
	"9C3B": "man",
	"7899": "gang",
	"7E78": "sui",
	"8B01": "ye",
	"8CD4": "bin",
	"5263": "jian",
	"560A": "none",
	"5C0C": "shu",
	"63EA": "jiu",
	"81F3": "zhi",
	"50A6": "none",
	"51B2": "chong",
	"5CBA": "ling",
	"6D53": "nong",
	"7293": "chu",
	"7AC5": "qiao",
	"818C": "ji",
	"840D": "ping",
	"84F0": "xi",
	"89EF": "zhi",
	"8BC2": "gu",
	"4FF7": "fei",
	"7DFB": "zhi",
	"803C": "dan",
	"93EF": "none",
	"5492": "zhou",
	"54A1": "er",
	"88E5": "jian",
	"9071": "lou",
	"92F7": "zui",
	"9854": "yan",
	"9B93": "zha",
	"9F59": "bao",
	"614C": "huang",
	"643F": "ge",
	"6DCD": "zhou",
	"83F1": "ling",
	"8F3A": "zi",
	"9685": "yu",
	"528A": "gui",
	"5A82": "ti",
	"5B47": "shuang",
	"5BFE": "dui",
	"6963": "mei",
	"6B9D": "none",
	"7CC2": "san;shen",
	"7D8C": "xi",
	"9B46": "xu",
	"5A83": "rou",
	"5B25": "tiao",
	"7AE7": "jing",
	"9722": "mo",
	"5522": "suo",
	"7DCD": "min",
	"5752": "bi",
	"6A04": "chen",
	"6A4D": "run",
	"774E": "xi",
	"787A": "zhuo",
	"84D3": "bei",
	"8C91": "jia",
	"92F1": "te",
	"5648": "cu",
	"8573": "jian",
	"6492": "sa",
	"72E6": "shan",
	"843F": "huo",
	"86C2": "bie",
	"8ADD": "xu",
	"842D": "yu",
	"8BBE": "she",
	"5DC5": "dian",
	"641B": "jian",
	"82EC": "qiu",
	"8946": "pu",
	"8E09": "liang",
	"9844": "han",
	"9C90": "tai",
	"54F4": "liang",
	"81D9": "yan",
	"8FB8": "reng",
	"5F3F": "jian",
	"6599": "liao",
	"6ABA": "gao",
	"71A9": "hu",
	"79A3": "none",
	"7A54": "huang",
	"8526": "niao",
	"864D": "hu",
	"8B15": "si",
	"59C3": "zheng",
	"6648": "jiao",
	"79D2": "miao",
	"9B64": "e",
	"53AA": "qin;jin",
	"8430": "lian",
	"8F31": "xian",
	"568D": "jin",
	"66D2": "jiao",
	"6C7D": "qi",
	"6ECC": "di",
	"8EB0": "ti",
	"8F6B": "ren",
	"79BB": "li",
	"8AE6": "di",
	"8CE8": "cong",
	"9AE1": "kun",
	"5080": "kui;gui",
	"5DF6": "zhao",
	"6604": "ban",
	"6BFE": "ta",
	"73B7": "dian",
	"8F40": "wen",
	"92B8": "zhe",
	"54DE": "mou",
	"5DE7": "qiao",
	"64FA": "bai",
	"75C2": "jia",
	"77F4": "ding",
	"7B7E": "qian",
	"8606": "lu",
	"94CC": "ni",
	"6422": "jin",
	"6CFC": "po",
	"702E": "none",
	"79BC": "xie",
	"83CF": "he",
	"855E": "zui",
	"5053": "wo",
	"526E": "gua",
	"576F": "pi",
	"676F": "bei",
	"7ECD": "shao",
	"8505": "yan",
	"96AA": "xian",
	"5D09": "ta",
	"82AE": "rui",
	"86E0": "li",
	"8DFB": "ji",
	"9DDB": "rong",
	"53F2": "shi",
	"8071": "ao",
	"972A": "yin",
	"9D9F": "tu",
	"5059": "di",
	"5C3D": "jin",
	"6C47": "hui",
	"8AB2": "ke",
	"9AD0": "nao",
	"521E": "qu",
	"6603": "ze",
	"8370": "du",
	"86A2": "hang",
	"8A02": "ding",
	"9A33": "du",
	"5BD9": "yu",
	"77FE": "fan",
	"8009": "gou",
	"8A27": "you",
	"9970": "shi",
	"4F06": "wen",
	"6A7D": "ta",
	"7071": "xiao",
	"99C5": "yi",
	"9A37": "sao",
	"9C3E": "biao",
	"9E82": "ji",
	"551C": "none",
	"57E3": "sui",
	"8160": "cou",
	"8B87": "chan",
	"909A": "ru",
	"90C2": "gai",
	"90CB": "xi",
	"96B0": "xi",
	"9B29": "xi",
	"5B4F": "lan",
	"67D4": "rou",
	"941A": "lou;lue",
	"96ED": "se",
	"9DC8": "ti",
	"54FD": "geng",
	"551B": "ma",
	"5865": "ge",
	"5884": "ce",
	"6337": "peng",
	"6821": "xiao;jiao",
	"7DA4": "shao",
	"85A5": "shu",
	"89C9": "jue;jiao",
	"8C7F": "gou",
	"998A": "sou",
	"9B68": "tun",
	"9E3F": "hong",
	"9274": "jian",
	"599C": "yue",
	"5AE0": "li",
	"7042": "zhuo",
	"7C61": "none",
	"85FC": "xuan",
	"8674": "zhe",
	"4E35": "zhuo",
	"6007": "ju",
	"65D7": "qi",
	"6A69": "qiong",
	"74A1": "jin",
	"8976": "dai",
	"8C36": "chen",
	"5212": "hua;huai",
	"8AF4": "xian",
	"8ED2": "xuan",
	"583A": "jie",
	"761E": "yi",
	"7A90": "gui",
	"55CA": "hong",
	"693A": "xi",
	"76DE": "zhan",
	"8171": "jian",
	"8E28": "zong",
	"974C": "bao",
	"6647": "xu;kua",
	"683B": "chi",
	"741E": "sheng",
	"7E49": "hun",
	"84B3": "na",
	"922E": "ni",
	"80CB": "tian",
	"6218": "zhan",
	"64D7": "pi",
	"7DB3": "beng",
	"7FCD": "pi;po",
	"878A": "lian",
	"9CD7": "man",
	"67B6": "jia",
	"827B": "le",
	"8DDA": "shan",
	"93D0": "liu",
	"95F3": "hong",
	"695A": "chu",
	"6EB5": "yin",
	"79B2": "li",
	"881B": "mie",
	"947A": "qu",
	"6169": "lian",
	"66E9": "nang",
	"9179": "lei",
	"97C0": "jian",
	"9BFD": "ji",
	"533D": "yan",
	"5E3A": "qi",
	"69F8": "yi",
	"8B59": "qiao",
	"6246": "yi",
	"76E8": "xu",
	"8584": "bo;bao",
	"9AB8": "hai",
	"5934": "tou",
	"7691": "ai",
	"89BE": "shen",
	"64E3": "dao",
	"6766": "shan",
	"7222": "mi",
	"77E4": "shen",
	"81D4": "xian",
	"99BD": "zhi",
	"5978": "jian",
	"7E97": "zui",
	"8F2A": "lun",
	"7B35": "fan",
	"845D": "jing",
	"9459": "ji",
	"945B": "kuang",
	"9BB0": "hui",
	"9BBB": "suo",
	"56BE": "huan",
	"5CA6": "li",
	"6501": "yang",
	"8E24": "zu",
	"96DC": "za",
	"5107": "xuan",
	"7686": "jie",
	"8173": "jiao",
	"9272": "ka",
	"9660": "pu",
	"7FBB": "qiang",
	"84E7": "diao",
	"9D69": "fu",
	"4F5F": "tong",
	"5133": "chan",
	"5354": "xie",
	"56CF": "jian",
	"5CE5": "zheng",
	"71F6": "none",
	"760A": "hou",
	"9DA7": "ying",
	"55EE": "sai",
	"561D": "hu",
	"6D2D": "kuang",
	"6F01": "yu",
	"7442": "mei",
	"78B0": "peng",
	"823D": "pang",
	"8F15": "qing",
	"9DF9": "ying",
	"527C": "shan",
	"56CB": "zan",
	"6700": "zui",
	"7A3F": "gao",
	"7A43": "none",
	"5F51": "ji",
	"71DA": "yi",
	"98F3": "zhu",
	"4FFE": "bi;bei",
	"5411": "xiang",
	"5604": "jiao",
	"5671": "xue;jue",
	"7CF1": "nie",
	"7EA7": "ji",
	"806F": "lian",
	"82C4": "bian",
	"8862": "qu",
	"9371": "ye",
	"98B7": "biao",
	"5134": "rang",
	"5D86": "cao",
	"6BAB": "dan",
	"6BF0": "pei",
	"8B94": "yin",
	"8C69": "bin",
	"99AF": "han",
	"5323": "xia",
	"554C": "xiang",
	"658D": "jue",
	"7040": "shuang",
	"862D": "lan",
	"95F8": "zha",
	"97F6": "shao",
	"5547": "di",
	"6C53": "qiu",
	"6EE3": "chun",
	"8FA6": "ban",
	"995D": "mo",
	"5195": "mian",
	"7421": "chu",
	"520C": "cun",
	"5349": "hui",
	"6A8D": "yi",
	"83BD": "mang",
	"87CA": "mao",
	"8B8A": "bian",
	"6AE3": "lian",
	"756B": "hua",
	"7CC7": "hou",
	"834F": "ren",
	"882B": "li",
	"8B12": "qiang",
	"8D28": "zhi",
	"92C2": "mei",
	"9DFB": "tuan",
	"5809": "yu",
	"5828": "e;ai",
	"5FB0": "zheng",
	"7CD5": "gao",
	"861D": "lian",
	"983A": "tui",
	"9C06": "chun",
	"5275": "chuang",
	"721C": "cong",
	"8A52": "yi",
	"8AC4": "zhun",
	"4E6C": "none",
	"5736": "qia",
	"5E33": "zhang",
	"7019": "qin",
	"7B5E": "ce",
	"87D3": "xiang",
	"8874": "dan",
	"954A": "nie",
	"584B": "ying",
	"6732": "ren",
	"5FF2": "tai",
	"6082": "mang",
	"7EEF": "fei",
	"86DD": "xian",
	"9147": "zan",
	"9C35": "min",
	"9F97": "ling",
	"509B": "yong",
	"51A0": "guan",
	"59DA": "yao",
	"5ACF": "lang",
	"6B95": "fou",
	"7351": "chan",
	"7A13": "zuo",
	"8852": "xuan",
	"8F44": "xia",
	"4F3C": "si;shi",
	"5EFD": "hui",
	"7F22": "yi",
	"85AA": "xin",
	"9444": "zhu",
	"4EC3": "ding",
	"7967": "tiao",
	"5046": "chun",
	"57FC": "qi",
	"6976": "jie",
	"765B": "lin",
	"8B45": "se",
	"8FC1": "qian",
	"60F3": "xiang",
	"6AFF": "ying",
	"718E": "yao",
	"7352": "ao",
	"789F": "die",
	"85C1": "gao",
	"918B": "cu",
	"927C": "bing",
	"8063": "none",
	"81A0": "jiao",
	"8984": "none",
	"8E11": "qi",
	"9B89": "diao",
	"609A": "song",
	"998B": "chan",
	"9EC6": "guang",
	"5055": "xie;jie",
	"58BA": "ao",
	"6030": "xuan",
	"611B": "ai",
	"937D": "bian",
	"6DB0": "chuo",
	"715E": "sha",
	"77F2": "bai;pai",
	"55B8": "none",
	"5B96": "hong",
	"6B10": "li",
	"869A": "qi",
	"92EB": "li",
	"948E": "qian",
	"5A7E": "tou",
	"6AFC": "jian",
	"6D43": "jia",
	"8409": "fei",
	"8DAF": "yue",
	"50B7": "shang",
	"5E82": "ze",
	"7FED": "hou",
	"58E5": "chan",
	"597D": "hao",
	"78FC": "za",
	"7F33": "huan",
	"88EF": "chou",
	"52F4": "lu",
	"7A9B": "kou",
	"7B1F": "gu",
	"7D1E": "dan",
	"872D": "han",
	"8CB0": "shi",
	"92E1": "han",
	"9988": "kui",
	"6E70": "long",
	"8AA8": "hui",
	"9159": "zhen",
	"95D6": "chuang",
	"51A3": "zui",
	"5818": "cheng",
	"8BC6": "shi;zhi",
	"9252": "zhu",
	"5142": "zan",
	"5603": "chong",
	"58BD": "qiao",
	"6661": "bu",
	"70AC": "ju",
	"7BAF": "bian",
	"8A1F": "song",
	"7749": "cuo",
	"7BE1": "cuan",
	"829D": "zhi",
	"532C": "yu",
	"5388": "an;chang",
	"65EB": "tiao",
	"66F9": "cao",
	"7E83": "qi",
	"9D16": "wen",
	"9E8F": "jun;qun",
	"65CF": "zu",
	"792C": "fan",
	"8CF4": "lai",
	"97F1": "xian",
	"5F8A": "huai;hui",
	"6EC9": "huang",
	"7EBC": "zhen",
	"7F5C": "zhu",
	"9ED4": "qian",
	"4FA2": "zai",
	"9349": "di",
	"99D2": "ju",
	"9A5F": "zou;zhou",
	"5BBD": "kuan",
	"71C3": "ran",
	"7DB5": "cai",
	"92BA": "zang",
	"9400": "kui",
	"53EF": "ke",
	"8C2E": "jian;zen",
	"9EBF": "none",
	"565D": "si",
	"6027": "xing",
	"681D": "gua;kuo",
	"685B": "none",
	"6F73": "tu",
	"7F79": "li",
	"8CF8": "sheng",
	"8F01": "qiong",
	"9996": "shou",
	"6113": "dang",
	"6A26": "zhu",
	"6E00": "ben",
	"9247": "ta;tuo",
	"58FD": "shou",
	"6B31": "xia",
	"70A3": "ke",
	"82F0": "hong",
	"8A4E": "ju",
	"8E71": "zhong",
	"9026": "li",
	"9779": "ren",
	"5100": "yi",
	"51DF": "du",
	"5926": "chen",
	"64A7": "jue",
	"9054": "da",
	"56B4": "yan",
	"587E": "shu",
	"5D41": "kan",
	"7AC6": "qiong",
	"7E74": "bo",
	"9F75": "yu",
	"579D": "gui",
	"66DE": "li",
	"6C2C": "ya",
	"7EAF": "chun",
	"8BB1": "ren",
	"5B97": "zong",
	"5DBE": "yin",
	"6E22": "feng",
	"7D66": "gei;ji",
	"8A13": "xun",
	"52DF": "mu",
	"5551": "jie",
	"7126": "jiao",
	"899E": "yao",
	"9F38": "xian",
	"5C0E": "dao",
	"5CF6": "dao",
	"6A64": "rui",
	"6F4B": "lian",
	"8302": "mao",
	"8F94": "pei",
	"98E5": "tuo",
	"9EDF": "yi",
	"9F91": "yan",
	"5FBE": "mei",
	"693F": "chun",
	"821E": "wu",
	"64EB": "ye",
	"6CD0": "le",
	"71F4": "hui",
	"7C07": "cu",
	"51D6": "zhun",
	"659E": "yu",
	"6C18": "dao",
	"615D": "ni;te",
	"62EB": "hen",
	"8B29": "mo",
	"920B": "e",
	"9533": "ying",
	"6748": "cha",
	"9A76": "shi",
	"9E2D": "ya",
	"515D": "fen",
	"5248": "yuan",
	"53B4": "yan",
	"6F26": "li",
	"720D": "shuo",
	"7B45": "xian",
	"8403": "cui",
	"8535": "cang;zang",
	"8828": "xiao",
	"9C29": "yao",
	"5D5A": "qin",
	"6A80": "tan",
	"845E": "mi",
	"95EA": "shan",
	"9D4E": "tuo",
	"563A": "qiao",
	"687A": "liu",
	"71BE": "chi",
	"7FA3": "qun",
	"897E": "ya",
	"903F": "dang",
	"4EDC": "hong",
	"5909": "bian",
	"7E15": "yun",
	"8FC4": "qi",
	"58C3": "jiang",
	"5E5C": "jiong",
	"64B2": "pu",
	"75E5": "duo",
	"7B9F": "jun",
	"8408": "huan",
	"92A3": "ru",
	"73F2": "hun;hui",
	"7F5E": "mao",
	"8D5A": "zhuan;zuan",
	"4EFE": "di",
	"5A5C": "qian",
	"62FA": "ce",
	"6CC8": "zhong",
	"8414": "tiao",
	"96BA": "he",
	"9D56": "bi",
	"5488": "fu",
	"60A0": "you",
	"6636": "chang",
	"7C63": "lan",
	"8BD1": "yi",
	"4FCD": "lang",
	"6E4D": "tuan",
	"855D": "jue",
	"977F": "yao",
	"6ACA": "none",
	"7EB1": "sha",
	"8699": "qian",
	"8EAF": "qu",
	"9717": "none",
	"5EA5": "xiu",
	"669B": "suo",
	"6A82": "nong",
	"6EDF": "yan",
	"6FD2": "bin",
	"8D80": "ci",
	"925E": "yue",
	"92B2": "han",
	"9D81": "jing",
	"571A": "hui",
	"5BD1": "qin",
	"5A11": "suo",
	"7D1C": "yun",
	"949C": "ju",
	"94C6": "mao",
	"9889": "jie;xie",
	"59C6": "mu",
	"681E": "kan",
	"78BB": "que",
	"99C1": "bo",
	"9ED6": "xi",
	"532B": "hu",
	"54AF": "ge;ka;lo;luo",
	"7E5B": "chuo",
	"8BF2": "hui",
	"7186": "he",
	"815D": "ruan",
	"872B": "kun",
	"518D": "zai",
	"5401": "yu;xu",
	"7157": "nuan",
	"7F9D": "di",
	"8E42": "rou",
	"98AF": "sa",
	"9D3E": "mou",
	"53D5": "zhui",
	"6759": "yi",
	"678A": "ang",
	"98AB": "fu",
	"581C": "lian",
	"59D4": "wei",
	"6348": "tu",
	"7190": "ming",
	"8DD4": "ju",
	"9A7C": "tuo",
	"6ECB": "zi",
	"73B4": "yi",
	"762E": "shen",
	"845A": "shen;ren",
	"8EC7": "dao",
	"93AF": "luo",
	"96C7": "gu",
	"9997": "kui",
	"9726": "bin",
	"4E31": "guan",
	"57D5": "cheng",
	"727C": "keng",
	"53EE": "ding",
	"579F": "yang",
	"616A": "ou",
	"74F1": "none",
	"7EF9": "tao",
	"8115": "wan",
	"8949": "jian",
	"7876": "chen",
	"7A3C": "jia",
	"7AE8": "diao",
	"8CD8": "zang",
	"9388": "cha",
	"985A": "dian",
	"519D": "yi",
	"5436": "na",
	"7941": "qi",
	"83EA": "dang",
	"9061": "su",
	"9731": "yu",
	"9892": "hui",
	"9E74": "shuang",
	"540F": "li",
	"68C2": "ling",
	"856E": "xi",
	"85EA": "sou",
	"90A8": "cun",
	"945D": "peng",
	"9BB7": "ti",
	"6208": "ge",
	"748D": "none",
	"75DE": "pi",
	"7A47": "shan",
	"833E": "none",
	"950D": "liu",
	"9EAF": "qu",
	"52ED": "tong",
	"53AC": "gui",
	"624B": "shou",
	"87E9": "jue",
	"50EF": "lin",
	"540A": "diao",
	"613C": "shen",
	"6805": "zha;shan",
	"698A": "none",
	"5E0A": "pa",
	"5DC2": "sui;xi",
	"6189": "peng",
	"6E80": "man",
	"88DE": "shui",
	"97C4": "huo",
	"5898": "qi",
	"66A7": "ai",
	"7B96": "lin",
	"85F5": "none",
	"514A": "dui",
	"5545": "zhuo",
	"656C": "jing",
	"6B27": "ou",
	"7D54": "bai",
	"8A9F": "xiao",
	"9216": "fen",
	"7C0C": "su",
	"9187": "chun",
	"7617": "yi",
	"8A8D": "ren",
	"5F58": "zhi",
	"6374": "zong",
	"81AB": "liao",
	"8572": "qi",
	"8701": "xuan",
	"9008": "jiong",
	"59F7": "you",
	"5D74": "ji",
	"5FDC": "ying",
	"683E": "luan",
	"701D": "li",
	"7C3C": "gou",
	"7EE1": "xiao",
	"8615": "none",
	"8B3E": "man",
	"70B9": "dian",
	"7107": "xiao",
	"7E80": "pu",
	"7F73": "si",
	"9DF4": "xian",
	"5C67": "xie",
	"5F1F": "di",
	"6C71": "quan",
	"6F5B": "qian",
	"74DE": "die",
	"9668": "yun",
	"99CE": "zhou",
	"4EE1": "ge;yi",
	"6167": "hui",
	"62E9": "ze;zhai",
	"699F": "zi",
	"6F42": "hong",
	"7507": "ying",
	"837E": "sui",
	"880C": "ze",
	"8F4D": "che;zhe",
	"9B77": "you",
	"58DD": "wei",
	"6AB8": "ning",
	"7EEC": "yin",
	"85C3": "xiao",
	"6DF9": "yan",
	"86F0": "zhe",
	"89E4": "gui",
	"5004": "yao",
	"53BC": "none",
	"53EA": "zhi",
	"5764": "kun",
	"5A1C": "na;nuo",
	"5BFA": "si",
	"650E": "lu",
	"781D": "fa",
	"8224": "none",
	"888A": "ling",
	"94E5": "diu",
	"99D9": "fu",
	"51AC": "dong",
	"71D1": "tong",
	"8D85": "chao",
	"4F37": "zhou",
	"6182": "you",
	"84B8": "zheng",
	"94D9": "nao",
	"9E8E": "chen",
	"6955": "tuo",
	"7453": "lian",
	"8722": "meng",
	"55C9": "su",
	"7B46": "bi",
	"7D23": "cui",
	"8503": "qiang",
	"539F": "yuan",
	"573C": "nie",
	"6950": "jie",
	"7575": "hua",
	"75C4": "zha",
	"8167": "shu",
	"8A88": "wu",
	"4EFF": "fang",
	"54BB": "xiu",
	"956D": "lei",
	"9EDA": "qian",
	"616B": "song",
	"7A36": "yu",
	"85C6": "jian",
	"8C3F": "qi;xi",
	"94D4": "ya",
	"5AC5": "cha",
	"5BA7": "yi",
	"6BD8": "pi",
	"7409": "liu",
	"839E": "guan;wan",
	"869D": "hao",
	"996E": "yin",
	"5638": "fu;m",
	"75A3": "you",
	"76F2": "mang",
	"8A72": "gai",
	"92E5": "zeng",
	"5CAF": "pei",
	"9D28": "ya",
	"9E96": "jing",
	"52E1": "piao",
	"5386": "li",
	"5E01": "bi",
	"7AD7": "miao",
	"85BD": "zhen",
	"8900": "ji",
	"9131": "po",
	"9829": "ping",
	"98B2": "lie",
	"5BBC": "kou",
	"5CD8": "hu",
	"5EC7": "liu",
	"680E": "li;yue",
	"94D1": "lao",
	"6654": "ye",
	"6817": "li",
	"6D5C": "bang",
	"7BA8": "tuo",
	"88D6": "chen",
	"51F7": "kuai",
	"5F09": "zang;zhuang",
	"6CD9": "ping",
	"732E": "xian",
	"7360": "liao",
	"4E8D": "chu",
	"5117": "ni",
	"5DCA": "ying",
	"67F6": "si",
	"6EB3": "yun",
	"93B1": "yuan",
	"981C": "he;han",
	"9852": "yong",
	"51E2": "fan",
	"5539": "yu",
	"617F": "ping",
	"82D8": "qing",
	"9489": "ding",
	"5D43": "yan",
	"6F8F": "han",
	"70B1": "tai",
	"7111": "none",
	"7490": "lu",
	"8C75": "zong",
	"8CA2": "gong",
	"5CEA": "yu",
	"69CD": "qiang",
	"6CF8": "lu",
	"7EE8": "ti;di",
	"855F": "fa",
	"998C": "ye",
	"5536": "jie",
	"7DC6": "yi",
	"9509": "cuo",
	"97FB": "yun",
	"9989": "gu",
	"7CFD": "zheng",
	"8E75": "zu",
	"954C": "juan",
	"5776": "mu",
	"8F0E": "shao",
	"952F": "ju",
	"598A": "ren",
	"5BC3": "yuan",
	"6FE5": "yin",
	"521B": "chuang",
	"78B2": "di",
	"89F2": "xing",
	"97D1": "wei",
	"9A6B": "biao",
	"4EEC": "men",
	"5440": "ya",
	"58F8": "kun",
	"7498": "lin",
	"8DC5": "tuo",
	"99DF": "si",
	"6AD6": "lu",
	"81E7": "zang",
	"97ED": "jiu",
	"5768": "tuo",
	"5B14": "fan",
	"5B7D": "nie",
	"5D84": "zhan",
	"7333": "jia",
	"7BBE": "shuo",
	"9242": "shi",
	"534E": "hua",
	"6800": "zhi",
	"7A30": "xu",
	"9BE0": "lai",
	"623D": "hu",
	"659D": "jia",
	"7C9B": "su",
	"52A9": "zhu",
	"5BFD": "lu;luo",
	"711A": "fen",
	"75B8": "dan",
	"6C3C": "ni",
	"7625": "chai;cuo",
	"7BAB": "xiao",
	"88D8": "qiu",
	"890E": "xiu",
	"9234": "ling",
	"9739": "pi",
	"92D9": "wu",
	"7313": "guo",
	"73BA": "xi",
	"5286": "lian",
	"537F": "qing",
	"59BF": "e",
	"6862": "zhen",
	"8A03": "fu",
	"8C11": "xue",
	"9BAB": "jiao",
	"5B1C": "none",
	"5B4B": "li",
	"5ED8": "lu",
	"809F": "wo",
	"959A": "none",
	"4E40": "fu",
	"5E08": "shi",
	"64F8": "lie",
	"67AB": "feng",
	"69A4": "jie",
	"722F": "zhao",
	"7859": "wei",
	"9B9C": "hou",
	"5CFC": "hao",
	"602C": "xi",
	"65D4": "jian",
	"6FF8": "none",
	"8CE7": "dan",
	"9B17": "man",
	"9C48": "xue",
	"75C7": "zheng",
	"81E4": "qian",
	"8743": "zhuo",
	"9436": "huan",
	"85D6": "xian",
	"8D59": "fu",
	"9206": "yan",
	"963D": "dian;yan",
	"623B": "li",
	"725A": "cheng",
	"9307": "pei",
	"50D4": "zun",
	"5317": "bei",
	"5A08": "luan",
	"5D4B": "mei",
	"5F73": "chi",
	"750E": "zhuan",
	"7A10": "lun",
	"8800": "zi",
	"8F21": "kan",
	"9231": "min",
	"9AF1": "pao",
	"5CCA": "fu",
	"5F11": "shi",
	"5F2B": "zhen",
	"6480": "gou",
	"6917": "ding",
	"905C": "xun",
	"9903": "jiao",
	"9D9C": "mao",
	"6A20": "men",
	"6E92": "yuan",
	"7A21": "zui",
	"859E": "sun",
	"8A2A": "fang",
	"6C7F": "xu",
	"8EDF": "ruan",
	"5BAF": "xiao",
	"7166": "xu",
	"55B2": "yo",
	"5891": "di",
	"67F7": "zhu",
	"9093": "deng",
	"519C": "nong",
	"6F5F": "xi",
	"7FD1": "qu",
	"872C": "gan",
	"59A7": "yuan",
	"6D8D": "xiao",
	"7075": "ling",
	"7711": "yao",
	"81C4": "jue",
	"92FD": "diao",
	"7173": "hu",
	"849C": "suan",
	"8FD5": "wu",
	"587C": "zhuan",
	"6E1D": "yu",
	"71D9": "tang",
	"7209": "lu",
	"740E": "jin",
	"8FC6": "yi",
	"9F5E": "nian",
	"54EB": "zu",
	"5D6B": "zi",
	"6263": "kou",
	"7BDA": "fei",
	"87B5": "piao",
	"517C": "jian",
	"56F4": "wei",
	"5A3F": "e",
	"5CE7": "jiao",
	"67C4": "bing",
	"6ACF": "qian",
	"722A": "zhua;zhao",
	"9C8D": "bao",
	"9E49": "wu",
	"670C": "ban",
	"8283": "peng",
	"84F7": "tui",
	"856A": "wu",
	"9735": "ji",
	"5C08": "zhuan",
	"63A3": "che",
	"9E05": "zhe",
	"4F76": "ji",
	"79E9": "zhi",
	"949F": "zhong",
	"61CC": "yi",
	"670D": "fu",
	"7CD6": "tang",
	"856F": "yong",
	"97B7": "ge",
	"99BB": "yin",
	"53D6": "qu",
	"6A12": "mi",
	"87D1": "zhang",
	"8BA9": "rang",
	"97C9": "jian",
	"9B53": "bi",
	"56CE": "none",
	"7BB9": "yue",
	"7DF7": "yun",
	"812A": "xin",
	"8BFD": "fei",
	"9198": "ke",
	"9340": "de",
	"97DD": "gou",
	"644F": "chong",
	"6908": "ju",
	"726B": "fa",
	"79F3": "huo",
	"832E": "jiao",
	"838A": "zhuang",
	"79CE": "fen",
	"8233": "zhu",
	"83AD": "jie",
	"540D": "ming",
	"58D8": "lei",
	"5DDB": "chuan",
	"7CBA": "bai",
	"8703": "shen",
	"8EBC": "none",
	"8EC8": "none",
	"934B": "guo",
	"546A": "zhou",
	"68DD": "gu",
	"96BB": "zhi",
	"97CB": "wei",
	"4E98": "gen",
	"5239": "cha;sha",
	"628E": "yun",
	"6C5B": "xun",
	"7819": "pan",
	"8514": "bo;bu",
	"8E94": "chan",
	"4F9D": "yi",
	"5E76": "bing",
	"61B0": "jue",
	"75B0": "zhu",
	"9224": "ri",
	"933C": "nai",
	"984E": "e",
	"5165": "ru",
	"541B": "jun",
	"58F0": "sheng",
	"9A05": "zhui",
	"9C94": "wei",
	"6128": "que",
	"6742": "za",
	"7C85": "wu",
	"8A0C": "hong",
	"918D": "ti",
	"5F53": "dang",
	"736A": "kuai",
	"8BD3": "kuang",
	"4E2C": "qiang;pan",
	"5ADF": "ni",
	"80E6": "yang",
	"92D2": "feng",
	"9EA0": "jing",
	"4F6C": "lao",
	"626D": "niu",
	"6AAB": "cha",
	"8402": "he",
	"5693": "ca;cha",
	"985E": "lei",
	"4F2F": "bo;bai",
	"5372": "shao",
	"5608": "cao",
	"7E6E": "jiang",
	"7F7C": "bi",
	"994C": "zhuan",
	"6981": "none",
	"78C2": "liu",
	"831E": "chen",
	"8867": "yu",
	"8C52": "zhi",
	"9715": "tun",
	"9759": "jing",
	"7363": "shou",
	"8241": "zao",
	"90B4": "bing",
	"91CC": "li",
	"7F5F": "gu",
	"819B": "tang",
	"828B": "yu",
	"57B1": "dang",
	"5FA2": "xie",
	"7BE5": "li",
	"78CA": "lei",
	"7FBF": "yi",
	"8181": "qian",
	"827D": "jiao",
	"96CB": "jun;juan",
	"9874": "quan",
	"64CF": "jing",
	"6C41": "zhi",
	"79FA": "du",
	"8574": "yun",
	"8621": "ying",
	"9025": "hui",
	"54D1": "ya",
	"5A8B": "chun",
	"5CD2": "tong;dong",
	"649C": "zheng",
	"690C": "qiang",
	"72A6": "bao",
	"7AD2": "qi;ji",
	"7C1D": "liao",
	"7E57": "lin",
	"8CAC": "ze;zhai",
	"8E04": "bo",
	"71EA": "cong",
	"6231": "xi",
	"666B": "zhuo",
	"6F8C": "si",
	"8BF9": "zou",
	"8D08": "zeng",
	"9C9C": "xian",
	"6E08": "ji",
	"8D44": "zi",
	"9ACC": "bin",
	"5784": "long",
	"5793": "gai",
	"6A3E": "yue",
	"7CFC": "gong",
	"8D72": "li",
	"9895": "ying",
	"9C5C": "xiang",
	"9DEE": "jiao",
	"6847": "ru",
	"6EEA": "yu",
	"6F4F": "yu",
	"87F3": "xun",
	"9B70": "wen",
	"9BDB": "diao",
	"60E7": "ju",
	"6372": "juan",
	"6441": "en",
	"7724": "yi",
	"8CB3": "er",
	"905E": "di",
	"9EF4": "mei",
	"6154": "mo",
	"6CE7": "yue",
	"8118": "wan",
	"92AF": "none",
	"98A1": "sang",
	"9917": "su",
	"5187": "mao;mou",
	"6088": "jie",
	"6FA9": "xue",
	"5E8F": "xu",
	"71A3": "sui",
	"7898": "dian",
	"7FD7": "qi",
	"823A": "jia;xia",
	"8449": "xie;ye;she",
	"9AF2": "pi",
	"6104": "wei",
	"717C": "chao",
	"8EBA": "tang",
	"9DFD": "xue",
	"594B": "fen",
	"5DE9": "gong",
	"6351": "she",
	"6D15": "yin",
	"53BF": "xian",
	"5A6E": "none",
	"63D3": "shi",
	"6CF1": "yang",
	"7855": "shuo",
	"9518": "nuo",
	"9968": "tun",
	"9D1D": "qu",
	"9F21": "shu",
	"6AAC": "meng",
	"96C6": "ji",
	"97CC": "ren",
	"5BDE": "mo",
	"5EEC": "lu",
	"6813": "shuan",
	"76E6": "an",
	"88BB": "er",
	"53D9": "xu",
	"5755": "jing",
	"5D27": "song",
	"63F3": "xie",
	"7F06": "lan",
	"9185": "pei",
	"9BB9": "shao",
	"56B6": "ying",
	"6726": "meng",
	"6C13": "mang;meng",
	"8868": "biao",
	"5127": "zan",
	"5BE5": "liao",
	"5D64": "rong",
	"6D6D": "geng",
	"657D": "jiao",
	"74DC": "gua",
	"7F87": "ji",
	"8592": "can",
	"9AE0": "kun",
	"9F9F": "gui;jun;qiu",
	"816C": "rou",
	"8E7A": "qiao",
	"9319": "zi",
	"94A2": "gang",
	"963F": "a;e",
	"97BF": "ji",
	"5DB8": "rong",
	"638E": "ji",
	"70F3": "pu",
	"99B2": "tuo",
	"9C52": "zun",
	"9E67": "zhe",
	"63A6": "ti",
	"663D": "long",
	"742A": "qi",
	"8416": "wan",
	"8B72": "rang",
	"8D6F": "tang",
	"99ED": "hai;xie",
	"9C84": "ke",
	"9CA5": "shi",
	"578E": "ke",
	"5A7A": "wu",
	"69FA": "kang",
	"7596": "jie",
	"8AB7": "wang",
	"54A7": "lie",
	"7639": "diao",
	"8CC4": "hui",
	"921B": "guo",
	"53C6": "ai",
	"5B52": "jue",
	"6534": "po",
	"6DDD": "fei",
	"7593": "nai",
	"54FA": "bu",
	"55BE": "ku",
	"65E9": "zao",
	"79ED": "zi",
	"934C": "xian",
	"9842": "lai",
	"9D0E": "ou",
	"5D30": "zi",
	"5FAE": "wei",
	"687F": "gan",
	"6FAB": "man",
	"7032": "lian",
	"8151": "fu",
	"85DB": "xie",
	"4FB4": "chou",
	"5428": "dun",
	"58DA": "lu",
	"68E4": "xi",
	"6D34": "ping",
	"7616": "yin",
	"7956": "zu",
	"8242": "feng",
	"830A": "zi",
	"8562": "kui",
	"67D8": "zhe",
	"7AFD": "yu",
	"8AD1": "zhuo",
	"4E90": "yu",
	"5512": "miu",
	"62AF": "zha",
	"7BBB": "fu",
	"8CC0": "he",
	"9126": "xu",
	"57C0": "chui",
	"73DD": "xu",
	"8040": "zhi",
	"8217": "pu",
	"8836": "can",
	"9A2A": "sou",
	"60D3": "quan",
	"7E45": "sao",
	"8285": "yi",
	"913F": "qi",
	"9C81": "lu",
	"5F02": "yi",
	"6524": "tan",
	"4FC9": "wu",
	"545B": "qiang",
	"546C": "ling",
	"54A5": "xi;die",
	"57D7": "bu",
	"58AC": "zui",
	"670A": "ruan",
	"73AF": "huan",
	"93DF": "chan",
	"57DF": "yu",
	"5BEE": "liao",
	"6029": "ni",
	"8FF1": "tuo",
	"9A5B": "yi",
	"5F6D": "peng",
	"6B47": "xie",
	"6D58": "wei",
	"71CC": "fen",
	"98F7": "jie",
	"9A5E": "bin",
	"9B2E": "jiu",
	"9F90": "pang",
	"8A31": "xu;hu",
	"9751": "qing",
	"6DC6": "xiao;yao",
	"6F9B": "lu",
	"74D0": "lu",
	"7673": "luo",
	"87FB": "yi",
	"6594": "yu",
	"69BD": "xi",
	"7A2B": "bi",
	"82EE": "xian",
	"8D69": "xi",
	"8E3A": "jian",
	"58F5": "zhuang",
	"6754": "zhe",
	"500A": "zong",
	"5B40": "shuang",
	"663F": "kuang",
	"8144": "chui;zhui",
	"8DED": "xiang",
	"973B": "none",
	"6014": "zheng",
	"6476": "tuan",
	"70CB": "xiao",
	"8BA2": "ding",
	"5C61": "lu",
	"8338": "rong",
	"598D": "yan",
	"9B5B": "dao",
	"5270": "sheng",
	"5D36": "feng",
	"6AFD": "yin",
	"8588": "hui",
	"8F74": "zhou",
	"9D8C": "qu",
	"4FCE": "zu",
	"6E5E": "zhen",
	"5ADC": "zhang",
	"5B9C": "yi",
	"65ED": "xu",
	"66B8": "liao",
	"66C6": "li",
	"7B12": "cen",
	"84C2": "ming",
	"8948": "zhuan",
	"9945": "man",
	"9FA1": "chui",
	"5096": "cang",
	"5283": "hua",
	"642A": "tang",
	"68F0": "chui",
	"735D": "yu",
	"9659": "chun",
	"9848": "jiong",
	"5AD6": "piao",
	"7651": "nong",
	"612B": "su",
	"9D98": "hu",
	"5449": "wu",
	"61F2": "cheng",
	"6D63": "huan;wan",
	"765A": "dan",
	"8376": "yin",
	"7BD3": "lou",
	"7D19": "zhi",
	"81BA": "ying",
	"82DB": "ke",
	"9876": "ding",
	"67AA": "qiang",
	"6B49": "qian",
	"6E64": "shi",
	"94CE": "duo",
	"9EF5": "dan",
	"9F56": "ya",
	"52EC": "juan",
	"5899": "qiang",
	"6324": "ji",
	"6BF7": "mao",
	"9182": "lan",
	"50A9": "nuo",
	"617E": "yu",
	"8AAF": "chang",
	"8FE7": "chen",
	"7F53": "wang",
	"927D": "shi",
	"938C": "lian",
	"9F2A": "sheng",
	"6670": "xi",
	"6B08": "wei",
	"7571": "liu",
	"75DF": "xiao",
	"8D63": "gan",
	"9CFD": "jian",
	"563E": "dan",
	"6D1A": "jiang",
	"8D24": "xian",
	"90F5": "you",
	"9EC5": "jin",
	"6AD9": "ou",
	"7FCA": "yi",
	"816B": "zhong",
	"5164": "kuang",
	"6012": "nu",
	"80D5": "fu",
	"861A": "xian;li",
	"8713": "ting",
	"8CD1": "zhen",
	"93A3": "ying",
	"9EA6": "mai",
	"57DA": "guo",
	"5D0B": "hua",
	"611A": "yu",
	"8561": "fen",
	"9C8F": "pi",
	"660B": "gui",
	"69D9": "dian",
	"7015": "bin;pin",
	"802F": "huo",
	"9083": "sui",
	"98DF": "shi;si;yi",
	"9AFC": "peng",
	"51A4": "yuan",
	"54C1": "pin",
	"586D": "wen",
	"6D7B": "weng",
	"7A9D": "wo",
	"96B4": "long",
	"6083": "kun",
	"6A92": "feng",
	"7C98": "zhan;nian",
	"9C2C": "qian",
	"9F16": "fen",
	"5C0F": "xiao",
	"5B0D": "mei",
	"6CA3": "feng",
	"849B": "que",
	"8612": "none",
	"6BCF": "mei",
	"6EF8": "hu;xu",
	"72D7": "gou",
	"85E7": "huan",
	"8667": "kui",
	"8903": "ken",
	"897C": "yi",
	"504C": "ruo",
	"5162": "jing",
	"5B88": "shou",
	"777A": "hou",
	"7E5C": "zun",
	"8939": "yi",
	"5FDF": "min",
	"6432": "wa",
	"6A44": "gan",
	"6E60": "tan",
	"72DF": "huan",
	"77A1": "ji",
	"7AB9": "wu",
	"5A4F": "fu",
	"5B04": "none",
	"5BDC": "ning",
	"6AAF": "tai",
	"80A6": "ban",
	"8622": "long",
	"8E55": "bi",
	"91A4": "jiang",
	"5022": "jie",
	"55A6": "nie",
	"9141": "chan",
	"9433": "lei",
	"7856": "xia",
	"79A2": "ta",
	"5B33": "none",
	"5E20": "yi",
	"60A7": "li",
	"612F": "song",
	"6637": "wen",
	"8A89": "yu",
	"8D94": "lie",
	"6CE2": "bo;po",
	"73F8": "wu",
	"8578": "xia",
	"906F": "dun",
	"9D97": "ti",
	"7164": "mei",
	"86B8": "li",
	"881D": "lei",
	"4EF8": "yao",
	"7204": "li",
	"7669": "lai",
	"84A6": "huo",
	"8C73": "bin",
	"9DDD": "bi",
	"4F66": "none",
	"61DD": "ai",
	"68E0": "tang",
	"7340": "sou",
	"74DA": "zan",
	"752D": "beng",
	"8C81": "you",
	"8DAB": "qiao",
	"9A21": "quan",
	"9D48": "none",
	"7425": "hu",
	"80C9": "bo",
	"5230": "dao",
	"5BA6": "huan",
	"72E5": "huan",
	"8C66": "qu",
	"9390": "zu",
	"62B8": "za",
	"9A6A": "li",
	"9B69": "mo",
	"4E00": "yi",
	"595A": "xi",
	"5F00": "kai",
	"5FDE": "min",
	"6153": "piao",
	"72DD": "xian",
	"59F1": "kua",
	"5A73": "hua",
	"674F": "xing",
	"7613": "huan",
	"84DA": "xiu",
	"95B1": "yue",
	"9974": "yi",
	"544B": "fu",
	"7C1E": "dan",
	"81D5": "biao",
	"5723": "sheng",
	"6292": "shu",
	"73C9": "min",
	"93C4": "tuan",
	"9A25": "rou",
	"9A2E": "liu",
	"5634": "zui",
	"575F": "fen",
	"5E21": "ping",
	"5E53": "sen",
	"61F1": "mie",
	"70A8": "duo",
	"7161": "xin",
	"7376": "nao",
	"8A3E": "zi",
	"7794": "ze",
	"7AA1": "zhui",
	"7D50": "jie",
	"97BB": "lou",
	"9A87": "hai",
	"4EDD": "tong",
	"5816": "nao",
	"66CE": "yi",
	"74DD": "bao",
	"82B4": "wu",
	"8F9D": "ci",
	"5B0B": "chan",
	"718B": "nai",
	"77C3": "ning",
	"8829": "zhu",
	"9CE9": "jiu",
	"9F05": "zhi",
	"5F43": "bi",
	"639B": "gua",
	"672B": "mo",
	"870D": "chu",
	"8AE7": "xie",
	"9149": "you",
	"9373": "jian",
	"97AA": "mu",
	"6315": "die",
	"650F": "long",
	"7FBC": "chan",
	"9430": "qiao",
	"6793": "dou",
	"6D0B": "yang",
	"7A00": "xi",
	"82BE": "fei;fu",
	"8BF7": "qing",
	"9022": "feng",
	"9ABA": "hou",
	"59B3": "nai;ni",
	"5AC3": "zhen",
	"772E": "tong",
	"7A4B": "lu",
	"973A": "wei",
	"604F": "hao",
	"6326": "xian",
	"7719": "yi",
	"52F0": "xie",
	"5E74": "nian",
	"9F53": "chen",
	"562B": "ran",
	"58E3": "lin",
	"84E5": "ying",
	"9AFF": "sha",
	"5514": "wu;n;ng",
	"60CF": "lin",
	"6392": "pai",
	"6A4F": "zhan",
	"6AF5": "none",
	"73E8": "xia",
	"9325": "yu",
	"9538": "cha",
	"6C86": "hang",
	"907A": "yi;wei",
	"7D16": "yin",
	"80B9": "xi",
	"7977": "dao",
	"7D21": "fang",
	"4F8A": "guang",
	"50D0": "shan",
	"53AD": "yan",
	"578D": "ji",
	"5948": "nai",
	"5FFD": "hu",
	"6CEF": "min",
	"752C": "yong",
	"76EF": "ding",
	"7E47": "zhou;yao;you",
	"555D": "he",
	"7C2F": "none",
	"7E10": "zhou",
	"956C": "huo",
	"7595": "bi",
	"772C": "long",
	"895D": "lian",
	"4E5B": "none",
	"5F81": "zheng",
	"610D": "min",
	"62B4": "yi",
	"6650": "gai",
	"7508": "qi",
	"7632": "zong",
	"541D": "lin",
	"7296": "luo",
	"8A11": "yi",
	"9DEB": "su",
	"727A": "xi",
	"741A": "ju",
	"7723": "die",
	"77E5": "zhi",
	"7E7A": "shai",
	"9217": "yun",
	"9C7C": "yu",
	"5A54": "none",
	"6A67": "zeng",
	"79EA": "zhi",
	"7B9A": "zha",
	"9F96": "ta",
	"800E": "ruan",
	"8845": "xin",
	"8AD5": "hao",
	"517F": "yi",
	"6B92": "yun",
	"6BCB": "wu",
	"7D24": "jiu",
	"896D": "xie",
	"5714": "e",
	"9C59": "miao",
	"506B": "zhi",
	"6D12": "sa",
	"935E": "keng",
	"97E4": "wa",
	"999F": "tu",
	"5457": "bei;bai",
	"5BD4": "shi",
	"62CE": "lin",
	"824D": "ju",
	"9377": "kui",
	"5B22": "niang",
	"74B2": "sui",
	"7782": "fa",
	"7BDC": "zheng",
	"544C": "jiao",
	"5730": "di;de",
	"6A13": "lou",
	"6E15": "yuan",
	"7F3B": "fou",
	"845C": "qia",
	"886F": "fen",
	"95F0": "run",
	"58D3": "ya",
	"5ACE": "pang",
	"7965": "xiang",
	"9082": "xie",
	"6061": "lin",
	"6138": "zheng",
	"6150": "none",
	"6679": "yi",
	"9CFE": "shi",
	"50E1": "hui",
	"59BC": "bi",
	"59E8": "yi",
	"6FC5": "jin",
	"7410": "suo",
	"7B97": "suan",
	"7BD4": "yun",
	"82E6": "ku",
	"8BAF": "xun",
	"8DEF": "lu",
	"9132": "dan",
	"9559": "luo",
	"9CA4": "li",
	"4E7D": "none",
	"558C": "zhou",
	"5DB1": "ke",
	"6332": "suo;sa;sha",
	"860C": "yu",
	"8B0B": "huo",
	"9E59": "qiu",
	"63F8": "zha",
	"69CA": "shuo",
	"853B": "kou",
	"55D9": "pang",
	"615F": "tong",
	"692E": "sen",
	"6BA2": "ti",
	"776A": "gao",
	"8453": "hong",
	"89A5": "tian",
	"73A9": "wan",
	"7B02": "none",
	"8975": "zhe",
	"63FB": "none",
	"4FC0": "tui",
	"5494": "ka",
	"607E": "mang",
	"8500": "bu",
	"8EF0": "bei",
	"8F69": "xuan",
	"9742": "li",
	"993D": "kui",
	"51EE": "feng",
	"6BD9": "bi",
	"7AF9": "zhu",
	"8450": "pen",
	"8DA2": "lu",
	"9D85": "zi",
	"9E5B": "mei",
	"5B18": "sui",
	"953B": "duan",
	"9CC7": "huang",
	"5049": "wei",
	"5565": "sha",
	"5883": "jing",
	"6052": "heng",
	"85B1": "dui",
	"555A": "bi",
	"75D5": "hen",
	"7C17": "liang",
	"7C5A": "lu",
	"95B4": "qu",
	"71B8": "jian",
	"8716": "hui",
	"500F": "shu",
	"5504": "bai;bei",
	"5664": "jin",
	"5C62": "lu",
	"7702": "shi",
	"8CE4": "jian",
	"4FAA": "chai",
	"50E7": "seng",
	"6FAD": "yong",
	"705B": "chan",
	"83AE": "nan",
	"85C0": "ying",
	"8980": "xi",
	"9EE8": "dang",
	"5C27": "yao",
	"65F6": "shi",
	"727D": "qian",
	"75D9": "jing",
	"7DF1": "gou",
	"96D3": "yu",
	"97FA": "ying",
	"4F0C": "ai",
	"51B9": "fu",
	"5DEA": "none",
	"649F": "jiao",
	"6702": "xu",
	"8169": "nan",
	"8170": "yao",
	"8BCE": "qu",
	"8DFC": "ju",
	"5596": "hu",
	"5819": "yin",
	"5C12": "er",
	"69BF": "qi",
	"7417": "cui",
	"760C": "la",
	"8C26": "qian",
	"8C29": "man",
	"8EEF": "peng",
	"91E4": "shan",
	"50C1": "xi",
	"5502": "gu",
	"566A": "zao",
	"712F": "zhuo;chao",
	"8314": "ying",
	"9292": "xing",
	"5611": "hu",
	"7123": "ju",
	"85A8": "hong",
	"8CD3": "bin",
	"95C6": "ban",
	"976B": "ren",
	"6C6C": "jing",
	"73B8": "fu",
	"7994": "ti",
	"81DD": "luo",
	"8B48": "dui",
	"9337": "ga",
	"571D": "luan",
	"6100": "qiao",
	"788A": "jian",
	"52D9": "wu",
	"68E2": "wang",
	"8672": "none",
	"8B06": "shan",
	"686B": "suo",
	"7110": "wu",
	"87BE": "yin",
	"8D92": "tiao",
	"8ECB": "ya;zha;ga",
	"97EF": "xian",
	"5B30": "ying",
	"5BE4": "wu",
	"5E45": "fu",
	"5EA2": "zhi",
	"652E": "nang",
	"7E02": "zong",
	"897D": "none",
	"50DB": "qi",
	"5400": "mie",
	"597B": "nan",
	"5A23": "di",
	"6186": "cheng",
	"638C": "zhang",
	"6B38": "e;ai",
	"7106": "jue",
	"7D3C": "fu",
	"852A": "jian",
	"62C8": "nian",
	"676C": "yuan",
	"83C4": "dong",
	"72EE": "shi",
	"8842": "nu",
	"8C32": "jue",
	"8EC0": "qu",
	"68FB": "fen",
	"77EC": "cuo",
	"8E72": "dun;cun",
	"984A": "yi",
	"69DF": "bin;bing",
	"8004": "mao",
	"957F": "zhang;chang",
	"57F2": "beng",
	"5B16": "bi",
	"5C79": "yi;ge",
	"627F": "cheng",
	"7E2B": "feng",
	"95A4": "he;ge",
	"642F": "tao",
	"7741": "zheng",
	"7A96": "jiao",
	"9277": "hong",
	"4E60": "xi",
	"58FE": "mang",
	"59DC": "jiang",
	"5E94": "ying",
	"777D": "kui",
	"99E4": "zhi",
	"8431": "xuan",
	"51D8": "si",
	"5808": "gang",
	"60CA": "jing",
	"64CC": "se",
	"6DE0": "pi",
	"7A14": "ren",
	"7AE6": "song",
	"9464": "bao",
	"56E2": "tuan",
	"8A6E": "quan",
	"965C": "shan",
	"61D2": "lan",
	"6468": "nai",
	"712E": "xin",
	"7BCA": "hong",
	"9176": "mei",
	"4FBC": "bo",
	"51CE": "gan",
	"556F": "guo",
	"5E18": "lian",
	"6C5A": "wu",
	"8128": "cu",
	"95C5": "wen",
	"5124": "bao",
	"59EA": "zhi",
	"694F": "kui",
	"770F": "yang",
	"7B2F": "nu",
	"82FE": "bi",
	"8EFF": "ping",
	"5968": "jiang",
	"5A69": "yan",
	"6369": "lie",
	"75BD": "ju",
	"8033": "er",
	"82AB": "yan;yuan",
	"5D63": "dang",
	"60BD": "qi",
	"62D7": "ao;niu;yao",
	"68B7": "jing",
	"6FDB": "meng",
	"7A5B": "zhuo",
	"8C37": "gu;yu",
	"5A0C": "li",
	"5AD8": "lei",
	"714E": "jian",
	"7806": "fu",
	"7DA3": "quan",
	"8168": "shuan",
	"825D": "none",
	"8D30": "er",
	"5D62": "cang",
	"68D3": "pou;bang",
	"72B5": "jie",
	"76E4": "pan",
	"87AF": "ao",
	"946A": "lu",
	"9D35": "jiao",
	"59EC": "ji",
	"7CC5": "rou",
	"8392": "ju",
	"9740": "meng",
	"7C90": "none",
	"5304": "gai",
	"8125": "xie",
	"9CB6": "nian",
	"5228": "bao;pao",
	"6814": "qi",
	"6A78": "none",
	"6B3C": "chi",
	"8018": "yun",
	"4FD7": "su",
	"5B2D": "nai",
	"5D0D": "lai",
	"61AA": "xian",
	"8B07": "jian",
	"9262": "bo",
	"6F28": "feng",
	"7627": "nue;yao",
	"8C58": "tun",
	"5379": "xu",
	"5D95": "jiao",
	"6733": "ba",
	"6769": "ma",
	"6900": "wan",
	"72B3": "chuo",
	"7B8C": "zhao",
	"7FDC": "se",
	"8429": "qiu",
	"8486": "qiong",
	"89FC": "jue",
	"90FC": "yi",
	"92D8": "wu",
	"9F8D": "long",
	"6919": "shan",
	"6C42": "qiu",
	"7906": "jian",
	"8EF7": "ba",
	"5C8E": "fen",
	"62C7": "mu",
	"9692": "yan",
	"5672": "kuai",
	"6CB2": "duo",
	"4E4F": "fa",
	"60E4": "jian",
	"676B": "si",
	"679D": "zhi;qi",
	"946B": "xin",
	"693E": "zhan",
	"7EDC": "luo;lao",
	"8B66": "jing",
	"528C": "gui",
	"556E": "nie",
	"7061": "lan",
	"7469": "ying",
	"7B0F": "hu",
	"8243": "li",
	"4F0F": "fu",
	"5C4D": "shi",
	"727F": "gu",
	"738A": "su",
	"7C58": "teng",
	"83DF": "tu",
	"9CD5": "xue",
	"573E": "ji",
	"9066": "guan",
	"5EE6": "bi",
	"7435": "pi",
	"5701": "yin",
	"5C84": "yue",
	"5E6E": "chu",
	"6F5C": "qian",
	"79FC": "zhu",
	"9D4C": "yu",
	"6172": "man",
	"640A": "chou",
	"71E4": "tai",
	"7D3B": "yang",
	"8F81": "quan",
	"9104": "juan",
	"9366": "she",
	"9EDE": "dian",
	"8509": "gun",
	"8CAE": "er",
	"4F8B": "li",
	"55BB": "yu",
	"624D": "cai",
	"8467": "bo",
	"8489": "kui",
	"5D91": "xiang",
	"8140": "lun",
	"9267": "mu",
	"5120": "lie",
	"66F1": "yue",
	"69AE": "rong",
	"71E3": "lan",
	"7354": "hao",
	"7CF5": "nie",
	"9914": "bu",
	"4EF1": "qian",
	"5B5A": "fu",
	"5804": "ni",
	"7B2C": "di",
	"853A": "lin",
	"874F": "ting",
	"62F0": "nin",
	"6574": "zheng",
	"70CA": "yang",
	"79FB": "yi",
	"76E3": "jian",
	"9D62": "shen",
	"5359": "ji",
	"76D8": "pan",
	"7BC8": "feng",
	"96F2": "yun",
	"4E23": "you",
	"59E3": "jiao",
	"8849": "mie",
	"90DA": "wu",
	"972E": "dan",
	"9926": "zhang",
	"9015": "jing",
	"52EB": "fan",
	"8BE3": "yi",
	"8DE6": "chu",
	"9A9F": "shan",
	"7D93": "jing",
	"9C75": "zhen",
	"50EC": "jiao",
	"73C0": "po",
	"8BEB": "jie",
	"91B5": "ju",
	"7514": "dan",
	"83DE": "li",
	"89E6": "chu",
	"972B": "xi",
	"53B9": "qiu",
	"7767": "hun",
	"7F42": "ying",
	"955D": "di",
	"9F6F": "ni",
	"9F78": "yi",
	"662C": "hun",
	"69BC": "ke",
	"7D05": "hong;gong",
	"8AED": "yu",
	"5800": "ku;jue",
	"59F9": "cha",
	"5FDB": "fan",
	"8EB2": "duo",
	"52C8": "yong",
	"5506": "suo",
	"5C8A": "jie",
	"5E95": "di;de",
	"8099": "yuan",
	"883C": "qu",
	"8B2B": "zhe",
	"9A15": "yao",
	"7E8C": "xu",
	"83E7": "di",
	"950A": "lue",
	"995E": "chan",
	"4FCB": "yi",
	"86AC": "xian",
	"917E": "shi;shai",
	"91A8": "li",
	"941B": "ying",
	"9929": "e",
	"9BF5": "sao",
	"5A3A": "zhui",
	"5E07": "nie",
	"6C9E": "za",
	"7588": "bo",
	"7B89": "guai",
	"7FEB": "wan",
	"8F53": "fan",
	"60F0": "duo",
	"62E0": "ju",
	"87D7": "qiu",
	"9A88": "pian",
	"9CD4": "biao",
	"5CEE": "qun",
	"63E9": "kai",
	"7A12": "gu",
	"8BBD": "feng",
	"9781": "bei;tuo",
	"78A1": "zhou",
	"7EBB": "zhu",
	"845F": "huang",
	"9E42": "li",
	"60C3": "kun",
	"8D5E": "zan",
	"60A8": "nin",
	"6839": "gen",
	"6889": "zhuang",
	"7287": "ben",
	"77A0": "cheng",
	"80A0": "chang",
	"9438": "duo",
	"5437": "chuo",
	"6BC0": "hui",
	"849A": "he",
	"943D": "da",
	"95E2": "pi;bi",
	"57FB": "zhun",
	"5FA8": "huang",
	"7081": "qi",
	"7F00": "zhui",
	"9078": "xuan",
	"55AD": "yan",
	"5AD5": "yi",
	"6411": "rong",
	"8920": "gou",
	"994B": "kui",
	"54BF": "yi",
	"6021": "yi",
	"6B5A": "none",
	"77D5": "man",
	"889B": "di",
	"95EC": "han",
	"7045": "lei",
	"7C78": "shen",
	"7D34": "bei",
	"848D": "wei",
	"869F": "wang",
	"56EC": "hui",
	"6043": "shi",
	"69B8": "zhai",
	"76E7": "lu",
	"8448": "xi",
	"8649": "yi",
	"8C20": "dang",
	"8DCA": "mei",
	"933D": "wan",
	"6467": "cui",
	"8A6C": "gou",
	"9EE5": "qing;jing",
	"52E7": "quan",
	"53E3": "kou",
	"6B15": "none",
	"8ED6": "qiang",
	"9670": "yin",
	"6168": "kai",
	"64FE": "rao",
	"66CA": "fei",
	"765E": "lai",
	"947E": "luan",
	"53CA": "ji",
	"613D": "bo",
	"621E": "jia",
	"6527": "dian",
	"69BB": "ta",
	"6B86": "dai",
	"7E64": "zuan",
	"93D1": "di",
	"9AE5": "ran",
	"50E3": "tie",
	"7108": "xi",
	"8348": "chuan",
	"8EF5": "rong;fu",
	"9EA3": "yan",
	"52DD": "sheng",
	"6217": "qiang",
	"65EC": "xun",
	"6D50": "chan",
	"708D": "pan",
	"779F": "piao",
	"8EBB": "none",
	"65E3": "ji",
	"6F83": "jiong",
	"8347": "xing",
	"9B0B": "jian",
	"52FE": "gou",
	"6256": "none",
	"628B": "qin",
	"657F": "qiao",
	"85DA": "xu",
	"8C49": "chi",
	"69E0": "zhu",
	"6AE1": "zhu",
	"6F99": "xi",
	"7960": "ci",
	"80B2": "yu;yo",
	"6DCF": "hao",
	"6EDD": "long;shuang",
	"74DF": "pao",
	"79AC": "hui",
	"8368": "qian;xun",
	"9977": "xiang",
	"5991": "pa",
	"6329": "tuo",
	"659F": "zhen",
	"9BC4": "qiu",
	"4F33": "xie",
	"589B": "none",
	"6BEA": "mu",
	"81D6": "xing",
	"978D": "an",
	"5903": "gu",
	"6160": "ao",
	"819F": "lu",
	"82EA": "bing",
	"865F": "hao",
	"64BD": "qiao",
	"680D": "none",
	"6F2F": "luo;ta",
	"6F77": "bi",
	"72AB": "chou",
	"7DA9": "wan",
	"8C96": "e",
	"4FCC": "fu",
	"51E1": "fan",
	"8637": "kui",
	"970E": "sha",
	"63F6": "ye",
	"72A2": "du",
	"7E24": "su",
	"81DA": "lu",
	"9446": "zhui",
	"978C": "an",
	"5B65": "nu",
	"8FAF": "bian",
	"9204": "tou",
	"9B84": "fu",
	"590F": "xia;jia",
	"5309": "peng",
	"53D3": "shi",
	"550C": "xian",
	"71DB": "jing",
	"73F6": "ti;di",
	"8ECE": "wei",
	"51C5": "gu",
	"5C3C": "ni",
	"7664": "jie",
	"7BB0": "sun",
	"7FFD": "hui",
	"8373": "dou",
	"9F61": "ling",
	"5B67": "none",
	"612E": "yao",
	"940E": "jiao",
	"5915": "xi",
	"8B49": "zheng",
	"5B37": "ma",
	"63CB": "wei",
	"64EF": "bin",
	"6500": "pan",
	"66D3": "bao",
	"6C37": "bing",
	"76EB": "an",
	"79E4": "cheng",
	"96FC": "dang",
	"988A": "jia",
	"5B01": "deng",
	"5EB9": "tuo",
	"645D": "lu",
	"6487": "pie",
	"68E5": "fan",
	"6EB2": "sou",
	"7A3D": "ji;qi",
	"811B": "jing",
	"89F1": "bi",
	"5967": "ao",
	"77FD": "xi",
	"8555": "you",
	"9BB2": "none",
	"5174": "xing",
	"51B8": "pan",
	"6C70": "tai",
	"71D0": "lin",
	"8044": "zhen",
	"91D8": "ding",
	"9D82": "ni",
	"6DF5": "yuan",
	"7148": "feng",
	"85D2": "qie",
	"9C30": "none",
	"5BE1": "gua",
	"8D66": "she",
	"5FCC": "ji",
	"6300": "bo",
	"692C": "none",
	"6F90": "yun",
	"7541": "qi",
	"771E": "zhen",
	"810D": "kuai",
	"523E": "ci",
	"6B21": "ci",
	"9364": "cha",
	"937B": "jie",
	"4F59": "yu;tu",
	"5DAA": "ye",
	"6321": "dang",
	"77D7": "chu",
	"80B4": "yao",
	"8BA7": "hong",
	"548E": "jiu",
	"57B8": "huan;yuan",
	"588C": "zhi",
	"6B32": "yu",
	"6E10": "jian",
	"818E": "xie",
	"8DF0": "beng",
	"540E": "hou",
	"6370": "wo",
	"6AF1": "nie",
	"7E4F": "xuan",
	"8BFC": "zhuo",
	"8D3D": "zhi",
	"8D86": "di",
	"5434": "wu",
	"6B96": "zhi;shi",
	"78E6": "biao",
	"9215": "niu",
	"9741": "lei",
	"97E3": "shu",
	"9C92": "jie",
	"6D7F": "pei",
	"721F": "guan",
	"9AC1": "ke",
	"549B": "ning",
	"55FF": "tan",
	"6C3E": "fan",
	"72EF": "kuai",
	"981F": "e",
	"9EFD": "min;mian",
	"9934": "fen",
	"6156": "guo",
	"632E": "ti",
	"7159": "yan",
	"7A38": "xu",
	"8B58": "shi;zhi",
	"8E73": "bo",
	"9A48": "yu",
	"4F53": "ti;ben",
	"5D24": "yao;xiao",
	"677B": "chou;niu",
	"8150": "fu",
	"8196": "pang",
	"89CB": "xi",
	"98A9": "biao",
	"9BC0": "gun",
	"512D": "chen",
	"60EA": "de",
	"6697": "an",
	"547B": "shen",
	"5D23": "wei",
	"61D9": "yu",
	"719C": "cong",
	"75E8": "lao",
	"8104": "mei",
	"84F4": "chun",
	"8CC6": "pian",
	"882E": "ye",
	"8F4F": "zhan",
	"9771": "ren",
	"51AE": "gang",
	"557D": "an",
	"6F2A": "yi",
	"872A": "tao",
	"9404": "huang",
	"9637": "cheng",
	"5A4C": "shu",
	"7AFA": "zhu",
	"82A1": "qian",
	"9963": "shi;si",
	"559C": "xi",
	"6FF5": "bin",
	"5A63": "yin",
	"6205": "gang",
	"6212": "jie",
	"7DD7": "xiang",
	"857D": "deng",
	"9B2B": "kan",
	"9C80": "tun",
	"4F7D": "ci",
	"6E65": "tu",
	"7A1A": "zhi",
	"7F67": "lin;sen",
	"97BE": "xue",
	"6063": "zi",
	"92B9": "xiu",
	"9EE2": "qu",
	"5013": "tan",
	"55F0": "ge",
	"61B8": "xian",
	"5614": "ou",
	"5DDC": "gui",
	"69B6": "tang",
	"7332": "xie;he",
	"7970": "gao",
	"7BC6": "zhuan",
	"7F75": "ma",
	"8D7B": "xian",
	"9465": "lu",
	"9DE8": "hua",
	"5799": "guang",
	"61B9": "nao",
	"6C27": "yang",
	"9E90": "lin",
	"61FD": "huan",
	"6899": "huan",
	"7EA2": "hong;gong",
	"8905": "ti",
	"92F4": "none",
	"7778": "mei",
	"97F2": "ji",
	"56AC": "pin",
	"5D4E": "yu",
	"5F69": "cai",
	"86D1": "mou",
	"87FF": "qi",
	"93A1": "zi",
	"93E2": "biao",
	"9429": "sui",
	"5CCF": "er",
	"62D2": "ju",
	"6DDE": "song",
	"7E1A": "tao",
	"9052": "qiu",
	"6095": "xi",
	"71D8": "mei",
	"8393": "mei",
	"6665": "han",
	"6A58": "ju",
	"7289": "run",
	"908F": "luo",
	"9397": "qiang",
	"9747": "long",
	"5F4E": "wan",
	"6016": "bu",
	"6779": "hua",
	"6FE7": "dui",
	"7F5A": "fa",
	"8301": "zhuo",
	"9C8A": "zha",
	"9CB0": "zou",
	"6660": "sheng",
	"785F": "chan",
	"9B63": "yu",
	"5143": "yuan",
	"53F7": "hao",
	"5413": "he;xia",
	"71E2": "xue",
	"7CCD": "ci",
	"8CE2": "xian",
	"91F3": "xi",
	"9F9E": "bie",
	"5432": "yin",
	"7160": "ye",
	"806D": "kui",
	"8670": "ding",
	"8D1B": "gan",
	"8E52": "pan",
	"53A9": "jiu",
	"6238": "hu",
	"637B": "nian",
	"63B5": "none",
	"7655": "yong",
	"94F6": "yin",
	"8F6F": "ruan",
	"943E": "bei",
	"5726": "none",
	"63CF": "miao",
	"67FA": "guai",
	"6DC9": "guo",
	"7290": "ke",
	"7585": "jiang",
	"77B3": "tong",
	"8116": "bo",
	"9D73": "jian",
	"6E01": "yuan",
	"7CC1": "san;shen",
	"81EC": "nie",
	"86C7": "she;yi",
	"8726": "lun",
	"8D04": "zhi",
	"8E46": "tui",
	"90CD": "nuo",
	"92B0": "ai",
	"56B1": "xi",
	"6299": "pou",
	"641D": "qiu",
	"66BC": "pie",
	"6D71": "chun",
	"73E5": "er",
	"7900": "jian",
	"8FD8": "hai;huan",
	"9589": "bi",
	"9A0F": "qi",
	"51B5": "kuang",
	"5406": "yao",
	"80D2": "ni",
	"8EA4": "jie",
	"92AA": "you",
	"9766": "tian;mian",
	"9F9D": "qiu",
	"5BEF": "jun",
	"6B1B": "ba",
	"8BDE": "dan",
	"98D8": "piao",
	"81A4": "xue",
	"89B7": "qu",
	"8AFB": "heng",
	"8E74": "cu",
	"6D10": "xing",
	"795E": "shen",
	"7C43": "lan",
	"80BC": "jing",
	"8303": "fan",
	"9608": "yu",
	"9ED8": "mo",
	"59F8": "yan",
	"5EA8": "xiao",
	"606C": "tian",
	"8B4A": "nao",
	"7F80": "liu",
	"854E": "qiao",
	"8AD0": "qian",
	"8D07": "yun",
	"92AD": "qian",
	"5A84": "mei",
	"63F1": "shuo",
	"68C6": "lun",
	"6A9F": "jia",
	"6CA0": "liu",
	"6E87": "lou",
	"7095": "kang",
	"59A2": "fen",
	"6552": "shen",
	"6904": "jie",
	"6BE1": "zhan",
	"7023": "xie",
	"9EEC": "an",
	"6D73": "yi",
	"7401": "xuan",
	"8D75": "zhao",
	"9245": "ju",
	"9EAA": "mian",
	"5213": "wan",
	"523A": "ci",
	"6171": "tuan",
	"8DE7": "quan",
	"8E56": "chong",
	"98F1": "sun",
	"69AF": "shi",
	"6FE8": "ci",
	"94E3": "xian",
	"5C4C": "diao",
	"635E": "lao",
	"684F": "qiong",
	"7F6A": "zui",
	"83C8": "la",
	"98ED": "chi",
	"9B78": "none",
	"5017": "peng",
	"51C4": "qi",
	"7A19": "zhi",
	"83FF": "dao",
	"8C16": "xuan",
	"8E92": "li",
	"5954": "ben",
	"5F18": "hong",
	"6B64": "ci",
	"7116": "men",
	"4F35": "xu",
	"6516": "ying",
	"8362": "none",
	"8EBF": "kang",
	"80CD": "gua",
	"637D": "zu",
	"7ABF": "long",
	"911B": "chao",
	"9CDA": "wei",
	"53E9": "kou",
	"6067": "nu",
	"60AB": "que",
	"6388": "shou",
	"72DE": "ning",
	"9663": "zhen",
	"9674": "pi",
	"9D9A": "e",
	"55D2": "da;ta",
	"567A": "none",
	"5E7E": "ji",
	"74CF": "long",
	"7654": "yi",
	"7817": "che",
	"85D0": "miao",
	"95D2": "da;ta",
	"53F0": "tai",
	"5C45": "ju;ji",
	"6687": "xia",
	"6E24": "bo",
	"74B8": "bin",
	"9936": "gu",
	"6E88": "gui",
	"78F3": "zeng",
	"8914": "fu",
	"8AD8": "biao",
	"901C": "wu",
	"945F": "du",
	"67BF": "nie",
	"8915": "yu",
	"53A2": "xiang",
	"5866": "zhen",
	"5F20": "zhang",
	"762C": "zhang",
	"84BB": "ruo",
	"649D": "hui",
	"64D1": "jie",
	"73CD": "zhen",
	"7752": "shan",
	"7E9E": "lian",
	"70BF": "none",
	"7F76": "liu",
	"80B0": "ran",
	"9CCF": "guan",
	"58B8": "chu",
	"5DFD": "xun",
	"603C": "dui",
	"8C6F": "xi",
	"94EF": "se",
	"590D": "fu",
	"61CD": "lin",
	"6471": "man",
	"6D88": "xiao",
	"8043": "dan",
	"8C9E": "zhen",
	"976A": "ding",
	"58F7": "hu",
	"5F0E": "san",
	"7E16": "xia",
	"8079": "ning",
	"81FE": "yu",
	"82D2": "ran",
	"98E8": "xiang",
	"4E6B": "jia",
	"5A9B": "yuan",
	"80AE": "ang",
	"9C10": "e",
	"5832": "ji",
	"6758": "chi",
	"6863": "dang",
	"753F": "meng",
	"7B27": "ce",
	"8EAD": "dan",
	"5DD9": "nao",
	"6308": "qie",
	"68B2": "zhuo",
	"72D9": "ju",
	"57C6": "que",
	"66FF": "ti",
	"6767": "mang",
	"9BF8": "hou",
	"9CA8": "sha",
	"5BEA": "wei",
	"6724": "lang",
	"4F8D": "shi",
	"5AAD": "xu",
	"5C57": "none",
	"6042": "xun",
	"7387": "lu;shuai;shuo",
	"75AD": "zong",
	"77D4": "guan",
	"829C": "wu",
	"9DC1": "yi;ni",
	"69EC": "hua",
	"7884": "lin",
	"844C": "jian",
	"8638": "zhan",
	"9976": "rao",
	"5713": "yuan",
	"81C1": "lian",
	"961D": "fu;yi",
	"57EC": "dong",
	"7B18": "shan",
	"9166": "fa;po",
	"93BB": "suo",
	"964E": "shu",
	"98CE": "feng",
	"9C2B": "rong",
	"64D8": "bo;bai",
	"64E2": "zhuo",
	"7A59": "pu",
	"9055": "wei",
	"90FD": "dou;du",
	"9919": "shi",
	"8494": "shi",
	"92B1": "diao",
	"958F": "run",
	"99A6": "xian",
	"4E9E": "ya",
	"5665": "nong",
	"836E": "zhou",
	"867B": "meng",
	"94C3": "ling",
	"5957": "tao",
	"603E": "none",
	"6F45": "guan",
	"7687": "huang",
	"7BE8": "chu",
	"80C1": "xie",
	"9EFF": "yuan",
	"53D4": "shu",
	"5A5B": "jing",
	"628A": "ba",
	"5FE0": "zhong",
	"7D3F": "dai",
	"7EB9": "wen",
	"85E5": "yao;yue",
	"98E6": "jian",
	"5082": "chi",
	"5847": "xuan",
	"6D4A": "zhuo",
	"9E09": "yang",
	"52F6": "che",
	"9888": "jing;geng",
	"5762": "pan",
	"834B": "er",
	"8433": "nan",
	"8D58": "zhui",
	"9E5C": "wu",
	"6320": "nao",
	"6F25": "wa",
	"91C3": "shi",
	"9F85": "bao",
	"4F23": "xian",
	"5407": "zi",
	"7C1C": "dang",
	"6A79": "lu",
	"98C6": "biao",
	"71AF": "han",
	"72AA": "kui",
	"7A51": "se",
	"8A20": "shen",
	"8FDE": "lian",
	"9E60": "liu",
	"5106": "jing",
	"5DB2": "sui",
	"71BF": "huang",
	"752A": "lu",
	"81B5": "cui",
	"9585": "men",
	"967F": "shan",
	"9AF5": "er",
	"7256": "you",
	"7AA5": "kui",
	"8399": "jun",
	"83A9": "fu;piao",
	"92B4": "shi",
	"96B2": "zhi",
	"9DAA": "ju",
	"9EF6": "yan",
	"5DAB": "ye",
	"6DF3": "chun",
	"7E5E": "rao",
	"5A8A": "qian",
	"62DB": "zhao",
	"6C2E": "dan",
	"7330": "ya",
	"7867": "none",
	"78A4": "ying",
	"8904": "none",
	"99FC": "tu",
	"51A6": "kou",
	"5DA8": "xue",
	"6181": "zong",
	"9B5E": "ba",
	"50DF": "zhang",
	"5860": "dui",
	"61FA": "chan",
	"6FB3": "ao",
	"78F8": "ding",
	"8661": "ju",
	"9BF2": "none",
	"9E52": "geng",
	"5364": "lu",
	"6D3C": "wa",
	"7115": "huan",
	"4FEA": "li",
	"5300": "yun",
	"5834": "chang",
	"6671": "shan",
	"84D4": "yao",
	"8760": "fu",
	"9502": "li",
	"99A5": "fu",
	"9AAC": "yu",
	"9B86": "ji",
	"5F2D": "mi",
	"6475": "suo",
	"7DF0": "yu",
	"9B52": "piao",
	"562A": "mai",
	"600A": "chao",
	"66A9": "gui",
	"75C9": "jing",
	"7679": "po",
	"7913": "jiang",
	"8CE6": "fu",
	"4E89": "zheng",
	"5418": "ou",
	"5717": "tu",
	"75CC": "tong",
	"80E3": "yi",
	"88CF": "li",
	"9E9E": "zhang",
	"56B2": "duo",
	"5AD3": "pi",
	"67E9": "jiu",
	"714C": "huang",
	"7349": "zhen",
	"756E": "mu",
	"8C8D": "li",
	"8CB9": "sheng",
	"9B9D": "xiang",
	"60A1": "li",
	"7438": "zhuo",
	"7953": "fu",
	"8735": "yuan",
	"95C3": "qu",
	"9916": "dou",
	"99FF": "jun",
	"9CF9": "qian",
	"5026": "juan",
	"5FF6": "hun",
	"6C57": "han",
	"70CC": "xiu",
	"7189": "yun",
	"7745": "han",
	"8062": "none",
	"8461": "pu",
	"5047": "jia",
	"5621": "tang",
	"76D7": "dao",
	"7F4F": "lu",
	"83AA": "e",
	"71FE": "dao;tao",
	"7458": "ye",
	"7B5D": "zheng",
	"7B74": "jia;ce",
	"7489": "lian",
	"7EB7": "fen",
	"865B": "xu",
	"9264": "gou",
	"51E0": "ji",
	"58C9": "ju",
	"5942": "huan",
	"7B6E": "shi",
	"7B77": "kuai",
	"8D51": "bi",
	"997D": "bo",
	"72FF": "yan",
	"749E": "pu",
	"4E3D": "li",
	"87DF": "liao",
	"7D0D": "na",
	"9432": "zhuo",
	"5138": "luo",
	"5757": "kuai",
	"5A49": "wan",
	"616D": "yin",
	"66A3": "qi",
	"6A65": "zhu",
	"7408": "fu",
	"7DC3": "zong",
	"82CD": "cang",
	"847A": "qi",
	"93EE": "kang",
	"56EF": "guo",
	"57CE": "cheng",
	"74CC": "gui",
	"81DE": "qu",
	"95F2": "xian",
	"4E1F": "diu",
	"4E47": "tuo",
	"5735": "dang",
	"6399": "zheng",
	"6AE2": "sou",
	"80F8": "xiong",
	"8236": "bo",
	"8F30": "yang",
	"910C": "tang",
	"62CC": "ban",
	"6D4F": "liu",
	"70EB": "tang",
	"7CB2": "can",
	"8A6D": "gui",
	"5587": "la",
	"8E1E": "ju",
	"8FDA": "none",
	"5B1F": "yi",
	"7244": "qiang",
	"789A": "bei",
	"7BD7": "yue",
	"71F2": "xie",
	"769D": "huang",
	"777F": "rui",
	"9B04": "ti",
	"63C8": "hong",
	"6EBC": "shi",
	"718D": "none",
	"891B": "lu",
	"8EA9": "jue",
	"91EB": "hua",
	"9458": "lei",
	"5591": "yin",
	"5CB4": "qu",
	"6090": "ti",
	"6258": "tuo",
	"751E": "chang",
	"8280": "tiao",
	"864B": "men",
	"937A": "zang;zhe",
	"9885": "lu",
	"6D39": "huan",
	"6DFE": "yin",
	"6EA4": "ma",
	"8C19": "an",
	"5DA4": "yao",
	"78E9": "qi",
	"9A04": "lu",
	"9A5A": "jing",
	"51E8": "feng",
	"530A": "ju",
	"5748": "keng",
	"9B05": "peng",
	"59AF": "zhou",
	"618D": "jiao",
	"7C79": "nu",
	"92EA": "pu",
	"9327": "guan",
	"505C": "ting",
	"5DB7": "yi",
	"7F54": "wang",
	"5788": "none",
	"6A4C": "xian",
	"7B80": "jian",
	"83D3": "guo",
	"9036": "wei",
	"57B4": "nao",
	"5CB2": "kuang",
	"5D7E": "cen",
	"5F5F": "huo",
	"710E": "xie",
	"8022": "lao",
	"86C8": "tie",
	"5336": "jiu",
	"5ECC": "jian",
	"8566": "xu",
	"8C0D": "die",
	"5702": "hun",
	"76BC": "gu",
	"8D54": "pei",
	"9522": "gu",
	"96DA": "guan",
	"547C": "hu",
	"5616": "ze",
	"6716": "lang",
	"6D6C": "li",
	"72D1": "ling",
	"7ADD": "bing",
	"99C9": "jiong",
	"53C5": "can;cen;shen",
	"60AE": "wu",
	"68F6": "lai",
	"7614": "ku",
	"7F8D": "ta",
	"94DD": "lu",
	"9CB9": "shen",
	"5369": "jie",
	"5B5D": "xiao",
	"75E6": "wu",
	"7F82": "juan",
	"7FBA": "nou",
	"86C9": "ling",
	"6D06": "cheng",
	"95A9": "min",
	"6493": "nao",
	"94AF": "ba;pa",
	"66CB": "qin",
	"706D": "mie",
	"766D": "ying",
	"9C7D": "dao",
	"6912": "jiao",
	"70E1": "guang",
	"7F07": "ti",
	"8D10": "jin",
	"91CA": "shi",
	"9906": "yao",
	"5C66": "ju",
	"62DD": "bai",
	"7494": "zeng",
	"749A": "qiong",
	"8745": "can",
	"97D9": "wei",
	"97F3": "yin",
	"56C4": "li",
	"6248": "hu",
	"7F02": "ke",
	"8C3C": "hong",
	"97C6": "qian",
	"6C95": "wu",
	"57E2": "juan",
	"5F83": "wang",
	"6676": "jing",
	"6EA7": "li",
	"6EE2": "ying",
	"8618": "rang",
	"9110": "chu",
	"4EB7": "lian",
	"5659": "qin",
	"646E": "ao",
	"74AA": "zao",
	"9586": "yan",
	"9B90": "tai",
	"4EE8": "sa",
	"4F7E": "yi",
	"51F8": "tu;gu",
	"579B": "duo",
	"6466": "hua",
	"77FB": "ku",
	"8423": "ding",
	"93FD": "xiu",
	"965E": "sheng",
	"5419": "xue",
	"5B15": "shi",
	"5DEC": "none",
	"64E5": "lan",
	"6F84": "cheng;deng",
	"91B8": "niang",
	"91E8": "zi",
	"995B": "meng",
	"4F0A": "yi",
	"4FB1": "cheng",
	"6F39": "yan",
	"6FFA": "jian",
	"723A": "ye",
	"73EE": "pei",
	"76AE": "pi",
	"810C": "none",
	"5626": "jiao",
	"8D79": "qiong",
	"8FC0": "gan",
	"9127": "deng",
	"91F7": "tu",
	"9DBC": "jian",
	"4F3B": "beng",
	"5807": "jin",
	"5919": "su",
	"59E1": "kuo",
	"6A60": "nuo",
	"7B1E": "chi",
	"800B": "die",
	"8A8E": "su",
	"9B00": "ti",
	"620E": "rong",
	"80C8": "ba",
	"94AC": "huo",
	"98BF": "fan",
	"75F7": "an",
	"7EA8": "wan",
	"81FB": "zhen",
	"53BE": "du",
	"5982": "ru",
	"6035": "chu",
	"7934": "bo",
	"9556": "biao",
	"4E75": "yan",
	"5E79": "gan",
	"7316": "chang",
	"9605": "yue",
	"5846": "wan",
	"64AE": "cuo;zuo",
	"6C78": "fang",
	"73D2": "jin",
	"75A4": "ba",
	"8EAC": "gong",
	"9DE6": "jiao",
	"50F6": "min",
	"564C": "cheng;ceng",
	"567F": "zui",
	"5AD7": "yu",
	"72CC": "sheng",
	"74E3": "ban",
	"8A9E": "yu",
	"5E29": "qiao",
	"7E99": "luo",
	"8943": "bao",
	"4EC0": "shen;shi",
	"5198": "yin",
	"571B": "yi",
	"58CE": "xuan",
	"702C": "lai",
	"852B": "nian",
	"88AA": "qu",
	"5284": "zha",
	"7FE2": "tao",
	"8F2F": "ji",
	"9700": "xu",
	"5548": "heng",
	"5AEA": "lao",
	"72F5": "mang",
	"730E": "lie",
	"7EE5": "sui",
	"897A": "jian",
	"9A60": "yan",
	"67D2": "qi",
	"69F1": "you",
	"700F": "liu",
	"8762": "xie",
	"922B": "none",
	"5154": "tu",
	"6D81": "shen",
	"6ECF": "fu",
	"8239": "chuan",
	"8E23": "bo",
	"936E": "zhen",
	"5E69": "fen",
	"6BFC": "he",
	"81C7": "juan",
	"567B": "sai",
	"5DF2": "yi",
	"6CB9": "you",
	"7361": "shuo",
	"757D": "tun",
	"7D0E": "zi",
	"884E": "kan",
	"8869": "cha",
	"9374": "duan",
	"4F91": "you",
	"69D7": "qiao",
	"6D0E": "ji",
	"94E7": "hua",
	"9A64": "xiang",
	"5BCE": "bing",
	"726A": "yan",
	"754E": "quan",
	"78A0": "ding",
	"78BA": "que",
	"86CD": "ying",
	"88C2": "lie",
	"8E13": "wei",
	"965A": "fu",
	"750F": "beng",
	"54A9": "mie",
	"5742": "ban",
	"59F4": "lie",
	"6282": "kuang",
	"7B40": "gui",
	"8A99": "heng",
	"90B5": "shao",
	"99B0": "di",
	"9CBF": "chang",
	"533C": "an",
	"713C": "shao",
	"9A0D": "ke",
	"5064": "you",
	"515A": "dang",
	"69A6": "gan;han",
	"8882": "mei",
	"91AC": "jiang",
	"4FF8": "feng",
	"759E": "xu",
	"7D91": "kun",
	"5AA1": "lian",
	"7C16": "duan",
	"9CAA": "jun",
	"8529": "yin",
	"5199": "xie",
	"6FA3": "huan",
	"772D": "sui",
	"52B1": "li",
	"5516": "ya",
	"73AD": "pi",
	"78EA": "cui",
	"792F": "ying",
	"7A1B": "kun",
	"819A": "fu",
	"8B55": "wu",
	"95CF": "none",
	"9A4D": "xiao",
	"4F6F": "yang",
	"66A4": "hao",
	"8FD9": "zhei",
	"5786": "lu",
	"63A2": "tan",
	"69DC": "zui",
	"80FE": "zi",
	"9088": "miao",
	"93B6": "ge",
	"50DA": "liao",
	"5F1C": "qiang",
	"5989": "dan",
	"59B0": "zhou",
	"652A": "jiao;gao",
	"7835": "bo",
	"7F7B": "wei",
	"7FAD": "yu",
	"8CC7": "zi",
	"94A0": "na",
	"960E": "yan",
	"9C1F": "pang",
	"8B83": "zan",
	"8C64": "ken",
	"5A79": "yao",
	"6ED1": "hua;gu",
	"801B": "chi",
	"9302": "ling",
	"503B": "ye",
	"59AB": "gui",
	"6B4B": "yi",
	"729A": "wei",
	"8700": "shu",
	"50AD": "yong",
	"5973": "nu;ru",
	"5C68": "ju",
	"5E9A": "geng",
	"6093": "qian",
	"6693": "mao",
	"6885": "mei",
	"6CA4": "ou",
	"87BA": "luo",
	"9406": "sui",
	"9A1A": "qian",
	"63F2": "she;die",
	"6762": "none",
	"6831": "gong",
	"6FF1": "bin",
	"82E8": "ni",
	"8697": "jue",
	"8DBB": "chen",
	"6849": "an",
	"701E": "jing",
	"88C5": "zhuang",
	"8C71": "wen",
	"98FA": "ci",
	"824A": "bo",
	"9CD9": "yong",
	"6440": "wu",
	"6E86": "xu",
	"73DE": "luo",
	"89FD": "xi",
	"8FB0": "chen",
	"91EC": "han",
	"9C9E": "xiang",
	"66FC": "man",
	"72A5": "piao",
	"7DDA": "xian",
	"4F79": "gui",
	"5093": "shan",
	"50C0": "di",
	"5720": "ya",
	"5B3C": "liu",
	"5E03": "bu",
	"64BC": "han",
	"66C5": "ye",
	"6753": "shao;biao",
	"70AD": "tan",
	"782C": "la;li",
	"9136": "kuai",
	"9EC3": "huang",
	"6AA5": "yi",
	"6F14": "yan",
	"74C0": "ruan",
	"4EED": "ren",
	"54A3": "guang",
	"7231": "ai",
	"8353": "ping",
	"4EC6": "pu",
	"689D": "tiao",
	"6BA0": "chou;xiu",
	"7997": "si",
	"8025": "tang",
	"8D29": "fan",
	"7321": "luo",
	"73A7": "yun",
	"7C7A": "xie",
	"7E4C": "none",
	"9B1B": "lie",
	"9F37": "xi",
	"56F1": "cong",
	"5D90": "long",
	"7748": "cheng",
	"90B9": "zou",
	"912C": "wei",
	"55F1": "na",
	"5662": "o",
	"6A06": "li",
	"8A65": "he",
	"5BF9": "dui",
	"6B12": "luan",
	"82A5": "jie;gai",
	"8786": "xi",
	"5433": "wu",
	"5553": "qi",
	"6951": "kui",
	"7D25": "zha",
	"80C0": "zhang",
	"836F": "yao",
	"8F85": "fu",
	"91E1": "fu",
	"9214": "chao",
	"95D5": "que",
	"54C6": "duo",
	"638A": "pou",
	"7E05": "none",
	"569D": "huang",
	"5997": "jin",
	"637C": "nuo",
	"89AB": "pang",
	"8CA4": "yi",
	"9B47": "yan",
	"4E96": "si",
	"5EB3": "bi;bei",
	"6593": "lan",
	"84AA": "po",
	"8861": "heng",
	"659C": "xie;xia",
	"7283": "pou",
	"7BDD": "gou",
	"8B65": "jiao",
	"54D5": "hui;yue",
	"93B7": "ma",
	"9557": "tang",
	"9960": "luo",
	"9A38": "shan",
	"9C7A": "li",
	"4E08": "zhang",
	"644E": "liao",
	"6ADC": "gao",
	"7B98": "jun",
	"7C0E": "zha",
	"93AB": "wan",
	"706C": "biao",
	"7F65": "juan",
	"89AE": "ping",
	"8AFA": "yan",
	"966B": "pei",
	"63A5": "jie",
	"6AE0": "fei",
	"73FF": "chuo",
	"88C3": "none",
	"8B82": "xuan",
	"5A36": "qu",
	"899C": "tiao",
	"5AFF": "hua",
	"5C1B": "yuan",
	"72E0": "hen",
	"875E": "mei",
	"8FE5": "jiong",
	"9DE3": "yin",
	"4F01": "qi",
	"54A2": "e",
	"60F6": "huang",
	"8322": "lie",
	"500E": "tian",
	"5166": "wang;wu",
	"854B": "rui",
	"8614": "jiong",
	"901E": "cheng",
	"5739": "kuang",
	"7636": "sou",
	"7E62": "hui",
	"85CA": "bian",
	"8753": "yu",
	"9714": "chou",
	"98D0": "zhan",
	"5318": "nao",
	"5410": "tu",
	"5A28": "xian",
	"67DB": "shen",
	"7BC5": "chuan",
	"8013": "ting",
	"931D": "cong",
	"8AEE": "zi",
	"9268": "ni",
	"9A27": "gua",
	"56E3": "tuan",
	"6515": "san",
	"6ED7": "bi",
	"7188": "xi",
	"923C": "zuo",
	"5FB4": "zheng",
	"6325": "hui",
	"76DC": "dao",
	"7D59": "geng",
	"579A": "yao",
	"64BE": "zhua;wo",
	"8831": "gu",
	"9987": "cha",
	"5129": "si",
	"5641": "wu",
	"67DA": "you",
	"67EB": "fu;bi",
	"7141": "chen",
	"7892": "yin",
	"7E96": "xian",
	"9C54": "shan",
	"5BFC": "dao",
	"629B": "pao",
	"7B0B": "sun",
	"8080": "yu",
	"9E93": "lu",
	"5E63": "bi",
	"6523": "luan",
	"8738": "qian",
	"9B7A": "he;ge",
	"6743": "quan",
	"6B50": "ou",
	"910A": "xiang",
	"5A4B": "xiao",
	"67A8": "cheng",
	"6F0E": "cong",
	"7364": "none",
	"5D92": "ceng",
	"8064": "ting",
	"83C5": "jian",
	"8C94": "pi",
	"5A10": "none",
	"6F91": "liu",
	"9E63": "jian",
	"4E26": "bing",
	"501D": "gan",
	"68DC": "yu",
	"7740": "zhe;zhuo;zhao",
	"9F1C": "qi",
	"5F01": "bian",
	"64CD": "cao",
	"6FB9": "dan;tan",
	"7A1D": "peng",
	"50C2": "lou;lu",
	"77D0": "huo",
	"8157": "pi",
	"8E82": "ta",
	"5A52": "tan",
	"5B73": "zi",
	"6CAC": "mei",
	"7850": "dong",
	"7C5E": "yu",
	"980A": "xu",
	"4E24": "liang",
	"5032": "dong",
	"6448": "bin",
	"6828": "ci",
	"73F0": "dang",
	"5992": "du",
	"5B85": "zhai;zhe",
	"69E7": "qian",
	"7278": "zi",
	"82C1": "cong",
	"85EF": "wei",
	"579E": "cha",
	"6F07": "xi",
	"6F60": "sun",
	"739E": "fu",
	"8204": "xi",
	"84A9": "zu",
	"8605": "heng",
	"662F": "shi",
	"98CB": "se",
	"99CA": "bo",
	"50E6": "jiu",
	"5A8F": "duan",
	"60F2": "yun",
	"66B9": "xian",
	"7067": "yan",
	"68A1": "kuan",
	"6FA4": "ze",
	"76F7": "tian",
	"7A67": "ji",
	"7C1B": "shai",
	"7CF9": "mi",
	"7FC0": "chong",
	"9776": "ba",
	"9CDB": "xi",
	"5C49": "ti",
	"64DB": "ye",
	"8DE3": "xian",
	"9C3A": "sao",
	"502B": "lun",
	"5897": "zeng",
	"5A1F": "juan",
	"844D": "fu",
	"9069": "shi;kuo",
	"979A": "kong",
	"59A1": "xin",
	"6303": "zhi",
	"673D": "xiu",
	"7853": "none",
	"786B": "liu",
	"93E4": "lou",
	"618C": "chun",
	"6F35": "xu",
	"82E9": "bo",
	"9938": "song",
	"9C24": "shi",
	"5CAB": "xiu",
	"636D": "bai",
	"65CD": "jing",
	"697B": "heng",
	"6F72": "shao",
	"7BB3": "ping",
	"828F": "du",
	"8E65": "lian",
	"95BB": "yan",
	"9A2B": "qian",
	"522A": "shan",
	"57F4": "zhi",
	"6C1B": "fen",
	"78BE": "nian",
	"50AF": "zong",
	"7F89": "luan",
	"8912": "bao",
	"548A": "he;huo",
	"9893": "tui",
	"5B8C": "wan",
	"5EA0": "xiang",
	"626B": "sao",
	"65A1": "wo",
	"78CB": "cuo",
	"7D7A": "chi",
	"5D12": "zu",
	"60BC": "dao",
	"8FB9": "bian",
	"903B": "luo",
	"9517": "zhe;zang",
	"9D60": "hu;gu",
	"4FAD": "jin",
	"505F": "huang",
	"5C73": "xian",
	"6360": "bang",
	"541C": "chou",
	"63C7": "nan",
	"6E0A": "yuan",
	"9AF7": "qu",
	"6183": "chuang",
	"6DE6": "gan",
	"6E63": "min",
	"72E1": "jiao",
	"755E": "mu",
	"917A": "pu",
	"9AD9": "gao",
	"4E5A": "yin",
	"51B4": "hu",
	"70F6": "ting",
	"762A": "bie",
	"93CC": "mo",
	"5157": "yan",
	"7051": "sa",
	"761F": "wen",
	"7A27": "xi",
	"8A56": "bi",
	"52A2": "mai",
	"6658": "han",
	"784B": "ai",
	"8801": "xiang",
	"9050": "xia",
	"991C": "guo",
	"9CDC": "gui",
	"577B": "chi;di",
	"65C2": "qi",
	"6D1F": "yi",
	"70C0": "hu",
	"7A6D": "lu",
	"9B15": "mo",
	"9F0D": "tuo",
	"7BC9": "zhu",
	"8AB9": "fei",
	"9ADB": "kao",
	"9BA1": "tiao",
	"4F29": "xin",
	"7550": "fu",
	"879D": "xi",
	"8BB3": "hui",
	"60F9": "re",
	"65C4": "mao",
	"806A": "cong",
	"8774": "hu",
	"91BC": "yan",
	"6236": "hu",
	"8053": "none",
	"8E4E": "dian",
	"51E7": "none",
	"53E7": "gua",
	"6A5E": "hui",
	"7268": "ren",
	"4E87": "none",
	"55D3": "sang",
	"6130": "huang",
	"6EE7": "xiao",
	"7399": "yu",
	"9048": "shi",
	"6841": "heng;hang",
	"6B63": "zheng",
	"6C3D": "tun",
	"7DBB": "zhan",
	"7F1A": "fu",
	"892B": "chi",
	"9CCB": "sao",
	"6678": "zhen",
	"7887": "ding",
	"81DB": "hu",
	"82D9": "li",
	"6254": "reng",
	"6296": "dou",
	"645F": "lou",
	"6684": "xuan",
	"68D5": "zong",
	"715C": "yu",
	"8A34": "su",
	"68DF": "dong",
	"6B69": "bu",
	"7228": "cuan",
	"80DC": "sheng",
	"842E": "yu",
	"92FA": "yuan",
	"6DA5": "none",
	"7F4E": "tan",
	"89DC": "zui;zi",
	"9A9D": "liu",
	"53D2": "ruo",
	"6894": "zhi",
	"6B48": "yu",
	"860B": "pin;ping",
	"89E7": "jie;xie",
	"5744": "tou",
	"5F38": "beng",
	"7890": "ling",
	"8D65": "xi",
	"8EF1": "gu",
	"5537": "yo",
	"5A1B": "yu",
	"6317": "jue",
	"7780": "mao",
	"5D52": "yan",
	"6087": "yu",
	"7369": "hui",
	"7E01": "yuan",
	"63DF": "xu;ju",
	"644C": "chan",
	"7EE0": "geng",
	"8EAB": "shen;juan",
	"55B9": "kui",
	"9350": "cong",
	"9C73": "li",
	"5A43": "cong",
	"672A": "wei",
	"7E88": "xie",
	"8DA0": "chuo",
	"9142": "cuo",
	"9220": "yi",
	"5594": "wo",
	"5920": "gou",
	"6FDA": "ying;xing",
	"75CB": "chong",
	"778D": "sou",
	"7875": "lu",
	"8BB2": "jiang",
	"51DE": "xi",
	"69BE": "gu",
	"4ED7": "zhang",
	"5EBB": "shu",
	"633D": "wan",
	"98E7": "sun",
	"9C91": "gui;xie",
	"771A": "sheng",
	"9545": "mei",
	"5AB3": "xi",
	"87D2": "mang",
	"9BFB": "la",
	"5292": "jian",
	"618B": "bie",
	"652D": "li",
	"6AB1": "qi",
	"6FCB": "chu",
	"7534": "zha",
	"8D0B": "yan",
	"6CD8": "hu",
	"7444": "xuan",
	"834D": "shou",
	"4EF6": "jian",
	"683C": "ge",
	"8252": "mao",
	"8994": "mi",
	"98FE": "shi",
	"5561": "fei",
	"66C1": "ji",
	"7AB5": "diao",
	"7CF7": "lan",
	"9675": "ling",
	"565F": "ying",
	"6272": "qian",
	"71E0": "yu",
	"551F": "none",
	"619F": "su",
	"7310": "qiang",
	"841B": "jiu",
	"6400": "chan",
	"7087": "po",
	"8636": "wei",
	"9D5A": "tu",
	"5FC9": "dao",
	"64E4": "xing",
	"68AD": "suo",
	"86FD": "bai",
	"8B3C": "hu",
	"94FA": "pu",
	"60CE": "ji",
	"94B5": "bo",
	"9633": "yang",
	"581B": "bi",
	"61D4": "lin",
	"67CB": "dai",
	"9EE4": "yan",
	"5311": "gong",
	"5582": "wei",
	"8E59": "cu",
	"764D": "ban",
	"5498": "bu",
	"6C6A": "wang",
	"6E7E": "wan",
	"86B0": "you",
	"96F3": "li",
	"65E4": "huo",
	"76FD": "feng",
	"7D47": "ju",
	"7DF2": "miao",
	"82C8": "li",
	"95DC": "guan",
	"986F": "xian",
	"5F08": "yi",
	"634D": "han",
	"64FC": "lu",
	"678F": "nan",
	"68ED": "yi",
	"6DB5": "han",
	"73A5": "yue",
	"7998": "di",
	"7D61": "luo;lao",
	"8319": "rong",
	"9BD1": "none",
	"9C2E": "wen",
	"65AC": "zhan",
	"72F8": "li",
	"7BDB": "ruo",
	"89BC": "luo",
	"5558": "wan",
	"69CC": "chui",
	"7AAC": "yu",
	"8826": "lu",
	"5D54": "wei",
	"62E7": "ning",
	"65D0": "zhao",
	"7F28": "ying",
	"7FF8": "pen",
	"8133": "nao",
	"4E2F": "jie",
	"5DC0": "jie",
	"7B16": "yi",
	"90D0": "kuai",
	"9485": "jin",
	"5431": "zhi;zi",
	"56DD": "jian;nan",
	"75B3": "gan",
	"78FB": "pan",
	"7CCE": "li",
	"80E1": "hu",
	"9C41": "zhu",
	"637A": "na",
	"6A3D": "zun",
	"6DAF": "ya",
	"9D0A": "zheng",
	"9D22": "you",
	"4F09": "kang",
	"537A": "jin",
	"56C9": "luo",
	"6401": "ge",
	"64C5": "shan",
	"941E": "nou",
	"4ED1": "lun",
	"6433": "xia",
	"6BDE": "pi",
	"6D0C": "lie",
	"6DA2": "yun",
	"8228": "ban",
	"9A89": "biao",
	"5159": "shi;ke",
	"52A0": "jia",
	"701F": "xiao",
	"7676": "bo",
	"966A": "pei",
	"9A1B": "fei",
	"54E3": "pou",
	"5EC5": "he",
	"6FC2": "lian",
	"766E": "yin",
	"8124": "shen",
	"87B8": "yu",
	"8C5F": "e",
	"957A": "ao",
	"95FC": "ta",
	"531D": "za",
	"6BE5": "xun",
	"73AA": "jian",
	"74AF": "hui",
	"8E18": "ju",
	"6017": "tie",
	"6526": "li",
	"799F": "tang",
	"8DB7": "he",
	"59A9": "wu",
	"59D8": "pin",
	"5B45": "xian",
	"5C85": "ban",
	"72FB": "suan",
	"567D": "pi",
	"6451": "guo;guai",
	"6838": "he;hu",
	"8756": "xuan",
	"8C05": "liang",
	"61BD": "song",
	"6BE4": "tuo",
	"7C3B": "ke",
	"8F8A": "gun",
	"9105": "yu",
	"917D": "yan",
	"9480": "nie",
	"95B7": "shai",
	"5A9E": "ti;shi",
	"5F7E": "ling",
	"70DE": "po",
	"7874": "none",
	"7D9D": "lin",
	"8EB7": "ai",
	"92BE": "gong",
	"5ACB": "niao",
	"74F8": "none",
	"7567": "lue",
	"80D3": "ping",
	"81E3": "chen",
	"8260": "none",
	"7B8A": "yu",
	"7B91": "sha",
	"8325": "kui",
	"9870": "pin",
	"5AAB": "none",
	"991A": "yao",
	"9B09": "zong",
	"4F5C": "zuo",
	"51C6": "zhun",
	"63FA": "yao",
	"7D63": "beng;ping",
	"8B86": "wei",
	"9EC9": "hong",
	"548B": "za;ze;zha",
	"549D": "si",
	"6B44": "none",
	"837D": "sui",
	"8F5F": "hong",
	"961C": "fu",
	"5852": "shi",
	"690B": "liang",
	"6B61": "huan",
	"6CD1": "you",
	"6D05": "zui",
	"78E3": "chen",
	"904E": "guo",
	"95D0": "tian",
	"9D71": "lu",
	"62D9": "zhuo",
	"70B2": "tai",
	"71ED": "zhu",
	"7F70": "fa",
	"8822": "chun",
	"881E": "jie",
	"8DF9": "xian",
	"8F68": "gui",
	"5399": "she",
	"584D": "cheng",
	"592D": "yao",
	"5A20": "shen;chen;zhen",
	"5FF4": "qian",
	"5278": "tuan;zhuan",
	"6BE0": "jia",
	"6E72": "yuan",
	"804E": "tiao",
	"92CE": "han",
	"9F88": "yin;ken",
	"6DC2": "de",
	"6DDA": "lei",
	"7B2B": "zi",
	"80B3": "wen",
	"81B0": "fan",
	"89C6": "shi",
	"8E9E": "xie",
	"69D2": "xu",
	"7467": "jin",
	"90C0": "ku",
	"9A62": "lu",
	"9EF0": "zhen",
	"5D05": "que",
	"7327": "wo",
	"79E6": "qin",
	"8205": "jiu",
	"5AE5": "zhuan",
	"7C14": "suo",
	"7F57": "luo",
	"92A5": "yi",
	"55E7": "jia;lun",
	"6768": "yang",
	"6D42": "yi",
	"7F77": "ba;pi",
	"913C": "zan",
	"9499": "gai",
	"9623": "yi",
	"4E1E": "cheng",
	"68D4": "hun",
	"70F9": "peng",
	"8B51": "jiao",
	"9119": "bi",
	"5BAE": "gong",
	"656A": "duo",
	"7759": "lie",
	"7E28": "huang",
	"8963": "bi",
	"92FE": "tao",
	"98A5": "ru",
	"9B13": "bin",
	"9D5B": "jing",
	"68A3": "cen",
	"69DA": "jia",
	"6DC0": "dian",
	"97E2": "hui",
	"860A": "yun",
	"88FA": "yan",
	"8EE3": "hong",
	"9790": "gong",
	"9E01": "luo",
	"580E": "leng;ling",
	"7221": "che",
	"9927": "wei",
	"585D": "bang",
	"86FE": "e;yi",
	"8953": "rao",
	"8999": "luo",
	"8E8D": "yue",
	"515C": "dou",
	"59D5": "zi",
	"7D06": "yu",
	"87C0": "shuai;shuo",
	"87E3": "ji",
	"8F2D": "ruan",
	"9D38": "zhu",
	"5088": "li",
	"690D": "zhi",
	"6DD3": "fang",
	"78F4": "deng",
	"8620": "qiang",
	"6ADB": "zhi;jie",
	"72B0": "qiu",
	"7758": "qiong",
	"8DC3": "yue",
	"9303": "bei",
	"9C8E": "hou",
	"5B0F": "fan",
	"6EEB": "xiu",
	"88D2": "pou",
	"91FF": "yin",
	"962E": "ruan",
	"9D91": "none",
	"5A1D": "pei",
	"6DF2": "piao;hu",
	"705F": "zhu",
	"8F70": "hong",
	"8F8F": "cou",
	"9BCE": "none",
	"9C5A": "xi",
	"6718": "juan;zui",
	"9505": "guo",
	"96FE": "wu",
	"9B72": "lu",
	"9BC3": "wu",
	"52D7": "xu",
	"7B29": "fa",
	"8208": "xing",
	"9689": "nie",
	"974D": "none",
	"9983": "guo",
	"4FA8": "qiao",
	"61FE": "she;zhe",
	"68EE": "sen",
	"6E96": "zhun",
	"7AB1": "tiao",
	"7E27": "tao",
	"7F4D": "lei",
	"5775": "qiu",
	"5B90": "yi",
	"653C": "gan",
	"685D": "none",
	"784F": "yan",
	"94F8": "zhu",
	"5B92": "zhun",
	"6CBA": "tian",
	"7E3F": "shan",
	"84FE": "lu",
	"938F": "liu",
	"944C": "bin",
	"4FFC": "yu;zhou",
	"767D": "bai",
	"7FCB": "la",
	"539A": "hou",
	"6705": "qie",
	"70F8": "hai",
	"9431": "qian",
	"9E6F": "zhan",
	"50F9": "jia",
	"5C30": "zhong",
	"60A4": "cong",
	"58E1": "rui",
	"5E1F": "yi",
	"660E": "ming",
	"6BA4": "shang",
	"6D85": "nie",
	"80C4": "zhou",
	"9E25": "ou",
	"7573": "die",
	"61EF": "fu",
	"7266": "mao",
	"8917": "yan",
	"63C0": "jian",
	"6FAF": "can",
	"73CE": "zhen",
	"8245": "yu",
	"5645": "kui",
	"6195": "cheng",
	"6662": "zhe",
	"6F50": "jiao",
	"7769": "lu",
	"7E0F": "pan",
	"790B": "zhai",
	"851F": "cu",
	"8C65": "gai",
	"55CF": "cha",
	"5A0D": "cheng",
	"5ED1": "qin;jin",
	"70D0": "zhou",
	"7BA1": "guan",
	"9600": "fa",
	"97AC": "jian",
	"6B66": "wu",
	"702B": "hu",
	"9777": "yin",
	"9C55": "fan",
	"597A": "jiu",
	"7D80": "shu",
	"8061": "cong",
	"9890": "yi",
	"766B": "dian",
	"9091": "yi",
	"5355": "dan;chan;shan",
	"56BA": "ta",
	"80A1": "gu",
	"5856": "cheng",
	"602E": "you",
	"8719": "song",
	"6CB1": "tuo",
	"7A85": "yao",
	"87A0": "yi",
	"891C": "none",
	"968D": "huang",
	"9B62": "ji",
	"5BBA": "huang",
	"6818": "chi;yi",
	"723E": "er",
	"7ED6": "die",
	"7EFC": "zong;zeng",
	"908C": "li",
	"98EE": "yin",
	"9D77": "yuan",
	"4E81": "gan",
	"5BD8": "zhi",
	"63EC": "tu",
	"6918": "chu",
	"7074": "hong",
	"7963": "lu",
	"7B60": "yun;jun",
	"808D": "qiu",
	"8A41": "gu",
	"8A57": "xiong",
	"5B66": "xue",
	"7341": "ma",
	"7928": "lei",
	"8083": "su",
	"84B2": "pu",
	"4F4E": "di",
	"62D4": "ba",
	"6D1D": "an",
	"82DC": "mu",
	"84B6": "fen",
	"857C": "si",
	"95A0": "run",
	"9A52": "tuo",
	"5236": "zhi",
	"6F58": "pan",
	"7A32": "dao",
	"86A9": "chi",
	"4F71": "fa",
	"5326": "gui",
	"5D07": "chong",
	"6278": "xi",
	"6B7B": "si",
	"8AA7": "pu",
	"974E": "he",
	"9ADA": "qiao",
	"513A": "nuo",
	"65A7": "fu",
	"69D0": "huai",
	"6CB5": "mi",
	"747D": "cong",
	"913E": "you",
	"4FAE": "wu",
	"60B4": "cui",
	"6AE8": "lu",
	"9E29": "zhen",
	"5222": "ling",
	"59BB": "qi",
	"5B2F": "tai",
	"5F0D": "er",
	"60AA": "e;wu",
	"71AB": "zhi",
	"7A49": "zhi",
	"8331": "zhu",
	"514B": "ke",
	"5FA6": "jia",
	"62E3": "jian",
	"6423": "mie",
	"6B4E": "tan",
	"70E0": "hui",
	"76DA": "qiu",
	"9E85": "pao",
	"5F95": "lai",
	"6010": "kou",
	"618F": "chi",
	"66F4": "geng",
	"706A": "yu",
	"707A": "xie",
	"83CE": "kun",
	"91C2": "jiao",
	"9D6C": "peng",
	"5040": "ying",
	"5B6A": "luan",
	"635D": "tuo",
	"8B89": "yi",
	"52C4": "min",
	"6C30": "qing",
	"7C06": "kou",
	"7D5D": "ku",
	"91A1": "zha",
	"50B6": "zu",
	"6F0C": "jin",
	"82C7": "wei",
	"9C45": "yong",
	"4F1D": "yun",
	"69FF": "jin",
	"8796": "hua",
	"9C6C": "ru",
	"682D": "er",
	"79D9": "ku",
	"96AC": "ni",
	"70DF": "yan;yin",
	"929E": "jun",
	"9756": "jing",
	"5074": "ce;ze",
	"60B1": "fei",
	"7172": "bao",
	"7CEE": "jian",
	"7DCE": "yu",
	"9855": "xian",
	"9BE3": "yi",
	"7445": "ti",
	"7AC3": "zao",
	"910F": "ru",
	"971C": "shuang",
	"86AF": "qiu",
	"87E7": "lao",
	"90DF": "jia",
	"974B": "li",
	"5261": "yan;shan",
	"53A8": "chu",
	"631C": "ya",
	"6675": "qi",
	"8656": "hu",
	"9BD4": "zi",
	"5E04": "ding",
	"61B3": "tan",
	"6E6B": "qiu;jia;jiao;jiu",
	"7594": "ding",
	"7D5E": "jiao",
	"88A2": "pan",
	"961B": "huan",
	"5F2A": "jing",
	"5F88": "hen",
	"8C22": "xie",
	"616C": "jin",
	"746B": "tao",
	"7495": "xun",
	"7EA3": "zhou",
	"6914": "zi",
	"7063": "wan",
	"7C2C": "lu",
	"9CE5": "niao",
	"516E": "xi",
	"64F3": "jie",
	"8093": "huang",
	"8FB5": "chuo",
	"9687": "wei",
	"9951": "ji",
	"5FC7": "le",
	"61AF": "can",
	"819D": "xi",
	"8307": "ba",
	"8749": "chan",
	"8926": "nai",
	"8AA4": "wu",
	"8BC8": "zha",
	"969F": "xi",
	"6C40": "ting",
	"75CE": "jie",
	"8BDC": "shen",
	"5EB8": "yong",
	"7165": "huan",
	"76BB": "zha",
	"4ECA": "jin",
	"8E10": "jian",
	"93E7": "long",
	"9801": "ye",
	"6FFB": "dui;wei",
	"7270": "you",
	"75D0": "hui",
	"7693": "hao",
	"910B": "sou",
	"920A": "xin",
	"5D68": "wu",
	"6AEB": "zhu",
	"7064": "luan",
	"74A0": "fan",
	"81D0": "xun",
	"8FBE": "da",
	"98FF": "duo",
	"52FB": "yun",
	"6022": "tu",
	"6B3F": "kan",
	"6ECA": "xi",
	"7C2A": "zan",
	"6421": "sang",
	"76B9": "jun",
	"7F61": "gang",
	"87A9": "none",
	"5A74": "ying",
	"6127": "kui",
	"659A": "jia",
	"7094": "gui;que",
	"7D87": "xiu",
	"6F30": "peng",
	"7118": "dao;tao",
	"7EC9": "zhou",
	"913B": "lian",
	"9D6B": "zhao",
	"9E94": "jiu",
	"4F55": "he",
	"50F8": "jin",
	"5EF3": "ting",
	"69E6": "yong",
	"7D1A": "ji",
	"54F5": "ba",
	"8253": "die",
	"9E83": "biao",
	"4EFA": "cang",
	"590C": "ling",
	"6E34": "ke",
	"8C35": "zhan",
	"8DBF": "ta",
	"5B9F": "shi",
	"733B": "sun",
	"8779": "yun",
	"5FEB": "kuai",
	"91A7": "yu",
	"5121": "lei",
	"5CC1": "mao",
	"74F3": "hu",
	"977E": "yi",
	"9BF6": "hun",
	"5F84": "jing",
	"6CAB": "mo",
	"7EF1": "shang",
	"8C6C": "zhu",
	"4E82": "luan",
	"669D": "ming",
	"6BB9": "yi",
	"8F12": "zhe",
	"95E0": "hui",
	"532E": "kui",
	"6C17": "qi",
	"6CBC": "zhao",
	"71FD": "chou",
	"7EF7": "beng",
	"9405": "pie",
	"5BBE": "bin",
	"7E29": "cai",
	"8D7F": "chi",
	"9D02": "ju",
	"4EF5": "wu",
	"576B": "dian",
	"5DBA": "ling",
	"6387": "duo",
	"6544": "wu",
	"6B33": "kuai",
	"6C20": "shen",
	"7EE4": "xi",
	"82D0": "yi;ti",
	"8375": "ren",
	"85E8": "biao",
	"9DBD": "zhun",
	"6069": "en",
	"6CA5": "li",
	"6EBA": "ni;niao",
	"708F": "kai",
	"8485": "none",
	"8EE4": "hu",
	"535F": "bu",
	"5D8A": "zui",
	"7729": "xuan",
	"88AF": "bo",
	"9B2A": "dou",
	"68C0": "jian",
	"7AEF": "duan",
	"873A": "ni",
	"89C8": "lan",
	"9B20": "kuai",
	"5098": "san",
	"68E9": "yuan",
	"7C21": "jian",
	"81EA": "zi",
	"8AF2": "yin",
	"8F1D": "hui",
	"9E43": "juan",
	"5A02": "hong",
	"6E3A": "miao",
	"6EEF": "zhi",
	"70DA": "xia",
	"7F9A": "ling",
	"8077": "zhi",
	"8E01": "xing",
	"96A8": "sui",
	"6239": "e",
	"6481": "qian",
	"64F2": "zhi",
	"733C": "bo",
	"7B14": "bi",
	"7CCC": "zan",
	"8149": "jie",
	"8ED7": "shu",
	"9B38": "liu",
	"84FF": "xu;su",
	"739B": "ma",
	"5C51": "xie",
	"93A2": "wu",
	"9C38": "qu",
	"5C5B": "ping",
	"8871": "jie",
	"5B6C": "nao",
	"80BB": "ken",
	"98DD": "fei",
	"5F15": "yin",
	"8F95": "yuan",
	"5AB1": "yao",
	"5DAF": "ji",
	"6A00": "di",
	"606E": "quan",
	"6985": "yun",
	"6E8C": "po",
	"8E97": "wei",
	"8F13": "wan",
	"5524": "huan",
	"5C54": "ni",
	"5CD1": "quan",
	"634F": "nie",
	"7B72": "shao",
	"8E00": "chu",
	"97A7": "qiu",
	"644D": "suo",
	"729E": "se",
	"7706": "fang",
	"8BAD": "xun",
	"903C": "bi",
	"96A4": "tui",
	"9E98": "xiang",
	"593C": "kuang",
	"64AD": "bo",
	"5944": "yan",
	"6795": "zhen",
	"95A6": "chu",
	"9804": "pan",
	"9F62": "ling",
	"5273": "zha",
	"6334": "mei",
	"73F3": "wen",
	"766C": "xian;xuan",
	"6956": "ji",
	"6FE0": "hao",
	"7456": "duan",
	"7914": "pi",
	"7DBA": "qi",
	"844A": "an",
	"70AF": "jiong",
	"7B03": "du",
	"81BB": "shan",
	"83E3": "qin",
	"9095": "yong",
	"6FA0": "min;mian;sheng",
	"895A": "sui",
	"59EE": "heng",
	"5A17": "ding",
	"6247": "shan",
	"861F": "yin",
	"94E1": "zha",
	"7E8A": "kuang",
	"806B": "lian",
	"847D": "yao",
	"8754": "jie",
	"9841": "ding",
	"9C47": "kang",
	"4F43": "dian;tian",
	"6EB9": "su",
	"706B": "huo",
	"745D": "huang",
	"5C70": "ni",
	"696A": "die",
	"6A29": "quan",
	"77F6": "ji",
	"886D": "fu",
	"8CB5": "pian",
	"994F": "dan",
	"5371": "wei",
	"5518": "qi",
	"5DE8": "ju",
	"6B5E": "kan",
	"70AB": "xuan",
	"858C": "xiang",
	"9009": "xuan",
	"9DE7": "yi",
	"5DAD": "e",
	"752F": "ning",
	"7FE6": "jian",
	"63F7": "cha",
	"74ED": "dan",
	"77BC": "jian",
	"91E2": "nai",
	"504A": "yu",
	"7986": "bei",
	"7EDA": "xuan",
	"8F35": "ge",
	"9C63": "zhan",
	"9D7C": "kong",
	"51CF": "jian",
	"5259": "chuang",
	"5C95": "jie",
	"70B3": "bing",
	"71C1": "ye",
	"7560": "none",
	"4F97": "dong;tong",
	"6119": "ke",
	"62C9": "la",
	"64A5": "bo",
	"7193": "wen",
	"7565": "lue",
	"596D": "shi",
	"6673": "xi",
	"6E83": "kui;hui",
	"89B6": "luo",
	"8EEA": "ao",
	"9004": "pang",
	"6B30": "xu",
	"8FE1": "ni",
	"5AC0": "qin",
	"6530": "gui",
	"6562": "gan",
	"66ED": "tang",
	"76CC": "wan",
	"7CFE": "jiu",
	"9C25": "guan",
	"591C": "ye",
	"5D9D": "deng",
	"7273": "mu",
	"780E": "jie",
	"7BB5": "sheng",
	"7F01": "zi",
	"5745": "qin",
	"5790": "ci",
	"641A": "xie",
	"7656": "pi",
	"8F7E": "zhi",
	"9774": "xue",
	"9A9E": "qian",
	"9E80": "you",
	"5857": "tu",
	"7BEB": "zhu",
	"8254": "none",
	"827A": "yi",
	"846F": "yao",
	"989D": "e",
	"9918": "yu",
	"9BAC": "pu",
	"4F90": "xu",
	"5D51": "jie;he",
	"607C": "nao",
	"6498": "da",
	"6D44": "jing",
	"739D": "wu",
	"7422": "zhuo;zuo",
	"7811": "ya",
	"82C2": "yin",
	"8D3C": "zei",
	"9D70": "diao",
	"5820": "hou",
	"5F29": "nu",
	"68EC": "quan",
	"7720": "mian",
	"7A1E": "ke",
	"8A95": "dan",
	"9049": "zhen",
	"90BA": "ye",
	"6C9C": "pan",
	"6E48": "mei",
	"8454": "hou",
	"779B": "cong",
	"82C9": "pi",
	"839D": "cuo",
	"9324": "qi",
	"97B9": "kuo;kui",
	"99C6": "qu",
	"9D51": "juan",
	"5A65": "chuo",
	"5F92": "tu",
	"7959": "mei",
	"79DC": "ni",
	"828A": "qian",
	"906E": "zhe",
	"98EF": "fan",
	"591F": "gou",
	"66A8": "ji",
	"7FFF": "dao",
	"90CE": "lang",
	"9845": "qian",
	"510A": "chu",
	"796D": "ji;zhai",
	"81A7": "tong",
	"97B5": "xie",
	"986A": "hui",
	"7A29": "ji",
	"92C4": "wan",
	"4E13": "zhuan",
	"5B58": "cun",
	"62A9": "tan",
	"7843": "zhu",
	"7BF7": "peng",
	"8C04": "chan",
	"5279": "lu",
	"66C8": "tong",
	"6E0E": "du",
	"738D": "ga",
	"753D": "quan",
	"7770": "ma",
	"7DCF": "zong",
	"8736": "su",
	"9A6D": "yu",
	"538C": "yan",
	"6A51": "lao",
	"7243": "zang",
	"72E7": "ta",
	"72FE": "zhi",
	"86C4": "gu",
	"9593": "jian",
	"980B": "gu",
	"983C": "lai",
	"9F40": "wu",
	"5B1B": "huan;qiong;xuan",
	"6F36": "huan",
	"75B5": "ci",
	"7825": "di",
	"7BC0": "jie",
	"870B": "lang",
	"8A4F": "ao",
	"8A5C": "tao",
	"98F8": "tao",
	"9A68": "xi",
	"567E": "yin",
	"5B11": "yi",
	"6685": "geng",
	"67C6": "la",
	"758C": "nie",
	"7A3A": "zhi",
	"8FAB": "bian",
	"9BDE": "zhou",
	"5445": "mei",
	"55D0": "hai",
	"5C94": "cha",
	"5D9B": "liao",
	"696B": "ji",
	"8055": "hao",
	"5861": "tian",
	"698E": "jia",
	"6CAA": "hu",
	"7478": "bin",
	"8F46": "lu",
	"5FAD": "yao",
	"6BA7": "cu",
	"7A93": "chuan",
	"98AD": "zhan",
	"99EF": "none",
	"573D": "mo",
	"62FD": "zhuai;ye",
	"754D": "jie",
	"7CBB": "chang",
	"67A1": "dou",
	"7B58": "kou",
	"7C4E": "none",
	"8580": "yun",
	"5C6C": "shu;zhu",
	"6D5B": "han",
	"7BCF": "qian",
	"8315": "qiong",
	"4FC3": "cu",
	"510E": "zai",
	"5461": "wen",
	"5531": "chang",
	"5C97": "gang",
	"8488": "kai",
	"8D43": "zang",
	"98F5": "zhai",
	"9B4F": "wei",
	"56C5": "chan",
	"6573": "ai",
	"6BEF": "tan",
	"72F4": "bi",
	"7CE9": "kuai",
	"7D7F": "qiu",
	"5218": "liu",
	"6C09": "sao",
	"7CDC": "mi;mei",
	"89B4": "deng",
	"902B": "jue",
	"6775": "chu",
	"82F8": "hu",
	"82FB": "fu",
	"84F5": "jie",
	"9375": "jian",
	"94DE": "diao",
	"9CA0": "geng",
	"522E": "gua",
	"5395": "ce;si",
	"581E": "die",
	"5C7B": "ren",
	"62B5": "di",
	"6BD4": "bi",
	"7771": "xia",
	"7B1D": "na",
	"8D60": "zeng",
	"9712": "ying",
	"98E1": "can",
	"9B57": "chou",
	"5380": "xi",
	"5557": "dan",
	"85A0": "fan",
	"8B8C": "yan",
	"57F0": "cai",
	"700D": "chan",
	"763B": "lou",
	"8C27": "mi",
	"8F89": "hui",
	"9F1A": "chang",
	"54DF": "yo",
	"7053": "luan",
	"9280": "yin",
	"9D50": "wu",
	"5A29": "mian;wan",
	"775C": "zheng",
	"7FBD": "yu",
	"935F": "xing",
	"577C": "che",
	"670B": "peng",
	"70A9": "ling",
	"5975": "ding",
	"6B68": "bu",
	"7C2D": "shi",
	"8CF6": "cang",
	"9570": "lian",
	"964D": "jiang;xiang",
	"6F89": "gan",
	"8CDC": "si;ci",
	"93B3": "nie",
	"9935": "wei",
	"9CF2": "shi",
	"6FBA": "yi",
	"876C": "zong",
	"5DB6": "none",
	"6AB7": "mi;ni",
	"75D4": "zhi",
	"8773": "du",
	"8B1E": "xue",
	"916E": "tong",
	"5B3A": "ni",
	"7C7F": "cun",
	"8513": "man;wan",
	"879A": "nai",
	"8D2F": "guan",
	"5136": "hui",
	"58F2": "mai",
	"5AFC": "mo",
	"61C1": "huan",
	"6CEE": "pan",
	"7644": "qiao",
	"8047": "zheng",
	"83DA": "zhan",
	"997E": "dou",
	"5754": "di",
	"57BD": "yin",
	"626A": "men",
	"7372": "huo",
	"87DD": "qu",
	"9853": "zhuan",
	"4E38": "wan",
	"66C2": "kuang",
	"6A43": "fa",
	"7D17": "sha",
	"8587": "wei",
	"894C": "dan",
	"4F57": "tuo",
	"5A41": "lou;lu",
	"7725": "zi",
	"852E": "kui",
	"87CE": "man",
	"8C7E": "pi",
	"8E0B": "jiao;jue",
	"4E06": "none",
	"61AD": "liao",
	"94E6": "xian",
	"5C2F": "kui",
	"51F4": "ping",
	"5475": "he;ke;a",
	"5E97": "dian",
	"6E73": "nan",
	"768C": "mo",
	"7AF2": "ceng",
	"8371": "wei",
	"93F7": "pu",
	"4F2A": "wei",
	"4FFF": "chi",
	"643E": "zha",
	"7153": "tuan",
	"917F": "niang",
	"95BE": "yu",
	"975F": "fei",
	"52DB": "xun",
	"7AB8": "xi",
	"7682": "zao",
	"76F3": "mang",
	"809A": "du",
	"8B47": "she",
	"90F3": "ni",
	"919F": "yong",
	"9B22": "bin",
	"9C64": "gan",
	"5AD1": "bao",
	"6713": "tiao",
	"7C27": "huang",
	"8BC4": "ping",
	"4E5E": "qi",
	"5862": "wu",
	"5BB2": "bao",
	"65EE": "ga",
	"7450": "jian",
	"7927": "lei",
	"8397": "che",
	"9707": "zhen",
	"5057": "sheng",
	"5C9D": "zhai",
	"6808": "zhan",
	"513B": "tang",
	"6943": "wo",
	"9177": "ku",
	"9761": "mi",
	"9C89": "you",
	"4FDA": "li",
	"54DC": "ji",
	"925D": "li",
	"96F1": "pang",
	"61E0": "qi",
	"7B75": "yan",
	"52E3": "ji",
	"5DF7": "xiang;hang",
	"66C9": "xiao",
	"6B35": "kuan",
	"5D71": "yong",
	"735F": "yao",
	"9396": "suo",
	"73CB": "liu",
	"7742": "mei",
	"8983": "tan;qin",
	"9239": "pi",
	"97A0": "ju",
	"9A7A": "zou",
	"9D66": "lu",
	"52CD": "qing",
	"759B": "zhou",
	"76B2": "jun",
	"7C83": "bi",
	"8581": "yu",
	"9BAE": "xian",
	"9782": "jia",
	"5737": "none",
	"6588": "xue",
	"6A2F": "qiang",
	"76A7": "ai",
	"7C45": "yu",
	"983E": "zi",
	"9931": "hou",
	"4F98": "cha",
	"5D8D": "xi",
	"629E": "ze;zhai",
	"754C": "jie",
	"7B10": "gang",
	"7EBF": "xian",
	"84DD": "lan",
	"9B01": "li",
	"9C0A": "lian",
	"5BD0": "mei",
	"6F0B": "long",
	"809E": "cha",
	"651D": "she",
	"7882": "zong",
	"8964": "lan",
	"94D8": "ye",
	"9952": "rao",
	"5F4A": "qiang;jiang",
	"66FD": "ceng;zeng",
	"67AD": "xiao",
	"6933": "wei",
	"6B6B": "ju",
	"7B6A": "xia",
	"85EC": "tui",
	"87EC": "chan",
	"8EB3": "gong",
	"55D1": "ke",
	"5653": "xu;shi",
	"6D66": "pu",
	"6EF5": "mi",
	"7734": "xuan",
	"888C": "bao",
	"695B": "hu;ku",
	"7B05": "xiao",
	"86B5": "he;ke",
	"92C7": "bei",
	"5BC6": "mi",
	"6738": "li",
	"6B81": "mo",
	"7299": "san",
	"7439": "qin",
	"78B9": "xuan",
	"987B": "xu",
	"5EDA": "chu",
	"6BBD": "yao",
	"9014": "tu",
	"5062": "qiu",
	"5238": "quan;xuan",
	"5A3C": "chang",
	"5F1A": "tui",
	"6479": "mo",
	"73D0": "fa",
	"74E0": "hu",
	"7F7E": "zeng",
	"96B1": "yin",
	"9C34": "hui",
	"883B": "man",
	"8A9D": "an",
	"68D8": "ji",
	"6DD8": "tao",
	"77D9": "kan",
	"5642": "zun",
	"611E": "nuo",
	"6340": "feng",
	"66DF": "chen",
	"6C7A": "jue",
	"7010": "jian",
	"9749": "ai",
	"5397": "ti",
	"6EE6": "luan",
	"74BA": "wen",
	"8875": "ri",
	"5885": "shu",
	"7A7B": "yu",
	"90B6": "bei",
	"9C70": "none",
	"5D8C": "dao",
	"7389": "yu",
	"7661": "chi",
	"7FCE": "ling",
	"9597": "dou",
	"6879": "lang",
	"8C21": "su",
	"8ED3": "fan",
	"53DB": "pan",
	"568A": "pi",
	"59AC": "du",
	"5EE0": "chang",
	"66AE": "mu",
	"674C": "wu",
	"4E42": "yi;ai",
	"7370": "ning",
	"8247": "ting",
	"516A": "yu;shu",
	"5378": "xie",
	"6178": "di",
	"72B6": "zhuang",
	"821D": "xia",
	"84E8": "xiu",
	"87FD": "da",
	"968F": "sui",
	"71BC": "yi",
	"92D1": "cuan",
	"6266": "qian",
	"86B2": "ping",
	"99A0": "han",
	"9E61": "ji",
	"670F": "fei",
	"8E2C": "zhi",
	"5644": "chi",
	"6285": "ju",
	"6D1B": "luo",
	"6DA8": "zhang",
	"592C": "guai",
	"5E11": "tang",
	"7F0D": "duo",
	"8EE9": "dai",
	"9383": "pai",
	"7448": "rou",
	"833B": "mang",
	"8B2E": "ze",
	"9C57": "lin",
	"535A": "bo",
	"82CE": "zhu;ning",
	"8617": "bo;nie",
	"9089": "bian",
	"733F": "yuan",
	"76D1": "jian",
	"797A": "qi",
	"89FA": "yi",
	"8F02": "ju",
	"5593": "yao",
	"6A8A": "gan",
	"8130": "dou",
	"90E9": "xiao",
	"9BEF": "zhi",
	"5290": "huo",
	"7951": "zhi",
	"8452": "hong",
	"8A62": "xun",
	"96FA": "meng",
	"9AA6": "shuang",
	"5C6F": "tun;zhun",
	"5EAD": "ting",
	"8424": "ying",
	"8913": "bao",
	"8DE5": "duo",
	"93C8": "lian",
	"9F09": "tuo",
	"6B73": "sui",
	"78DA": "zhuan",
	"7D20": "su",
	"8A7B": "e",
	"4FA9": "kuai",
	"6019": "hu",
	"685C": "ying",
	"9053": "dao",
	"83F0": "gu",
	"9EED": "yan",
	"550B": "tu",
	"584C": "ta",
	"681C": "su",
	"7549": "fu",
	"9DA1": "he",
	"62A0": "kou",
	"6F88": "che",
	"7021": "sui",
	"780F": "fen",
	"92A9": "diu",
	"9672": "chui",
	"991D": "shi",
	"6645": "xuan",
	"6D69": "hao",
	"7A98": "jiong;jun",
	"83A5": "niu;chou",
	"8507": "ji",
	"8D78": "shan",
	"6268": "cha",
	"710D": "di;ti",
	"7CC9": "zong",
	"80EA": "lu",
	"89A1": "xi",
	"9DDF": "zhuo",
	"619E": "dui",
	"728A": "du",
	"88F6": "fei",
	"9BB8": "mian",
	"5AA7": "wa",
	"728C": "jia",
	"7497": "dang",
	"86AB": "bao",
	"8277": "yan",
	"6A33": "xin",
	"76E5": "guan",
	"7809": "hua;xu",
	"8103": "cui",
	"8864": "yi",
	"7993": "yang",
	"53C7": "dai",
	"62F4": "shuan",
	"660A": "hao",
	"6869": "zhuang",
	"89D3": "jiu",
	"94F1": "yi",
	"501B": "qi",
	"6309": "an",
	"6491": "cheng",
	"6B6C": "qian",
	"773F": "mai",
	"90F0": "zou",
	"9F02": "chao",
	"9732": "lu;lou",
	"67B0": "ping",
	"6A61": "xiang",
	"721D": "jue;jiao",
	"775A": "ya;ai",
	"881F": "la;zha",
	"91C4": "mi",
	"5837": "an",
	"6099": "heng",
	"6241": "bian;pian",
	"6E81": "ying",
	"9A30": "teng",
	"4E58": "cheng;sheng",
	"4F85": "gai;kai",
	"51C2": "mei",
	"87A7": "none",
	"56F9": "ling",
	"7028": "lai",
	"7412": "none",
	"8866": "gan",
	"9546": "mo",
	"58D1": "he;huo",
	"5A60": "wan",
	"63AD": "tian",
	"6C1C": "ri",
	"77E0": "ce",
	"82CA": "e",
	"766A": "ji",
	"7E50": "hui",
	"99C7": "wen",
	"9D92": "chi",
	"5443": "e",
	"603F": "yi",
	"6DF6": "lai",
	"7297": "jie",
	"76F4": "zhi",
	"7B6C": "cheng",
	"8444": "zuo",
	"5A48": "ling",
	"5613": "guo",
	"61CA": "ao",
	"69F4": "hu",
	"7DDC": "mian",
	"7E1F": "ru",
	"8434": "ze",
	"51C3": "shang",
	"5392": "ke",
	"65DB": "fan",
	"689F": "xiao",
	"6CCD": "ben",
	"7FA7": "suo",
	"857B": "hong",
	"93DE": "yong",
	"95B8": "kun",
	"884F": "yuan",
	"5211": "xing",
	"62BB": "chen;shen",
	"6572": "qiao",
	"6811": "shu",
	"7813": "zhe",
	"7985": "shan;chan",
	"915F": "tian",
	"92AE": "luan",
	"9B96": "none",
	"69B1": "cui",
	"8B9D": "zhan",
	"539C": "zui",
	"55CB": "xie",
	"6462": "hu",
	"6DD4": "chi",
	"943C": "fen",
	"9E4A": "que",
	"6BED": "dou",
	"781C": "feng",
	"84EB": "zhu",
	"88E4": "ku",
	"8BC3": "he",
	"8D8D": "chi",
	"99D1": "nu",
	"9B11": "lian",
	"5402": "mang",
	"58C0": "pi",
	"784D": "ken",
	"7ED8": "hui",
	"90EE": "none",
	"654F": "min",
	"81C0": "tun",
	"8E49": "cuo",
	"9103": "yu",
	"9227": "kang",
	"9925": "fei",
	"698C": "none",
	"6D08": "wei",
	"7ECA": "ban",
	"9BB3": "kao",
	"9E18": "shuang",
	"9E22": "yuan",
	"5337": "qu",
	"5C76": "none",
	"64FB": "sou",
	"5609": "jia",
	"59DB": "tong",
	"6B85": "sheng",
	"6D7D": "sui",
	"8C89": "he;hao;mo",
	"8D9D": "jian",
	"8EE2": "zhuan;zhuai",
	"9886": "ling",
	"9D2B": "none",
	"85B7": "ru",
	"8C50": "feng",
	"8E9F": "rang",
	"520B": "qian",
	"6B42": "chuan",
	"94FE": "lian",
	"52AD": "shao",
	"5595": "mian",
	"58A4": "kuai",
	"763C": "mo",
	"7ABA": "kui",
	"8010": "nai",
	"8108": "mo;mai",
	"9BBA": "za",
	"5B13": "chan",
	"6A07": "xiu",
	"7D35": "zhu",
	"8B1C": "yuan",
	"8BBC": "song",
	"9001": "song",
	"5652": "lian",
	"5AD4": "pin",
	"5F86": "xi",
	"67C1": "tuo;duo",
	"6B2F": "xi",
	"7F86": "pi;biao",
	"829A": "tun",
	"8967": "zhi",
	"98C0": "liu",
	"9E50": "qian",
	"5A26": "pin",
	"7388": "lu",
	"8012": "lei",
	"87AA": "shang",
	"880B": "zhu",
	"9DA4": "yun",
	"5384": "e",
	"57CD": "xuan",
	"6203": "tang",
	"79CB": "qiu",
	"8D2E": "zhu",
	"9C69": "none",
	"9F27": "tuo",
	"53B0": "chang",
	"5E4F": "jia",
	"7DD5": "none",
	"8DEC": "kui",
	"9428": "fei",
	"9AED": "zi",
	"9C21": "liu",
	"6E03": "re",
	"7A9C": "cuan",
	"7E87": "lei",
	"8258": "sou;sao",
	"5B91": "jing",
	"646F": "zhi",
	"6DD0": "chang",
	"6EAE": "shi",
	"7EBE": "shu",
	"8443": "zuo",
	"85AE": "sou",
	"88A0": "zhi",
	"990F": "yi",
	"6214": "jian",
	"6701": "can",
	"691E": "xi",
	"785C": "keng",
	"7C84": "ban",
	"87DA": "peng",
	"92DF": "qin",
	"9A84": "jiao",
	"8548": "xun;jun",
	"73AB": "mei",
	"7F91": "you",
	"862A": "mi",
	"8802": "she",
	"9BBD": "yu",
	"507F": "chang",
	"5951": "qi;xie;qie",
	"60B0": "cong",
	"6413": "cuo",
	"7BD6": "tang",
	"8263": "lu",
	"847C": "zong",
	"9798": "qiao;shao",
	"4E16": "shi",
	"524C": "la",
	"887C": "zhi",
	"90C5": "zhi",
	"98FD": "bao",
	"9D12": "ling",
	"57CC": "lang",
	"62A5": "bao",
	"8586": "ai",
	"875D": "yuan",
	"880A": "lian",
	"9323": "zhuo",
	"956A": "qiang",
	"5747": "jun;yun",
	"722E": "pao",
	"8052": "guo;gua",
	"8FB3": "nong",
	"8FEF": "tao",
	"9AF9": "xiu",
	"9F76": "e",
	"5880": "chi",
	"59B9": "mei",
	"6AC1": "mi",
	"607D": "yun",
	"7062": "nang",
	"7AE2": "si;qi",
	"8460": "shen",
	"8C7D": "na",
	"9B87": "wei",
	"9DB1": "xuan",
	"9F23": "fei",
	"55BC": "jie",
	"66F0": "yue",
	"6A8B": "ju",
	"7462": "rong",
	"63E3": "chuai",
	"6925": "zhi",
	"8DB0": "none",
	"9478": "lei",
	"9E13": "lei",
	"9E15": "lu",
	"52B4": "lao",
	"5B8D": "rou",
	"5E48": "ping",
	"62CF": "na",
	"778E": "xia",
	"9514": "ju",
	"9B50": "jian",
	"9BB6": "jun",
	"65D6": "yi",
	"6B76": "yu",
	"6F5A": "xiao;su",
	"7846": "e",
	"8646": "lei",
	"8DCD": "ku",
	"6230": "zhan",
	"6D55": "jin",
	"6CD5": "fa",
	"6F18": "chun",
	"7E51": "qiao",
	"573F": "jia",
	"6152": "cong",
	"6FE9": "huo",
	"76AB": "piao",
	"80AF": "ken",
	"78C8": "wei",
	"88F3": "shang;chang",
	"512C": "qin",
	"672D": "zha",
	"7DD4": "shang",
	"5333": "lian",
	"72BE": "han",
	"83B1": "lai",
	"92D5": "zhi",
	"93AA": "sou",
	"57DE": "di",
	"7683": "mao",
	"8D3E": "jia;gu",
	"5D17": "gang",
	"65E2": "ji",
	"6EFD": "yong",
	"7D99": "ji",
	"7F0F": "bian;pian",
	"8FB2": "nong",
	"9A1D": "jian",
	"5031": "hun",
	"6598": "sheng",
	"68F7": "zou",
	"7B59": "lai",
	"8DB9": "jue",
	"9AEC": "pi",
	"6E66": "sheng",
	"747B": "kun",
	"8179": "fu",
	"9A1C": "huang",
	"8B7C": "jian",
	"8C72": "huan",
	"9401": "san",
	"9532": "qie",
	"5482": "za",
	"6577": "fu",
	"7AF5": "huai",
	"807D": "ting",
	"8D15": "du",
	"9F15": "dong",
	"531E": "jiang",
	"6D4C": "none",
	"762D": "biao",
	"79BE": "he",
	"7B54": "da",
	"8689": "wen",
	"6232": "xi;hu",
	"6BC2": "gu",
	"734D": "jing",
	"8A98": "you",
	"8BB4": "ou",
	"919B": "quan",
	"9380": "xiu",
	"9A92": "ke",
	"69D8": "yang",
	"9A96": "can",
	"9F65": "xie",
	"9F82": "yin",
	"6211": "wo",
	"6235": "qu",
	"692F": "duo",
	"6B7D": "zhe",
	"756D": "yu",
	"79B9": "yu",
	"89C7": "chan",
	"951E": "ke",
	"5B71": "chan;can",
	"6011": "ban",
	"765C": "dian",
	"77A4": "run",
	"7A03": "fu",
	"909C": "none",
	"93D8": "qiang",
	"5370": "yin",
	"5DB3": "di",
	"6BFF": "san",
	"70A1": "zheng",
	"8C0C": "chen",
	"50BA": "chi",
	"6580": "zhuo",
	"900E": "qiu",
	"51B1": "hu",
	"6024": "fu",
	"8DD0": "ci",
	"9DE1": "wu",
	"5148": "xian",
	"61E2": "lan",
	"6578": "shu;shuo",
	"6BA1": "bin",
	"7BAC": "ruo",
	"8B04": "teng",
	"9290": "chi",
	"9528": "xian",
	"9799": "xuan",
	"9E28": "bao",
	"508E": "dian",
	"6354": "jue",
	"6B79": "dai",
	"6DEF": "yu",
	"84E2": "lang",
	"981B": "lei",
	"5351": "bei",
	"5D06": "kong",
	"5D8E": "yu",
	"6AC3": "gui;ju",
	"6F8A": "cun",
	"7646": "lao",
	"89AD": "ming",
	"6E9D": "gou",
	"6F80": "se",
	"77AB": "shen",
	"9D10": "jia",
	"5FF8": "niu;nu",
	"6D87": "jing",
	"7234": "jue",
	"9121": "qiao",
	"926B": "jia",
	"9626": "yang",
	"988B": "ting",
	"5756": "ji",
	"801F": "ju",
	"88CB": "shu",
	"8D2C": "bian",
	"8D38": "mao",
	"93E6": "cong",
	"9C88": "lu",
	"6349": "zhuo",
	"7A17": "bai;bi",
	"8FA9": "bian",
	"9D99": "ti",
	"5156": "yan",
	"603D": "none",
	"6221": "kan",
	"758F": "shu",
	"79C7": "yi",
	"95EE": "wen",
	"63F5": "qian",
	"7001": "yang",
	"751B": "tian",
	"5139": "zan;zuan",
	"52CE": "lu",
	"5CFF": "wu;yu",
	"5D13": "gu",
	"6585": "xue",
	"8D3A": "he",
	"9E72": "meng",
	"4F95": "er",
	"59D3": "xing",
	"5C31": "jiu",
	"651B": "cuan",
	"6E1C": "nuan",
	"7C75": "fan",
	"984C": "ti",
	"5408": "he;ge",
	"581F": "zhuan",
	"61A1": "ce",
	"6DFD": "zhi",
	"8142": "guo",
	"8853": "shu;zhu",
	"891F": "ta",
	"919E": "yun",
	"9210": "qian",
	"9973": "duo",
	"6048": "mou;mu",
	"6D13": "zi",
	"9E06": "yu",
	"6CF0": "tai",
	"7135": "gang",
	"7EDE": "jiao",
	"9C18": "none",
	"5CDD": "tong",
	"66FA": "cao",
	"7083": "fen",
	"71AE": "liao",
	"813A": "cui",
	"9EFC": "fu",
	"53F9": "tan",
	"62A6": "bing",
	"7E4D": "xiu",
	"50A7": "bin",
	"524D": "qian",
	"5787": "ao",
	"640F": "bo",
	"6730": "none",
	"7B7B": "gang",
	"5A61": "lai",
	"657C": "xi",
	"66C7": "tan",
	"7A40": "gu",
	"9709": "mei",
	"5F19": "wu",
	"7D6C": "xie",
	"8F3E": "zhan",
	"90B0": "tai",
	"4F58": "she",
	"5D2C": "dong",
	"8D99": "zhao",
	"8EFB": "ke",
	"665E": "xi",
	"6BEB": "hao",
	"6E8B": "none",
	"7D51": "zhu",
	"8456": "tu",
	"8C9C": "qu",
	"99A2": "jian",
	"502C": "zhuo",
	"5CE1": "xia",
	"5D75": "none",
	"8AE2": "hun",
	"8D8F": "gua",
	"8D0A": "zan",
	"7F37": "xie",
	"6BA8": "hui",
	"73DB": "xiu",
	"772A": "bing",
	"8BEC": "wu",
	"8C8F": "bi",
	"61D5": "yan",
	"639F": "ding",
	"7A18": "ji;qi",
	"7602": "ya",
	"7772": "xing",
	"7B73": "ting",
	"7E26": "zong",
	"9222": "nie",
	"96BF": "yi",
	"59FC": "chi",
	"6FEC": "jun",
	"7539": "ping",
	"89B0": "qu",
	"5048": "jie",
	"6253": "da",
	"6311": "tiao",
	"64D3": "kuai",
	"69E3": "qi",
	"8AB8": "xuan",
	"900A": "xun",
	"676A": "miao",
	"83E5": "xi",
	"4FBD": "nan",
	"52CA": "ke",
	"5838": "feng",
	"76F9": "dun",
	"7C2B": "xiao",
	"7E4B": "xi;ji",
	"840C": "meng",
	"8DCF": "jia",
	"5BE6": "shi",
	"6050": "kong",
	"7E21": "zai",
	"9020": "zao",
	"91B4": "li",
	"544F": "sheng",
	"8FE9": "er",
	"928A": "xu",
	"86E3": "ji",
	"8AD2": "liang",
	"9BE2": "ni",
	"9C86": "ping",
	"52E2": "shi",
	"5EF6": "yan",
	"6990": "zhan",
	"8F3D": "ben",
	"95FB": "wen",
	"6159": "can",
	"6338": "jian",
	"8877": "zhong",
	"92A0": "lao",
	"93D4": "yin",
	"9D7E": "kun",
	"6A4E": "fan",
	"8908": "chong",
	"8F36": "you",
	"9ECD": "shu",
	"5316": "hua",
	"67CE": "fu",
	"6C54": "qi",
	"8111": "nao",
	"926A": "di",
	"9D37": "lie",
	"9E79": "xian",
	"53CE": "shou",
	"6055": "shu",
	"4FDD": "bao",
	"5E4D": "dao;tao",
	"5CA0": "ju",
	"61D1": "men",
	"6242": "dian",
	"9843": "yan",
	"9C58": "xun",
	"9D4B": "ji",
	"686F": "ting",
	"773E": "zhong",
	"86A3": "gong",
	"5177": "ju",
	"691C": "jian",
	"7A89": "bing",
	"8290": "xia",
	"83A3": "wang",
	"88AD": "xi",
	"9E53": "yuan",
	"9E71": "hu",
	"694D": "ben",
	"9ADD": "lao",
	"686D": "zhen",
	"74AE": "tan",
	"7C74": "di",
	"94BE": "jia",
	"9639": "qu",
	"9CB7": "diao",
	"5374": "que",
	"55EF": "ng",
	"6893": "zi",
	"6C75": "gan",
	"71C9": "dun",
	"9D90": "shu",
	"5900": "shou",
	"6CD7": "si",
	"7E2F": "yin",
	"94A8": "wu",
	"561B": "ma",
	"5EDF": "miao",
	"632F": "zhen",
	"6B2E": "jue",
	"6D00": "zhou",
	"6EF0": "jiang",
	"7246": "qiang",
	"776D": "zhou",
	"7D6A": "yin",
	"8CA0": "fu",
	"574A": "fang",
	"5EE8": "xie",
	"6B53": "huan",
	"66E7": "rong",
	"6EB0": "yi",
	"7807": "min",
	"84B1": "pu",
	"5260": "qing",
	"54C0": "ai",
	"804D": "ning",
	"9076": "rao",
	"91A0": "ang",
	"67D3": "ran",
	"7147": "hui",
	"782D": "bian",
	"78A2": "tuo",
	"8D20": "yuan;yun",
	"98A2": "hao",
	"9B2F": "chang",
	"56B3": "ku",
	"7343": "dai",
	"8003": "kao",
	"644B": "sha",
	"66F7": "he",
	"998E": "bo",
	"73CA": "shan",
	"75EC": "yi",
	"7A76": "jiu",
	"8034": "zhe",
	"9B92": "fu",
	"5149": "guang",
	"684A": "juan",
	"7449": "min",
	"990E": "le",
	"4F77": "heng",
	"675C": "du",
	"7CA0": "hong",
	"8C9F": "yuan;yun",
	"9E69": "liao",
	"5E84": "zhuang",
	"6206": "gang;zhuang",
	"83CD": "nie",
	"784E": "xing",
	"8237": "xian",
	"8ED5": "shan",
	"9E84": "cu",
	"5990": "zhong",
	"8389": "li",
	"87DC": "jiao",
	"5A91": "zhong",
	"5CC3": "xue",
	"76EE": "mu",
	"780C": "qi;qie",
	"78E7": "qi",
	"822D": "bi",
	"8ABC": "yi",
	"9549": "ge",
	"9899": "yong",
	"5085": "fu",
	"6365": "wan",
	"5583": "nan",
	"5AD2": "ai",
	"6376": "chui",
	"6E58": "xiang",
	"9A71": "qu",
	"6B1E": "ling",
	"902C": "beng",
	"4E97": "sui",
	"546F": "ping",
	"6D49": "shi",
	"7216": "long",
	"85B8": "piao",
	"885A": "hu",
	"4E74": "xi",
	"5FE2": "wu",
	"762F": "cu",
	"8281": "jiao",
	"8817": "zhuo",
	"50FB": "pi",
	"5F10": "er",
	"6AC0": "qi",
	"7191": "lian",
	"4EC5": "jin",
	"54D7": "hua;ye",
	"57BC": "yi",
	"6F33": "zhang",
	"80D9": "zuo",
	"8178": "chang",
	"828C": "yu",
	"8524": "mi",
	"8F67": "ya;zha;ga",
	"5FD2": "te;tui;tei",
	"67A6": "lu",
	"83EB": "jin",
	"9312": "a;e",
	"63DC": "yan",
	"650A": "lue",
	"6672": "yi",
	"6964": "song",
	"506D": "mian",
	"5B23": "ning",
	"85A3": "gu",
	"8923": "rong",
	"998D": "mo",
	"5DC6": "ying",
	"7217": "yan",
	"7454": "quan",
	"7B24": "tiao",
	"8275": "ping",
	"9D6F": "bei",
	"5AB6": "rong",
	"783D": "none",
	"7A7C": "sen",
	"9A8C": "yan",
	"5C8F": "wan",
	"691D": "gui",
	"8A9A": "qiao",
	"9E3B": "heng",
	"9F49": "nang",
	"6AE6": "none",
	"923D": "bu",
	"93F5": "hua",
	"5B09": "xi",
	"606F": "xi",
	"806C": "weng",
	"87F1": "wu",
	"88B8": "cun",
	"89F6": "zhi",
	"5F35": "zhang",
	"6009": "bao",
	"776E": "yu",
	"51ED": "ping",
	"6EEC": "hu",
	"8F99": "zhe",
	"78F1": "lao",
	"81D3": "zang",
	"94D6": "cheng",
	"9EEB": "yin",
	"52D5": "dong",
	"7F18": "yuan",
	"8991": "pian",
	"8D0E": "wan",
	"8EA2": "ta",
	"93DB": "chang",
	"5874": "beng",
	"58E8": "lei",
	"6077": "none",
	"6D60": "xi",
	"81AE": "xiao",
	"9ACB": "kuan",
	"5810": "ya",
	"6202": "mi",
	"6632": "fei;fu",
	"7420": "dian",
	"7861": "hong",
	"838C": "duo",
	"9BCB": "sha",
	"6709": "you",
	"6A39": "shu",
	"8D57": "feng",
	"5003": "zan",
	"65BE": "pei",
	"6691": "shu",
	"6824": "bing",
	"87D4": "mo",
	"9C96": "tong",
	"9DC9": "ti",
	"6895": "ren",
	"75D2": "yang",
	"7CA2": "zi;ci",
	"7FE4": "chi",
	"6397": "ya",
	"6CDE": "ning",
	"8B78": "zhou",
	"8E61": "qiang",
	"8EBD": "yan",
	"632C": "bo",
	"87FA": "shan",
	"5150": "er",
	"541A": "yi",
	"801E": "jia",
	"80A2": "zhi",
	"8725": "xi",
	"8F6A": "dai",
	"9298": "ming",
	"52CC": "juan",
	"631F": "xie;jia",
	"6ACC": "you",
	"6DB8": "he;hao",
	"7374": "meng",
	"7535": "dian",
	"7BB6": "hu",
	"7E63": "hua",
	"94B1": "qian",
	"966D": "yi",
	"9A94": "zong",
	"57DB": "jiong",
	"65D9": "fan",
	"6B87": "shang",
	"6E9E": "sao",
	"6EDE": "zhi",
	"71B7": "zeng",
	"7795": "zhang",
	"84DB": "ce",
	"8593": "shen;can;cen",
	"8935": "li",
	"8AE8": "fu",
	"959B": "peng",
	"655B": "lian",
	"7631": "yi",
	"83D7": "chou",
	"8AD7": "shen",
	"8FA8": "bian",
	"57D3": "lie",
	"57D9": "xun",
	"70D7": "kai",
	"7D3D": "tuo",
	"7FF9": "qiao",
	"8658": "cuo",
	"8C60": "cu",
	"932F": "cuo",
	"937F": "zi",
	"58C8": "lan",
	"5B46": "ying",
	"7B21": "qie",
	"80DD": "zhi",
	"8F42": "gu",
	"5038": "cai",
	"5232": "kui",
	"53DC": "sou",
	"56F7": "jun",
	"7441": "mao;mei",
	"7857": "qiao",
	"8EB6": "luo",
	"91AF": "xi",
	"9F8F": "gong",
	"4E78": "na",
	"4F72": "ming",
	"88CC": "jia",
	"8C48": "qi;kai",
	"5C69": "jue",
	"5DAE": "xian",
	"672F": "shu;zhu",
	"7A5D": "none",
	"7D8B": "hong",
	"825E": "yao",
	"82A9": "qin",
	"8472": "quan",
	"94B2": "zheng",
	"54C8": "ha;ka",
	"5794": "yin",
	"627B": "zi",
	"744D": "huan",
	"8CDB": "zan",
	"4FDC": "ping",
	"5670": "yong",
	"6CF2": "ji",
	"7AC4": "cuan",
	"88FF": "qi",
	"550E": "li",
	"5780": "hu",
	"6A72": "none",
	"7C6E": "luo",
	"839B": "ting",
	"8648": "xiao",
	"865C": "lu",
	"9254": "za",
	"6F6B": "wan",
	"802C": "lou",
	"940F": "zun",
	"4E61": "xiang",
	"6B71": "zhong",
	"7DE5": "bao",
	"82F4": "ju",
	"8771": "meng",
	"5128": "zhi",
	"5696": "hui",
	"62A2": "qiang",
	"677D": "chou",
	"693B": "yan",
	"719D": "lu",
	"729B": "li",
	"7920": "zi",
	"8504": "man",
	"939F": "sang",
	"4F5D": "gou",
	"664C": "shang",
	"99D5": "jia",
	"4EB9": "wei",
	"5B5E": "xin",
	"7B92": "zhou",
	"88FC": "ti;xi",
	"9B99": "ta",
	"5140": "wu",
	"523D": "gui",
	"5C7E": "shen",
	"8830": "rang",
	"9A16": "wu",
	"558D": "chai",
	"5B28": "ci",
	"624E": "zha;za",
	"66EE": "yan",
	"7BFC": "dou",
	"7D96": "yan",
	"85C7": "xu",
	"9794": "man;wan",
	"4EDE": "ren",
	"574E": "kan",
	"5D34": "wei;wai",
	"604D": "huang",
	"826A": "lu",
	"8DC4": "qiang",
	"4F39": "qu",
	"5A4E": "hui",
	"5BCD": "ning",
	"6139": "yong",
	"65BB": "hang",
	"67BE": "shi",
	"71FC": "jin",
	"9C17": "hu",
	"9D6A": "an",
	"9EEE": "tan",
	"4FD5": "san",
	"5122": "lu",
	"5BAC": "cheng",
	"5CEB": "ye",
	"6488": "lao",
	"5E17": "fu",
	"6E4C": "can",
	"82C3": "you",
	"84CC": "cuo",
	"8B05": "zou;zhou",
	"8D9E": "que",
	"996A": "ren",
	"99E2": "pian",
	"7CEC": "shu",
	"8214": "tian",
	"8B8B": "zhe",
	"9F31": "jing",
	"4E99": "gen;geng",
	"4EF2": "zhong",
	"67DD": "tuo",
	"6A1F": "zhang",
	"8C45": "long",
	"9D09": "ya",
	"9F03": "wa",
	"9F7F": "chi",
	"669C": "pu",
	"7B53": "ji",
	"7E4A": "xian",
	"7E90": "none",
	"7F95": "yang",
	"842F": "fu",
	"8CAA": "tan",
	"8E26": "qi",
	"9569": "cuan",
	"96A2": "rao",
	"50C5": "jin",
	"7356": "ben",
	"8B5A": "tan",
	"8C09": "shen",
	"6BB7": "yin;yan",
	"7E66": "qiang",
	"8F6C": "zhuan;zhuai",
	"9300": "lun",
	"74C5": "li",
	"75FE": "e",
	"87E0": "pan",
	"9954": "yong",
	"5266": "yan",
	"5749": "dun",
	"5976": "nai",
	"5CD6": "an",
	"7FC7": "fu;pei",
	"8501": "zhang",
	"595D": "diao",
	"5CC4": "yi",
	"8137": "li",
	"9413": "dui;dun",
	"9BED": "meng",
	"9EE3": "mei",
	"9F7A": "zou",
	"573B": "qi;yin",
	"630B": "zhen",
	"78FF": "li",
	"7B50": "kuang",
	"89C4": "gui",
	"5089": "ru",
	"5677": "xin",
	"7C5C": "tuo",
	"7DAD": "wei",
	"7E55": "shan",
	"835E": "qiao",
	"865D": "hu",
	"95DD": "piao",
	"6A25": "peng",
	"70D9": "luo;lao",
	"7D69": "tiao",
	"552B": "yin",
	"5FE8": "wan",
	"772F": "mi",
	"7CCF": "xie",
	"9AA2": "cong",
	"7D49": "shu",
	"7E3E": "ji",
	"87F0": "xiao",
	"8A4A": "pan",
	"9A65": "ji",
	"5936": "bi",
	"712D": "qiong",
	"9E32": "qu",
	"5C6B": "jue",
	"805E": "wen",
	"6B56": "xi",
	"78E5": "lei",
	"79A8": "ji",
	"7FFC": "yi",
	"81E0": "luan",
	"8FD0": "yun",
	"9BEE": "zong",
	"4F44": "han",
	"68F8": "zou",
	"7041": "yuan",
	"709B": "xin",
	"856C": "si",
	"88A5": "none",
	"56D6": "none",
	"7315": "mi",
	"9DB4": "he;hao",
	"53C8": "you",
	"81B1": "zhi",
	"85B2": "pin",
	"8610": "xuan",
	"9862": "man",
	"4EAA": "none",
	"5E55": "mu",
	"726E": "jian",
	"936C": "qiao",
	"50C9": "qian",
	"5993": "ji",
	"8DB5": "bao;bo",
	"9097": "han",
	"9B6E": "pi",
	"7459": "nao",
	"7485": "suo",
	"89A6": "yu",
	"8C84": "si",
	"4FB9": "ting",
	"5AF9": "mao",
	"7561": "gai",
	"7862": "yu",
	"86C5": "ran",
	"4F4A": "bi",
	"6E06": "yuan",
	"79AA": "chan;shan",
	"8751": "xu",
	"8839": "du",
	"99DB": "shi",
	"5F1E": "shen",
	"6FB1": "dian",
	"9656": "jun",
	"9E2A": "gu",
	"4E56": "guai",
	"59C5": "ban",
	"71F1": "yi",
	"5245": "lou",
	"6514": "lan",
	"6BFA": "yu",
	"7395": "gan",
	"7921": "bo",
	"7C56": "qian",
	"5E34": "sha",
	"6BAC": "du",
	"76C9": "he",
	"7D3E": "zhen",
	"8A1B": "e",
	"690A": "zuo",
	"6E5A": "yin",
	"92DD": "lue",
	"9415": "zan",
	"941F": "ti",
	"9CF7": "zhi",
	"7050": "none",
	"7182": "xi",
	"7379": "lu",
	"9858": "yuan",
	"50CF": "xiang",
	"750D": "meng",
	"7803": "dan",
	"82FD": "gu",
	"9378": "hu",
	"528D": "jian",
	"5AA8": "jiu",
	"5CE6": "luan",
	"689E": "ji",
	"7FB0": "tang",
	"8ACA": "ju",
	"9B1D": "qian",
	"5BC8": "qing",
	"715A": "jiong",
	"751F": "sheng",
	"7AD9": "zhan",
	"7F4A": "qing",
	"8A08": "ji",
	"9D80": "qi",
	"5BC7": "kou",
	"7AEA": "shu",
	"8045": "che",
	"8727": "li",
	"8E5B": "dai",
	"923E": "you",
	"6073": "ken",
	"65FD": "tun",
	"733D": "ming",
	"7E14": "shuang",
	"59B4": "yuan",
	"6336": "ju",
	"6F70": "kui;hui",
	"9407": "fan",
	"9ABE": "geng",
	"533A": "qu;ou",
	"5D7A": "liao",
	"6445": "shu",
	"6C82": "yi",
	"7930": "li",
	"91CE": "ye",
	"558A": "han",
	"610F": "yi",
	"6CC6": "yi",
	"7A8F": "wu",
	"5C99": "ao",
	"6842": "gui",
	"8BCF": "zhao",
	"995A": "hai",
	"6EA1": "shi",
	"8276": "yan",
	"4E01": "ding;zheng",
	"56BD": "chuo",
	"647D": "biao",
	"6E2D": "wei",
	"81B8": "sui",
	"878D": "rong",
	"89DA": "gu",
	"71BA": "xi",
	"72A7": "xi",
	"8211": "tan",
	"86BC": "gou",
	"8B76": "ta",
	"8B85": "shen",
	"8E79": "ta",
	"5538": "nian",
	"7CBE": "jing",
	"819E": "zhuan",
	"82AF": "xin",
	"8F18": "ling",
	"95BF": "wen",
	"5640": "xun",
	"5B98": "guan",
	"6A38": "pu;po",
	"7F41": "gang",
	"9543": "zi",
	"5366": "gua",
	"5AF4": "gu",
	"5DF9": "jin",
	"605B": "hui",
	"7583": "tuan",
	"92DB": "gong",
	"5D7C": "chan",
	"60E1": "e;wu",
	"884B": "shi",
	"88BE": "zhu",
	"9D07": "bao",
	"5A87": "qin",
	"6129": "gong",
	"7AD4": "gong;sheng",
	"7D0C": "qiu",
	"7F2C": "xie",
	"7F32": "qiao;sao;zao",
	"9DF2": "jiu",
	"4F08": "xin",
	"4FB0": "jiong",
	"5321": "kuang",
	"5464": "ling",
	"5F34": "diao",
	"6541": "dian",
	"6A90": "yan;yin",
	"84C9": "rong",
	"8FC5": "xun",
	"9107": "hou",
	"95F4": "jian",
	"9632": "fang",
	"53A1": "yuan",
	"56F5": "lun",
	"7E58": "yu",
	"8C24": "bang",
	"53B7": "si",
	"5A95": "an",
	"692D": "tuo",
	"7A3B": "dao",
	"81E2": "za",
	"86C3": "bing",
	"9258": "fu",
	"9561": "chan;xin;tan",
	"517E": "ji",
	"54B6": "huai",
	"55E8": "hai;hei",
	"5B99": "zhou",
	"7B22": "min",
	"9F8C": "wo",
	"4ECE": "cong",
	"6A54": "tui",
	"8996": "shi",
	"9EB2": "xian",
	"64C7": "ze;zhai",
	"6B89": "xun",
	"6CB7": "fu",
	"6CE1": "pao",
	"7397": "yu",
	"7552": "mu",
	"81E9": "guang",
	"964C": "mo",
	"9A12": "sao",
	"9BD7": "xiang",
	"9F51": "ji",
	"51FB": "ji",
	"54AC": "yao",
	"63A4": "bing",
	"657A": "qu",
	"6DDF": "tian",
	"74DB": "huan",
	"763A": "lou",
	"77B8": "ye",
	"7F88": "ji",
	"9ACF": "lou",
	"6026": "peng",
	"6721": "zong",
	"8084": "yi",
	"8361": "dang",
	"8651": "lu",
	"9823": "shen",
	"5090": "hao",
	"5E4C": "huang",
	"5E89": "dun",
	"7403": "qiu",
	"74E8": "jiang;hong",
	"9129": "xin",
	"4EFC": "wang",
	"9507": "e",
	"4F1C": "cui;zu",
	"59A8": "fang",
	"6049": "zhi",
	"61E8": "yan",
	"622A": "jie",
	"7DBD": "chuo",
	"8039": "qin",
	"966C": "zou",
	"684C": "zhuo",
	"6891": "di",
	"791F": "pao",
	"7A46": "mu",
	"8C0B": "mou",
	"8E67": "zao",
	"8F22": "yi",
	"9322": "qian",
	"9BF4": "shi",
	"6A23": "yang",
	"6FB8": "dan",
	"838D": "qiu",
	"8B99": "huan",
	"8BFA": "nuo",
	"4FEE": "xiu",
	"6F20": "mo",
	"7285": "gang",
	"7335": "bian",
	"77D8": "tang",
	"794E": "yi",
	"9278": "jiao",
	"4F3D": "jia;ga;qie;qia",
	"6A5D": "tan",
	"8291": "qi",
	"9683": "yu",
	"537C": "wu",
	"54E0": "hao",
	"5895": "yan",
	"6C32": "yun",
	"75D6": "ya",
	"7DC1": "jie",
	"94ED": "ming",
	"7619": "sao",
	"9291": "xian",
	"598E": "xie",
	"5E86": "qing",
	"6942": "zha;cha",
	"82D1": "yuan",
	"62E8": "bo",
	"6E6C": "jiao",
	"5ADA": "man",
	"6BFB": "tuo",
	"6CE6": "ju",
	"7C6C": "li",
	"7E6D": "jian",
	"8FE2": "tiao",
	"927E": "mou",
	"9573": "biao",
	"9613": "hui",
	"9A18": "cong",
	"9DE9": "bi",
	"5170": "lan",
	"5D0C": "ju",
	"74AC": "jiao",
	"7C42": "none",
	"992F": "hui",
	"9CFB": "fen",
	"51A1": "meng",
	"8642": "lu",
	"948C": "liao",
	"4F47": "zhu",
	"510D": "sha",
	"5FED": "bian",
	"7708": "dan",
	"7BA6": "ze",
	"7F6D": "yu",
	"8466": "wei",
	"8981": "yao",
	"956E": "huan",
	"6640": "tiao",
	"817A": "xian",
	"8A30": "zhun",
	"6E9B": "wa",
	"7A83": "qie",
	"5CBE": "none",
	"7A7A": "kong",
	"9361": "wei",
	"9961": "zuan;zan",
	"999B": "ba",
	"5738": "none",
	"5AC2": "sao",
	"771C": "mo",
	"77AF": "xian",
	"9040": "sui",
	"6567": "qi",
	"6601": "bei",
	"79A5": "qi",
	"6A7B": "none",
	"6B45": "yin",
	"6D89": "she",
	"86A4": "zao",
	"89B1": "zhan",
	"8EDA": "dai",
	"8D12": "xian",
	"8C08": "tan",
	"9BC9": "li",
	"6398": "jue",
	"7815": "sui",
	"7A35": "zi",
	"9164": "gu",
	"9B30": "yu",
	"9CAB": "ji",
	"5841": "lei",
	"5E56": "biao",
	"63E4": "ji;jie",
	"6B09": "cong",
	"6C61": "wu",
	"7405": "lang",
	"4EB3": "bo",
	"563B": "xi",
	"7526": "su",
	"8005": "zhe",
	"5208": "yi",
	"90E5": "bei",
	"66D9": "shu",
	"74CD": "sui",
	"7C0F": "lu",
	"84EF": "cong",
	"6164": "que",
	"908E": "you",
	"90D1": "zheng",
	"93CB": "man",
	"9CA2": "lian",
	"5BA1": "shen",
	"60AF": "min",
	"6B1C": "nang",
	"745F": "se",
	"5D2D": "zhan",
	"72E8": "rong",
	"7457": "yuan",
	"79E2": "ling",
	"8235": "duo;tuo",
	"889A": "bo;fu",
	"8AA6": "song",
	"60BA": "guan",
	"7281": "li",
	"73C2": "ke",
	"759A": "jiu",
	"75BB": "zhi",
	"7976": "di",
	"858D": "luan",
	"909D": "kuang",
	"5EFB": "hui",
	"66C3": "dai",
	"8C06": "zhun",
	"4E9C": "ya",
	"6BC8": "duan",
	"71E9": "que",
	"84D7": "zong",
	"8695": "can;tian",
	"92C1": "lu",
	"9AC3": "yu",
	"75C1": "dian",
	"7A02": "lang",
	"82C5": "yi",
	"830F": "long",
	"8357": "rong",
	"936D": "hou",
	"4F2C": "chi",
	"552F": "wei",
	"571E": "luan",
	"6DED": "qu",
	"9BE7": "chang",
	"6843": "tao",
	"6DB4": "wan",
	"77E9": "ju",
	"97AF": "jian",
	"4FED": "jian",
	"5568": "qing",
	"88BD": "ru",
	"8E5A": "tang",
	"9520": "chang",
	"53AF": "li",
	"57D0": "jin",
	"6CCB": "hui",
	"72CB": "ni",
	"8335": "yin",
	"9251": "bo",
	"970D": "huo",
	"60C6": "chou",
	"6304": "kuo",
	"7A58": "xiao",
	"7C62": "lian",
	"8B40": "han",
	"55A1": "wei",
	"5D47": "ji",
	"5ED5": "yin",
	"6C68": "mi",
	"7EC7": "zhi",
	"8A3D": "gou",
	"9969": "xi",
	"80F1": "guang",
	"8543": "fan;bo",
	"511D": "qiong",
	"6BC6": "ou",
	"6F1F": "tang",
	"7667": "li",
	"7939": "yan",
	"8216": "pu",
	"848C": "lou",
	"9194": "qiu",
	"9A2F": "pang",
	"6132": "gu",
	"6855": "jiu",
	"7B87": "ge",
	"6586": "xiao",
	"6612": "hu",
	"7FE9": "pian",
	"8A97": "chan",
	"8D47": "qiu",
	"5221": "min",
	"5A92": "mei",
	"6141": "hun",
	"7B2D": "ling",
	"8814": "hao",
	"562E": "lao",
	"5FCA": "ding",
	"61C2": "dong",
	"76B4": "cun",
	"8671": "shi",
	"8E54": "zhan",
	"9B4D": "wang",
	"9E6A": "jiao",
	"9F06": "mang",
	"4E3E": "ju",
	"5241": "duo",
	"5721": "tu",
	"711D": "hun",
	"7B67": "jian",
	"8565": "ya",
	"8F6E": "lun",
	"9AAB": "wei",
	"5027": "zong",
	"6ECD": "zhi",
	"8154": "qiang",
	"9D21": "ju",
	"6116": "chen",
	"6834": "zhan",
	"7337": "you",
	"9443": "diao;yao",
	"4EE0": "gan",
	"56EE": "e",
	"5AC7": "ming",
	"8495": "yun",
	"84A1": "bang;pang",
	"616F": "shang",
	"81C6": "yi",
	"8382": "bie",
	"848E": "pai",
	"9038": "yi",
	"9439": "guo",
	"9F77": "wo",
	"7751": "jian",
	"7ECB": "fu",
	"8298": "bi;pi",
	"59A0": "na",
	"6AEF": "su",
	"76FA": "xin",
	"83E1": "han",
	"8C85": "xiu",
	"9A81": "xiao",
	"9CC5": "qiu",
	"5246": "luo",
	"5E54": "man",
	"668D": "he",
	"6F29": "xuan",
	"879E": "ma",
	"8FE4": "yi",
	"97F7": "luo",
	"9D36": "ji",
	"4F74": "nai;er",
	"6589": "qi;ji",
	"688E": "ao",
	"7A74": "xue",
	"83C3": "qu",
	"86CC": "gu",
	"88C6": "dang",
	"528B": "jiao",
	"58CD": "qian",
	"602D": "bi",
	"7D4B": "kuang",
	"8591": "jiang",
	"8D95": "gan",
	"9475": "guan",
	"9AE4": "xiu",
	"6883": "ting",
	"583B": "zhen",
	"8D32": "bi;ben",
	"51D7": "cui",
	"5535": "an",
	"58BC": "ji",
	"6865": "qiao",
	"6B67": "qi",
	"6C80": "xu",
	"6E4E": "mian",
	"938D": "suo",
	"9E87": "jun;qun",
	"5099": "bei",
	"50FF": "sai",
	"6755": "di",
	"6D2B": "xu",
	"982E": "hui",
	"50F7": "ye",
	"5DE0": "jing",
	"6496": "han",
	"70CE": "yin",
	"7386": "zi",
	"87AC": "cao",
	"9CB3": "chang",
	"50C4": "piao",
	"6646": "kui",
	"6CFD": "ze",
	"8629": "fan",
	"8DBE": "zhi",
	"91DC": "fu",
	"4EB5": "xie",
	"6653": "xiao",
	"6E36": "ying",
	"518B": "jiong",
	"6CE9": "sheng",
	"7122": "hong",
	"92F3": "zhu",
	"6415": "ke",
	"7836": "po",
	"5C88": "ya",
	"6966": "xuan",
	"8261": "dang",
	"860F": "jiong",
	"8FBF": "chan",
	"52F7": "rang",
	"5660": "da",
	"6170": "wei",
	"7AA0": "ke",
	"5519": "di",
	"56CC": "su",
	"5B8F": "hong",
	"7218": "none",
	"7F40": "none",
	"7FE1": "fei",
	"8351": "ti;yi",
	"5B93": "mi",
	"754F": "wei",
	"88C7": "none",
	"97DA": "ge",
	"99F3": "dan",
	"9E14": "bo",
	"5005": "cui",
	"557E": "jiu",
	"7AC9": "zao",
	"7FB6": "shan",
	"8C10": "xie",
	"90D9": "fu",
	"9CE4": "guan",
	"51A2": "zhong",
	"5FBD": "hui",
	"74C1": "huo",
	"7B0E": "yuan",
	"815C": "mei",
	"8715": "tui",
	"8757": "huang",
	"8AB4": "cong",
	"8B34": "guan",
	"525F": "duo",
	"8CF1": "yun",
	"8D0D": "shan",
	"919C": "chou",
	"9810": "yu",
	"9B79": "none",
	"7DE8": "bian",
	"8398": "xin;shen",
	"9218": "yi",
	"552D": "qi",
	"67DC": "ju;gui",
	"7746": "huan",
	"9CC0": "ti",
	"5172": "tian",
	"5932": "ben;tao",
	"71E6": "can",
	"74B5": "yu",
	"8422": "none",
	"8ECF": "yue",
	"98DE": "fei",
	"5FD0": "tan",
	"64E6": "ca",
	"658C": "bin",
	"6A0E": "suo",
	"771D": "zhu",
	"7C05": "chan",
	"7FF3": "yi",
	"949D": "dun",
	"6363": "dao",
	"647F": "yin",
	"7C52": "zhou",
	"7E6C": "se",
	"9BB5": "duo",
	"4E71": "luan",
	"5ECB": "sou",
	"533B": "yi",
	"6ED4": "tao",
	"78CD": "xia",
	"815B": "wu",
	"5B84": "gui",
	"87A6": "none",
	"9E6D": "lu",
	"50BF": "yan",
	"5F32": "xuan",
	"69F9": "gao",
	"77B5": "lin",
	"8159": "zong",
	"77CA": "mian",
	"7A6E": "biao",
	"8BBA": "lun",
	"8E96": "duan",
	"904F": "e",
	"928F": "shan",
	"9658": "xing",
	"58D5": "hao",
	"84CE": "tang",
	"8691": "qi",
	"9508": "xiu",
	"9C6A": "none",
	"887F": "jin",
	"8F27": "ping",
	"56B7": "rang",
	"6361": "jian",
	"647B": "chan;shan",
	"6A02": "le;yue",
	"7BA5": "bo",
	"889C": "wa",
	"8918": "hui",
	"8C28": "jin",
	"5250": "gua",
	"61CB": "mao",
	"6C8D": "hu",
	"8166": "nao",
	"8146": "tian",
	"872E": "yu",
	"6792": "ya",
	"9851": "kan",
	"9A3B": "shuang",
	"7240": "chuan",
	"7827": "zhen",
	"807C": "ting",
	"86D6": "mang",
	"94A1": "bei",
	"9566": "dun;dui",
	"9B24": "rang",
	"56A3": "xiao",
	"7202": "biao",
	"7430": "yan",
	"75DA": "xiao",
	"78B8": "feng",
	"794D": "none",
	"52AF": "zhu",
	"539B": "ting",
	"7309": "qi",
	"8FAE": "bian",
	"928B": "ren",
	"6681": "xiao",
	"71A2": "feng",
	"7304": "jing",
	"7DF3": "jie",
	"8896": "xiu",
	"8A40": "zhan",
	"8D0F": "ying",
	"9072": "chi",
	"97B2": "gou",
	"504D": "ti",
	"5257": "chan",
	"8F5E": "xian",
	"93BE": "none",
	"4F75": "bing",
	"51B3": "jue",
	"5C59": "e",
	"5FC8": "ren",
	"926F": "yi",
	"9D1C": "zi",
	"6D28": "xiao",
	"7B49": "deng",
	"868B": "rui",
	"972D": "ai",
	"56CD": "xi",
	"5774": "liu",
	"717E": "yun",
	"853E": "li",
	"95CB": "que",
	"992C": "hu",
	"5115": "chai",
	"6D3B": "huo",
	"7223": "tang",
	"8FD4": "fan",
	"50D5": "pu",
	"59E5": "lao;mu",
	"60E5": "yong",
	"6373": "yue",
	"78E8": "mo",
	"8B5D": "sheng",
	"8C2C": "miu",
	"9D41": "jiao",
	"5E67": "qiao",
	"72FD": "bei",
	"7D7B": "mian",
	"832A": "guang",
	"8CDF": "tian",
	"7303": "xian",
	"825C": "dai",
	"97F0": "xie",
	"537D": "ji",
	"53E4": "gu",
	"56F6": "guo",
	"5E42": "mi",
	"7C6A": "duan",
	"7D68": "rong",
	"8483": "zhuan",
	"9403": "nao",
	"5E6D": "mie",
	"7329": "xing",
	"7492": "deng",
	"7C3F": "bu",
	"8569": "dang",
	"9DEF": "liao",
	"8B2A": "shang",
	"9F0A": "bi",
	"5DDE": "zhou",
	"8438": "yu",
	"88FD": "zhi",
	"8EC5": "none",
	"8F1B": "liang",
	"9EA8": "chao",
	"4F45": "mai",
	"552E": "shou",
	"7700": "ming",
	"8611": "mo",
	"8CCD": "zang",
	"9435": "tie",
	"9588": "han",
	"4FD9": "xi",
	"5BF1": "yi",
	"5D3D": "zai",
	"7181": "xie",
	"94C4": "shuo",
	"9BA5": "luo",
	"592E": "yang",
	"6F76": "hei",
	"7E41": "fan;po",
	"82A7": "zhu",
	"82E1": "yi",
	"8C4B": "deng",
	"9115": "xiang",
	"5054": "e",
	"79E3": "mo",
	"7BCB": "qie",
	"7EB8": "zhi",
	"80D1": "zhi",
	"8804": "qin",
	"4FA7": "ce;ze;zhai",
	"6FC6": "fen",
	"8EA1": "nie",
	"5C2D": "yao",
	"6A2C": "cong",
	"6BF5": "san",
	"9160": "qia",
	"7E5F": "chan",
	"9AF3": "mao",
	"93A5": "tiao",
	"6F1E": "mi",
	"7AB0": "yao",
	"7DEF": "wei",
	"8978": "zan",
	"8BDA": "cheng",
	"9BEB": "zou",
	"716D": "lie",
	"9B06": "song",
	"9F6A": "chuo",
	"60B8": "ji",
	"65D3": "shao",
	"8BFE": "ke",
	"5E2B": "shi",
	"61EE": "you",
	"9A6E": "tuo;duo",
	"4E88": "yu",
	"4FBE": "hao",
	"621F": "ji",
	"69D3": "gang",
	"6B43": "sha",
	"7831": "ling",
	"8957": "duo",
	"9167": "chou",
	"9B40": "jie",
	"5153": "jin",
	"5546": "shang",
	"56E0": "yin",
	"5C0B": "xun;xin",
	"7101": "none",
	"6518": "rang",
	"8188": "ge",
	"9392": "nou",
	"9DAC": "cang",
	"5DFE": "jin",
	"60D9": "chuo",
	"6BAF": "bin",
	"70C6": "xing",
	"73D4": "jian",
	"8404": "tao",
	"87D5": "zi",
	"8C6A": "hao",
	"9B66": "sha",
	"6B26": "qian",
	"9153": "yan",
	"67C3": "ling",
	"7860": "lang",
	"7E38": "mo",
	"855C": "fei",
	"9281": "jun",
	"974F": "he",
	"4F11": "xiu",
	"6FA7": "li",
	"7ADB": "ling",
	"7FEA": "zong",
	"8740": "dong",
	"9796": "sui",
	"6226": "zhan",
	"7DFF": "dai",
	"9470": "yao;yue",
	"9BD5": "qi",
	"54C3": "tong",
	"5DD0": "chao",
	"6F03": "ji",
	"8FD7": "e",
	"9230": "shi",
	"57FF": "ni",
	"91BA": "xun",
	"948F": "chuan",
	"9CA6": "tiao",
	"6286": "wen",
	"7196": "none",
	"78CC": "tian",
	"9ACD": "mo",
	"5DFC": "none",
	"6257": "zai",
	"9A46": "bi",
	"6CAD": "shu",
	"7580": "cha",
	"7E0A": "yi",
	"62E2": "long",
	"7721": "di",
	"7EA6": "yue;yao",
	"9473": "jian",
	"9DE2": "jue",
	"5C39": "yin",
	"82E2": "yi",
	"8677": "gan",
	"8D41": "lin",
	"945E": "la",
	"9C23": "shi",
	"5E2A": "zhen",
	"8341": "huan",
	"8729": "tiao",
	"9D53": "bo",
	"5169": "liang",
	"53E6": "ling",
	"5479": "yi",
	"58AD": "sheng",
	"6C4B": "zhuo",
	"7808": "nuo",
	"88C9": "ken",
	"9750": "bing",
	"9F2B": "shi",
	"8B7A": "ni",
	"63B6": "none",
	"6B20": "qian",
	"6C87": "yan",
	"7104": "xun",
	"714F": "bi",
	"87CC": "cong",
	"9495": "nu",
	"4F7A": "quan",
	"5602": "jiao",
	"6623": "zhen",
	"6A55": "cheng",
	"6A9E": "jia",
	"8F9F": "pi;bi",
	"4FAC": "nong",
	"5939": "jia;ga",
	"6215": "qiang",
	"7932": "long",
	"9529": "juan",
	"5F57": "hui",
	"6ACD": "zhi",
	"71EC": "hui",
	"85F6": "li",
	"8934": "lan",
	"8936": "zhe;xi",
	"95F5": "min",
	"9ED0": "chi;li",
	"9F3A": "lei",
	"56D7": "wei",
	"57FD": "sao",
	"5DDF": "huang",
	"6A0F": "lei",
	"74FF": "bu",
	"7E7D": "bin",
	"85AB": "xun",
	"8D96": "suo",
	"915E": "tai",
	"955F": "xuan",
	"9D54": "xun",
	"4FD1": "yong",
	"9665": "xian",
	"65E0": "wu;mo",
	"6EC3": "weng",
	"70FB": "shan",
	"7357": "jue",
	"8937": "shi",
	"91AB": "yi",
	"719F": "shu;shou",
	"93EC": "xia",
	"9484": "lan",
	"78E2": "qiang",
	"7D13": "shu",
	"8E1C": "leng",
	"5D5F": "dui",
	"610E": "bi",
	"9CDE": "lin",
	"50E9": "xian",
	"51BF": "jian",
	"5631": "zhu",
	"5C5D": "fei",
	"5F9F": "zhou",
	"68D6": "cheng",
	"6E1A": "zhu",
	"7446": "xing",
	"79C6": "gan",
	"7E37": "lu",
	"8AEB": "jian",
	"926E": "shen",
	"97A9": "xiao",
	"9838": "jing;geng",
	"9ADE": "zao",
	"9F7B": "dian",
	"6001": "tai",
	"70FE": "chi",
	"88F4": "pei",
	"97D2": "qiao",
	"9F24": "wen",
	"5D46": "ji",
	"6081": "juan",
	"6499": "zun",
	"64A6": "che",
	"7ACF": "qian;gong;sheng",
	"9C7E": "ji",
	"6760": "gang",
	"68E6": "cheng",
	"6E6D": "none",
	"8833": "ying",
	"5825": "mao",
	"6988": "lu",
	"70D2": "shi",
	"723C": "zu",
	"8C53": "yan",
	"4E3C": "jing;dan",
	"9356": "chen",
	"592A": "tai",
	"85AD": "bai",
	"91B6": "yan",
	"565A": "xun",
	"929B": "xian",
	"94B3": "qian",
	"5109": "jian",
	"5F6B": "diao",
	"605D": "jia",
	"7665": "zheng",
	"7E91": "lu",
	"921A": "pi",
	"58C5": "yong",
	"5952": "kai",
	"67F4": "chai",
	"7282": "li",
	"8D87": "se",
	"914E": "zhou",
	"56D4": "nang",
	"6537": "kao",
	"9BE5": "lu",
	"5058": "kan",
	"5F91": "jing",
	"64B0": "zhuan",
	"8CAB": "guan",
	"7413": "wan",
	"8097": "ru",
	"80E7": "long",
	"6D26": "po",
	"75F8": "chi",
	"80A8": "pang",
	"81E1": "ni",
	"9B39": "gui",
	"57BF": "xu",
	"6909": "cheng;sheng",
	"98E2": "ji",
	"9B16": "san",
	"5210": "dan",
	"561E": "lei",
	"68FE": "qiong",
	"6C15": "pie",
	"6EBD": "ru",
	"6F47": "xiao",
	"7C54": "sou",
	"8296": "zhi",
	"8C44": "du",
	"93EA": "cao",
	"9B60": "tuo",
	"5520": "lao",
	"5AF5": "wu",
	"69DE": "long",
	"6B02": "bo",
	"6C66": "chi",
	"721E": "tong",
	"7F43": "ying",
	"8213": "shi",
	"5489": "bi;fu",
	"55F3": "ai",
	"58F3": "qiao;ke",
	"6AF8": "ju",
	"7434": "qin",
	"77EA": "zhou",
	"80EC": "nu",
	"5490": "fu",
	"6F2B": "man",
	"7A6C": "gong",
	"8E6C": "deng",
	"9314": "ta",
	"9491": "sa",
	"996F": "jian",
	"52E9": "yi",
	"54FE": "shuo",
	"6C06": "pu",
	"71C2": "qian",
	"878E": "rong",
	"9602": "he",
	"56B9": "la",
	"5A24": "zhuang",
	"5F41": "none",
	"6B23": "xin",
	"6F95": "he",
	"75D3": "chi",
	"7F9B": "yi",
	"5E7A": "yao",
	"633F": "cha",
	"6456": "qi",
	"66D4": "jing",
	"783E": "li",
	"942C": "hui",
	"9694": "ge",
	"96F0": "fen",
	"5387": "zhe",
	"78D2": "yun",
	"876A": "tang",
	"91BD": "ling",
	"82B0": "ji",
	"91A6": "lao",
	"7BF0": "bu",
	"7E17": "shuai",
	"858B": "ci",
	"86E1": "yi",
	"83B0": "kan",
	"94A7": "jun",
	"5021": "chang",
	"52A6": "xie",
	"6312": "lie",
	"6ABB": "jian;kan",
	"75E1": "pu",
	"7D4D": "ren",
	"820F": "jiu",
	"8C56": "chu",
	"7A84": "zhai;ze",
	"8675": "she;yi",
	"8EB9": "ju",
	"9ABD": "tui",
	"9BB1": "none",
	"5CC5": "none",
	"607A": "kai",
	"60F5": "die",
	"7F92": "fen",
	"935C": "xia",
	"9807": "han",
	"5447": "qi",
	"5D5D": "lou",
	"5F05": "fen",
	"66E2": "none",
	"779C": "lou",
	"56A7": "lu",
	"870E": "yuan",
	"5566": "la",
	"7689": "ci",
	"79FD": "hui",
	"911D": "liao",
	"58ED": "none",
	"687D": "wen",
	"9253": "chi",
	"9ED3": "yi",
	"53F5": "po",
	"5D50": "lan",
	"5FA5": "chi;shi",
	"826B": "lu",
	"9728": "wei",
	"9BFF": "bian",
	"68CE": "chan",
	"8968": "none",
	"9CE7": "fu",
	"5984": "wang",
	"6327": "none",
	"6C4D": "wan",
	"7F62": "ba",
	"8545": "ou",
	"8635": "zhi",
	"8C95": "xi",
	"8FEC": "wang",
	"9C04": "wei",
	"7D95": "zhi",
	"97F5": "yun",
	"9887": "po",
	"6EBE": "wei",
	"9DDA": "liao;liu",
	"5CFD": "xia",
	"7592": "chuang",
	"773C": "yan",
	"87B0": "lu",
	"8AC5": "ji",
	"5933": "tai",
	"60B9": "guan",
	"71B0": "ou",
	"7A9E": "dan",
	"9140": "yan",
	"9AAD": "gan",
	"50F1": "gu",
	"730A": "ni",
	"90F7": "xiang",
	"9F66": "yin;ken",
	"4FFB": "bei",
	"59F0": "jun",
	"635A": "zhai",
	"6DB7": "dong",
	"7079": "zha",
	"7BB8": "zhu",
	"7D2D": "hong",
	"8046": "ling",
	"8E64": "zong",
	"9379": "xuan",
	"93BC": "none",
	"5B78": "xue;xiao",
	"61B2": "xian",
	"6ECE": "ying;xing",
	"7006": "du",
	"7139": "none",
	"7A99": "xiao",
	"8A67": "cha",
	"8CEE": "jin",
	"8D84": "ju;qie",
	"97D3": "han",
	"9E39": "gua",
	"9EB7": "feng",
	"51DD": "ning",
	"5513": "che",
	"6EA2": "yi",
	"7465": "wen",
	"82DE": "bao",
	"8951": "xin",
	"91FB": "none",
	"947B": "pan",
	"60D4": "yan",
	"6CDC": "zhi",
	"7054": "yan",
	"9AB0": "tou;shai",
	"646C": "ying",
	"66BF": "xi",
	"81EF": "gao",
	"88AB": "bei;pi",
	"8C0A": "yi",
	"905F": "chi",
	"9DD8": "chi",
	"61A6": "lao",
	"6FBB": "sui",
	"7483": "li",
	"9E5D": "yi",
	"52F5": "li",
	"5B60": "si",
	"8DDD": "ju",
	"5CC7": "ke",
	"5FC0": "xiang",
	"62E6": "lan",
	"6B9E": "yun",
	"6D21": "lei",
	"6D75": "tong",
	"7D65": "fu",
	"9F94": "gong",
	"9F99": "long",
	"5020": "xu",
	"6252": "ba;pa",
	"7013": "cheng",
	"8AB0": "shui;shei",
	"8972": "xi",
	"94DC": "tong",
	"9706": "ting",
	"4F5B": "fo;fu",
	"544D": "hong",
	"5798": "fu",
	"57A3": "yuan",
	"614E": "shen",
	"6CD4": "gan",
	"6C5E": "gong;hong",
	"7761": "shui",
	"6B7C": "jian",
	"8883": "chai",
	"955E": "zu",
	"95E8": "men",
	"57C3": "ai",
	"6BD6": "bi",
	"858A": "ji",
	"9108": "kui",
	"92BB": "ti",
	"9DCC": "ma",
	"4E80": "gui;jun;qiu",
	"6C94": "mian",
	"96A6": "pi",
	"4ECD": "reng",
	"6E33": "mi",
	"9333": "meng",
	"6450": "chuang",
	"6ABE": "qing",
	"722D": "zheng",
	"7CFA": "jiu",
	"8EA8": "kui",
	"5937": "yi",
	"831C": "qian;xi",
	"834C": "an",
	"8B1F": "tao",
	"99FE": "tui",
	"4FAF": "hou",
	"5067": "zha",
	"53FC": "diao",
	"5667": "hui",
	"5854": "ta;da",
	"7406": "li",
	"8195": "guo",
	"827F": "nai",
	"90BC": "kuang",
	"90E3": "bo",
	"96D1": "za",
	"5C2A": "wang",
	"5EC3": "fei",
	"6D8A": "nian",
	"7072": "xiao",
	"97E1": "wei",
	"9AB7": "ku",
	"5D14": "cui",
	"7A34": "lian",
	"857F": "xuan",
	"98BB": "yao",
	"9904": "jia",
	"5C41": "pi",
	"68A8": "li",
	"72A8": "chou",
	"85E6": "mo",
	"8B9C": "dang",
	"9F18": "yuan",
	"524F": "chuan",
	"6406": "gou",
	"6E3B": "xing",
	"7A53": "yi",
	"876D": "ti",
	"8808": "ze",
	"5931": "shi",
	"6628": "zuo",
	"7F4B": "weng",
	"8000": "yao;yue",
	"85E3": "pi",
	"8C30": "lan",
	"9B6B": "shen",
	"5390": "pang",
	"60C4": "ni",
	"7B00": "mang",
	"7BBA": "chun",
	"8451": "feng",
	"8CB6": "bian",
	"9BAD": "gui;xie",
	"5E98": "ya",
	"6867": "gui;hui",
	"7CD8": "none",
	"81FA": "tai",
	"915A": "fen",
	"52A8": "dong",
	"5C1F": "xian",
	"64C2": "lei",
	"6ADE": "yuan",
	"6D5A": "jun;xun",
	"764E": "xian",
	"80C5": "die",
	"8522": "po",
	"929F": "cha",
	"57F5": "duo",
	"6BD0": "ai",
	"6FBF": "qin",
	"8413": "yi",
	"870A": "li",
	"88F7": "yuan",
	"8AE9": "pu",
	"94F5": "an",
	"989C": "yan",
	"9EB5": "mian",
	"5BF2": "yi",
	"7237": "ye",
	"748C": "yin",
	"7821": "yu",
	"4E43": "nai",
	"68AE": "ju",
	"6E39": "hong",
	"8723": "qiang",
	"8C78": "zhi",
	"4E37": "none",
	"52DA": "yi",
	"582A": "kan",
	"5F71": "ying",
	"63E5": "ti",
	"7002": "lu",
	"8A9B": "qin",
	"8F06": "kai",
	"90D4": "yan",
	"94CD": "pi",
	"58DE": "huai;pi",
	"598C": "jing",
	"826F": "liang",
	"9DEA": "ying",
	"5435": "chao",
	"4EA8": "heng",
	"5EEE": "ying",
	"601E": "zhou",
	"516B": "ba",
	"6298": "zhe;she",
	"97B0": "none",
	"56DA": "qiu",
	"7317": "yi",
	"4EB1": "ye",
	"4F94": "mou",
	"516C": "gong",
	"5AC8": "ying",
	"6B0E": "yu",
	"6FC4": "guo",
	"702D": "none",
	"9956": "hui",
	"9AEA": "fa",
	"9D78": "qi",
	"66F2": "qu",
	"6D4E": "ji",
	"81B7": "xin",
	"8CE0": "pei",
	"9259": "zhai",
	"999A": "fen",
	"5465": "ran",
	"5AAE": "tou",
	"67CC": "ci",
	"67F2": "bi",
	"7298": "ma",
	"7991": "wu",
	"84ED": "an",
	"968A": "dui",
	"5A96": "ying",
	"5CE9": "e",
	"7162": "qiong",
	"7A8B": "zhu",
	"883A": "can",
	"931E": "chun",
	"7C51": "zhuan",
	"9AE3": "fang",
	"6F38": "jian",
	"8DF1": "zhi",
	"966E": "dui",
	"56CA": "nang",
	"5FE9": "zong",
	"9BAF": "ge",
	"69EA": "gai",
	"6F1B": "teng",
	"9223": "gai",
	"92D6": "si",
	"56A8": "long",
	"5DDD": "chuan",
	"676E": "fei",
	"747F": "yi",
	"8595": "lian",
	"863B": "ji",
	"4E65": "none",
	"57E7": "ju",
	"5A7B": "nan",
	"5BF0": "huan",
	"6469": "mo;ma",
	"6559": "jiao",
	"8710": "jie",
	"526C": "duan",
	"681F": "bing;ben",
	"74AD": "gun",
	"9441": "dang;zheng",
	"6B54": "xu",
	"8E03": "xiao",
	"6519": "chan",
	"6521": "li",
	"741C": "lai",
	"7909": "he",
	"81C9": "lian",
	"8333": "jiang",
	"8BA4": "ren",
	"9037": "ti",
	"9462": "lu",
	"9610": "chan",
	"58A8": "mo",
	"5E91": "wu",
	"87B3": "tang",
	"8AEF": "chuan",
	"9186": "zhan",
	"6AD1": "lei",
	"74BF": "xuan",
	"7C47": "hao",
	"8D9A": "su",
	"9A01": "cheng",
	"7B23": "bao",
	"87A4": "yu",
	"8992": "mao",
	"9553": "jia",
	"977A": "mo",
	"9B35": "qian",
	"895E": "bi",
	"8B35": "xi",
	"5455": "ou",
	"61DC": "meng",
	"63C4": "yu",
	"7BCE": "miao",
	"8EEC": "fan",
	"665D": "zhou",
	"8AC2": "chan",
	"9AA5": "ji",
	"5BB4": "yan",
	"79C1": "si",
	"87FC": "jing",
	"8F14": "fu",
	"9574": "la",
	"9F9C": "gui;jun;qiu",
	"4EE4": "ling",
	"5086": "yuan",
	"5945": "pao",
	"691F": "du",
	"728B": "ju",
	"84A0": "xi",
	"569B": "hu",
	"6CA8": "feng",
	"75CF": "wei",
	"8CA7": "pin",
	"98B1": "tai",
	"5D99": "lin",
	"6173": "qian",
	"67E7": "gu",
	"6A73": "none",
	"8B30": "lian",
	"8C86": "huan",
	"8E34": "yong",
	"9839": "tui",
	"985B": "dian",
	"586F": "liu",
	"65C1": "pang;bang",
	"6BE9": "ju",
	"7241": "ke",
	"7839": "ai",
	"864A": "luan",
	"8B10": "mi",
	"8C4E": "shu",
	"56AE": "xiang",
	"5C80": "chu",
	"7CDD": "san;shen",
	"80E5": "xu",
	"93C1": "suo",
	"958E": "hong",
	"591B": "duo",
	"5C22": "wang;you",
	"5C7C": "wu",
	"6799": "e",
	"6972": "wei",
	"71B5": "shang",
	"7F46": "guan",
	"5192": "mao;mo",
	"60FA": "xing",
	"655F": "dian",
	"6B1A": "li;ji",
	"903D": "nuo",
	"96B9": "zhui;cui",
	"5C7A": "qi",
	"5F4C": "mi",
	"6896": "bei",
	"72C2": "kuang",
	"7696": "wan;huan",
	"877B": "nan",
	"9512": "lang",
	"532F": "hui",
	"57E5": "cheng",
	"5961": "ao",
	"7703": "yun",
	"84A3": "xu",
	"9073": "cuo",
	"9B31": "yu",
	"6616": "yan",
	"8518": "sen",
	"87C1": "wen",
	"8A2C": "chao",
	"5887": "zhang",
	"61A2": "xiao",
	"8A38": "he",
	"9748": "ling",
	"5034": "ben",
	"6507": "xian",
	"70E9": "hui",
	"745B": "ying",
	"7DD1": "lu",
	"9165": "su",
	"5D7B": "none",
	"66B6": "xuan",
	"7F3F": "hou",
	"8721": "la;zha",
	"9E88": "zhu",
	"4E7B": "none",
	"521C": "fu",
	"5655": "hui",
	"576D": "ni",
	"5C34": "gan",
	"6C3B": "le",
	"7DED": "wei",
	"8266": "jian",
	"8458": "zi",
	"8F54": "lin",
	"94DF": "yin",
	"9A0B": "lai",
	"4E2E": "ji",
	"53CD": "fan",
	"6E19": "huan",
	"71C7": "zun",
	"7589": "die",
	"8516": "cuo",
	"95F6": "kang",
	"4E45": "jiu",
	"6A0C": "guan",
	"6FBE": "ta",
	"81F1": "mian",
	"8AA9": "jing",
	"8DEE": "chi",
	"96E8": "yu",
	"9BF0": "nian",
	"5529": "wo",
	"6157": "chi",
	"6CA7": "cang",
	"6E7A": "yan",
	"6EAC": "qiang",
	"6F54": "jie",
	"74E5": "li",
	"940A": "yang",
	"9D29": "zhi",
	"534F": "xie",
	"6486": "pie",
	"8C67": "fu",
	"911C": "fu",
	"9A93": "zhui",
	"510C": "jiao",
	"5EA1": "yi",
	"6A95": "ji",
	"6C4C": "chuan",
	"7710": "zheng",
	"825F": "chong;tong",
	"840B": "qi",
	"88DB": "yi",
	"8E22": "ti",
	"6A57": "meng",
	"7675": "luan",
	"8813": "meng",
	"51D3": "li",
	"520E": "wen",
	"6A3F": "zhan",
	"6D79": "jia",
	"8051": "die",
	"4F68": "none",
	"534A": "ban",
	"6969": "pian",
	"707E": "zai",
	"7E2E": "suo",
	"8B20": "yao",
	"50D8": "chang",
	"52F9": "bao",
	"6DD5": "lu",
	"6DF8": "qing",
	"6E02": "wen",
	"7AA8": "yin;xun",
	"863C": "mi",
	"956B": "deng",
	"64EC": "ni",
	"7648": "fei",
	"81D7": "kuan",
	"8BB0": "ji",
	"65B6": "chu",
	"8598": "da",
	"67C0": "bi",
	"7731": "yi",
	"7AFF": "gan",
	"7DF6": "bian;pian",
	"8447": "rou",
	"4F8E": "mi",
	"55F7": "ao",
	"7982": "dao",
	"7F2B": "sao",
	"9856": "xin",
	"560F": "gu;jia",
	"69A0": "ming",
	"8AAA": "shuo;shui;yue",
	"9087": "er",
	"5471": "gua;wa",
	"54CD": "xiang",
	"55FC": "mo",
	"6091": "bu",
	"68B9": "bing",
	"7CF6": "tiao",
	"8006": "qi",
	"9240": "jia",
	"649A": "nian",
	"7177": "none",
	"905A": "chu",
	"9360": "huang",
	"978F": "gong",
	"5ECD": "pou",
	"66EA": "luo",
	"7215": "xie",
	"73F5": "cheng",
	"7466": "wu",
	"9A0E": "qi;ji",
	"52F2": "xun",
	"681B": "li",
	"7E67": "none",
	"5FD1": "te",
	"6A8F": "pu",
	"736D": "ta",
	"8FCC": "none",
	"5FD4": "qi",
	"8215": "dan",
	"893F": "cao",
	"926D": "tan",
	"9837": "han",
	"4E44": "none",
	"51DA": "jin",
	"6600": "yun",
	"688C": "tu",
	"6EDC": "gao",
	"7197": "qiang",
	"79C2": "ren",
	"7A1C": "leng",
	"7CF2": "li",
	"9E19": "yue",
	"530C": "ge",
	"5B4E": "zhu",
	"5E8B": "gui",
	"71B6": "cuan",
	"7DF5": "zong",
	"82E7": "zhu;ning",
	"8EC1": "lou",
	"9A57": "yan",
	"9D86": "lai",
	"9E20": "jiu",
	"56FA": "gu",
	"5F59": "hui",
	"6CBE": "zhan",
	"7184": "xi",
	"7933": "mo",
	"8B6F": "yi",
	"9C44": "zhuan",
	"6564": "ke",
	"6A42": "dian",
	"7C20": "fu",
	"800F": "er",
	"9E12": "yu",
	"54D8": "none",
	"5972": "che",
	"75F4": "chi",
	"764A": "yin",
	"8902": "gua",
	"8A43": "jian",
	"9688": "wei",
	"9B0A": "shun",
	"593A": "duo",
	"72FA": "yin",
	"7840": "chu",
	"79D5": "bi",
	"7EC4": "zu",
	"815F": "zhi",
	"9701": "ji",
	"53CC": "shuang",
	"6416": "yao",
	"6509": "huo",
	"8AE1": "shi",
	"8DD7": "fu",
	"5851": "su",
	"7347": "none",
	"7B66": "guan",
	"7C04": "hu",
	"8E12": "wo",
	"90E8": "bu",
	"536C": "ang;yang",
	"605F": "xiong",
	"6A41": "xun",
	"75A1": "yang",
	"79C5": "cha",
	"96BE": "nan",
	"61FF": "yi",
	"75B4": "ke",
	"97E7": "ren",
	"9A69": "huan",
	"6901": "guo",
	"6BE3": "mu",
	"6DEE": "huai",
	"7423": "pei",
	"7DEA": "geng",
	"8D14": "bi",
	"8D1F": "fu",
	"8E2D": "zheng",
	"92E3": "ye",
	"9AD7": "lu",
	"52E0": "lu",
	"634C": "ba",
	"92FB": "jian",
	"58FC": "kun",
	"62A7": "zhi",
	"6C2F": "lu",
	"77E2": "shi",
	"7D44": "zu",
	"898C": "guan",
	"89D0": "jin",
	"9148": "li",
	"4EF3": "pi",
	"4F63": "yong",
	"599B": "chi",
	"7121": "wu;mo",
	"71EE": "xie",
	"8225": "pa",
	"9E2B": "dong",
	"4F42": "zheng",
	"64D9": "ao",
	"666D": "zhou",
	"7262": "lao",
	"73E6": "xiang",
	"85BB": "zao",
	"94D0": "kao",
	"9E0B": "ning",
	"4F6A": "huai",
	"7C1F": "dian",
	"692A": "peng",
	"6C88": "shen;chen",
	"6D93": "juan",
	"84B5": "xi",
	"4F4F": "zhu",
	"5CF4": "xian",
	"651A": "none",
	"72B1": "bo",
	"88B5": "ren",
	"8BF5": "song",
	"9E51": "chun",
	"679B": "zhao",
	"7926": "kuang;gong",
	"8BCD": "ci",
	"9785": "yang",
	"9B6D": "yuan",
	"57E8": "lun",
	"5AA2": "mao",
	"5D77": "song",
	"5E22": "qia",
	"66A6": "li",
	"77A2": "meng",
	"6B4D": "wu",
	"8708": "wu",
	"90FB": "qiao",
	"6576": "zhen",
	"7FD6": "xi",
	"8C3B": "jue",
	"8CD9": "zhou",
	"961E": "le",
	"9EAE": "qu",
	"5622": "ye",
	"5675": "dao",
	"581D": "guo",
	"7404": "quan",
	"76DF": "meng;ming",
	"85A4": "xie",
	"624F": "qiu",
	"7FB2": "xi",
	"881C": "fan",
	"5209": "ji",
	"54AD": "ji",
	"5FAC": "pang",
	"7144": "zhong",
	"884C": "xing;hang;heng",
	"98B5": "shao",
	"55E4": "chi",
	"63AC": "ju",
	"6979": "ying",
	"7608": "ji;zhi",
	"8CBD": "yi",
	"96B6": "li",
	"7543": "xun",
	"77CC": "guang",
	"7B0C": "ya",
	"900C": "you",
	"9BCD": "meng",
	"4E50": "le;yue",
	"83BB": "none",
	"88E9": "gun",
	"95AB": "kun",
	"97E6": "wei",
	"4FF4": "jian",
	"7532": "jia",
	"87F2": "chong",
	"8B70": "yi",
	"9630": "pi",
	"5325": "fan",
	"7885": "jun",
	"7B8B": "jian",
	"82A0": "wen",
	"893A": "die",
	"9F6D": "chu",
	"5383": "han",
	"5D32": "huang",
	"64C9": "chuo",
	"70B8": "zha",
	"81A9": "ni",
	"98BA": "yang",
	"9ACA": "cuo",
	"5A37": "chui",
	"632D": "geng",
	"6CA1": "mei;mo",
	"8FA1": "bian",
	"946E": "bo",
	"98A0": "dian",
	"5F65": "yan",
	"80BF": "zhong",
	"84F9": "yu",
	"915B": "none",
	"9498": "xing",
	"5585": "yu",
	"65AB": "zhuo",
	"6AC4": "chun",
	"6AD3": "lu",
	"6FDC": "jin",
	"8A51": "tuo",
	"9BC2": "none",
	"6D70": "li",
	"6E05": "qing",
	"8B42": "chan",
	"9504": "chu",
	"70BE": "ping",
	"74FA": "chang",
	"7637": "suo",
	"7A7F": "chuan",
	"9045": "chi",
	"64D4": "dan",
	"6E56": "hu",
	"7103": "lang",
	"7C29": "lao",
	"93A4": "huang",
	"6201": "nan",
	"6A1E": "shu",
	"67EC": "jian",
	"8B7F": "hui",
	"518C": "ce",
	"5B83": "ta",
	"749D": "gui",
	"9DF7": "zun",
	"9F58": "xie",
	"6546": "ge",
	"6619": "tan",
	"6EE1": "man",
	"8D53": "geng",
	"9CB1": "fei",
	"9E03": "yi",
	"4FB5": "qin",
	"5D44": "mei",
	"61E6": "nuo",
	"55F6": "bi",
	"641F": "xian",
	"79E1": "ba",
	"7F35": "zuan",
	"8A7E": "xiong",
	"8F1E": "wang",
	"94FB": "wu",
	"5119": "qian",
	"55FB": "zhe",
	"56FE": "tu",
	"6D7A": "chong",
	"7487": "xuan",
	"7A95": "tiao",
	"8664": "yan",
	"8E3D": "ju",
	"5563": "xian",
	"5681": "di",
	"63C1": "zheng",
	"63EE": "hui",
	"65C5": "lu",
	"76CA": "yi",
	"79EB": "shu",
	"839C": "you",
	"8EEE": "ang",
	"908A": "bian",
	"979C": "ta",
	"9BE9": "lun",
	"9D45": "luo",
	"5493": "wa",
	"59C2": "fa",
	"6565": "yan",
	"96FD": "hang;yu",
	"5890": "jin",
	"630F": "dong",
	"6752": "ren",
	"6B77": "li",
	"8220": "dao",
	"8A8B": "ji",
	"4EE7": "chang",
	"66D1": "sen",
	"7A0C": "tu",
	"9158": "tou",
	"625E": "han",
	"63CE": "xuan",
	"6AB4": "huo",
	"7353": "ao",
	"6E5D": "jie",
	"7BD0": "none",
	"9F20": "shu",
	"4F4C": "ci",
	"5F1D": "ba",
	"6B55": "pen",
	"77CB": "li",
	"784A": "wei;kui",
	"5146": "zhao",
	"6790": "xi",
	"7300": "sha",
	"7E9F": "mi",
	"5824": "di;ti",
	"5A72": "none",
	"732D": "yuan",
	"755D": "mu",
	"89BB": "qu",
	"94B6": "ke",
	"98DA": "biao",
	"586A": "kan",
	"597F": "fan",
	"5F21": "jue",
	"7473": "cuo",
	"7AD6": "shu",
	"7C80": "zhang",
	"7D81": "bang",
	"8BDD": "hua",
	"572A": "ge",
	"7443": "chun",
	"83C0": "yu;wan",
	"9C40": "ji",
	"8019": "pa;ba",
	"99E3": "tao",
	"9E44": "hu;gu",
	"4E79": "gan;qian",
	"5188": "gang",
	"51D9": "duo",
	"6836": "none",
	"7152": "wei",
	"75F3": "lin",
	"7E12": "cuo",
	"8024": "ji",
	"98F4": "yi",
	"69AB": "sun",
	"7849": "lu",
	"7CD2": "bei",
	"7E42": "shuai",
	"8F90": "fu",
	"9B8D": "pi",
	"5EF4": "yin",
	"6940": "yu;ju",
	"7325": "wei",
	"7431": "diao",
	"7432": "bei",
	"8A0F": "xu",
	"8A78": "mi",
	"95DA": "kui",
	"9727": "wu",
	"4E02": "kao",
	"58BF": "yi",
	"73E2": "ken",
	"8A80": "er",
	"9098": "yu",
	"95AE": "ting",
	"59BE": "qie",
	"5A15": "lai",
	"618E": "zeng",
	"794B": "shu",
	"9CE0": "hu",
	"9DB6": "tang",
	"7ED3": "jie",
	"95E1": "chan",
	"7AC7": "dou",
	"9830": "jia",
	"9AC0": "bi",
	"5237": "shua",
	"783C": "tong",
	"7F04": "jian",
	"8EFD": "qing",
	"9C42": "jiang",
	"9EC2": "fen",
	"543E": "wu",
	"6CC9": "quan",
	"738E": "ding",
	"82E4": "pie",
	"8969": "shu",
	"64E0": "ji",
	"7E2A": "bi;bie",
	"85BA": "qi;ji",
	"87FE": "chan",
	"882C": "long",
	"8D82": "chen",
	"54B5": "kua",
	"56F3": "tu",
	"770A": "mao",
	"7BB2": "xian",
	"8D1C": "zang",
	"9764": "pao",
	"9AF6": "rong",
	"5575": "bo",
	"7BE2": "gong",
	"7CBC": "lin",
	"992B": "hun",
	"9B80": "tuo",
	"5078": "tou",
	"537B": "que",
	"66AD": "hao",
	"75FB": "min",
	"7DB0": "wan",
	"8036": "ye",
	"8231": "cang",
	"57A1": "fa",
	"5B06": "xi",
	"5D1B": "jue",
	"9971": "bao",
	"567C": "pi",
	"8734": "yi",
	"6B2A": "chu",
	"775F": "sui",
	"8135": "gu",
	"55C5": "xiu",
	"5A2F": "yu",
	"6472": "shan",
	"740F": "lian",
	"75C5": "bing",
	"81A6": "lin",
	"4FE8": "yan",
	"6E3C": "mei",
	"6F3D": "ti",
	"739F": "min;wen",
	"8072": "sheng",
	"96D8": "huo",
	"9F93": "long",
	"53E8": "tao;dao",
	"6DD2": "qi",
	"7FF7": "lin",
	"84AD": "chu",
	"8626": "ling",
	"901A": "tong",
	"5C20": "xian",
	"6C4A": "cha",
	"73D5": "li",
	"7EA5": "he;ge",
	"9A31": "xi",
	"5D3A": "yi",
	"7DBE": "ling",
	"8793": "qin",
	"8CDD": "chen",
	"9B25": "dou",
	"9B73": "za",
	"513E": "nang",
	"5F79": "yi",
	"8D71": "zou",
	"5FBB": "wei",
	"74A3": "ji",
	"7A79": "qiong",
	"83B2": "lian",
	"880D": "xie",
	"8876": "zhong",
	"9803": "qing",
	"5697": "bao",
	"5FB7": "de",
	"69ED": "qi;cu",
	"7DD6": "xu",
	"8577": "yu",
	"948A": "zhao",
	"9C93": "kao",
	"5533": "li",
	"5F55": "lu",
	"71C4": "yan",
	"7F08": "miao",
	"8050": "ya",
	"8F0D": "yu",
	"9524": "chui",
	"5D22": "zheng",
	"6EB7": "hun",
	"75F0": "tan",
	"7C37": "yan",
	"82F6": "nie",
	"8E2B": "pan",
	"9B3E": "ji",
	"9DA2": "yuan",
	"545D": "e",
	"65B4": "lin",
	"6D8F": "ting",
	"7883": "qing",
	"7CEB": "huan",
	"5981": "shuo",
	"61B1": "chou",
	"731F": "lie",
	"9260": "yang",
	"96B7": "li",
	"9E77": "ling",
	"9F4D": "zi;ji",
	"515E": "mao",
	"9295": "yi",
	"518A": "ce",
	"547A": "xiao",
	"5F96": "cong",
	"6114": "yin",
	"70CD": "xian",
	"8E5C": "su",
	"9D14": "fu",
	"4F4D": "wei",
	"7760": "juan",
	"8D4A": "she",
	"62B7": "pi",
	"8645": "none",
	"95B5": "lin",
	"5A64": "chou;zhou",
	"5AB2": "pi",
	"5D67": "liu",
	"6C7B": "hu",
	"78E4": "yin",
	"5C60": "tu",
	"601F": "di",
	"8A46": "di",
	"8A4C": "gan",
	"542D": "hang;keng",
	"807E": "long",
	"830B": "di",
	"846A": "ji",
	"88A1": "ran",
	"9369": "nuo",
	"5560": "zhe",
	"5580": "ka;ke",
	"5896": "ta;da",
	"72BC": "hou",
	"8AAC": "shuo;shui;yue",
	"8F43": "zhen",
	"9170": "xian",
	"6770": "jie",
	"6F24": "lan",
	"9027": "none",
	"5FCD": "ren",
	"6A75": "none",
	"75FD": "dui",
	"77C8": "mian",
	"788C": "liu;lu",
	"8A7C": "hui",
	"9CB8": "jing",
	"8889": "tuo",
	"9AC4": "sui",
	"5661": "zhan",
	"56C2": "xiao",
	"73BD": "gou",
	"74F7": "ci",
	"75BE": "ji",
	"7C9F": "su",
	"84BE": "mi",
	"8A28": "zhi",
	"9DFA": "lu",
	"5253": "li",
	"5710": "ku",
	"8257": "yi",
	"914A": "ding",
	"4EAC": "jing",
	"6040": "chi",
	"61A5": "lao",
	"703C": "rang",
	"8074": "ting",
	"9878": "han",
	"5D57": "sui",
	"68FC": "fen",
	"8E3B": "gua",
	"4E3A": "wei",
	"64A8": "xiao",
	"65DA": "piao",
	"7823": "tuo",
	"7B71": "xiao",
	"821C": "shun",
	"8990": "jue;jiao",
	"8F78": "zhen",
	"9341": "xian",
	"7C3D": "qian",
	"8F47": "jiu",
	"9EE7": "li",
	"5922": "meng",
	"65A5": "chi",
	"7BC7": "pian",
	"72F3": "yu",
	"7B25": "si",
	"831A": "yin",
	"9079": "yu",
	"53B8": "lin",
	"5572": "di",
	"6117": "mou",
	"6B74": "li",
	"6E23": "zha",
	"7698": "qian",
	"7716": "kuang",
	"7C28": "sun",
	"54F0": "lao",
	"6A5A": "su",
	"8652": "zhi",
	"8F79": "li",
	"93EB": "li",
	"6A91": "lei",
	"71FB": "xun",
	"7219": "rang;shang",
	"7225": "zhu",
	"8A79": "zhan",
	"9D0F": "te",
	"7AF3": "deng",
	"8E2E": "dian;die",
	"9C95": "er",
	"4FB2": "zhen",
	"5FE3": "ji",
	"6E3E": "hun",
	"97CE": "mei",
	"99E1": "ma",
	"65F4": "xu",
	"6E74": "ban",
	"5573": "quan",
	"678E": "fu",
	"8558": "rao",
	"9476": "cang",
	"5269": "sheng",
	"7331": "nao",
	"892E": "ying",
	"8B31": "lou",
	"96D0": "hu",
	"557A": "tang",
	"7D70": "die",
	"8A37": "shen",
	"918F": "du",
	"5532": "er",
	"6522": "zan;cuan",
	"6ED0": "jie",
	"71A4": "yi",
	"7B7F": "xiao",
	"81C3": "yong",
	"5633": "kui",
	"6255": "fu;bi",
	"682E": "er",
	"7DB1": "gang",
	"827C": "ting",
	"8542": "sheng",
	"892A": "tun;tui",
	"8BA1": "ji",
	"5094": "qian",
	"5A50": "wo",
	"7DF9": "ti",
	"836B": "yin",
	"5226": "jie",
	"62FF": "na",
	"8E4B": "ta",
	"9729": "kuo",
	"9A2C": "cheng",
	"69B9": "si",
	"8A2D": "she",
	"9C01": "quan",
	"4E22": "diu",
	"589A": "liang",
	"60E9": "cheng",
	"65D8": "zhi",
	"73B0": "xian",
	"7527": "shen",
	"807A": "none",
	"9DD9": "zhi",
	"5964": "pan",
	"5AF0": "nen",
	"62BC": "ya",
	"9035": "kui",
	"66CF": "xiang",
	"6986": "yu",
	"6F4E": "pi",
	"732B": "mao",
	"8530": "hu",
	"89C2": "guan",
	"8EDB": "e",
	"9347": "kai",
	"619C": "duo",
	"6710": "qu",
	"7068": "gan",
	"80E4": "yin",
	"894D": "za",
	"90C6": "ji",
	"92A6": "yin",
	"9B1E": "nong",
	"577A": "ba",
	"5CD9": "zhi;shi",
	"6A18": "tang",
	"6C0A": "zhan",
	"89D7": "zhi",
	"710C": "qu;jun",
	"8533": "qian",
	"817D": "wa",
	"9D84": "jing",
	"9F0C": "chao",
	"549E": "xian",
	"6402": "lou",
	"6C49": "han",
	"858E": "mie",
	"89AF": "gou",
	"9580": "men",
	"967E": "reng",
	"5227": "jie",
	"6A7A": "none",
	"7320": "none",
	"7C68": "lian",
	"997A": "jiao",
	"5EDB": "chan",
	"713D": "none",
	"727E": "wu",
	"90A9": "huo",
	"5A42": "mian",
	"6385": "qing",
	"69E1": "none",
	"6D20": "mou",
	"74E6": "wa",
	"810A": "ji",
	"8895": "xue",
	"91C6": "bian",
	"9949": "jin",
	"5AE2": "gui",
	"91D0": "li;xi",
	"5821": "bao;bu;pu",
	"93CE": "bi",
	"9924": "tan",
	"9F39": "yan",
	"5185": "nei",
	"8CFA": "zhuan;zuan",
	"995F": "xiang",
	"9CBE": "bi",
	"591E": "none",
	"6439": "e",
	"776C": "cai",
	"92EE": "cheng",
	"529E": "ban",
	"5BF5": "chong",
	"911F": "zhuan",
	"986D": "hong",
	"67C9": "fan;bian",
	"68E8": "qi",
	"77E6": "hou",
	"8C87": "kun",
	"8CFE": "ze",
	"8D26": "zhang",
	"8DC7": "yi",
	"925F": "pi",
	"9883": "hang",
	"9967": "xing;tang",
	"6A53": "shun",
	"8B2D": "jian",
	"91B2": "nong",
	"93FC": "suo",
	"9DCA": "ni",
	"6F64": "run",
	"7F39": "fou",
	"90D6": "dou",
	"642D": "da",
	"742D": "lu",
	"7B11": "xiao",
	"83EE": "geng",
	"8D5C": "ze",
	"915D": "yun",
	"9293": "quan",
	"5A05": "ya",
	"5C02": "zhuan",
	"8B8E": "chou",
	"8C2A": "zhe",
	"9357": "ti",
	"5368": "xie",
	"6AB0": "mian",
	"74D1": "li",
	"80A9": "jian",
	"8FB7": "none",
	"7EAD": "yun",
	"8279": "cao",
	"94C0": "you",
	"968E": "jie",
	"9D06": "zhen",
	"5946": "juan",
	"5C32": "gan",
	"63A7": "kong",
	"8038": "song",
	"9CEB": "yan",
	"5D2E": "gu",
	"6549": "mi",
	"7531": "you",
	"7DAC": "shou",
	"8805": "ying",
	"6590": "fei",
	"67A3": "zao",
	"6AC8": "deng",
	"9B7B": "xia",
	"4F21": "che",
	"557F": "dan",
	"5823": "yu",
	"7323": "zong",
	"7D36": "qu",
	"8663": "bao",
	"8B09": "none",
	"5069": "fu",
	"7A62": "hui",
	"5FEF": "chi",
	"5396": "pang",
	"6290": "na",
	"71DC": "men",
	"7D85": "qin",
	"8540": "ji",
	"9111": "zi",
	"9DA0": "yan",
	"7E19": "rong",
	"85F8": "zhu",
	"8973": "xian",
	"935B": "duan",
	"4F82": "tuo",
	"56DF": "xin",
	"8EF3": "pao",
	"95FE": "lu",
	"56F8": "ri",
	"5DEB": "wu",
	"65CE": "ni",
	"6F46": "ying",
	"7137": "pi",
	"7C5F": "lai",
	"8CD7": "chuan",
	"9CF3": "feng",
	"53A4": "li",
	"6AFE": "you",
	"6E04": "fei",
	"71CE": "liao",
	"8DA1": "cui",
	"9511": "ti",
	"7271": "gu",
	"7437": "qiang",
	"8AC0": "pi",
	"92CF": "jia",
	"9F74": "xian",
	"9540": "du",
	"9939": "tang;xing",
	"9F8B": "qu",
	"6F0A": "lu;lou",
	"72B2": "chai",
	"7C7C": "xian",
	"81D1": "nao;ru",
	"822B": "fang",
	"8E87": "chu",
	"9629": "sheng",
	"5499": "long",
	"6438": "zhen",
	"6C00": "lu",
	"86AA": "dou",
	"94F7": "ru",
	"9650": "xian",
	"5542": "nou",
	"5B82": "rong",
	"5C10": "ji",
	"7EB5": "zong",
	"84A2": "chu",
	"8CA3": "te",
	"9582": "shuan",
	"9E54": "su",
	"54F7": "le",
	"593B": "none",
	"5C35": "gan",
	"7901": "jiao",
	"7DC5": "zou",
	"92E6": "ju",
	"513C": "yan",
	"562F": "xiao",
	"63AB": "zou",
	"6B8F": "qiu",
	"79D1": "ke",
	"7FAE": "geng",
	"8081": "zhao",
	"8528": "jun",
	"934E": "tu",
	"5F50": "ji",
	"6054": "xiao",
	"76B6": "zha",
	"8EA0": "xie",
	"5766": "tan",
	"5D59": "ke",
	"6188": "qu",
	"8732": "wei",
	"507C": "jie",
	"6A37": "cong",
	"82BC": "mao",
	"921F": "shi",
	"9DED": "fan",
	"62A8": "peng",
	"7306": "fei",
	"7672": "dian",
	"7972": "jin",
	"850D": "lu",
	"9EBC": "ma;me;mo",
	"4F52": "yang",
	"5CD3": "yi",
	"5DD7": "yan",
	"6D9B": "tao",
	"9EBB": "ma",
	"5694": "ti",
	"5C46": "jie",
	"6D80": "xian",
	"6F3F": "jiang",
	"70EE": "none",
	"7ABD": "none",
	"8AFE": "nuo",
	"9EDD": "you",
	"5D66": "ai",
	"6584": "li",
	"6E5B": "zhan",
	"8ADA": "pian",
	"975A": "jing;liang",
	"9E23": "ming",
	"5A55": "jie",
	"63BD": "peng",
	"65FE": "chun",
	"69A7": "fei",
	"88E6": "fou",
	"9256": "tong",
	"4E76": "fu",
	"6CE0": "ling",
	"939A": "chui",
	"83B4": "wo;zhua",
	"860D": "xun",
	"89CC": "di",
	"8B96": "chen",
	"61D8": "chi",
	"7A23": "su",
	"9770": "wu",
	"9C4E": "jiao",
	"57D6": "none",
	"5E43": "wei",
	"64B6": "none",
	"8788": "yuan",
	"4FD4": "xian",
	"52CF": "bu",
	"62C6": "chai;ca",
	"63BB": "sao",
	"8094": "yi",
	"951D": "de",
	"55B0": "shi;si",
	"5858": "tang",
	"60F7": "chun",
	"6928": "none",
	"725D": "pin",
	"6307": "zhi",
	"70F5": "zhuo",
	"7227": "ling",
	"7AF7": "kan",
	"5A33": "li",
	"7120": "cui",
	"7B84": "bi",
	"8E53": "liu",
	"4E4E": "hu",
	"742C": "wan",
	"7B6B": "zhi",
	"8BD8": "jie",
	"8E33": "chun",
	"9D46": "none",
	"704F": "hao",
	"7826": "zhai",
	"8944": "xiang",
	"924D": "bi",
	"5421": "bi;pi",
	"5AB8": "chi",
	"5E31": "chou;dao",
	"6B5D": "yi",
	"7F1C": "zhen",
	"954D": "nie",
	"4EA6": "yi",
	"67F3": "liu",
	"6A11": "liang",
	"8C92": "tuan",
	"97EE": "jiu",
	"588E": "guo",
	"766F": "qu",
	"4EE3": "dai",
	"6E49": "tian",
	"6F63": "min",
	"9294": "pi",
	"9BF9": "xing",
	"4F6D": "xiang",
	"50B4": "yu",
	"796F": "zhen",
	"7C9C": "tiao",
	"839F": "han",
	"8A55": "ping",
	"9395": "tang",
	"9417": "jian",
	"572C": "wu",
	"6131": "none",
	"6E3F": "nai",
	"7BE9": "shai",
	"7E89": "zuan",
	"56D0": "za",
	"6AF0": "huai",
	"78F2": "qu",
	"7978": "huo",
	"90A3": "nei;na",
	"9269": "xi",
	"944B": "qing",
	"5527": "ji",
	"6D6E": "fu",
	"8497": "lang",
	"8B7B": "ying",
	"61A8": "han",
	"6E37": "yan",
	"6F71": "none",
	"7EFB": "quan",
	"537E": "e",
	"7A6B": "huo",
	"7F9F": "qiang",
	"8473": "wei",
	"8C7B": "han",
	"9922": "bu",
	"4EC2": "le",
	"595C": "fei",
	"620B": "jian",
	"9C78": "lu",
	"6C45": "mian",
	"9ABB": "kua",
	"5B07": "hui",
	"6C1D": "nei;nai",
	"9384": "ai",
	"9648": "chen",
	"97E8": "fu",
	"57FE": "ju",
	"6032": "bing",
	"70AE": "pao;bao",
	"7DC7": "zi",
	"8E1A": "lun",
	"9905": "bing",
	"9C2F": "ruo",
	"9F30": "nian",
	"520A": "kan",
	"6AA4": "dao",
	"6CA6": "lun",
	"712A": "qiong",
	"7A16": "bang",
	"7AD1": "hong",
	"8D2D": "gou",
	"6952": "si",
	"79B1": "dao",
	"927F": "jia;ha",
	"688D": "zao",
	"700E": "mie",
	"8380": "chen",
	"9C0F": "bi",
	"52EA": "qiao",
	"59DF": "gai",
	"731B": "meng",
	"7407": "xiu",
	"78BD": "gong",
	"9DFF": "pi",
	"4E94": "wu",
	"4FC4": "e",
	"7178": "bian",
	"9A77": "si",
	"7211": "jue",
	"85B6": "mai",
	"8BE7": "cha",
	"8379": "bu",
	"96C0": "que;qiao",
	"9F44": "zha",
	"5F22": "tao",
	"7BFF": "zhuan",
	"812B": "tuo",
	"89CA": "ji",
	"5DBD": "yue",
	"6876": "tong",
	"6921": "none",
	"6DE1": "dan",
	"70F2": "che",
	"55BD": "lou",
	"63DB": "huan",
	"67E8": "none",
	"73AC": "dan",
	"7964": "yu",
	"7B9E": "qian",
	"8117": "wen",
	"8919": "bei",
	"973F": "meng",
	"9A8F": "jun",
	"9E81": "cu",
	"5A66": "fu",
	"6C01": "mu",
	"7DDF": "zhong",
	"80AC": "you",
	"83DC": "cai",
	"89F7": "xue",
	"8CB2": "zi",
	"9B4C": "qi",
	"5D82": "zhang",
	"8082": "si",
	"96A5": "deng",
	"63A0": "lue",
	"6EC6": "he",
	"73D9": "gong",
	"774F": "kun",
	"81BE": "kuai",
	"9772": "qin",
	"99E8": "xun",
	"9ECA": "xi",
	"5D9E": "duo",
	"6D1E": "dong",
	"77B2": "xu",
	"5009": "cang",
	"53CF": "guai",
	"6B16": "lan",
	"83C7": "gu",
	"8ADC": "die",
	"95AD": "lu",
	"9DCF": "zhen",
	"5BD3": "yu",
	"888F": "zuo",
	"8B1D": "xie",
	"5CA1": "gang",
	"61A0": "jue",
	"6890": "bi",
	"6CED": "fu",
	"71B3": "man",
	"7E31": "zong",
	"8EA3": "qu",
	"5ACC": "xian",
	"60C8": "guo",
	"619D": "dui",
	"64D2": "qin",
	"72DB": "bo",
	"7AD8": "ju",
	"7ED2": "rong",
	"7F10": "xian",
	"80DE": "bao",
	"9984": "hun",
	"6B82": "cu",
	"7D86": "geng",
	"8161": "gua;luo",
	"6E1B": "jian",
	"7D8F": "sui",
	"83F3": "jin",
	"840F": "dan",
	"8CA1": "cai",
	"5E7C": "you",
	"6DA6": "run",
	"716A": "qiu",
	"8F16": "zhou",
	"928E": "qiong",
	"5E37": "wei",
	"6784": "gou",
	"6E98": "ke",
	"76FC": "pan",
	"9CBC": "fen",
	"9D2F": "er",
	"5917": "yuan",
	"59FB": "yin",
	"6FF3": "qian",
	"83BA": "ying",
	"8FC8": "mai",
	"924C": "he",
	"5322": "hu",
	"5A2C": "wu",
	"72A0": "xi",
	"7763": "du",
	"7C4A": "ti",
	"898F": "gui",
	"8DB1": "zan",
	"560C": "piao",
	"5BEC": "kuan",
	"582D": "huang",
	"630A": "nong;long",
	"6674": "qing",
	"71B2": "jiong",
	"868F": "yue",
	"50A2": "jia",
	"50CD": "dong",
	"59A5": "tuo",
	"5AAC": "bao",
	"6751": "cun",
	"73C3": "ran",
	"96D4": "chou",
	"9FA0": "yue",
	"54C5": "xiong;hong",
	"63BE": "yuan",
	"9E10": "di",
	"4F26": "lun",
	"5600": "di",
	"6018": "hu",
	"60A6": "yue",
	"738C": "qiu",
	"8201": "yu",
	"91BF": "mi",
	"55C3": "he",
	"5914": "kui",
	"6092": "yi",
	"79AB": "xuan",
	"830C": "chi",
	"955A": "beng",
	"4F93": "lu",
	"5639": "liao",
	"599E": "niu",
	"6F11": "gai",
	"7858": "none",
	"8B98": "zhe",
	"9362": "fu",
	"9859": "sang",
	"5C23": "wang;you",
	"7267": "mu",
	"8D37": "dai",
	"5E2E": "bang",
	"7A80": "zhun",
	"7AEE": "ping",
	"7C8A": "bi",
	"4E4D": "zha",
	"50BB": "sha",
	"5258": "qi",
	"800D": "shua",
	"6DDB": "zhi",
	"7525": "sheng",
	"761D": "guan",
	"7845": "gui;huo",
	"7A70": "rang",
	"957C": "qu",
	"8057": "lie",
	"9A9A": "sao",
	"9B12": "zhen",
	"5649": "dan",
	"73A8": "jue",
	"9308": "juan",
	"56ED": "yuan",
	"5B27": "jin",
	"5F1B": "chi",
	"69AC": "yuan",
	"6A77": "dou",
	"741D": "wen",
	"72EA": "tong",
	"8131": "tuo",
	"9CA9": "huan",
	"55DE": "zi",
	"5C01": "feng",
	"647C": "keng",
	"7F45": "xia",
	"8234": "ze",
	"832C": "cha;zha",
	"8378": "bi",
	"8D77": "qi",
	"91E9": "fan",
	"550F": "xi",
	"5E39": "sha",
	"894A": "zui",
	"8F5B": "dui",
	"96E3": "nan",
	"9C97": "zei",
	"5DA2": "yao",
	"6126": "kui",
	"6AAE": "tao",
	"8508": "biao;piao",
	"91C9": "you",
	"9669": "xian",
	"9C74": "mie",
	"4F60": "ni",
	"70D1": "yao",
	"81F2": "nie",
	"960A": "chang",
	"613B": "sun",
	"6629": "mo",
	"8021": "chu",
	"8F71": "gu",
	"622B": "yu",
	"711F": "xi",
	"8F7F": "jiao",
	"9D05": "huan",
	"9D20": "dan",
	"4E20": "qiu",
	"8879": "qi;zhi",
	"971F": "hong",
	"9A97": "pian",
	"9E5A": "ci",
	"54D4": "bi",
	"7AB7": "liao",
	"9472": "xiang",
	"5643": "pan",
	"6125": "none",
	"6310": "ru;na",
	"6F87": "lao",
	"7622": "ban",
	"506C": "zong",
	"53BA": "qu",
	"5ABD": "ma",
	"80E9": "ka",
	"841E": "none",
	"8A81": "beng",
	"8EC3": "duo",
	"931A": "zheng",
	"987E": "gu",
	"5EFF": "nian",
	"692B": "shan",
	"6AA6": "biao",
	"7EE2": "juan",
	"8CCA": "zei",
	"924E": "sheng",
	"4FD0": "li",
	"50C3": "bei",
	"542F": "qi",
	"5C92": "qian",
	"9F4E": "ji",
	"7031": "ji",
	"7F55": "han",
	"8BE8": "hun",
	"9E73": "guan",
	"885C": "dao",
	"96CA": "gou",
	"9A4E": "lin",
	"5F2E": "quan",
	"666A": "tian",
	"6A6F": "lao",
	"9BFC": "zong",
	"4EC7": "chou;qiu",
	"4FF5": "biao",
	"5353": "zhuo",
	"6056": "sai;si",
	"63A8": "tui",
	"6906": "chou",
	"758A": "die",
	"8C1A": "yan",
	"8E48": "dao",
	"91DD": "zhen",
	"5F5A": "hui",
	"782E": "nu",
	"7D94": "hu",
	"83E2": "bao",
	"8406": "bei;bi",
	"5A13": "wei",
	"69C5": "ge",
	"80DA": "pei",
	"9032": "jin",
	"9DA3": "pian;bin",
	"5C04": "she;shi;ye",
	"5C2C": "ga",
	"6199": "xi",
	"6ED6": "sui",
	"80D0": "ku",
	"81A8": "peng",
	"84B7": "yun",
	"866E": "ji",
	"5357": "nan",
	"5850": "su",
	"5AEF": "ao",
	"5B36": "none",
	"70E8": "ye",
	"6276": "fu",
	"63F0": "chong",
	"65D1": "yi",
	"6FE4": "tao",
	"767B": "deng",
	"90D2": "lang",
	"57B5": "an",
	"6941": "he",
	"8FB4": "zhen",
	"4E70": "mai",
	"5D19": "lun",
	"6FD7": "mi",
	"7311": "kun",
	"7CD7": "qiu",
	"890C": "kun;hui",
	"559D": "he",
	"8F03": "jiao",
	"9743": "huo;sui",
	"5886": "di",
	"7365": "xi",
	"78ED": "chuo",
	"8C02": "shen",
	"8E98": "long",
	"965D": "shan;xia",
	"5F40": "gou",
	"7BED": "long",
	"82E3": "ju;qu",
	"54FB": "han",
	"5C03": "fu",
	"637F": "xi;qi",
	"7471": "tian",
	"761B": "chi",
	"78A5": "bian",
	"4F38": "shen",
	"682F": "yu",
	"6D23": "mi",
	"7A01": "kao",
	"7A2C": "nuo",
	"8834": "none",
	"9E08": "ye",
	"6575": "di",
	"7618": "lou",
	"777E": "gao",
	"9031": "zhou",
	"9445": "heng",
	"502E": "luo",
	"82CC": "chang",
	"9DA5": "mei",
	"4E52": "ping",
	"507E": "fen",
	"5FF9": "wang",
	"606B": "dong;tong",
	"8EE7": "di",
	"9101": "bei",
	"9BC5": "ting",
	"5193": "gou",
	"526A": "jian",
	"8F0F": "you",
	"544A": "gao;gu",
	"74D2": "zan",
	"82BD": "ya;di",
	"8F4C": "none",
	"5B00": "gui",
	"66EF": "chu",
	"73F7": "wu",
	"746A": "ma",
	"96D2": "luo",
	"6F3C": "cui",
	"841D": "luo",
	"9D6E": "qian",
	"5442": "lu",
	"5C1E": "liao",
	"5CA3": "gou",
	"651F": "jun",
	"866F": "qiu",
	"87B6": "qu",
	"92CB": "chan",
	"99B1": "tuo;duo",
	"7B3A": "jian",
	"8B73": "nou",
	"8F80": "zhou",
	"5EFE": "gong",
	"6BBB": "ke;qiao",
	"78D3": "dui",
	"8037": "da",
	"9E7C": "jian",
	"5EE5": "guai",
	"6FF7": "fei",
	"7FEE": "he",
	"9B3C": "gui",
	"57C1": "cen",
	"6ED9": "hui",
	"7822": "ke",
	"9AA3": "zhan;chan",
	"9CFC": "wen",
	"87F6": "cheng",
	"8F7B": "qing",
	"9399": "shuo",
	"9738": "ba",
	"5C6A": "liao",
	"795F": "sui",
	"5A6D": "ya",
	"6861": "rao",
	"7D0B": "wen",
	"8ACF": "zou",
	"91CF": "liang",
	"669A": "yao",
	"6DBD": "hun",
	"76E1": "jin",
	"86EB": "gui",
	"8D11": "gan",
	"90A4": "none",
	"9515": "a",
	"69E8": "guo",
	"6E76": "quan",
	"711E": "chun",
	"54A6": "yi",
	"5930": "gao",
	"5B95": "dang",
	"5D65": "jie",
	"6D6A": "lang",
	"9192": "xing",
	"9B43": "ba",
	"9C43": "qiu",
	"4E59": "yi",
	"58FA": "hu",
	"5E4E": "mi",
	"6907": "ju",
	"6F05": "jiao",
	"7429": "chang",
	"597C": "cha",
	"7792": "man",
	"93F9": "qiang",
	"9981": "nei",
	"811A": "jiao;jue",
	"9F54": "chen",
	"75A6": "jue",
	"7C95": "po",
	"7D62": "xuan",
	"4F27": "cang;chen",
	"6840": "jie",
	"7277": "quan",
	"7447": "dai",
	"81FC": "jiu",
	"883E": "zhu",
	"90DE": "lang",
	"6DB1": "zhang",
	"70C8": "lie",
	"82D6": "di",
	"8B74": "qian",
	"99FD": "xuan",
	"4FE7": "none",
	"5B38": "shen",
	"6E93": "lian",
	"7FD3": "xie",
	"83F2": "fei",
	"8B80": "du;dou",
	"9A8A": "li",
	"9CE6": "yi",
	"4F54": "zhan",
	"5001": "zhi",
	"7047": "cong",
	"7220": "none",
	"81EE": "ji",
	"84CD": "shi",
	"4E7F": "zhi",
	"5205": "chuang",
	"543B": "wen",
	"5A51": "rui",
	"6833": "lao",
	"6905": "yi",
	"8249": "wei",
	"9075": "zun",
	"6D47": "jiao",
	"6F3B": "liao",
	"7ADE": "jing",
	"554B": "xiao",
	"8673": "di",
	"5D02": "lao",
	"79B7": "lei",
	"8E8E": "nian",
	"89F4": "shang",
	"57CA": "di",
	"70E6": "fan",
	"7C40": "zhou",
	"8075": "kui",
	"8E81": "zao",
	"5A00": "song",
	"6796": "yao",
	"7017": "xian",
	"7791": "ming",
	"86EF": "none",
	"89EE": "lu",
	"992D": "huang",
	"9F5C": "zi",
	"500D": "bei",
	"5BC0": "cai;shen",
	"6BDB": "mao",
	"7E30": "xi",
	"87B9": "jian",
	"884D": "yan",
	"9451": "jian",
	"577F": "fu",
	"5BC1": "zan",
	"931B": "ben",
	"99AC": "ma",
	"6989": "ju",
	"6FF2": "gu",
	"83F9": "zu",
	"86E7": "wang",
	"9819": "cheng",
	"5E5F": "zhi",
	"62C2": "fu;bi",
	"6A2E": "none",
	"6CC1": "kuang",
	"8286": "chai",
	"580D": "tu",
	"7D9A": "xu",
	"7E86": "mo",
	"97FF": "xiang",
	"534D": "wan",
	"5AEC": "zhe",
	"6198": "xi",
	"65C7": "pi",
	"8537": "qiang",
	"8D5F": "yun",
	"7119": "bei",
	"8470": "jun",
	"90C7": "xun;huan",
	"5F04": "nong;long",
	"6582": "lian",
	"6B06": "shuang",
	"7C7B": "lei",
	"7DDB": "ruan",
	"7FEF": "he",
	"8679": "hong;jiang",
	"9442": "xun",
	"5906": "feng",
	"6A01": "zhuang",
	"6E17": "shen",
	"77A6": "xi",
	"85AF": "shu",
	"8F29": "bei",
	"9EE0": "xia",
	"5477": "xia",
	"6605": "jie",
	"66FE": "ceng;zeng",
	"720C": "kuang",
	"8F9E": "ci",
	"8FCA": "za",
	"91D1": "jin",
	"72D2": "fei",
	"7880": "ceng",
	"8707": "zhe",
	"952C": "tan",
	"51E6": "chu",
	"5E6A": "meng",
	"65EF": "la",
	"69D1": "mei",
	"7D32": "xie",
	"8355": "jin",
	"83D1": "zai",
	"9E2E": "xiao",
	"5569": "gua",
	"57AE": "kua",
	"81B3": "shan",
	"8BC1": "zheng",
	"954F": "liu",
	"9746": "dai",
	"9F3F": "hui",
	"7DB7": "cui",
	"9902": "tian",
	"51D2": "ai",
	"6D82": "tu",
	"853F": "wei",
	"8CEF": "xiong",
	"9051": "huang",
	"91F0": "jian",
	"9F67": "nie",
	"5829": "geng",
	"6362": "huan",
	"8377": "he",
	"8A12": "ren",
	"4EEE": "jia",
	"54F1": "bei",
	"55DC": "shi",
	"72D8": "yue",
	"7C02": "guo",
	"87B2": "zhi",
	"895C": "chan",
	"8DB6": "ku",
	"9644": "fu",
	"9DBE": "han",
	"68B3": "shu",
	"7511": "zeng",
	"7E6F": "huan",
	"9616": "he",
	"9645": "ji",
	"9884": "yu",
	"5A8C": "mao",
	"6F75": "sa",
	"9190": "hu",
	"8B92": "chan",
	"8D56": "lai",
	"9D39": "ren",
	"5625": "none",
	"61C7": "ken",
	"7801": "ma",
	"9261": "ban",
	"5947": "qi;ji",
	"63B8": "dan;shan",
	"77BA": "hui",
	"78C0": "e",
	"82B7": "zhi",
	"8390": "chen",
	"89AA": "qin;qing",
	"8EB1": "duo",
	"99BE": "dan",
	"9A45": "qu",
	"5C83": "none",
	"7502": "bian",
	"799E": "gao",
	"8AE0": "xuan",
	"90AF": "han",
	"4EA4": "jiao",
	"76E9": "zhou",
	"6443": "gong",
	"69B0": "zhi",
	"6FC3": "nong",
	"72EB": "lao",
	"7545": "chang",
	"8471": "cong",
	"5763": "tang",
	"6004": "ou",
	"6CC4": "xie",
	"8158": "guo",
	"8D4F": "shang",
	"965F": "zhi",
	"69C3": "pan",
	"6B8E": "qia",
	"75EF": "guan",
	"877D": "chun",
	"5A44": "pou",
	"7C66": "zhong",
	"7E9B": "dao;du",
	"64BF": "jian",
	"6C72": "ji",
	"6CD3": "hong",
	"7F47": "zun",
	"8971": "long",
	"98D3": "ju",
	"9F0B": "yuan",
	"4E8B": "shi",
	"5E75": "jian",
	"63D9": "bian",
	"6BF4": "bi",
	"7F14": "di",
	"81BD": "dan",
	"9F7C": "chu",
	"5867": "ai",
	"5949": "feng",
	"71F8": "ru",
	"8CB8": "dai",
	"90DC": "gao",
	"97F9": "huang",
	"4FA4": "none",
	"5A9C": "zhen",
	"6CE4": "si",
	"52DC": "weng",
	"6BF3": "cui",
	"9D8F": "ji",
	"61D7": "xia",
	"6269": "kuo",
	"7470": "gui",
	"96F6": "ling",
	"9F13": "gu;hu",
	"58B2": "mu",
	"6804": "rong",
	"9134": "ye",
	"9137": "feng",
	"93C7": "xuan",
	"557B": "chi",
	"8310": "none",
	"907C": "liao",
	"5CD4": "mu",
	"73B1": "qiang",
	"75F2": "ma",
	"842B": "xiang",
	"9C87": "nian",
	"6CDD": "su",
	"8EB8": "ji",
	"903E": "yu",
	"94D2": "er",
	"4EF0": "yang",
	"5456": "li",
	"7E73": "jiao;zhuo",
	"9A49": "xu",
	"62B2": "he",
	"6666": "hui",
	"7B26": "fu",
	"908D": "yuan",
	"9B91": "bao",
	"50A4": "zai",
	"5C07": "jiang;qiang",
	"5C8B": "e",
	"5DDA": "yan",
	"7D18": "hong",
	"9F04": "zhu",
	"4ECF": "fo;fu",
	"5111": "an",
	"6C64": "tang;shang",
	"6E2F": "gang",
	"6FB5": "lian",
	"8F8E": "zi",
	"620A": "wu",
	"65C6": "pei",
	"6874": "fu",
	"7D09": "ren",
	"994E": "chi",
	"794C": "chong",
	"8F2E": "rou",
	"57F1": "shu",
	"8DD3": "zhu",
	"9168": "dai",
	"9F11": "ding",
	"54B2": "xiao",
	"5605": "kai",
	"70C1": "shuo",
	"83D9": "chui",
	"5FBC": "jiao",
	"6911": "bei;pi",
	"7645": "liu",
	"798C": "zi",
	"96AB": "fen",
	"9D23": "gu",
	"726F": "gu",
	"77B9": "ai",
	"8E69": "bie",
	"8EBE": "none",
	"9F12": "zi",
	"5426": "fou;pi",
	"5A67": "jing",
	"61E5": "zhi",
	"98FB": "tie",
	"51F1": "kai",
	"694E": "hun",
	"8273": "yan",
	"91A5": "piao",
	"93F1": "none",
	"9965": "ji",
	"5759": "jing",
	"5AA5": "pian",
	"5BE3": "hu",
	"6F16": "jiao",
	"787F": "kong",
	"7E7B": "xu",
	"8855": "tong",
	"8E84": "bi",
	"9624": "tuo",
	"9723": "yun",
	"658F": "lang",
	"65F9": "shi",
	"9C5B": "none",
	"648C": "kui",
	"9BE6": "jiu",
	"58C6": "xue",
	"6185": "tong",
	"59B2": "da",
	"7554": "pan",
	"75D1": "duo",
	"7988": "hui",
	"8568": "jue",
	"4F96": "lun",
	"5AB0": "zou",
	"65A4": "jin",
	"696C": "jie",
	"81D8": "la;xi",
	"90AA": "xie;ye",
	"5420": "fei",
	"68C4": "qi",
	"6B4A": "xiao",
	"852F": "chen",
	"8BEF": "wu",
	"5623": "beng",
	"6ADA": "lu",
	"716C": "yang",
	"77BB": "zhan",
	"8A63": "yi",
	"79E8": "zuo",
	"7C23": "kui",
	"8D4C": "du",
	"585E": "sai;se",
	"76AA": "li",
	"84FD": "bi",
	"8B77": "hu",
	"63B3": "lu",
	"6553": "duo",
	"724F": "tou",
	"7CCA": "hu",
	"8209": "ju",
	"54F6": "mi",
	"603B": "zong",
	"77C1": "chou",
	"7C10": "nian",
	"538B": "ya",
	"5F30": "shao",
	"65AE": "zhuo",
	"72C7": "yun",
	"901D": "shi",
	"9248": "she;tuo;ta",
	"92BF": "zhong",
	"53DA": "jia",
	"5586": "zhe",
	"5995": "zhong",
	"6180": "liao",
	"66BD": "lin",
	"7D9B": "none",
	"8812": "jian",
	"8847": "mo",
	"8989": "ji",
	"9391": "ye",
	"8189": "yi",
	"6F3A": "chuang;shuang",
	"7E1B": "fu",
	"8C42": "liao",
	"9AA9": "wei",
	"50EE": "tong;zhuang",
	"51F6": "xiong",
	"5729": "wei;xu",
	"74F2": "none",
	"7814": "yan",
	"7E70": "qiao;zao",
	"7EE9": "ji",
	"8202": "chong",
	"8846": "zhong",
	"9EEF": "an",
	"7D88": "ti;di",
	"8C4D": "bi",
	"8F9A": "lin",
	"4E91": "yun",
	"5795": "hou",
	"8A70": "jie",
	"8C9B": "huan",
	"5F7D": "di",
	"6C73": "bian",
	"7C03": "yi",
	"7E8F": "chan",
	"9AAE": "yi",
	"9E4C": "an",
	"54E7": "chi",
	"79B3": "rang",
	"7FE5": "zhu",
	"807B": "ji",
	"879B": "he",
	"923F": "dian;tian",
	"99DE": "tuo",
	"5315": "bi",
	"6723": "tong",
	"699D": "sha",
	"970A": "ling",
	"6C35": "shui",
	"57BE": "han",
	"6A5C": "jue",
	"7BFB": "piao",
	"8A45": "ling",
	"8E1B": "lu",
	"951F": "kun",
	"9523": "luo",
	"8702": "feng",
	"9A9C": "ao",
	"5BB9": "rong",
	"5F28": "chao",
	"5F61": "shan",
	"774A": "juan",
	"7A33": "wen",
	"810E": "sa",
	"9C6B": "ai",
	"9F32": "hun",
	"54CA": "you",
	"6929": "none",
	"740C": "ling",
	"7DA6": "qi",
	"9183": "yan",
	"992E": "tie",
	"9F26": "diao",
	"53FB": "le",
	"69DB": "jian;kan",
	"719B": "biao",
	"72E3": "zhao",
	"9765": "ye",
	"9D79": "li",
	"5B12": "wei",
	"6000": "huai",
	"6D3A": "ming",
	"6F9F": "lin",
	"8AD6": "lun",
	"6910": "ju",
	"7076": "zao",
	"8292": "mang;wang",
	"8959": "cao",
	"9188": "tan",
	"5019": "hou",
	"627A": "zhi",
	"6D14": "zhi",
	"7658": "li;ji",
	"9763": "mian",
	"5414": "ye",
	"62D0": "guai",
	"6DCB": "lin",
	"8F7D": "zai",
	"9A47": "zhi",
	"5B39": "xing",
	"8BAA": "shan",
	"98FC": "si",
	"9CAC": "yong",
	"555E": "ya",
	"6107": "wei",
	"6FAC": "zi",
	"9F8A": "chuo",
	"7FF0": "han",
	"9359": "hong",
	"5CED": "qiao",
	"7528": "yong",
	"76C2": "yu",
	"9753": "jing;liang",
	"5E90": "lu",
	"61DE": "meng",
	"63E2": "ke",
	"6495": "si",
	"7020": "ying",
	"7653": "wei",
	"76D0": "yan",
	"55D5": "ru;nou",
	"5DFF": "fu",
	"675D": "yi",
	"82EB": "shan",
	"51E9": "none",
	"527F": "jiao;chao",
	"535B": "shuai;lu",
	"54BC": "guo;kuai",
	"6E1F": "ting",
	"7735": "chi",
	"7B42": "chi",
	"837F": "cheng",
	"8741": "e",
	"88F9": "guo",
	"8A1D": "ya",
	"4EB8": "duo",
	"6777": "pa;ba",
	"67D7": "song",
	"9B44": "po;tuo;bo",
	"9ECF": "nian",
	"5135": "shu",
	"56BB": "xiao",
	"5797": "zhao",
	"747E": "jin",
	"7805": "li",
	"8076": "nie",
	"87A1": "wen",
	"8DB3": "zu;ju",
	"7479": "tu",
	"7BEF": "jian",
	"8232": "ling",
	"8650": "nue",
	"887B": "ran",
	"8F3C": "wen",
	"6615": "xin",
	"7059": "dang",
	"786C": "ying",
	"805F": "xu",
	"8F72": "ke",
	"9910": "can",
	"9EE6": "yu",
	"5056": "che",
	"5179": "zi;ci",
	"7226": "lan",
	"77EF": "jiao",
	"8678": "zi",
	"892D": "niao",
	"8940": "ji",
	"97D0": "ge",
	"56FC": "tai",
	"7B1C": "zhu",
	"88B3": "chi",
	"8F82": "lu",
	"99AE": "feng;ping",
	"5855": "weng",
	"5EBE": "yu",
	"6EC0": "chu",
	"7983": "zhi",
	"9F2C": "you",
	"55E9": "suo",
	"8028": "nou",
	"89BA": "jue;jiao",
	"8D73": "jiu",
	"9171": "jiang",
	"95B3": "chan",
	"9E02": "qi",
	"90A2": "xing",
	"6949": "ruo",
	"8CBB": "fei",
	"9D2E": "wu",
	"4FF3": "pai",
	"85A2": "xiao",
	"9130": "lin",
	"95EF": "chuang",
	"5716": "tu",
	"62ED": "shi",
	"7824": "tuo",
	"86BA": "ran",
	"981E": "e",
	"657E": "none",
	"689C": "jia",
	"68BD": "zhi",
	"6DA0": "wei",
	"7FF2": "piao",
	"8287": "mian",
	"88C1": "cai",
	"59B5": "tou",
	"7CA8": "bai",
	"907F": "bi",
	"6124": "fen",
	"6EBB": "ta",
	"78F0": "shan",
	"4FF1": "ju",
	"55C7": "se",
	"5908": "none",
	"5AC1": "jia",
	"7472": "qiang",
	"7905": "dun",
	"7D82": "tong",
	"8A93": "shi",
	"4ED9": "xian",
	"53DD": "ji",
	"88E1": "li",
	"9321": "qi",
	"529C": "ya",
	"609D": "kui;li",
	"7728": "zha",
	"8961": "shu",
	"66E3": "yan",
	"7584": "lin",
	"7671": "tan",
	"7D04": "yue;yao",
	"8657": "xu",
	"9C13": "sai;xi",
	"6109": "yu",
	"6872": "bo",
	"7863": "xiao",
	"90A1": "fang",
	"7EC5": "shen",
	"954E": "na",
	"9A79": "ju",
	"675F": "shu",
	"866D": "diao",
	"87F4": "si",
	"8C97": "ju",
	"5324": "qu",
	"68B0": "xie",
	"6DD9": "cong",
	"7A05": "shui",
	"8639": "huai",
	"909F": "kang",
	"94CA": "tuo;she;ta",
	"622E": "lu",
	"9932": "he",
	"4E9B": "xie",
	"5247": "ze",
	"5D80": "tu;die",
	"609F": "wu",
	"760F": "tu",
	"556A": "pa",
	"57AD": "ya",
	"8CC2": "lu",
	"57F8": "yi",
	"6145": "sao",
	"7302": "zhi",
	"8349": "cao",
	"9946": "bi",
	"67EA": "ao",
	"72C5": "qing",
	"7427": "e",
	"8126": "none",
	"818B": "liao",
	"852D": "yin",
	"9805": "xiang",
	"9A63": "teng",
	"5220": "shan",
	"62EF": "zheng",
	"711B": "lin",
	"8515": "di",
	"8FEA": "di",
	"9C7F": "you",
	"5C2B": "wang",
	"7F15": "lu",
	"8BA8": "tao",
	"72D0": "hu",
	"7A4D": "ji",
	"7B9B": "gu",
	"8BAB": "qi",
	"5708": "quan;juan",
	"572F": "yi",
	"583D": "gang",
	"4E34": "lin",
	"543A": "dou",
	"67CA": "zhong",
	"6BD1": "zuo",
	"6F74": "zhu",
	"9681": "yan",
	"50E0": "fan",
	"6714": "shuo",
	"7468": "jin",
	"789C": "chen",
	"7A8E": "diao",
	"512F": "teng",
	"5BE0": "ju",
	"6190": "lian",
	"6289": "jue",
	"6746": "gan",
	"67B4": "guai",
	"8A1E": "yao",
	"8A85": "zhu",
	"753E": "zai",
	"52C3": "bo",
	"6852": "sang",
	"8C90": "yu",
	"9150": "gan",
	"65FA": "wang",
	"6C97": "tian",
	"898E": "yan",
	"8D3F": "hui",
	"9212": "ji",
	"96C5": "ya",
	"9BC1": "geng",
	"5118": "jin",
	"6281": "yan",
	"64CB": "dang",
	"685E": "none",
	"8FA5": "xue",
	"9113": "ju",
	"9328": "mao",
	"552C": "hu;xia",
	"7BAE": "none",
	"504F": "pian",
	"596F": "huo",
	"789D": "ruan",
	"89E0": "quan",
	"93BA": "none",
	"6719": "ming",
	"6B70": "se",
	"6C8B": "you",
	"84B9": "jian",
	"88B2": "yi",
	"8BE4": "zheng",
	"9067": "zhang",
	"5690": "chang",
	"645E": "luo",
	"64A3": "dan;shan",
	"6614": "xi",
	"7BA9": "luo",
	"7BE6": "bi",
	"8DE8": "kua",
	"506E": "ji",
	"5E13": "ma",
	"66D8": "ru",
	"6BB0": "du",
	"9A0A": "tao",
	"4EA2": "kang",
	"5F46": "bie",
	"646A": "jiang",
	"6C63": "none",
	"78B6": "qi",
	"8073": "song",
	"90AD": "ju",
	"7046": "lan",
	"70D6": "zai",
	"7EBD": "niu",
	"82B5": "jue",
	"8364": "hun;xun",
	"519F": "shi",
	"536F": "mao",
	"5B80": "mian",
	"6D52": "hu;xu",
	"6F52": "xiang",
	"7CE8": "jiang",
	"8A35": "chi",
	"8C8C": "mao",
	"9947": "yu",
	"99B9": "ri",
	"5367": "wo",
	"608F": "qie",
	"6857": "duo",
	"7AFB": "le",
	"81C2": "bei;bi",
	"88E3": "lian",
	"93F2": "none",
	"9CB5": "ni",
	"4E0C": "ji",
	"55E6": "suo",
	"613A": "cao",
	"85A7": "kao",
	"8D7D": "jue",
	"9662": "yuan",
	"5783": "la",
	"5EE2": "fei",
	"5FF7": "xiong",
	"763F": "ying",
	"769E": "hao",
	"8218": "guan",
	"7461": "none",
	"7C73": "mi",
	"801D": "qu",
	"7E00": "jia",
	"9011": "qiu",
	"9289": "yu",
	"982F": "kui",
	"99FB": "han",
	"52A1": "wu",
	"5B26": "chou",
	"68A5": "song",
	"6B3E": "kuan",
	"97B4": "bei",
	"9AFA": "gua",
	"9E31": "chi",
	"521A": "gang",
	"5B29": "yu",
	"7B94": "bo",
	"663A": "bing",
	"7570": "yi",
	"9548": "bo",
	"89EC": "ni",
	"9427": "jian",
	"5CDE": "kui",
	"6293": "zhua",
	"6C9F": "gou",
	"8761": "ruan",
	"6AC7": "po",
	"868C": "bang;beng",
	"9BC7": "huan",
	"6F7E": "lin",
	"76B0": "pao",
	"7E98": "zuan",
	"88D5": "yu",
	"9063": "qian",
	"96BC": "sun;zhun",
	"9FA3": "jue",
	"5331": "kui",
	"5A7D": "jia",
	"7694": "han",
	"7E9A": "xi",
	"8308": "zi;ci",
	"9490": "shan",
	"7D64": "xian",
	"82E0": "min",
	"9911": "bo",
	"9CBD": "die",
	"50E8": "fen",
	"4ED6": "ta",
	"734E": "jiang",
	"753B": "hua",
	"79A9": "si",
	"80CA": "qu",
	"84C1": "zhen",
	"506A": "bi",
	"60DE": "xin",
	"78A7": "bi",
	"7EF6": "shou",
	"8ED9": "chen",
	"6C16": "nai",
	"7185": "yun",
	"845B": "ge",
	"8502": "luo",
	"8A6F": "hui",
	"8F24": "qian",
	"5B89": "an",
	"661A": "shen",
	"749B": "su",
	"894B": "ji",
	"9647": "long",
	"5243": "ti",
	"72E4": "ji",
	"7D08": "wan",
	"85CE": "jin",
	"9393": "weng",
	"9D5C": "ti",
	"580A": "e;wu",
	"6193": "hui",
	"6510": "qian",
	"669F": "kai",
	"6F6F": "xun",
	"5242": "ji",
	"7F6C": "zhuo",
	"821F": "zhou",
	"911E": "yin",
	"666E": "pu",
	"96A9": "yu",
	"548F": "yong",
	"569A": "yin",
	"958B": "kai",
	"95AA": "none",
	"55AE": "dan;chan;shan",
	"797F": "lu",
	"8785": "xi",
	"8DD5": "die",
	"594A": "xie",
	"5B6F": "jian",
	"6FF9": "bin",
	"701A": "han",
	"7D7E": "cheng",
	"55FE": "sou;zu",
	"5709": "yu",
	"7B3F": "luo",
	"8316": "ge",
	"9C49": "bie",
	"9D9E": "chun",
	"79C0": "xiu",
	"9193": "tan",
	"55B3": "zha;cha",
	"5DC8": "ju",
	"6251": "pu",
	"7E5D": "jian",
	"7FA8": "xian",
	"8153": "fei",
	"9A13": "yan",
	"4F5A": "yi;die",
	"6A1B": "jiu",
	"8F63": "li",
	"99B4": "xun",
	"9DB0": "yuan",
	"63C3": "jian",
	"65A8": "qiang",
	"665F": "sheng;cheng",
	"8412": "yan",
	"8C1C": "mi;mei",
	"8EEB": "zhen",
	"648F": "xian",
	"8042": "nie",
	"9019": "zhe;zhei",
	"9D4A": "jia",
	"5087": "rong",
	"553A": "tian",
	"625F": "shen",
	"6420": "shuo",
	"65B7": "duan",
	"88ED": "chi",
	"89DE": "shang",
	"98C2": "liao",
	"53F3": "you",
	"570E": "yuan",
	"607F": "yong",
	"832F": "fu",
	"4F9C": "zhou",
	"7155": "xi",
	"8337": "fa",
	"6041": "nen;ren;nin",
	"70EC": "jin",
	"873B": "qing",
	"8854": "xian",
	"8D6D": "zhe",
	"93A8": "sun",
	"4E1B": "cong",
	"545A": "none",
	"591A": "duo",
	"68A6": "meng",
	"80C6": "dan",
	"9BCC": "gao",
	"5112": "ru",
	"5840": "none",
	"82A3": "fou",
	"5B2B": "none",
	"5F0A": "bi",
	"83D4": "fu",
	"9D42": "xiu",
	"5EA9": "tu",
	"5F89": "yang",
	"877C": "lou",
	"91AE": "jiao",
	"9AE6": "mao",
	"737A": "ta",
	"77A5": "pie",
	"7D3A": "gan",
	"8E40": "die",
	"6074": "de",
	"61D3": "ai",
	"78EC": "qing",
	"7ACC": "chu",
	"7CD4": "xiu",
	"7D01": "cha",
	"854F": "chu",
	"8843": "pei",
	"90BF": "shi",
	"986C": "ru",
	"5373": "ji",
	"5826": "jie",
	"5DA6": "zhan",
	"609B": "quan",
	"62DE": "di",
	"6815": "zhen",
	"6B46": "xin",
	"704D": "que",
	"798F": "fu",
	"882A": "long",
	"9257": "qian",
	"92BC": "cuo",
	"9466": "none",
	"968C": "an",
	"51FE": "han",
	"5293": "yi",
	"5491": "da",
	"6643": "huang",
	"6D22": "yi",
	"8BEE": "qiao",
	"5B5F": "meng",
	"5CB5": "hu",
	"5E4A": "gong",
	"6882": "qiu",
	"6C5D": "ru",
	"73A4": "beng",
	"75D8": "dou",
	"875C": "fu",
	"87C9": "liao",
	"8F37": "hong",
	"980F": "hang",
	"6068": "hen",
	"7092": "chao",
	"709C": "wei",
	"7A45": "kang",
	"7D2C": "chou",
	"98D1": "biao",
	"5601": "qi",
	"5878": "ou",
	"7C0B": "gui",
	"8D19": "xuan",
	"94EC": "ge",
	"9CD2": "jian",
	"9DE4": "tan",
	"9F3E": "han",
	"67CF": "bo;bai",
	"6F92": "hong",
	"700C": "biao",
	"86E2": "ping",
	"8820": "mi",
	"88DF": "sha",
	"62CB": "pao",
	"64AB": "fu",
	"6F12": "qiang",
	"8274": "fu",
	"96A3": "lin",
	"7BFA": "pai",
	"8ABF": "diao;tiao",
	"953C": "sou",
	"5AB9": "liu",
	"6A68": "fen",
	"7777": "jian",
	"778F": "qiong",
	"7B3B": "qiong",
	"804F": "er",
	"870C": "bi",
	"9B6A": "gai",
	"5BDA": "bao",
	"6F10": "zhi",
	"73AE": "wei",
	"9519": "cuo",
	"9CE2": "li",
	"5853": "mi",
	"7294": "xi",
	"78AA": "zhen",
	"92B3": "rui",
	"9AC5": "lou",
	"5E7B": "huan",
	"7685": "pa",
	"78D7": "none",
	"83FE": "tian",
	"993A": "bo",
	"9B19": "seng",
	"9F2E": "ting",
	"7D46": "ban",
	"8F20": "guo",
	"9367": "hong",
	"9655": "shan",
	"988F": "ke",
	"4E48": "me;ma;yao",
	"65FC": "min",
	"6DE5": "lu",
	"78D9": "gun",
	"7D8A": "xie",
	"538A": "ya",
	"5BE2": "qin",
	"6FE2": "zui;cui",
	"7055": "li",
	"77B0": "kan",
	"801A": "pi",
	"5409": "ji",
	"77A9": "zhu",
	"84BA": "ji",
	"83D8": "song",
	"8AE4": "e",
	"9090": "li",
	"4EF7": "jia;jie",
	"5A35": "ju",
	"83F7": "zhou",
	"52A7": "zhi",
	"5C91": "cen",
	"93C2": "kou",
	"9B26": "dou",
	"9CCA": "bian",
	"5EB6": "shu",
	"6F65": "su",
	"72AE": "ba",
	"8B28": "mo",
	"9003": "tao",
	"9317": "wei",
	"9671": "ju",
	"4F25": "chang;tang",
	"6B84": "tian",
	"50A3": "dai",
	"50D3": "tui",
	"59F5": "pei",
	"5BA3": "xuan",
	"6EAD": "ce",
	"8FF3": "jing",
	"68E3": "di",
	"74E1": "zhi",
	"82BB": "chu",
	"8B32": "can",
	"9D1F": "chi;zhi",
	"5DA1": "gui",
	"5E10": "zhang",
	"8778": "gua;wo",
	"8892": "tan",
	"9780": "tao",
	"5C96": "qu",
	"60B3": "de",
	"74C6": "zhi",
	"8724": "si",
	"50AE": "zao",
	"55AF": "pen",
	"61FB": "ji",
	"7895": "qi",
	"7A6F": "none",
	"7EBA": "fang",
	"9172": "cheng",
	"917B": "zui",
	"9B98": "none",
	"9F6E": "yi",
	"53ED": "ba",
	"564D": "jiao",
	"6786": "mao",
	"67D6": "zhao",
	"7192": "ying",
	"7284": "ji",
	"73A2": "bin;fen",
	"8630": "none",
	"8C99": "chu",
	"95CD": "du;she",
	"5893": "mu",
	"5D11": "kun",
	"9915": "jun",
	"662D": "zhao",
	"850A": "han",
	"8E1F": "chi",
	"4F1B": "yu",
	"67C8": "ban",
	"7A09": "jing",
	"7B07": "suan",
	"7C55": "zhou",
	"7F20": "chan",
	"8C88": "he",
	"93E3": "shu",
	"93F8": "hui",
	"51A9": "xie",
	"5929": "tian",
	"76A4": "po",
	"7D98": "feng",
	"8049": "wa",
	"96C8": "huan",
	"54CC": "pai",
	"553E": "tuo",
	"6410": "chu",
	"7971": "shui",
	"7A61": "se",
	"9584": "huo",
	"9721": "mai",
	"99A3": "yan",
	"9DE5": "si",
	"9DF6": "mai",
	"6395": "ling",
	"6CFA": "luo;po",
	"78C3": "si",
	"826E": "gen",
	"9237": "gu",
	"51F3": "deng",
	"5E3D": "mao",
	"76C8": "ying",
	"7CA6": "lin",
	"8823": "li",
	"8EED": "kuang",
	"939D": "ta",
	"9930": "jian",
	"578C": "tong;dong",
	"59E2": "juan",
	"5A5D": "dian",
	"63E8": "cheng",
	"8816": "huo",
	"8AAB": "zhen",
	"93E0": "feng",
	"98EC": "juan",
	"9F22": "fen",
	"61C8": "xie",
	"63A9": "yan",
	"6556": "ao",
	"71D7": "lan",
	"7C24": "dai",
	"8705": "fu",
	"5DD2": "luan",
	"9B42": "hun",
	"585A": "zhong",
	"8933": "lian",
	"93E9": "jian",
	"949E": "chao",
	"9768": "ye",
	"64A2": "dan",
	"6AD7": "mie",
	"9A3F": "zhang",
	"6FD5": "shi",
	"8D1D": "bei",
	"9896": "ying",
	"5F8C": "hou",
	"89EA": "xing",
	"8C74": "di",
	"93E1": "jing",
	"9A8B": "cheng",
	"5789": "pao",
	"6835": "li",
	"6903": "hao",
	"799C": "yong",
	"92D4": "wan",
	"5B24": "ma",
	"5F23": "fu",
	"695D": "lian",
	"6D0D": "si",
	"73BF": "shao",
	"73D7": "xian",
	"7ACB": "li",
	"8BA0": "yan",
	"96EF": "wen",
	"50F4": "xian",
	"79B5": "ti",
	"7CDE": "fen",
	"5216": "yue",
	"7E69": "sheng",
	"8105": "xie",
	"87E8": "jue",
	"8A3F": "zi",
	"4E0A": "shang",
	"56E4": "dun;tun",
	"6377": "jie",
	"949B": "tai",
	"9E0C": "hu",
	"6649": "jin",
	"90C8": "hou",
	"5FC6": "yi",
	"6CEA": "lei",
	"882F": "pi",
	"8BB5": "ju",
	"96B5": "xi",
	"9EA5": "mai",
	"6DCE": "peng",
	"7334": "hou",
	"7501": "ping",
	"9E0E": "ying",
	"56BC": "jiao;jue",
	"68F1": "leng;ling",
	"69C6": "xun",
	"7BE3": "pang",
	"90DB": "fu",
	"63AF": "ken",
	"7626": "shou",
	"7A57": "sui",
	"7F97": "qiang",
	"9F5F": "ju",
	"8B1A": "shi;yi",
	"5892": "shang",
	"5F06": "ju",
	"6EFE": "gun",
	"7025": "hao",
	"7E92": "chan",
	"7F2A": "mou;miao;miu",
	"861C": "ju",
	"8811": "rong",
	"8C41": "huo;hua",
	"95C9": "yin",
	"6D2E": "tao",
	"7B5C": "dang",
	"811F": "lie",
	"982C": "jia",
	"9B88": "ju",
	"9CFA": "fu",
	"9F1B": "gao",
	"6ABD": "er",
	"6FA5": "xie",
	"939C": "pan",
	"6B58": "hu",
	"8365": "ying;xing",
	"5555": "tao",
	"61BC": "jing",
	"7CB4": "li",
	"8DE0": "yi",
	"50F2": "xian",
	"7CD1": "nuo",
	"7FEC": "hui",
	"861B": "yu",
	"68F4": "fu",
	"6F2D": "mang",
	"835D": "ce",
	"91EA": "yu",
	"5592": "zan",
	"76F6": "wan",
	"78A8": "wei",
	"8D7E": "qin",
	"58CB": "dang",
	"678D": "yi",
	"7537": "nan",
	"85A1": "ding",
	"985C": "jiang",
	"52BF": "shi",
	"5842": "gang",
	"69E2": "xi",
	"9AAF": "ang",
	"6F9C": "lan",
	"70FC": "hu",
	"7229": "yu",
	"85B9": "tai",
	"8CCB": "jiao",
	"9310": "zhui",
	"6105": "ge",
	"63DE": "an",
	"7312": "yan",
	"820C": "she",
	"86F3": "si",
	"87C7": "ma",
	"9012": "di",
	"91C8": "shi",
	"9784": "pao",
	"52EE": "ju",
	"5A6C": "yin",
	"694A": "yang",
	"80AD": "na",
	"91FE": "ye",
	"6C56": "pai",
	"6E6E": "yin;yan",
	"83F5": "wang",
	"88F8": "luo",
	"892F": "jie",
	"8E50": "ji",
	"902A": "cuo",
	"9243": "shi",
	"9D04": "pi",
	"5599": "hui",
	"57DD": "nian",
	"5ADB": "yi",
	"5D9C": "jin",
	"6980": "pin",
	"699C": "bang",
	"7E7F": "jian;kan",
	"8048": "you",
	"5011": "men",
	"58C4": "ye",
	"724C": "pai",
	"728E": "feng",
	"8E91": "zhi",
	"574C": "ben",
	"5F8B": "lu",
	"61F7": "huai",
	"6627": "mei",
	"750C": "ou",
	"88A3": "yi",
	"7BAD": "jian",
	"6C69": "gu",
	"936B": "qiao",
	"97C8": "wa",
	"515F": "xin",
	"5197": "rong",
	"7733": "ming",
	"9F43": "ge",
	"53BD": "lei",
	"664A": "zhi",
	"7CE2": "mo",
	"7FA9": "yi",
	"824C": "nian",
	"8F34": "chun",
	"58EC": "ren",
	"7A2A": "fu",
	"9263": "jie",
	"9D03": "jue",
	"5734": "zhuo;shao",
	"5E2D": "xi",
	"6424": "e",
	"655A": "duo",
	"6CB6": "yi",
	"6D78": "jin",
	"89A9": "du",
	"9408": "qiao",
	"9A20": "ti",
	"9D93": "miao",
	"9E58": "gu;hu",
	"5BE7": "ning",
	"62FC": "pin",
	"65B9": "fang",
	"6A66": "tong;chuang",
	"77ED": "duan",
	"7CE6": "chi",
	"969B": "ji",
	"9711": "zhan",
	"8D40": "zi",
	"9BDA": "ji",
	"5758": "di",
	"5ABF": "kui",
	"725C": "cheng",
	"7C89": "fen",
	"92EC": "shi",
	"51CB": "diao",
	"67C7": "he",
	"8DCC": "die",
	"991F": "zhui",
	"9E00": "shu",
	"667C": "wan",
	"6977": "kai;jie",
	"7151": "zhu",
	"7187": "he",
	"7F17": "min",
	"8DF8": "bi",
	"9C00": "huan",
	"631D": "wo;zhua",
	"677C": "zhu",
	"9A7E": "jia",
	"5484": "duo",
	"5871": "lang",
	"5ED4": "lou",
	"663B": "ang",
	"530E": "an",
	"6B25": "yu",
	"782B": "zhu",
	"787C": "peng",
	"7A8A": "yu",
	"7C9E": "xi",
	"8BCB": "di",
	"93D5": "lu",
	"9913": "e",
	"5839": "zhong",
	"625D": "ku",
	"746D": "tang",
	"93E8": "zan",
	"960F": "yan;e",
	"98C8": "biao",
	"9EA2": "ling",
	"5234": "duo",
	"6C8C": "dun;zhuan",
	"6D25": "jin",
	"7FB9": "geng",
	"8289": "gan",
	"85E4": "teng",
	"8962": "tan",
	"976F": "du",
	"5C7D": "han",
	"5D45": "gan",
	"6550": "chen",
	"65BD": "shi",
	"78C6": "hua",
	"7D2E": "zha;za",
	"866B": "chong;hui",
	"8AD9": "huai",
	"6A05": "cong;zong",
	"6BE7": "rong",
	"77FC": "qiang",
	"8203": "xi",
	"8A18": "ji",
	"5225": "bie",
	"8493": "chun",
	"967D": "yang",
	"57F3": "kan",
	"663E": "xian",
	"7307": "yao",
	"80EE": "pang",
	"8583": "hao",
	"8F7A": "yao",
	"9102": "e",
	"98E3": "ding",
	"5075": "zhen",
	"50A8": "chu",
	"6787": "pi",
	"7286": "zhi",
	"84A4": "tu",
	"8CF9": "ai",
	"8FE3": "zhi",
	"6313": "zha",
	"65BF": "you",
	"6F85": "hua",
	"723D": "shuang",
	"77DA": "zhu",
	"8DDB": "bo",
	"523B": "ke",
	"606D": "gong",
	"7C11": "suo",
	"58EE": "zhuang",
	"5F68": "chi",
	"7C88": "rou",
	"81FD": "xian",
	"85AC": "yao",
	"86D3": "ci",
	"87F7": "dang",
	"8D67": "nan",
	"5B69": "hai",
	"6394": "qian",
	"6EB4": "xiu",
	"72AC": "quan",
	"5D6F": "cuo",
	"622C": "jian",
	"6E18": "rou",
	"7799": "mo",
	"7B5A": "bi",
	"869E": "mu",
	"7248": "ban",
	"7D38": "zhu",
	"80DF": "mu",
	"9AE8": "kun",
	"669E": "jiao",
	"6E51": "xu",
	"75F1": "fei",
	"8CEC": "zhang",
	"8F2C": "liang",
	"9047": "yu",
	"9270": "si",
	"5084": "xia",
	"82CF": "su",
	"6386": "gang",
	"7923": "mie",
	"9800": "hu",
	"6745": "yu",
	"67F9": "shi",
	"6A40": "xi",
	"7563": "da",
	"8523": "jiang",
	"8B46": "xi",
	"5974": "nu",
	"80ED": "yan",
	"832D": "jiao",
	"9C26": "zi",
	"9E86": "zhu",
	"53EB": "jiao",
	"5E58": "ze",
	"690E": "zhui;chui",
	"7060": "lan",
	"7493": "none",
	"9CF0": "none",
	"53A0": "ce;si",
	"9B9E": "er",
	"50A5": "tang",
	"6652": "shai",
	"67DF": "nan",
	"6CD6": "mao",
	"7946": "xian",
	"953F": "ai",
	"9B8E": "nian",
	"9F84": "ling",
	"571C": "yuan;huan",
	"5812": "none",
	"5D8B": "dao",
	"60FD": "hun",
	"6657": "han",
	"76F0": "gan",
	"9157": "xu",
	"55C2": "yao",
	"585C": "peng",
	"6561": "yi",
	"6886": "bang",
	"8145": "dan",
	"9E4B": "miao",
	"6224": "gai",
	"6345": "tong",
	"6819": "xiang",
	"70F0": "fu",
	"85EB": "tan",
	"8CD2": "she",
	"8E4F": "ti",
	"9AC2": "qia",
	"6E4B": "wei",
	"79FE": "nong",
	"7B90": "qing",
	"875A": "rou",
	"8E7C": "pu",
	"9463": "biao",
	"540B": "cun",
	"5A5E": "xing",
	"6B2B": "qi",
	"78E1": "kan",
	"8DA3": "qu;cu",
	"8E86": "ju",
	"9A78": "fu",
	"742F": "guan",
	"4FA5": "jiao;yao",
	"55AB": "chi",
	"5767": "zhi",
	"636B": "men",
	"70C9": "huan",
	"74BC": "lan",
	"793A": "shi",
	"8FED": "die",
	"9BBF": "zhe",
	"53CB": "you",
	"5F52": "gui",
	"755A": "ben",
	"8594": "qiang",
	"5BAB": "gong",
	"65C3": "zhan",
	"73ED": "ban",
	"7418": "min",
	"751A": "shen",
	"7ED4": "ku",
	"9A59": "zhan",
	"9F50": "qi;ji",
	"577D": "ling",
	"585B": "li",
	"6B34": "lang",
	"6BC9": "yi",
	"7CC0": "none",
	"8C4A": "feng;li",
	"9860": "piao",
	"5B6E": "cong",
	"5E3F": "hou",
	"760D": "yang",
	"76C4": "zhao",
	"9081": "mai",
	"9C08": "die",
	"4EE2": "di",
	"57A8": "shou",
	"8BC7": "xiong",
	"9DAF": "ying",
	"6F69": "yi",
	"8008": "gou",
	"580F": "none",
	"6D1C": "none",
	"7FB5": "fen",
	"87D6": "si",
	"5FB9": "che",
	"7610": "yu",
	"9C02": "ji",
	"554F": "wen",
	"595E": "sui",
	"657B": "xiong",
	"6764": "none",
	"729C": "dun",
	"76EC": "gu",
	"7EE3": "xiu",
	"8D1E": "zhen",
	"51EF": "kai",
	"5B3D": "yuan",
	"66AC": "xie",
	"749C": "huang",
	"7DAA": "qian",
	"8898": "yi",
	"505B": "cha",
	"5998": "yun",
	"6EF1": "kou",
	"98D5": "sou",
	"9F60": "tiao",
	"582F": "yao",
	"7150": "ying",
	"7578": "ji",
	"851E": "lou",
	"98D2": "sa",
	"6437": "chen",
	"6609": "fang",
	"7C76": "shen",
	"8F4A": "wei",
	"9043": "yan",
	"615A": "can",
	"65E6": "dan",
	"680B": "dong",
	"7A73": "zan",
	"8E60": "zhi",
	"512A": "you",
	"54E9": "li",
	"5F78": "zhong",
	"677A": "xin",
	"6BDD": "none",
	"7318": "zhi",
	"7D1B": "fen",
	"7DD3": "none",
	"8C54": "yan",
	"921C": "hong",
	"9B61": "diao",
	"5E88": "qin",
	"6D02": "yi",
	"71BD": "xiao",
	"7C4F": "qi",
	"8102": "zhi",
	"8E14": "chuo",
	"58E7": "yan",
	"822E": "lu",
	"8571": "shao",
	"92F5": "tu",
	"97BD": "qiao",
	"993B": "gao",
	"9E4F": "peng",
	"6101": "chou",
	"79BA": "yu",
	"9D68": "shu",
	"5B03": "xu",
	"6B0D": "none",
	"829F": "shan",
	"9329": "chang",
	"4E9A": "ya",
	"60B7": "li",
	"630D": "jiao",
	"66AF": "mo",
	"9752": "qing",
	"9C9F": "xun",
	"5D42": "lu",
	"9479": "cuan",
	"660C": "chang",
	"7F48": "tan",
	"6545": "gu",
	"6856": "xue",
	"6AE7": "zhu",
	"777C": "ti",
	"8147": "nei",
	"83E8": "jie",
	"9C0C": "qiu",
	"62BD": "chou",
	"6BAA": "yi",
	"844B": "qu",
	"9599": "nao",
	"5EAB": "ku",
	"7AE5": "tong",
	"7E18": "xi",
	"7EC2": "fu",
	"82AA": "qi",
	"85FF": "huo",
	"65A3": "dou",
	"8AB3": "qu",
	"4E3B": "zhu",
	"4FE6": "chou",
	"58A3": "pu",
	"5BDF": "cha",
	"674E": "li",
	"6B57": "xiao",
	"7851": "peng",
	"962B": "pei",
	"52C1": "jing",
	"728F": "pian",
	"762B": "tan",
	"8AC6": "qi",
	"6708": "yue",
	"8459": "xiang",
	"915C": "none",
	"9B4B": "tui",
	"6C99": "sha",
	"7ED1": "bang",
	"58B4": "huang",
	"6223": "kui",
	"6EC2": "pang",
	"731D": "cu",
	"736C": "xie",
	"7F58": "fu;fou",
	"8619": "yi",
	"8B7D": "yu",
	"8E2F": "zhi",
	"5769": "gan",
	"5E15": "pa",
	"6624": "ling",
	"73FD": "ting",
	"83CC": "jun",
	"5C64": "ceng",
	"5E5B": "zhang",
	"60DB": "hun",
	"6C1E": "none",
	"851C": "ao",
	"650D": "ying",
	"8FAA": "none",
	"95A2": "guan",
	"6892": "han",
	"6D8C": "yong;chong",
	"7C65": "yue",
	"7E23": "xian;xuan",
	"9873": "nie",
	"9F9A": "gong",
	"511C": "neng",
	"5181": "chan",
	"5B8B": "song",
	"79EF": "ji",
	"902E": "dai",
	"92F6": "liu",
	"9501": "suo",
	"5308": "xiong",
	"5525": "none",
	"67EE": "duo",
	"7A2E": "zhong;chong",
	"9DDE": "shuang",
	"58E6": "xun",
	"5AE7": "ce",
	"6BC5": "yi",
	"7503": "zhou",
	"78DE": "peng",
	"8305": "mao",
	"870F": "you",
	"8AB1": "jie",
	"8F88": "bei",
	"9D49": "luan",
	"563F": "hei;mo;hai",
	"5EC8": "sha;xia",
	"745A": "hu",
	"8549": "jiao;qiao",
	"86F5": "xing",
	"9537": "e",
	"4E3F": "pie",
	"5BA4": "shi",
	"5C72": "wa",
	"7784": "miao",
	"77CF": "mian",
	"7C49": "tai",
	"7F34": "jiao;zhuo",
	"99F6": "ju",
	"4F12": "jin",
	"77D3": "long",
	"4F07": "yi",
	"57CF": "shan",
	"8844": "nu",
	"935A": "yang",
	"4F31": "ni",
	"684E": "zhi",
	"6C92": "mei;mo",
	"8165": "xing",
	"54BE": "lao",
	"5A01": "wei",
	"6C9B": "pei",
	"999D": "bi",
	"9A55": "jiao",
	"591D": "qing",
	"612C": "su",
	"70A4": "zhao",
	"95CC": "lan",
	"99FA": "liang",
	"50CC": "ying",
	"5203": "ren",
	"54BD": "yan;ye",
	"6F5D": "xi",
	"718F": "xun",
	"823B": "lu",
	"9871": "lu",
	"98BE": "sao",
	"9F7D": "jin",
	"5590": "yu",
	"6E9F": "ming",
	"81B4": "hu",
	"853C": "ai",
	"8600": "tuo",
	"930C": "an",
	"98CF": "yang",
	"6EF9": "hu",
	"7B44": "yao",
	"886A": "yi",
	"4F05": "dun",
	"525B": "gang",
	"6B9F": "wen",
	"7B4B": "jin",
	"98EB": "yu",
	"5081": "sou",
	"66F6": "hu",
	"6785": "ji",
	"8599": "ti",
	"5453": "yi",
	"5476": "nao",
	"6AF2": "yu",
	"904A": "you",
	"5E3C": "guo",
	"5E6B": "bang",
	"98B9": "wei",
	"58BE": "ken",
	"7847": "nao",
	"798E": "zhen",
	"8B71": "shan",
	"5D29": "beng",
	"63C2": "jiu",
	"76B8": "jun",
	"83E9": "pu",
	"951A": "mao",
	"4EEB": "mu",
	"5C3F": "niao;sui",
	"68AA": "dou",
	"6D90": "e",
	"6E46": "qi",
	"72B4": "an;han",
	"72F9": "xia",
	"7D9C": "zong;zeng",
	"964A": "duo",
	"9964": "ding",
	"5010": "shu",
	"89D8": "chao",
	"9315": "kun",
	"5FBF": "long",
	"6BFD": "jian",
	"5C75": "e",
	"6378": "tu",
	"63B9": "none",
	"75B6": "xie",
	"86B3": "chi",
	"929D": "xiu",
	"9D24": "zhong",
	"5656": "yin",
	"65B2": "zhuo",
	"6DFB": "tian",
	"7C6F": "ying",
	"7FA4": "qun",
	"9296": "zhu",
	"99D7": "zhen",
	"9F01": "qu",
	"5255": "fei",
	"56C8": "yi",
	"5C89": "wu",
	"6463": "zha",
	"69A8": "zha",
	"6A03": "lang",
	"7EB4": "ren",
	"8810": "qi",
	"8A59": "ba",
	"62D6": "tuo",
	"8180": "bang;pang",
	"81F7": "die",
	"7E0B": "zhui",
	"81B9": "fen",
	"90D8": "lu",
	"993E": "liu",
	"5123": "kuang",
	"4EB0": "jing",
	"5200": "dao",
	"5541": "zhou;zhao",
	"58F4": "zhu",
	"5E0E": "dan",
	"6DFF": "mi",
	"78CE": "xi",
	"8807": "li",
	"83D6": "chang",
	"8F4E": "jiao",
	"976E": "di",
	"9C53": "shan",
	"5682": "han",
	"61CE": "se",
	"63B7": "zhi",
	"6A28": "xi",
	"73A6": "jue",
	"743C": "qiong",
	"7D29": "zhi",
	"7D40": "chu",
	"8644": "none",
	"88C8": "kun",
	"5425": "pou",
	"5446": "dai",
	"5526": "gou",
	"6BE2": "sai",
	"7E2C": "cu",
	"803B": "chi",
	"905B": "liu",
	"91F8": "xi",
	"933A": "zhui",
	"9AE7": "dan",
	"9E4E": "bei",
	"668B": "min",
	"7381": "xian",
	"73B3": "dai",
	"794A": "beng",
	"841A": "tuo",
	"8979": "shi",
	"9488": "zhen",
	"9832": "ting",
	"4E51": "zhong",
	"547E": "da",
	"6728": "mu",
	"70ED": "re",
	"721B": "lan",
	"86AD": "ni",
	"8EC4": "zhi",
	"9A4B": "bo",
	"9ACE": "liao",
	"4FC8": "ku",
	"5F9B": "qi",
	"5D7D": "di",
	"7E07": "none",
	"8D9B": "yin",
	"6607": "sheng",
	"7709": "mei",
	"8293": "zi",
	"8A54": "zhao",
	"8EA6": "zuan",
	"9A50": "dun",
	"9C16": "tuo",
	"611D": "yan",
	"649E": "zhuang;chuang",
	"72D5": "sheng",
	"4E63": "diu",
	"57D4": "pu;bu",
	"65C9": "fu",
	"6C0D": "qu",
	"6DD1": "shu",
	"6DF0": "nian",
	"81B2": "jiao",
	"8DD9": "ju",
	"92CC": "ting;ding",
	"52A3": "lie",
	"5970": "bei",
	"717D": "shan",
	"738F": "le",
	"73EA": "gui",
	"8634": "feng",
	"8880": "jun",
	"9316": "du",
	"9F72": "qu",
	"5C5E": "shu;zhu",
	"66BA": "dan",
	"74F5": "yi",
	"7712": "shen",
	"919D": "cuo",
	"5E70": "xian",
	"820E": "she",
	"7878": "none",
	"78C4": "tang",
	"7F09": "ji;qi",
	"4E92": "hu",
	"5935": "yan",
	"6536": "shou",
	"6E09": "she",
	"70BB": "shi",
	"73E1": "qin",
	"880E": "mang",
	"5295": "zhi",
	"5306": "cong",
	"5B4D": "yan",
	"66DB": "xun",
	"74FE": "meng",
	"883D": "jie",
	"89CD": "tian",
	"8A5B": "zu",
	"950F": "jian",
	"57C2": "geng",
	"5EC2": "xiang",
	"6002": "song",
	"764B": "he",
	"9F6B": "kun",
	"78BC": "ma",
	"79D4": "jing",
	"90CC": "gui",
	"96CF": "chu",
	"9755": "zhen",
	"5DBB": "za",
	"645B": "chi",
	"693C": "yan",
	"6C76": "wen",
	"753A": "ding;ting",
	"78E0": "lu",
	"91AD": "bu",
	"64BA": "cuan",
	"656F": "hun;min",
	"7207": "ruo",
	"7BF8": "sen",
	"901F": "su",
	"9C37": "tiao",
	"85D8": "lu",
	"8AF5": "nan",
	"8B21": "yao",
	"983F": "zi",
	"9A17": "pian",
	"59A6": "feng",
	"5E0B": "zhi",
	"6868": "jiang",
	"693D": "chuan",
	"6B51": "hu",
	"782A": "mu",
	"833A": "chong",
	"5076": "ou",
	"5718": "tuan",
	"5805": "jian",
	"6166": "jiu",
	"67E3": "zhi",
	"8A50": "zha",
	"8EC9": "yu",
	"8FE6": "jia",
	"904D": "bian;pian",
	"628D": "zheng",
	"7BBF": "ji",
	"9203": "jian",
	"9365": "qie",
	"57EA": "kong",
	"5AFD": "liao",
	"7183": "wu",
	"8B53": "hui",
	"662B": "xu",
	"697D": "le;yue",
	"6ADF": "li;yue",
	"779D": "chi",
	"8C46": "dou",
	"98AC": "xia",
	"9A75": "zang",
	"5B59": "sun",
	"6222": "ji",
	"8175": "jia",
	"8A3A": "zhen",
	"927A": "er",
	"72CE": "xia",
	"8D21": "gong",
	"9C4C": "xiang",
	"4F87": "yi",
	"60CB": "wan",
	"8207": "yu",
	"8EE1": "qian",
	"51EA": "none",
	"6A4B": "qiao",
	"6BB5": "duan",
	"78A3": "jie",
	"8E45": "cha",
	"63D6": "yi",
	"71C5": "xian",
	"7830": "peng",
	"7E93": "ying",
	"91FD": "pi",
	"929C": "xian",
	"99BF": "lu",
	"679A": "mei",
	"74C4": "du",
	"81B6": "run",
	"9065": "yao",
	"959F": "bi",
	"54AE": "zhou",
	"5D55": "zong",
	"67ED": "bo",
	"7482": "qi",
	"7AF0": "shao",
	"952B": "pei",
	"574F": "huai;pi;pei",
	"846B": "hu",
	"8A84": "lei",
	"507D": "wei",
	"511B": "wu",
	"59D6": "ju",
	"88A6": "na",
	"9793": "ting",
	"9AEB": "tiao",
	"556B": "zhe",
	"63D5": "zhen",
	"67CD": "yang",
	"6C7E": "fen",
	"8187": "zhui",
	"9C07": "rou",
	"5376": "shi",
	"587B": "mo",
	"6484": "ying",
	"746E": "li",
	"7F25": "piao",
	"8BC0": "jue",
	"7A39": "zhen",
	"923A": "yu",
	"4F40": "si;shi",
	"6CC0": "si",
	"712B": "cui",
	"84E9": "wu",
	"8BA3": "fu",
	"8BC5": "zu",
	"9ECB": "kuang",
	"5CB9": "tiao",
	"67E1": "yong",
	"67F8": "pei",
	"7033": "jian",
	"8DEA": "gui",
	"6873": "ben",
	"7037": "yi",
	"93BD": "none",
	"5A14": "ke",
	"699E": "yuan",
	"7474": "jue",
	"816D": "e",
	"847F": "mei",
	"8CA9": "fan",
	"4FB7": "ju",
	"5F12": "shi",
	"57A4": "die",
	"5D1A": "leng",
	"78F7": "lin",
	"8F23": "peng",
	"9DB8": "ruo",
	"6046": "heng",
	"6DEC": "cui",
	"7007": "wang",
	"7586": "jiang",
	"7601": "cui",
	"8564": "rui",
	"93B4": "xi",
	"5D1C": "duo",
	"5FD9": "mang",
	"7276": "quan",
	"535E": "bian",
	"58F9": "yi",
	"6CEB": "xuan",
	"75A9": "cui",
	"7881": "qi",
	"8899": "pa",
	"951C": "qi",
	"4E53": "pang",
	"5E05": "shuai",
	"7521": "shen",
	"78C1": "ci",
	"5345": "sa",
	"5F80": "wang",
	"68A7": "wu",
	"6A88": "xuan",
	"8A73": "xiang",
	"8B3A": "zhe",
	"8EDD": "qi",
	"99D0": "zhu",
	"589F": "xu",
	"5B10": "xian",
	"6E11": "mian;sheng",
	"6F02": "piao",
	"6F68": "zhong",
	"729D": "tong",
	"7A31": "cheng",
	"7AA2": "xu",
	"7C5D": "ying",
	"8B67": "lian",
	"9A1E": "huo",
	"584F": "kai",
	"5DC4": "long",
	"6848": "an",
	"6B07": "she",
	"747A": "chang",
	"86DC": "yi",
	"877A": "ju",
	"59CB": "shi",
	"661B": "ju",
	"6B5C": "chu",
	"72FC": "lang",
	"8FD1": "jin",
	"6DFC": "miao",
	"7798": "kou",
	"805A": "ju",
	"82CB": "xian",
	"4FB3": "cuo",
	"5CEF": "feng",
	"6D8B": "tu",
	"6DC4": "zi",
	"8EDC": "na",
	"950E": "kai",
	"5007": "wan",
	"62F5": "tun",
	"6396": "ye;yi",
	"712C": "xi",
	"71D4": "fan",
	"73B5": "an",
	"8B0D": "ying",
	"9C03": "wei",
	"9EF8": "lu",
	"5DC3": "long",
	"5E4B": "pan",
	"6393": "shu",
	"63C5": "yan",
	"6822": "bo;bai",
	"6AED": "jie",
	"6CBB": "zhi",
	"76C5": "zhong",
	"78C5": "bang;pang",
	"4F48": "bu",
	"5EAE": "you",
	"760B": "feng",
	"96EE": "mu",
	"55CC": "ai;yi",
	"5D26": "yan",
	"7D10": "niu",
	"87CB": "xi",
	"9235": "bing",
	"562C": "zuo;chuai;zhuai",
	"8AC3": "chen",
	"928D": "zhi",
	"55B4": "wei",
	"57D8": "shi",
	"60AC": "xuan",
	"6D2A": "hong",
	"8B13": "chen",
	"9197": "fa;po",
	"91EE": "qi",
	"4F16": "tang",
	"60EB": "bei",
	"759D": "shan",
	"8C6E": "fen",
	"8EAA": "lin",
	"96AE": "ji",
	"9AFD": "zhua",
	"61BB": "tan",
	"6E44": "mei",
	"7073": "none",
	"769C": "hao",
	"7936": "guan",
	"87ED": "jiao",
	"8A75": "shen",
	"54E8": "shao",
	"57AB": "dian",
	"5FEC": "yu",
	"6357": "bu",
	"6F94": "hao",
	"773D": "mo",
	"783A": "li",
	"88FE": "ju",
	"5B50": "zi",
	"72CF": "tuo",
	"8087": "zhao",
	"885D": "chong",
	"89ED": "ji",
	"8C2D": "tan",
	"980C": "song",
	"9DC0": "ci",
	"50AC": "cui",
	"7B47": "qiong",
	"81AA": "chuai",
	"8321": "zi",
	"9024": "suo",
	"5BD2": "han",
	"7879": "song",
	"7A60": "nong",
	"8023": "lun",
	"8327": "jian",
	"872F": "bang;beng",
	"50A1": "bing",
	"592F": "hang;ben",
	"5A75": "chan",
	"783B": "long",
	"9334": "lu",
	"93ED": "xi",
	"5BCA": "zhen",
	"5D21": "han",
	"5F9A": "none",
	"6110": "mian",
	"7D7C": "zhen",
	"8B6A": "ai",
	"963C": "zuo",
	"9649": "xing",
	"4E8F": "kui",
	"849E": "li",
	"8EB4": "lang",
	"51C8": "jing",
	"6D96": "li",
	"6ED3": "zi",
	"856B": "tong",
	"9D7D": "duo",
	"6696": "nuan",
	"74B4": "none",
	"7551": "tian",
	"8B38": "ao",
	"5095": "jue",
	"5E06": "fan",
	"6F40": "cong",
	"889D": "fu",
	"9D5D": "e",
	"4E86": "le;liao",
	"58B7": "ye",
	"5AAA": "ao",
	"6121": "zong",
	"6DF4": "hu",
	"8363": "rong",
	"55E5": "hao",
	"6414": "sao",
	"671B": "wang",
	"6EA9": "wu",
	"8C2B": "jian",
	"8DF3": "tiao",
	"54DD": "nong",
	"7F12": "zhui",
	"4F0E": "ji",
	"57B7": "xian",
	"6319": "ju",
	"65F0": "gan",
	"66F5": "zhuai",
	"7FE3": "sha",
	"87A8": "man",
	"8AB6": "sui",
	"8B64": "ji",
	"8FC3": "yu",
	"9928": "guan",
	"5DA3": "qiao",
	"5E9C": "fu",
	"6147": "yin",
	"66C4": "ye",
	"8FEB": "po;pai",
	"9122": "yan",
	"92E9": "mang",
	"9B8F": "xing",
	"5036": "ju",
	"5A71": "xian",
	"5AD0": "niao",
	"609C": "cheng",
	"6FB7": "man",
	"531A": "fang;xi",
	"5FBA": "jiao",
	"7891": "bei",
	"7A92": "zhi",
	"8791": "xiu",
	"8B68": "nou",
	"93D7": "keng",
	"9676": "tao;yao",
	"538F": "zha",
	"61E4": "chou",
	"64F9": "tan",
	"6E55": "jian",
	"71F7": "lan",
	"7F9C": "zhu",
	"8148": "jing",
	"891D": "none",
	"984D": "e",
	"5C53": "xi",
	"7B19": "sheng",
	"7D2F": "lei",
	"7D6F": "hai",
	"899F": "zhi",
	"99C2": "bao",
	"4F61": "xuan;san",
	"5740": "zhi",
	"5B34": "ying",
	"67BC": "ye",
	"81CD": "qi",
	"8C80": "duo",
	"982B": "fu",
	"50B8": "qiang",
	"541F": "yin",
	"6BB8": "qing",
	"7E8D": "lei",
	"8C39": "hong",
	"5276": "juan",
	"6A59": "cheng",
	"85CC": "mi",
	"86D0": "qu",
	"955C": "jing",
	"964B": "lou",
	"4EAE": "liang",
	"5229": "li",
	"5D16": "ya;ai",
	"8EE5": "qu",
	"8F84": "zhe",
	"5508": "yi",
	"5CCE": "lang",
	"65D5": "none",
	"7128": "feng",
	"84CF": "luo",
	"8CC1": "bi;ben",
	"91B1": "fa;po",
	"5202": "dao",
	"5265": "bo;bao",
	"5B9A": "ding",
	"6075": "hui",
	"6240": "suo",
	"75B1": "pao",
	"8E5F": "ji",
	"52F1": "mai",
	"53E2": "cong",
	"7206": "bao",
	"7EF2": "gun",
	"85C9": "jie",
	"5168": "quan",
	"5FAA": "xun",
	"9ECE": "li",
	"788D": "ai",
	"8D35": "gui",
	"9734": "dai",
	"5E25": "shuai;shuo",
	"5E8A": "chuang",
	"68D2": "bang",
	"76FB": "xi",
	"8F98": "lu",
	"523C": "jie",
	"57BB": "ba",
	"8CC9": "xu",
	"9C46": "zhang",
	"50A0": "fa",
	"54BA": "xuan",
	"76C7": "he",
	"8924": "yuan",
	"916A": "lao;luo",
	"9A26": "si",
	"9002": "shi;kuo",
	"95D1": "nie",
	"9BE8": "jing",
	"4FE2": "xiu",
	"54B8": "xian",
	"65A6": "yin",
	"8824": "qiu",
	"8A8F": "lang",
	"8FCF": "ti",
	"93D3": "huo",
	"9CDD": "shan",
	"5D81": "lou",
	"93AE": "zhen",
	"5171": "gong",
	"586B": "tian",
	"5DD3": "dian",
	"743D": "du",
	"7E7C": "ji",
	"83CA": "ju",
	"8D45": "gai",
	"9029": "ben",
	"5E36": "dai",
	"8091": "di",
	"8227": "fan",
	"4FC6": "xu",
	"54EE": "xiao",
	"575E": "wu",
	"5A8D": "fu",
	"6474": "shu",
	"7B5B": "shai",
	"81E5": "wo",
	"8221": "chuan",
	"8755": "shi",
	"9F83": "ju",
	"6C05": "chang",
	"6FCF": "se",
	"7CF3": "zuo",
	"55B7": "pen",
	"5628": "xiao",
	"6322": "jiao",
	"984B": "sai",
	"8C01": "shei;shui",
	"5110": "bin",
	"5C19": "shang",
	"6EC8": "hao",
	"94EA": "ha",
	"9A95": "su",
	"9BE4": "kun",
	"7097": "guang",
	"8E7B": "qiao",
	"98E4": "si",
	"99A1": "fei",
	"50B1": "song",
	"734F": "mo",
	"8D5D": "yan",
	"8F8C": "liang",
	"98C3": "piao",
	"9F7E": "ya",
	"5731": "qian",
	"5CBF": "kui",
	"6995": "rong",
	"69F2": "hu",
	"6A30": "none",
	"7AB3": "yu",
	"7314": "zong",
	"73EB": "chong",
	"76AF": "gan",
	"868E": "yue",
	"8763": "you",
	"9EC1": "nen",
	"5CD0": "gai",
	"6B14": "jue",
	"79A1": "ma",
	"8655": "chu",
	"8714": "dian",
	"98EA": "ren",
	"51AB": "bing",
	"792E": "pao",
	"5B2C": "xu",
	"8647": "quan",
	"560E": "ga",
	"61DA": "yin",
	"68FA": "guan",
	"6E2C": "ce",
	"8DAA": "huang",
	"7B38": "po",
	"89A0": "jun",
	"8A4D": "shi",
	"9241": "zhen",
	"95D7": "guan",
	"500C": "guan",
	"60D2": "he",
	"7512": "wu",
	"8576": "ling",
	"8BE2": "xun",
	"4E29": "jiu",
	"5D88": "qiang",
	"775E": "lai",
	"78D4": "zhe",
	"843D": "luo;la;lao",
	"6A89": "cheng",
	"7390": "ba",
	"8065": "yu",
	"933F": "none",
	"57B2": "kai",
	"6301": "chi",
	"84D6": "bi",
	"8DA9": "chi",
	"8100": "cheng",
	"8309": "mo",
	"9425": "shan",
	"4F9A": "xun",
	"51BB": "dong",
	"538D": "she",
	"5817": "tu",
	"6825": "zi",
	"8E06": "qun",
	"5CA2": "ke",
	"66F8": "shu",
	"7BA4": "ju",
	"971B": "ling",
	"796A": "gui",
	"55A8": "liang",
	"6294": "pou",
	"6B8A": "shu",
	"9062": "ta",
	"9F14": "gu",
	"5509": "ai",
	"5B1E": "dong",
	"6379": "ben",
	"7CAB": "mian",
	"7CDA": "zhuang",
	"8956": "ao",
	"53F8": "si",
	"655D": "bi",
	"67E2": "di",
	"7117": "ju",
	"8AC7": "tan",
	"96C9": "zhi",
	"639D": "huo",
	"7681": "zao",
	"9697": "wei;kui",
	"5329": "kuang",
	"68BF": "lian",
	"7EFF": "lu",
	"9B71": "hu",
	"5451": "tun",
	"60F4": "zhui",
	"7484": "ying",
	"7635": "zhai",
	"8E43": "nuo",
	"58BB": "qiang",
	"6B59": "she;xi",
	"6FE3": "wo",
	"7958": "suan",
	"886E": "gun",
	"9C56": "gui",
	"6459": "lian",
	"67B5": "xiao",
	"6DE8": "jing",
	"70E7": "shao",
	"716E": "zhu",
	"7AE1": "yi;gong;sheng;bai;bei;si",
	"5684": "huo",
	"6BDC": "none",
	"9209": "na",
	"4F13": "bei",
	"566B": "yi",
	"6080": "yong",
	"66D7": "ye",
	"6FEA": "jing",
	"71A5": "teng",
	"8CA8": "huo",
	"598F": "wen",
	"6225": "deng",
	"6AA9": "lin",
	"6DF7": "hun",
	"76D6": "gai;ge",
	"7B06": "ba",
	"7F5B": "gu",
	"7FC6": "cui",
	"986B": "zhan;chan",
	"6A97": "bo",
	"6B3A": "qi",
	"869C": "ya",
	"86A6": "ran",
	"909B": "qiong",
	"621B": "jia",
	"7973": "zhen",
	"9C6F": "huo",
	"9E16": "he",
	"763E": "yin",
	"77CD": "jue",
	"86D5": "hui",
	"9980": "yu",
	"9E76": "jin",
	"78DC": "qi",
	"61B4": "sheng",
	"6229": "jian",
	"67AF": "ku",
	"7D97": "jiong",
	"85D9": "yi",
	"4F92": "an",
	"51C7": "song",
	"5F90": "xu",
	"6B52": "ti",
	"6DBF": "zhuo",
	"7FAF": "jie",
	"829E": "qi",
	"8E07": "mou",
	"5C17": "shu",
	"6826": "chou",
	"786A": "wo",
	"7F21": "li",
	"889E": "gun",
	"6404": "geng",
	"8B26": "qing",
	"9B9A": "jie",
	"61C0": "wei",
	"6454": "shuai",
	"6482": "liao",
	"8E85": "zhu",
	"980D": "kui",
	"9C05": "yu",
	"5272": "ge",
	"5E09": "fen",
	"6273": "ban;pan",
	"62EE": "jie",
	"6F04": "ya",
	"7864": "xia",
	"78F5": "jian",
	"56D3": "nie",
	"6782": "yue",
	"6AF6": "xian",
	"72C4": "di",
	"78CF": "lian",
	"7E76": "yi",
	"867F": "chai",
	"9A91": "qi",
	"5CF5": "hong",
	"9B4A": "yu",
	"5002": "bing",
	"8519": "xuan",
	"90EA": "qi",
	"5CF9": "tu",
	"5EEF": "xian",
	"6260": "cha",
	"59C0": "he",
	"655E": "chang;tang",
	"91E5": "qiao",
	"69C4": "tao",
	"8014": "zi",
	"96E4": "xue",
	"9D3A": "ti",
	"5C71": "shan",
	"84DE": "none",
	"92D0": "hong",
	"548D": "hai",
	"624C": "shou",
	"8B5F": "zao",
	"8F64": "lu",
	"9178": "suan",
	"7504": "zhen",
	"8711": "dan",
	"87B4": "chen",
	"8AF9": "yang",
	"5145": "chong",
	"5472": "ci;zi",
	"5CB7": "min",
	"8A29": "xiong",
	"9169": "ming",
	"9863": "qi",
	"5B49": "quan",
	"680C": "lu",
	"6E59": "yi",
	"6EAF": "su",
	"7609": "yu",
	"7718": "shen",
	"78F6": "xi",
	"7961": "chai",
	"8324": "duo",
	"8850": "none",
	"95BA": "min;wen",
	"9D65": "none",
	"5DB0": "xie",
	"605E": "yi",
	"67FC": "yao",
	"7DE4": "xie",
	"6F6D": "tan",
	"8D36": "kuang",
	"9AB4": "ci",
	"4E9F": "ji;qi",
	"5481": "gan",
	"5743": "xun",
	"5792": "lei",
	"84F6": "wei",
	"9653": "wu",
	"9792": "qiao",
	"597E": "xian",
	"5FA9": "fu",
	"74EB": "pen",
	"92F8": "ju",
	"5FCF": "chan",
	"6539": "gai",
	"785E": "que",
	"5103": "shan",
	"8A6A": "hen",
	"8E4A": "xi;qi",
	"9818": "ling",
	"9C3C": "xi",
	"9D7A": "ye",
	"53C0": "zhuan",
	"56EA": "cong;chuang",
	"6BD2": "du",
	"6E8F": "tang",
	"7DAE": "qi;qing",
	"5A04": "lou",
	"60D1": "huo",
	"6644": "huang",
	"6FF4": "xing",
	"8825": "nie",
	"8CA6": "wan",
	"81AC": "cui",
	"9F5B": "shi",
	"519E": "mi",
	"5C33": "gu",
	"5C44": "bi",
	"96A1": "sa",
	"5A18": "niang",
	"732F": "tuan",
	"8C9D": "bei",
	"50C6": "lian",
	"65D2": "liu",
	"7274": "di",
	"8A6B": "cha",
	"9449": "ta",
	"9521": "xi",
	"4E66": "shu",
	"6146": "tao",
	"8017": "hao",
	"95E3": "dang",
	"9642": "po;bei;pi",
	"96C1": "yan",
	"97B8": "bi",
	"5291": "ji",
	"5CB0": "you",
	"727B": "mang",
	"75AE": "chuang",
	"90C1": "yu",
	"4FA6": "zhen",
	"5D9A": "liao",
	"76E0": "lu",
	"7AE3": "jun",
	"8278": "cao",
	"83EC": "zhao",
	"8510": "di",
	"944F": "ning",
	"5577": "lang",
	"5647": "zan",
	"8938": "lu",
	"6184": "zhi",
	"6355": "bu",
	"788F": "que",
	"5A6B": "kun",
	"5BA8": "tiao",
	"6558": "xu",
	"7A75": "wa",
	"8139": "zhang",
	"6EC5": "mie",
	"76DB": "sheng;cheng",
	"962A": "ban",
	"5AA4": "si",
	"8CF2": "bao",
	"65EA": "xie",
	"7DDD": "ji;qi",
	"9EB0": "mou",
	"97DC": "tao",
	"4EBB": "ren",
	"54DB": "none",
	"656D": "yang",
	"7394": "chuan",
	"720B": "xun",
	"7A55": "qie",
	"8D18": "none",
	"90A7": "yuan",
	"9E38": "er",
	"6453": "feng",
	"7142": "he",
	"7481": "cong",
	"75B9": "zhen",
	"8095": "ren",
	"8916": "tuan",
	"5BC5": "yin",
	"6144": "li",
	"615C": "min",
	"79F6": "zi",
	"4E2A": "ge",
	"4E49": "yi",
	"7638": "que",
	"81CC": "gu",
	"8385": "li",
	"8B6D": "hui",
	"59EF": "guang",
	"5D0F": "min",
	"54B0": "shuai",
	"5505": "han",
	"5DF1": "ji",
	"6B8C": "jue",
	"79FF": "fu",
	"8176": "duan",
	"8206": "yu",
	"84FC": "liao;lu",
	"8CE3": "mai",
	"9C68": "chang",
	"54E2": "long",
	"6A45": "mo;mu",
	"6EE8": "bin",
	"740B": "xi",
	"8D05": "zhui",
	"6F37": "kuo;huo",
	"7BB4": "zhen",
	"83BF": "ci",
	"8C76": "fen",
	"8E3C": "tang",
	"8F65": "lin",
	"91D4": "yi",
	"93C0": "lu",
	"9B67": "hang",
	"5732": "qian",
	"7000": "you",
	"7F3E": "ping",
	"527D": "piao",
	"7084": "niu",
	"7034": "ying",
	"70C5": "xu",
	"761C": "xi",
	"94AE": "niu",
	"9AF8": "none",
	"4F51": "you",
	"50DC": "deng",
	"5CFB": "jun",
	"7E04": "sheng",
	"80AA": "fang",
	"94FF": "keng",
	"9617": "tian",
	"58A9": "dun",
	"5A76": "shen",
	"636C": "fu",
	"6D2F": "qie;jie",
	"6F81": "se",
	"7C34": "ju",
	"9DC7": "kou",
	"565E": "yan",
	"60E3": "zong",
	"5EF5": "xun",
	"8EC6": "ti",
	"9205": "yue",
	"97DB": "bei",
	"9BCA": "sha",
	"5E35": "wan",
	"7542": "liu",
	"7557": "da",
	"76EA": "dang",
	"781F": "zha;zuo",
	"9A39": "li",
	"9CDF": "zun",
	"9D63": "la",
	"6B19": "lei",
	"8AA3": "wu",
	"8E95": "chu",
	"6149": "xu",
	"618A": "bei",
	"6AA7": "song",
	"7A5A": "jiao",
	"7DE1": "min",
	"815E": "zhuan;dun",
	"8AA5": "gao",
	"9985": "xian",
	"55B5": "miao",
	"5EC6": "hui",
	"681A": "zhen",
	"76C3": "bei",
	"9719": "ying;ji",
	"988D": "ying",
	"996B": "yu",
	"517D": "shou",
	"5E5E": "fu",
	"7B31": "gou",
	"878B": "sou",
	"9F69": "nie",
	"6FB6": "chan",
	"6FD3": "lian",
	"7F1E": "cui",
	"8CBA": "kuang",
	"9D7F": "sheng",
	"502A": "ni",
	"6958": "mu",
	"77F5": "qi",
	"8060": "ping",
	"818F": "gao",
	"7984": "lu",
	"7989": "you",
	"896A": "wa",
	"8A14": "yin",
	"58A7": "que",
	"5B74": "ni",
	"73B2": "ling",
	"8604": "qi",
	"883F": "zha",
	"608C": "ti",
	"622D": "yan",
	"65B8": "zhu",
	"70B0": "pao",
	"5454": "dai;tai",
	"557C": "ti",
	"6C1F": "fu",
	"700B": "shen",
	"8D68": "xiong",
	"9B54": "mo",
	"7A5C": "tong",
	"7F90": "you",
	"97C1": "jiang",
	"65CA": "fang",
	"66BE": "tun",
	"9A70": "chi",
	"9D2C": "ying",
	"594C": "dian",
	"5F4F": "jue",
	"6A6E": "liu",
	"86E9": "qiong",
	"6028": "yuan",
	"6384": "lun",
	"6A0B": "tong",
	"6BB3": "shu",
	"9A85": "hua",
	"9F57": "ken",
	"57C9": "jia",
	"76B3": "qiu",
	"7B3C": "long",
	"7F98": "zang",
	"8FDB": "jin",
	"9C39": "jian",
	"5A85": "dan",
	"68EF": "ren",
	"6FC7": "se",
	"8328": "ci",
	"855B": "ti",
	"9138": "meng",
	"58E0": "long",
	"5F94": "none",
	"6367": "peng",
	"6D72": "feng",
	"78DF": "lu",
	"7992": "xian",
	"7B41": "qu",
	"8EA7": "xi",
	"9B4E": "liang",
	"510B": "dan",
	"5987": "fu",
	"604B": "lian",
	"7B79": "chou",
	"9921": "xian",
	"7604": "xi",
	"8C15": "yu",
	"6C3A": "shui",
	"722C": "pa",
	"7393": "di",
	"5DE4": "lie",
	"7516": "ying",
	"7CA3": "ce",
	"8BD0": "bi",
	"914B": "qiu",
	"9B02": "bin",
	"635B": "lu",
	"73DA": "yan",
	"7E52": "zeng",
	"8CC5": "gai",
	"5B63": "ji",
	"61A9": "qi",
	"6D01": "jie",
	"72F1": "yu",
	"805B": "bi",
	"9116": "yun",
	"593F": "ba",
	"695E": "leng",
	"7F8E": "mei",
	"6DFA": "qian;jian",
	"72A3": "lie",
	"74B3": "tian",
	"76A6": "jiao",
	"8FA2": "la",
	"5474": "xu",
	"5994": "keng",
	"6690": "wei",
	"6F06": "qi;qu;xi",
	"5FAB": "wei",
	"68CB": "qi",
	"6C59": "wu",
	"7269": "wu",
	"7510": "lin",
	"82B2": "hua",
	"82FA": "mei",
	"9679": "none",
	"4FCF": "qiao",
	"5598": "chuan",
	"5CAC": "jia",
	"5FF3": "tun",
	"83CB": "wei",
	"8ABD": "na",
	"505D": "bei",
	"5B44": "lan",
	"6BE8": "xian",
	"8837": "qu",
	"8BB9": "e",
	"7F6F": "an",
	"9536": "si",
	"9E62": "yi",
	"63D4": "zong",
	"6F9D": "none",
	"7569": "none",
	"913A": "kuang",
	"97DE": "yun",
	"9B10": "qi",
	"59BA": "mo",
	"68A2": "shao;sao",
	"9A19": "pian",
	"9A6F": "xun",
	"5B54": "kong",
	"87E5": "huang",
	"99EA": "shen",
	"57A7": "shang",
	"59AA": "yu",
	"5B41": "ling",
	"5FE6": "ye",
	"7FD0": "zhi",
	"9343": "huo",
	"9816": "pan",
	"53FD": "ji",
	"6034": "xu",
	"6403": "zong",
	"795C": "hu",
	"820B": "xin",
	"854C": "lei",
	"8B3F": "chao",
	"58B3": "fen",
	"6B9B": "ji",
	"8425": "ying",
	"5A16": "chuo",
	"6BCA": "xiao",
	"6BEC": "qiu",
	"7F83": "mi",
	"7FFA": "ao",
	"84C4": "xu",
	"5114": "chou",
	"575B": "tan",
	"5C82": "qi",
	"5F93": "cong",
	"628C": "zhen",
	"702A": "fan",
	"90EC": "qing",
	"922C": "duo",
	"991E": "jian",
	"5496": "ka;ga",
	"6BBC": "ke;qiao;que",
	"8320": "xiu",
	"8888": "jia",
	"8997": "si",
	"8DD6": "zhi",
	"9285": "tong",
	"5B17": "shan",
	"6031": "zong",
	"8A0B": "diao",
	"92DC": "zhuo",
	"9CB2": "kun",
	"9F28": "tong",
	"9FA5": "yue",
	"6279": "pi",
	"6339": "yi",
	"64DF": "mi",
	"6AD8": "hui",
	"8F58": "huan",
	"9E35": "tuo",
	"64F0": "ning",
	"8553": "yun",
	"9E0F": "meng",
	"6FC0": "ji",
	"776B": "jie",
	"90BB": "lin",
	"9114": "wu",
	"56B8": "dian",
	"6176": "qing",
	"68CF": "de",
	"726D": "si",
	"7475": "zhao",
	"7612": "wen",
	"7C86": "sha",
	"7697": "chou",
	"8AF7": "feng",
	"91F5": "chai",
	"55ED": "none",
	"78BF": "su",
	"568C": "ji",
	"6122": "sai",
	"7917": "pin",
	"7929": "zhi",
	"91E0": "luan",
	"989F": "man",
	"99D8": "tai",
	"9C62": "sao",
	"503E": "qing",
	"5161": "bai;ke",
	"604A": "xie",
	"8E57": "lu",
	"576A": "ping",
	"6C12": "jue",
	"9A90": "qi",
	"9C9A": "ji",
	"4F0D": "wu",
	"6C43": "bin",
	"826D": "shuang",
	"95A1": "he",
	"979D": "zhang",
	"68BA": "none",
	"4F0B": "ji",
	"50AA": "zan",
	"518E": "gua",
	"6810": "yong",
	"6C33": "yun",
	"7F3A": "que",
	"58B6": "da",
	"6F61": "dun",
	"864F": "lu",
	"5BF4": "qin",
	"658A": "qi;ji",
	"77FA": "tuo",
	"4E6E": "none",
	"58D4": "dao",
	"6277": "ao",
	"7C4B": "mi",
	"864E": "hu",
	"8FFF": "xun",
	"5773": "ao",
	"58B9": "none",
	"5BAD": "qun",
	"60EF": "guan",
	"8177": "bi",
	"873E": "guo",
	"9836": "hu",
	"9E34": "xue",
	"9E3C": "zhou",
	"733A": "yao",
	"84E6": "mo",
	"4EC4": "ze",
	"5438": "xi",
	"5B9D": "bao",
	"5F67": "yu",
	"7014": "gu",
	"7A41": "rong",
	"7D79": "juan",
	"80B1": "gong",
	"64CA": "ji",
	"6FE1": "ru",
	"76FE": "dun;shun",
	"8F61": "pei",
	"9207": "fu",
	"952A": "huo",
	"5C2E": "duo",
	"68A9": "li",
	"7F8B": "mie",
	"86BF": "xian",
	"960C": "wen",
	"701B": "ying",
	"7232": "wei",
	"8EE8": "ling",
	"92F9": "chang",
	"58B1": "deng;yan",
	"5F24": "di",
	"6938": "yi",
	"725F": "mou;mu",
	"8058": "pin",
	"9007": "dun",
	"68E1": "gang",
	"8F05": "lu",
	"9815": "dan",
	"99DD": "tuo",
	"62C5": "dan",
	"73D3": "jiao",
	"77C0": "wei",
	"7EB3": "na",
	"8269": "qi",
	"83A8": "lang;liang",
	"896C": "bai",
	"8B4E": "jue",
	"5024": "zhi",
	"5079": "bei",
	"660D": "xuan",
	"67C5": "ni",
	"67D5": "mao",
	"70E2": "zhe",
	"8681": "yi",
	"9060": "yuan",
	"99BA": "sa",
	"9B21": "ning",
	"503D": "sha",
	"8640": "ji",
	"8803": "luo",
	"9547": "zhen",
	"99AD": "yu",
	"9B82": "qiu",
	"6347": "huo",
	"74A5": "jing",
	"7B0D": "zhui",
	"813C": "liang",
	"8251": "bian",
	"8476": "ting",
	"8607": "su",
	"63BF": "nuo",
	"72DC": "gu",
	"73D1": "long",
	"5EA3": "tiao",
	"6597": "dou",
	"7DAB": "xian",
	"96FF": "zhao",
	"67F5": "zha",
	"73A1": "ya",
	"90EB": "pi",
	"9330": "shu",
	"5231": "chuang",
	"6551": "jiu",
	"76D2": "he",
	"7783": "wen",
	"791E": "meng",
	"7DFC": "yun",
	"9276": "xing",
	"7E82": "zuan",
	"80D8": "xian",
	"85B5": "chou",
	"6F6C": "dan",
	"7944": "xie",
	"7FDA": "hui",
	"8550": "hua",
	"89F0": "zhu",
	"931C": "nie",
	"6812": "xun",
	"72BF": "huan",
	"807F": "yu",
	"8A60": "yong",
	"9483": "shu",
	"7210": "lu",
	"7322": "hu",
	"7E81": "xun",
	"526D": "wu",
	"57E6": "wan",
	"6084": "qiao",
	"72EC": "du",
	"741B": "chen",
	"8432": "xuan",
	"525E": "ji",
	"5728": "zai",
	"5BED": "hui",
	"5ED6": "liao",
	"6051": "gui",
	"7414": "dian",
	"7980": "bing",
	"526F": "fu",
	"723F": "pan;qiang;ban",
	"75A0": "li",
	"862F": "dang",
	"86F2": "nao",
	"8BC9": "su",
	"91F2": "si",
	"62BF": "min",
	"62DF": "ni",
	"72D6": "you",
	"7640": "huang",
	"7877": "jian",
	"787B": "keng",
	"9133": "meng",
	"91D9": "li",
	"5A32": "wa",
	"5E2C": "qun",
	"673B": "jiu",
	"7167": "zhao",
	"781B": "none",
	"7C33": "gan",
	"7EC6": "xi",
	"5344": "nian",
	"5635": "xiao",
	"8C7A": "chai",
	"9B76": "na",
	"5DC1": "li",
	"6B11": "zan",
	"72A4": "pi",
	"836C": "mai",
	"842A": "ke",
	"95C2": "xiang",
	"6FD0": "zhu",
	"72BD": "ya",
	"8891": "shao",
	"8B69": "yi",
	"8C0E": "huang",
	"756A": "fan;pan",
	"7A63": "rang",
	"9555": "rong",
	"959E": "bian",
	"9C99": "kuai",
	"6C60": "chi",
	"82DA": "rao",
	"92AC": "kao",
	"6291": "yi",
	"6AA8": "she",
	"6EE9": "tan",
	"8ADB": "yu",
	"96AD": "er",
	"5D93": "bo",
	"671E": "ji;qi",
	"6EFF": "man",
	"7AB4": "tian",
	"7EC3": "lian",
	"9652": "gui",
	"6927": "none",
	"782F": "ping",
	"8185": "tang",
	"8CC3": "lin;ren",
	"9882": "song",
	"9DC2": "yao",
	"59CC": "ran",
	"6086": "yu",
	"66B1": "ni",
	"7522": "chan",
	"78B3": "tan",
	"7EA9": "kuang",
	"82A2": "ren",
	"8A0D": "cha",
	"8D00": "wei",
	"9F63": "chu",
	"5A77": "ting",
	"5E12": "dai",
	"7A07": "kun",
	"803E": "hong",
	"889F": "zhi",
	"916B": "chuo",
	"7902": "xi",
	"9482": "tang",
	"9F8E": "pang",
	"5500": "you",
	"7818": "dun",
	"78EF": "ji",
	"856D": "xiao",
	"8FDF": "chi",
	"9013": "di",
	"601A": "ju",
	"6924": "luo",
	"8A44": "die",
	"547F": "qu",
	"56C3": "ca",
	"60FC": "bian",
	"72C8": "bei",
	"74BB": "zui",
	"7DC8": "xing",
	"973D": "ji",
	"9A98": "zhi",
	"53E0": "die",
	"7C12": "cuan",
	"82AD": "ba",
	"625B": "kang;gang",
	"6D86": "han",
	"7198": "liu",
	"7E0C": "ni",
	"8297": "xiang",
	"84C6": "xi",
	"8C4F": "xian",
	"8D4E": "shu",
	"90AB": "bang",
	"946C": "jian",
	"9601": "ge",
	"5902": "zhi",
	"67A0": "none",
	"94DB": "dang;cheng",
	"5E68": "dan",
	"5E87": "bi",
	"600E": "zen",
	"6039": "tan",
	"9BA8": "qi",
	"4FB8": "shu",
	"66E6": "xi",
	"7C64": "qian",
	"80FF": "none",
	"9286": "mo",
	"5F5C": "yi",
	"7180": "huang",
	"9C11": "yang",
	"7533": "shen",
	"9C98": "hou",
	"543D": "ou;hong",
	"68A4": "fen",
	"71D2": "shao",
	"83C6": "zou",
	"8E76": "jue",
	"9318": "chui",
	"99CD": "peng",
	"57CB": "mai;man",
	"64B9": "jiao",
	"7CF4": "di",
	"94F9": "lao",
	"5A9F": "xie",
	"6EB1": "zhen;qin",
	"71A6": "jue",
	"9F86": "tiao",
	"55AC": "qiao",
	"5F66": "yan",
	"7E79": "yi",
	"8035": "ding",
	"8219": "hua",
	"9161": "tuo",
	"5CD7": "wei",
	"600C": "pi",
	"73A3": "bian",
	"8CAD": "zhi",
	"9713": "ni",
	"9DDC": "lou",
	"4EFD": "fen",
	"633C": "nuo",
	"7A24": "none",
	"9943": "mo",
	"8A01": "yan",
	"96C3": "ya",
	"6111": "yong",
	"652F": "zhi",
	"6F82": "cheng;deng",
	"7F50": "guan",
	"8A71": "hua",
	"54A8": "zi",
	"6CC2": "jiong",
	"7A66": "none",
	"8085": "su",
	"975E": "fei",
	"5458": "yuan;yun",
	"5C11": "shao",
	"6888": "peng",
	"7722": "yuan",
	"7E3A": "lian",
	"8D17": "yan",
	"9094": "qi",
	"5012": "dao",
	"54C7": "wa",
	"5778": "gou",
	"5888": "kan",
	"84A8": "qian",
	"84EA": "tong",
	"935D": "yu",
	"59C9": "zi",
	"6920": "qian",
	"6B83": "yang",
	"6BF1": "ju",
	"6E99": "tai",
	"6FDD": "qi",
	"8BE0": "quan",
	"4F8F": "zhu",
	"5E00": "za",
	"6DE9": "ling",
	"7520": "qing",
	"7EC1": "xie",
	"86A0": "fen",
	"4E7C": "none",
	"5041": "cheng",
	"8D89": "zhu",
	"8E0D": "xiao",
	"9AB1": "jie;xie",
	"9E2F": "yang",
	"9EFB": "fu",
	"50B9": "qiang",
	"53FE": "none",
	"576C": "wa",
	"68C7": "cong",
	"791A": "ke",
	"9786": "mo",
	"979E": "bing",
	"989A": "e",
	"55B6": "ying",
	"95C7": "an",
	"9D4D": "huan",
	"5394": "zhi",
	"5CCB": "xun",
	"65FB": "min",
	"69FE": "man",
	"6E45": "lian",
	"75DC": "tu",
	"75EA": "huan",
	"89C0": "guan",
	"5658": "jue",
	"60CD": "jin",
	"6D36": "xiong",
	"6D41": "liu",
	"7E46": "mou;miao;miu",
	"8E41": "pian",
	"9DA6": "hu",
	"57D2": "lie;le",
	"59EB": "ji",
	"5DA0": "jiao;qiao",
	"62B9": "mo;ma",
	"7F66": "fu",
	"80A7": "pei",
	"9D34": "heng",
	"5189": "ran",
	"5D08": "chong",
	"5E99": "miao",
	"7C31": "qi",
	"89B3": "guan",
	"5F72": "chi",
	"6120": "yun",
	"632B": "cuo",
	"9CF6": "yuan",
	"6CF6": "xue",
	"6D84": "pin",
	"7093": "liao",
	"8F4B": "hun",
	"5DCC": "yan",
	"617A": "lu",
	"65F1": "han",
	"707F": "can",
	"72DA": "dan",
	"7D72": "si",
	"7F30": "jiang",
	"96E1": "liu",
	"51F0": "huang",
	"5ECE": "qing",
	"5463": "mou",
	"5FFF": "fen",
	"6689": "hui",
	"86FC": "che",
	"9125": "wu",
	"5619": "po",
	"5B86": "qiong",
	"6C07": "lu",
	"86A1": "fen",
	"8A23": "jue",
	"9402": "liu",
	"9C33": "le",
	"9E36": "si",
	"5E23": "juan",
	"614A": "qian;qie",
	"6EB8": "su",
	"83E0": "bo",
	"971D": "ling",
	"52BC": "jie",
	"773B": "yang",
	"8623": "tou",
	"8932": "ku",
	"531B": "jiu",
	"74D7": "xi",
	"7743": "suo",
	"78D6": "la",
	"8457": "zhu;zhe;zhao;zi;zhuo",
	"89A8": "e",
	"8C55": "shi",
	"958D": "beng",
	"95F9": "nao",
	"996C": "chi",
	"99DA": "yang",
	"9EAD": "pao",
	"55E2": "wa",
	"65B0": "xin",
	"6613": "yi",
	"6E28": "wei",
	"77C7": "meng",
	"980E": "qi",
	"9F70": "cuo",
	"54E1": "yuan;yun",
	"5E3E": "du",
	"6D9C": "du",
	"7BA0": "chui",
	"8070": "cong",
	"8758": "yan",
	"9833": "cheng",
	"6D19": "zhu",
	"72C1": "yun",
	"8B17": "bang",
	"9503": "zeng",
	"9F9B": "kan",
	"55DD": "ge",
	"575C": "li",
	"530D": "pu",
	"560D": "lou",
	"6BF9": "shu",
	"6EA3": "lun",
	"734B": "hao",
	"8306": "mao",
	"86C6": "qu;ju",
	"9283": "chong",
	"59D0": "jie",
	"5A12": "mu",
	"9581": "ma",
	"5C1D": "chang",
	"6967": "ying",
	"6AEC": "chen",
	"6D83": "kun",
	"7931": "long",
	"9AD1": "du",
	"56BF": "huo",
	"6BCD": "mu",
	"9795": "ying",
	"8613": "su",
	"8628": "yao",
	"8858": "xian",
	"4E2B": "ya",
	"549F": "huo",
	"68BB": "none",
	"7E8E": "xian",
	"8B4C": "e",
	"8BBF": "fang",
	"52D6": "xu",
	"668C": "kui",
	"66A2": "chang",
	"6AD0": "lei",
	"8498": "nu",
	"91BE": "mi",
	"5722": "ting",
	"8C34": "qian",
	"631B": "luan",
	"737D": "rang",
	"8FD3": "ya",
	"978B": "xie",
	"5167": "nei",
	"62D1": "qian",
	"8D8C": "jie",
	"9673": "chen",
	"528F": "tang",
	"5C56": "xi",
	"600F": "yang",
	"6C4F": "dai",
	"7359": "bi",
	"742E": "cong",
	"7790": "mao",
	"8098": "zhou",
	"56A0": "liu",
	"7FCF": "liu",
	"4EBA": "ren",
	"525A": "zi",
	"5A7C": "chuo",
	"5ABA": "mei",
	"6C96": "chong",
	"7ABB": "chuang",
	"9877": "qing",
	"6A36": "zui",
	"9B0E": "la",
	"676D": "hang",
	"9056": "none",
	"4F81": "shen",
	"5CA8": "qu",
	"9941": "ye",
	"4F69": "pei",
	"6E1E": "qiu",
	"717F": "bo",
	"789E": "yan",
	"92BD": "gua",
	"529F": "gong",
	"54A4": "zha",
	"57F6": "yi",
	"6505": "zan;cuan",
	"6A35": "qiao",
	"6E7D": "zi",
	"7888": "min",
	"95DF": "xi",
	"5155": "si",
	"7257": "none",
	"7515": "weng",
	"8109": "mai;mo",
	"89A4": "xi",
	"58EA": "none",
	"6A50": "tuo",
	"85D4": "none",
	"97AB": "ju",
	"67F0": "nai",
	"7044": "she",
	"89CF": "gou",
	"9018": "yi",
	"925B": "qian;yan",
	"4FE3": "yu",
	"6E95": "meng",
	"7D5F": "quan",
	"9058": "gou",
	"94DA": "zhi",
	"94F2": "chan",
	"9E95": "jun;qun",
	"5B7B": "nai",
	"61ED": "kuang",
	"74D5": "mi",
	"85B0": "xun",
	"8CDA": "lai",
	"933B": "none",
	"9BDD": "gu",
	"56B5": "chan",
	"652C": "lan",
	"6923": "none",
	"5D56": "cha",
	"5D76": "none",
	"8110": "qi",
	"8198": "biao",
	"88CD": "kun",
	"8DF4": "cai",
	"5468": "zhou",
	"6B0B": "qu",
	"6BAD": "jiang",
	"8462": "ge",
	"8BAE": "yi",
	"8C8A": "mo",
	"90B8": "di",
	"9AA7": "xiang",
	"55A2": "sha",
	"7AD5": "shi;fen;zhi;yi;gong;sheng",
	"7E85": "li",
	"8441": "jiang",
	"8A8C": "zhi",
	"9A32": "cao",
	"5A80": "yu",
	"6DA4": "di",
	"6F34": "chong",
	"748E": "ying",
	"7B83": "zou",
	"7E3D": "zong",
	"8A04": "qiu",
	"5144": "xiong",
	"5637": "hao",
	"6213": "ge",
	"6A5B": "jue",
	"730B": "biao",
	"7A9F": "ku",
	"7EFA": "liu",
	"5578": "xiao",
	"6961": "yu",
	"7F23": "jian",
	"57A5": "xie",
	"6798": "rui",
	"5335": "du",
	"53C4": "san",
	"808B": "lei",
	"9342": "none",
	"5361": "ka;qia",
	"538E": "zhi",
	"5777": "ke",
	"666C": "zui",
	"6983": "tan",
	"6DD6": "nao",
	"7922": "none",
	"82EF": "ben",
	"9AEF": "ran",
	"5D28": "jie",
	"7B2E": "ze;zuo",
	"82BA": "ao",
	"86B9": "fu",
	"924F": "chu",
	"9527": "zhi",
	"6350": "juan",
	"70C3": "ting",
	"75A5": "jie",
	"8893": "ju",
	"8F86": "liang",
	"9A14": "jie;ge",
	"7A25": "none",
	"89E1": "ge",
	"9ED5": "zhen",
	"5877": "lu",
	"5D2B": "jue",
	"6E9A": "ta",
	"837A": "yun",
	"94BA": "yue",
	"9CF1": "gan",
	"5F3E": "dan;tan",
	"6477": "zhao",
	"6982": "gai",
	"8F39": "fu",
	"56AB": "chen",
	"57C4": "peng",
	"876E": "fu",
	"952E": "jian",
	"9962": "nang",
	"79D3": "zhi",
	"8129": "xiu",
	"86ED": "zhi",
	"906D": "zao",
	"977D": "ban",
	"9AC6": "bo",
	"6797": "lin",
	"87C5": "zhe",
	"9E8B": "mi",
	"8966": "ru",
	"9D7B": "zhui",
	"9E48": "ti",
	"5AAF": "gui",
	"90A6": "bang",
	"96C4": "xiong",
	"9B14": "peng",
	"57D1": "zhe",
	"698B": "none",
	"4F22": "ya",
	"61AE": "wu",
	"7235": "jue",
	"8415": "qi;ji",
	"8BCC": "zhou",
	"914F": "yi",
	"97E0": "bi",
	"99F7": "song",
	"54B4": "hui",
	"5A5F": "hu",
	"613E": "kai",
	"8986": "fu",
	"8FCE": "ying",
	"56D2": "lan",
	"79C9": "bing",
	"8284": "wan",
	"86EE": "man",
	"6832": "kao",
	"68BC": "tao",
	"6C19": "xian",
	"76F8": "xiang",
	"7842": "quan",
	"810F": "zang",
	"8EFC": "yi",
	"56C6": "chai",
	"6053": "xi",
	"7BAA": "dan",
	"85F7": "zhu;shu",
	"8683": "xiang",
	"4EB6": "dan",
	"582E": "e",
	"587D": "shuang",
	"5A0F": "mang",
	"6AB3": "bin;bing",
	"707C": "zhuo",
	"88EE": "chang",
	"8D27": "huo",
	"9F3B": "bi",
	"5959": "ben",
	"571F": "tu",
	"609E": "wu",
	"9453": "qiang",
	"57AA": "none",
	"5CD5": "shi",
	"78A9": "shuo;shi",
	"91C7": "cai",
	"9737": "yang",
	"9D74": "ju",
	"4EBC": "ji",
	"5A34": "xian",
	"5B2A": "pin",
	"67B3": "zhi",
	"6C23": "qi",
	"7292": "kao;di",
	"81AD": "gui",
	"9BEA": "ling",
	"5F3D": "she",
	"5F85": "dai",
	"6137": "kai",
	"6F53": "hui",
	"748A": "man",
	"5459": "guo",
	"6AA0": "qing",
	"6ABF": "yan",
	"80D4": "zi",
	"814A": "la;xi",
	"8F55": "ge",
	"92D3": "chan",
	"9CF8": "hu",
	"4E28": "shu",
	"6761": "tiao",
	"683A": "zhi",
	"7838": "za",
	"8330": "yu",
	"8886": "hui",
	"9B49": "liang",
	"6097": "man",
	"6BEE": "none",
	"706E": "guang",
	"7B64": "lang",
	"7D90": "dui",
	"87D8": "te",
	"8B57": "zha",
	"9607": "du;she",
	"5D53": "yan",
	"72F7": "juan",
	"7659": "shu",
	"84D0": "ru",
	"899D": "lian",
	"8A09": "fan",
	"6740": "sha",
	"85E9": "fan",
	"96D6": "sui",
	"9769": "ge;ji",
	"50F3": "su",
	"527B": "fou",
	"5844": "leng",
	"61D0": "huai",
	"630E": "kua",
	"6737": "dao",
	"941D": "jue",
	"5B61": "tai",
	"8A74": "hui",
	"8EB5": "none",
	"5DD5": "nie",
	"64F6": "jian",
	"6579": "liao",
	"71C6": "qiao",
	"7C99": "zhou",
	"7FFE": "xuan",
	"83B6": "xian",
	"8901": "zhi",
	"7CA1": "tong",
	"85F0": "liu",
	"8AF6": "chen",
	"97A6": "qiu",
	"688A": "di",
	"91B3": "yi",
	"61DF": "dui",
	"6D76": "lao",
	"8C38": "qian",
	"95E6": "wen",
	"554E": "wu",
	"6694": "nan",
	"8897": "zhen",
	"9389": "ta",
	"93A6": "liu",
	"4FDF": "si;qi",
	"5845": "duan",
	"9846": "ke",
	"9D19": "zhi",
	"5FD6": "cun",
	"8686": "pa",
	"4E09": "san",
	"94F3": "chong",
	"9894": "han",
	"5319": "chi;shi",
	"53B2": "li",
	"5CB6": "po",
	"68CA": "qi",
	"7242": "zang",
	"8693": "yin",
	"8783": "pang",
	"9368": "kui",
	"835C": "bi",
	"6BB4": "ou",
	"77D2": "meng",
	"7A56": "ji",
	"8294": "hui",
	"8DDF": "gen",
	"9643": "bing",
	"570F": "quan;juan",
	"6B36": "shuo",
	"8FF5": "tong",
	"9DB2": "weng",
	"539D": "cuo",
	"634E": "shao",
	"66DA": "meng",
	"6F1C": "ye",
	"721A": "yue",
	"7E0E": "gu",
	"820D": "she",
	"88DC": "bu",
	"8E4D": "zhan",
	"9898": "ti",
	"5427": "ba",
	"5589": "hou",
	"58FF": "zun",
	"5EAC": "pang;mang",
	"5F26": "xian",
	"5F98": "pai",
	"7C09": "zao",
	"7C69": "bian",
	"8465": "qian",
	"89E3": "jie;xie",
	"8A7F": "gua",
	"8F26": "nian",
	"60E8": "can",
	"6BB1": "jian",
	"8FFC": "jie",
	"9572": "cha",
	"5132": "chu",
	"60B2": "bei",
	"771F": "zhen",
	"7C93": "gan",
	"4FBA": "shen",
	"529D": "quan",
	"52FA": "shao;shuo;biao",
	"6703": "hui;kuai",
	"673A": "ji",
	"76CE": "ang",
	"80A3": "qin",
	"54A0": "qi",
	"5F6E": "yong",
	"6617": "ze",
	"6E53": "pen",
	"7100": "hu",
	"7820": "qu",
	"79D6": "zhi",
	"86DB": "zhu",
	"891E": "yun",
	"51F5": "qu;kan",
	"5F7B": "che",
	"6CF4": "guan",
	"753C": "ting;ding",
	"8B25": "cong",
	"8E7D": "liao",
	"8F17": "ni",
	"9AB2": "bo",
	"5480": "ju;zui",
	"7A37": "ji",
	"84A7": "zhen",
	"99A4": "ai",
	"644A": "tan",
	"7ED0": "dai",
	"9827": "dui",
	"9B3A": "shang",
	"7E68": "da",
	"9426": "kai",
	"9DD7": "ou",
	"77AE": "che",
	"8631": "lei",
	"8750": "mai",
	"8D33": "shi",
	"9552": "yi",
	"96D9": "shuang",
	"4E5C": "mie;nie",
	"6570": "shu;shuo",
	"4EAF": "heng",
	"5F5E": "yi",
	"85D5": "ou",
	"50D9": "guang",
	"5B62": "bao",
	"698D": "xie",
	"793F": "yue",
	"8442": "wan",
	"9A67": "ju",
	"4ED2": "none",
	"5483": "tuo",
	"5BA2": "ke",
	"6200": "lian",
	"683F": "fa",
	"68BE": "lai",
	"81A2": "lu",
	"84FB": "ji",
	"867E": "xia;ha",
	"9A0C": "zong",
	"5E0D": "hu",
	"695C": "hu",
	"6AA3": "qiang",
	"7C57": "kuo",
	"7E34": "qian",
	"6C8A": "dan",
	"8359": "da",
	"5A90": "xi",
	"6BA3": "jin",
	"837C": "tu",
	"83F8": "yan",
	"8CB7": "mai",
	"5A81": "wei",
	"5E61": "fan",
	"6483": "ji",
	"665A": "wan",
	"685A": "zan",
	"9CEE": "ji",
	"4EB4": "you",
	"5377": "juan;quan",
	"9789": "tao",
	"53F4": "qiu",
	"5E78": "xing",
	"6E67": "yong;chong",
	"7B08": "ji",
	"7EF5": "mian",
	"95BC": "e;yan",
	"583F": "jian",
	"60C7": "dun",
	"85D1": "qiong",
	"863D": "lei",
	"6220": "shi;chi",
	"8CFD": "sai",
	"90C4": "qie",
	"5116": "lan",
	"55D6": "sou",
	"643B": "nuo",
	"8521": "cai",
	"8BD6": "gua",
	"9440": "ai",
	"5FFB": "xin",
	"7BF6": "yan",
	"80CF": "zi",
	"9AEE": "fa",
	"57FA": "ji",
	"7C18": "xiao",
	"854A": "rui",
	"884A": "mie",
	"948D": "tu",
	"95A7": "hong",
	"96DD": "yong",
	"9A28": "tuo;tan",
	"9F79": "chi",
	"4E1A": "ye",
	"555F": "qi",
	"8965": "pu",
	"906C": "su",
	"737B": "xian",
	"86EA": "qie",
	"87A3": "teng",
	"9992": "man",
	"54EF": "xian",
	"5B4C": "luan",
	"7CA4": "yue",
	"7FF1": "ao",
	"8DE9": "zhuai;shi",
	"91C0": "niang",
	"9ABC": "ge",
	"9BD8": "nei",
	"5E52": "zhong",
	"6434": "qian",
	"73DC": "yang",
	"87DB": "peng",
	"500B": "ge",
	"6930": "ye",
	"7143": "kui",
	"7E3B": "mi",
	"53A6": "sha;xia",
	"6CEC": "xue",
	"7E6A": "hui",
	"9D6D": "qin",
	"9F3D": "yan;qui",
	"51B7": "leng",
	"5EC0": "sou",
	"60C2": "kan",
	"7A0F": "ya",
	"8288": "mi",
	"8B9E": "yan",
	"8D4D": "ji",
	"9596": "min",
	"67A5": "li",
	"6858": "zhui",
	"6C08": "zhan",
	"724D": "du",
	"6CA9": "wei",
	"8925": "ru",
	"8D42": "lu",
	"9D3F": "ge",
	"6234": "dai",
	"7B56": "ce",
	"9AE2": "ti",
	"4E57": "cheng;sheng",
	"52BE": "he",
	"8954": "man",
	"89AC": "ji",
	"997F": "e",
	"6C2A": "ke",
	"6CAF": "zan",
	"7F96": "gu",
	"7FB3": "fan",
	"9B55": "ji",
	"7969": "zhu",
	"8772": "la",
	"4EB2": "qin;qing",
	"60EE": "dan",
	"7C2E": "zan",
	"8F38": "shu",
	"5882": "biao",
	"5AA6": "wei",
	"5C3E": "wei;yi",
	"7547": "yun",
	"7765": "pi;bi",
	"7D4E": "heng;hang",
	"612A": "yun",
	"679E": "zong;cong",
	"6B91": "qing",
	"6D99": "lei",
	"8E88": "qiao",
	"9266": "zheng",
	"536A": "jie",
	"6635": "ni",
	"690F": "ya",
	"7308": "ba;pi",
	"7350": "zhang",
	"78F9": "dian",
	"7E11": "jian",
	"8D70": "zou",
	"99D6": "ling",
	"79CF": "hao",
	"7D5C": "xie;jie",
	"8250": "zong",
	"60B5": "chang",
	"6CCE": "zhuo",
	"7C36": "lu",
	"8D01": "bai",
	"5912": "nao",
	"5D7F": "ding",
	"7B13": "pi",
	"7B28": "ben",
	"90D3": "yun",
	"90E2": "ying",
	"9447": "ji",
	"969C": "zhang",
	"9D0B": "fang",
	"50BE": "qing",
	"566F": "ai",
	"5971": "lian",
	"7247": "pian",
	"5B72": "ya",
	"605C": "chi",
	"6F0D": "guo",
	"7168": "wei",
	"73E0": "zhu",
	"84D5": "gui",
	"9297": "hou",
	"99F9": "mang",
	"51CC": "ling",
	"524E": "cha",
	"6409": "que",
	"6757": "mang",
	"72F6": "xi",
	"7E6B": "xi;ji",
	"8733": "dun",
	"9B1F": "huan",
	"6197": "yin",
	"5700": "guo",
	"6A3B": "kui",
	"7E84": "peng",
	"8C17": "chan",
	"553C": "sha",
	"55A7": "xuan",
	"6774": "xian",
	"76E2": "xu",
	"7E40": "sui",
	"530F": "pao",
	"6DE7": "mi",
	"6EF3": "shang",
	"4ED5": "shi",
	"5287": "ju",
	"65F3": "di",
	"6E8A": "none",
	"8625": "yue",
	"6531": "gui",
	"6809": "zhi",
	"790E": "chu",
	"7F38": "gang",
	"930E": "xian",
	"4E73": "ru",
	"5A9D": "qiu",
	"5EF0": "ting",
	"68C1": "zhuo",
	"977B": "zu",
	"5B4A": "mi",
	"7426": "qi",
	"80C2": "shen",
	"8692": "ran",
	"9604": "jiu",
	"5486": "pao",
	"648D": "zan",
	"69CB": "gou",
	"6B7E": "mo",
	"770E": "shi",
	"77DB": "mao",
	"8343": "quan",
	"88B6": "jiang",
	"89F9": "xi",
	"8E90": "lie",
	"9EEA": "can",
	"5251": "jian",
	"54D0": "kuang",
	"6D5F": "you",
	"6DC1": "qie",
	"6E2B": "xie",
	"7149": "lian",
	"7BF2": "hui",
	"8780": "jiang",
	"880F": "xie",
	"8909": "xie",
	"8B00": "mou",
	"999E": "bo",
	"9E17": "long",
	"9EF1": "dai",
	"50DE": "wei",
	"8C03": "diao;tiao",
	"5E1B": "bo",
	"6C50": "xi",
	"8E35": "zhong",
	"92C9": "su",
	"9583": "shan",
	"967A": "xian",
	"87A2": "ying",
	"8927": "jiong",
	"9950": "yi",
	"9D87": "dong",
	"51E4": "feng",
	"5CDF": "you",
	"5D01": "kan",
	"69E9": "gai",
	"8A0E": "tao",
	"8C9A": "tan",
	"8E20": "wan",
	"9021": "qun",
	"5943": "di",
	"6B78": "gui",
	"8C13": "wei",
	"8C63": "jian",
	"9D83": "e",
	"59CE": "yang",
	"6AB2": "none",
	"6CF3": "yong",
	"72BA": "kang",
	"7897": "wan",
	"7955": "mi",
	"7B95": "ji",
	"8B44": "zeng",
	"5C58": "man",
	"7295": "bei",
	"74D6": "xiang",
	"8394": "meng",
	"8690": "jun",
	"5ACD": "tao;yao",
	"72A9": "wei",
	"6066": "xiang",
	"6706": "fen",
	"7738": "mou",
	"80FA": "an",
	"9622": "wu",
	"4F9F": "jian",
	"5666": "hui;yue",
	"62FE": "shi;she",
	"638D": "gun",
	"8CB4": "gui",
	"8D83": "die",
	"5D96": "yan",
	"6045": "lao",
	"680A": "long",
	"6987": "chen",
	"7810": "e",
	"79B0": "ni;mi",
	"811D": "heng",
	"9420": "pu",
	"9E33": "yuan",
	"56A5": "yan",
	"6720": "ying",
	"7328": "yuan",
	"7F27": "lei",
	"7AF6": "jing",
	"8551": "jian",
	"85F1": "hui",
	"8794": "yi",
	"8E4C": "qiang",
	"78EB": "zong",
	"7BF1": "li",
	"80D7": "zhen",
	"811E": "cuo",
	"8DA5": "qiu",
	"7AD0": "chu",
	"7E95": "xiang",
	"91B7": "yi",
	"5B94": "guai",
	"5D61": "weng",
	"691A": "none",
	"71AC": "ao",
	"7477": "ai",
	"8032": "huai",
	"9B1C": "qian",
	"54C2": "shen",
	"9146": "feng",
	"9DC3": "yan",
	"509E": "suo",
	"5B5C": "zi",
	"6638": "dong",
	"6C65": "zhi",
	"76BA": "zhou",
	"836D": "hong",
	"842C": "wan;mo",
	"88FB": "du",
	"744A": "zhen",
	"84AE": "yu",
	"850F": "shang",
	"9E7A": "cuo",
	"5F36": "jiang",
	"6F9E": "yu",
	"79A6": "yu",
	"7CBD": "zong",
	"9A08": "pian",
	"4F65": "qian",
	"52D8": "kan",
	"6DE4": "yu",
	"7090": "pang",
	"8B97": "huo",
	"8F04": "guang",
	"9730": "xian;san",
	"519A": "kan",
	"6A21": "mo;mu",
	"70C2": "lan",
	"7A20": "chou",
	"80B7": "qian",
	"8B95": "lan",
	"91D6": "dao",
	"99F0": "yin",
	"61C3": "qin",
	"6342": "wu",
	"8A36": "he",
	"535C": "bu;bo",
	"5417": "ma",
	"7E3C": "xuan",
	"7EF0": "chuo;chao",
	"808C": "ji",
	"77C9": "bin;pin",
	"7B15": "jian",
	"7DFE": "chan",
	"84AB": "cuo",
	"5381": "none",
	"61B5": "pi",
	"69AA": "ma",
	"792B": "li",
	"90A5": "shen",
	"5F3A": "qiang;jiang",
	"8D55": "dan",
	"5E19": "zhi",
	"6408": "yong",
	"93D2": "qiao",
	"6455": "di",
	"6E78": "liang",
	"9B45": "mei",
	"9C1E": "wu",
	"5676": "ga",
	"6237": "hu",
	"744F": "chuan",
	"5B2E": "yan",
	"6D9D": "lao",
	"7F85": "luo",
	"8DE2": "dai",
	"90F8": "dan",
	"6EDA": "gun",
	"8271": "jian",
	"8323": "wu",
	"992A": "nuan",
	"9EF2": "can",
	"5D6A": "qiao",
	"6502": "lei",
	"6AE5": "chu",
	"6FC8": "ji",
	"835F": "hui",
	"9CF4": "ming",
	"7CFF": "you",
	"8D06": "biao",
	"8DC8": "nian",
	"96CD": "yong",
	"4F3F": "yi",
	"522B": "bie",
	"6391": "qi",
	"6F2C": "zi",
	"642C": "ban",
	"6D0F": "er",
	"6F2E": "kang",
	"87F8": "li",
	"583C": "heng",
	"7BD1": "kui",
	"6B65": "bu",
	"6B88": "xu",
	"74B6": "jin",
	"7DC0": "qi",
	"82F1": "ying",
	"8767": "ying",
	"8856": "long",
	"9AFB": "ji",
	"5C37": "gan",
	"8DC2": "qi",
	"94A6": "qin",
	"9E47": "xian",
	"4EFB": "ren",
	"5BD6": "jin",
	"978E": "hen",
	"98F0": "fan",
	"5D31": "ze",
	"61EA": "bo",
	"6E42": "e",
	"769A": "ai",
	"56E5": "kang",
	"5FAF": "xi",
	"6057": "hu",
	"6151": "she",
	"61FC": "ju",
	"6DEB": "yin",
	"7DD8": "jian",
	"8E36": "di",
	"51F9": "ao;wa",
	"5FD8": "wang",
	"68B1": "kun",
	"6F9A": "ao",
	"87C4": "zhe;zhi",
	"9064": "none",
	"930D": "pi",
	"9E9D": "she",
	"4ECB": "jie",
	"55CE": "ma",
	"6F6E": "chao",
	"7345": "shi",
	"76DD": "lu",
	"827E": "ai;yi",
	"8410": "sha",
	"8544": "meng",
	"8559": "hui",
	"8B8F": "wei",
	"9184": "tao",
	"4E0B": "xia",
	"50CE": "zhuan",
	"790F": "ji",
	"793B": "shi",
	"7BE0": "xiao",
	"8DFA": "duo",
	"9023": "lian",
	"956F": "zhuo",
	"5223": "zhong",
	"62D5": "tuo",
	"7DC2": "tan",
	"7EED": "xu",
	"8764": "you;qiu",
	"62BA": "mo",
	"4F36": "ling",
	"54F2": "zhe",
	"6CB3": "he",
	"780A": "kang",
	"818A": "bo",
	"56A4": "mo",
	"6328": "ai",
	"715B": "jiong",
	"8E08": "shu",
	"5CF0": "feng",
	"64C8": "pu",
	"67FE": "jiu",
	"683D": "zai",
	"698F": "yi",
	"7D48": "pa",
	"8539": "lian",
	"887A": "xie",
	"88DA": "ji",
	"8BB6": "ya",
	"8BBB": "xiong",
	"6595": "lan",
	"7A91": "yao",
	"90FF": "mei",
	"582B": "zong",
	"6A83": "yin",
	"6C03": "tong",
	"7FDB": "shu",
	"896F": "chen",
	"8B27": "li",
	"9D3B": "hong",
	"6F23": "lian",
	"7130": "yan",
	"7275": "qian",
	"95AC": "lang",
	"59E4": "gou",
	"650C": "han",
	"6D04": "hui",
	"6D38": "guang;huang",
	"7AB6": "ju",
	"8B11": "xi",
	"90AE": "you",
	"9487": "yi",
	"94C2": "bo",
	"6352": "shu",
	"653B": "gong",
	"6D65": "yi",
	"7ECC": "chu",
	"88C4": "none",
	"94E4": "ting;ding",
	"5D89": "zui",
	"7402": "yan",
	"793C": "li",
	"512B": "hao",
	"5733": "zhen",
	"5C29": "wang",
	"71FF": "yao",
	"7AA4": "none",
	"7F69": "zhao",
	"92B5": "keng",
	"51AF": "feng;ping",
	"5EC9": "lian",
	"7C97": "cu",
	"8666": "zhan",
	"8789": "weng",
	"98F6": "bi",
	"8C4C": "wan",
	"9B1A": "xu",
	"9E5F": "weng",
	"9F25": "ba",
	"8589": "wei",
	"9B41": "kui",
	"4E19": "bing",
	"73B9": "xuan",
	"6639": "ai",
	"671C": "tun",
	"9AC7": "xiao",
	"5C09": "wei;yu",
	"5DF8": "yi",
	"5FA1": "yu",
	"5FEE": "zhi",
	"79BF": "tu",
	"894E": "fan",
	"923B": "si",
	"9579": "jiu",
	"590B": "qun",
	"5DCB": "kui",
	"74A9": "qu",
	"8ADF": "shi",
	"8D0C": "none",
	"72AF": "fan",
	"7451": "zhuan",
	"788E": "sui",
	"8859": "ya",
	"55FA": "cui",
	"6996": "gu",
	"7129": "ping",
	"79A7": "xi",
	"88AE": "none",
	"94E9": "sha",
	"9875": "ye",
	"9E64": "he",
	"4E83": "lin",
	"7366": "ge",
	"7699": "xi",
	"7A11": "lu",
	"5CDA": "mi",
	"65B3": "qin",
	"68A0": "lu",
	"752E": "none",
	"8632": "lei",
	"8DEB": "qiong",
	"96F4": "li",
	"9920": "bing",
	"4EA1": "wang;wu",
	"5CB1": "dai",
	"8C57": "hui",
	"8EC2": "lao",
	"9457": "li",
	"72BB": "bo",
	"8F73": "lu",
	"5CE3": "yao",
	"5ED3": "kuo",
	"74B9": "shu",
	"7CB3": "jing;geng",
	"7F78": "fa",
	"8421": "none",
	"90E0": "geng",
	"9208": "bu",
	"9641": "tuo",
	"994A": "san",
	"7643": "long",
	"8427": "xiao",
	"981D": "qiao",
	"9F48": "nong",
	"55D4": "chen",
	"6261": "chi",
	"6EA8": "cai",
	"82B6": "gou",
	"968B": "sui",
	"5271": "jian",
	"602A": "guai",
	"68FF": "nie",
	"6DB9": "wo",
	"73DF": "su",
	"8B7E": "jian",
	"4E84": "yi",
	"6999": "ta",
	"736B": "xian",
	"7A4E": "ying",
	"8506": "leng",
	"8A91": "kuang",
	"8B33": "ou",
	"95DE": "kan;han",
	"57B9": "bang",
	"5894": "cui",
	"5E0C": "xi",
	"65B5": "zhuo",
	"68B4": "chan",
	"75AC": "li",
	"833F": "zhu",
	"8C5D": "ba",
	"99B8": "xin",
	"541E": "tun",
	"584A": "kuai",
	"6932": "wei",
	"6E68": "ju",
	"748B": "zhang",
	"8119": "qiu",
	"89D2": "jiao;jue",
	"989E": "nie",
	"9A5C": "ye",
	"5023": "fang",
	"5D6C": "wei",
	"65BA": "xie",
	"7952": "tiao",
	"7B69": "tong",
	"7C30": "pai",
	"81FF": "cha",
	"9236": "yi",
	"9716": "lin",
	"5836": "tuo",
	"64D6": "ge",
	"66CD": "hao",
	"6A7F": "jiang",
	"9BA4": "lie",
	"566D": "jiao",
	"5DD6": "yan",
	"60DA": "hu",
	"63C6": "kui",
	"6ACE": "guang",
	"7755": "wan",
	"7BBC": "wu",
	"871F": "yu",
	"9C66": "sheng",
	"9D0D": "wen",
	"50E4": "dan",
	"75A2": "chen",
	"7726": "zi",
	"7B62": "pa",
	"8199": "jiang",
	"8417": "ce",
	"8D90": "xue",
	"9791": "da",
	"9AA1": "luo",
	"771B": "mei",
	"7A50": "qiu",
	"7E32": "lei",
	"9070": "zhi",
	"9174": "tu",
	"7171": "gua",
	"8799": "du",
	"882D": "feng",
	"8A26": "chen",
	"5AEE": "hu",
	"7D6B": "lei",
	"564B": "tun",
	"5D18": "lun",
	"65AF": "si",
	"7727": "chao",
	"8993": "mi",
	"9BF7": "ti",
	"51BC": "xian",
	"5CB3": "yue",
	"79AD": "sui",
	"8712": "yan",
	"91DB": "he",
	"9221": "zhong",
	"9628": "e",
	"96EB": "na",
	"99B6": "zhi",
	"5719": "lue",
	"5E9B": "ci",
	"61F5": "meng",
	"6A9C": "gui;hui;kuai",
	"6CFF": "yin",
	"6FB2": "ye",
	"7A81": "tu",
	"8E3E": "fu",
	"9AB5": "ti",
	"664D": "tong",
	"900D": "xiao",
	"6A70": "gao",
	"7A7E": "yao",
	"85FE": "lai",
	"925A": "liu;mao",
	"9704": "xiao",
	"4F1F": "wei",
	"5008": "lai",
	"594F": "zou",
	"59A4": "yu",
	"66C0": "yi",
	"802D": "ji",
	"8DF5": "jian",
	"8F87": "nian",
	"916C": "chou",
	"528E": "jian",
	"55A4": "huang",
	"59D2": "si",
	"76D3": "yu",
	"7B36": "shi",
	"7D30": "xi",
	"874B": "la;zha",
	"98BC": "sou",
	"6C11": "min",
	"735C": "lin",
	"73D6": "guang",
	"96E0": "chou",
	"5194": "xu",
	"5AE9": "nen",
	"6335": "long;nong",
	"6D91": "su",
	"9DAD": "fang",
	"9F19": "pi",
	"5CDC": "ji",
	"5F5D": "yi",
	"6062": "hui",
	"64A9": "liao",
	"71C8": "deng",
	"7FAB": "qiang",
	"839A": "yan",
	"9199": "sou",
	"9760": "kao",
	"521D": "chu",
	"54B3": "ke;hai;ka;kai",
	"5F7C": "bi",
	"64A1": "cao",
	"7804": "jue",
	"89B8": "jian",
	"8FA0": "zui",
	"5A09": "ping",
	"6187": "qi",
	"6BDA": "chan",
	"7607": "zhong",
	"9042": "sui",
	"9382": "mei",
	"9DD1": "li",
	"5A0B": "shao",
	"5F9E": "cong;zong",
	"6133": "ju",
	"7A65": "yu",
	"7C01": "xi",
	"7C44": "kui",
	"8DD1": "pao",
	"8F7C": "shi",
	"9AA4": "zhou",
	"514C": "dui",
	"53B1": "lan",
	"7156": "nuan;xuan",
	"77AD": "liao",
	"7A5F": "sui",
	"8D93": "duo",
	"9041": "dun",
	"6405": "jiao",
	"714B": "xing",
	"757F": "ji",
	"8952": "bie",
	"620F": "xi;hu",
	"7230": "yuan",
	"86D4": "hui",
	"5C4A": "jie",
	"7112": "none",
	"724E": "yong",
	"7B33": "jia",
	"7A0E": "shui",
	"7C81": "qian",
	"7D07": "he;ge",
	"7FDE": "jiang",
	"86DA": "lie",
	"89E2": "zhi",
	"8DF2": "jia",
	"8E25": "qie",
	"77BF": "ju;qu",
	"7A78": "xi",
	"7F0E": "duan",
	"86CB": "dan",
	"5375": "luan",
	"56DB": "si",
	"5781": "zhi",
	"6094": "hui",
	"8985": "none",
	"9993": "san",
	"55DB": "qian",
	"6430": "hu",
	"64C1": "yong",
	"66D6": "ai",
	"69EB": "tuan",
	"7F03": "xiang",
	"9CC1": "wen",
	"5182": "jiong",
	"59DE": "ji",
	"5A2A": "wu",
	"75F9": "bi",
	"7B99": "fu",
	"8F25": "gun",
	"932C": "lian",
	"5910": "xiong",
	"7F3D": "bo",
	"9813": "dun",
	"5996": "yao",
	"6803": "none",
	"7670": "yong",
	"8F1C": "zi",
	"5E5D": "chan",
	"709D": "qiang",
	"72C6": "zhong",
	"7AAE": "qiong",
	"7B63": "li",
	"5E77": "bing",
	"6076": "e;wu",
	"757B": "cheng",
	"89D1": "qu",
	"90ED": "guo",
	"9BA9": "bing",
	"9DBA": "ji",
	"5C28": "mang;pang",
	"6A86": "shan",
	"759F": "nue;yao",
	"9250": "shi",
	"9468": "long",
	"51B0": "bing",
	"5ABB": "pan",
	"7796": "yi",
	"7B39": "none",
	"7C13": "none",
	"7CAF": "xian",
	"8744": "wang",
	"929A": "yao;diao;tiao",
	"96CE": "ju",
	"92FC": "gang",
	"994D": "shan",
	"5588": "jie",
	"623A": "shi",
	"7692": "e",
	"9864": "yao",
	"5A8E": "jie",
	"69A1": "su",
	"8941": "qiang",
	"8E9B": "wei",
	"9477": "nie",
	"96E2": "li",
	"5299": "li",
	"6A14": "chao",
	"99C0": "you",
	"5814": "chen",
	"69E5": "hui",
	"73BC": "ci",
	"76D4": "kui",
	"7BD9": "gao",
	"821A": "tian",
	"8C77": "yi",
	"90B2": "bi",
	"920D": "dun",
	"5065": "jian",
	"5BEB": "xie",
	"6E79": "chan",
	"6F43": "xiu",
	"7460": "liu",
	"7509": "xian",
	"8374": "fu",
	"89BD": "lan",
	"95B0": "yan",
	"6BC3": "que",
	"71F9": "xian",
	"7C8E": "chi",
	"7FDD": "hong",
	"82D3": "ling",
	"960B": "xi",
	"66D5": "none",
	"7582": "die",
	"9B7E": "pi",
	"5ABC": "ao",
	"5F0B": "yi",
	"6641": "chao;zhao",
	"6F22": "han",
	"791B": "jian",
	"9BA6": "tong",
	"617B": "juan",
	"7ADF": "jing",
	"9BBE": "nei",
	"513D": "lei",
	"52D0": "meng",
	"559A": "huan",
	"5FC4": "xin",
	"6436": "qiang;chuang",
	"4F10": "fa",
	"573A": "chang",
	"5D15": "ya",
	"7391": "ji",
	"83B7": "huo",
	"8F07": "quan",
	"90EF": "tan",
	"8B54": "zhuan",
	"94AA": "kang",
	"604E": "die",
	"616E": "lu",
	"714A": "xuan",
	"8D23": "ze",
	"9847": "cui",
	"9E8D": "liu",
	"7995": "yi",
	"951B": "ben",
	"9DF3": "xian",
	"5869": "yan",
	"88E2": "lian",
	"9802": "ding",
	"9826": "ke",
	"9BD2": "yong",
	"51E5": "ju",
	"5EB2": "lai",
	"61B6": "yi",
	"82AC": "fen",
	"9708": "pei",
	"5BD7": "ning",
	"5C16": "jian",
	"5CC0": "xiu",
	"67B2": "xi",
	"6B40": "kuan",
	"728D": "jian;qian",
	"7D57": "hu",
	"8563": "shun",
	"8BD2": "yi",
	"906B": "su",
	"95D9": "qi",
	"6A46": "wu",
	"81AF": "teng",
	"87BB": "lou",
	"97C3": "da",
	"5DED": "none",
	"81CF": "bin",
	"8BD5": "shi",
	"97FC": "peng",
	"5DF5": "zhi",
	"82D7": "miao",
	"5416": "a",
	"6A96": "sui",
	"9C82": "fang",
	"9F81": "he",
	"4E9D": "qi",
	"509F": "wang",
	"5689": "duo",
	"614D": "yun",
	"9074": "lin",
	"51FA": "chu",
	"74F0": "none",
	"82B8": "yun",
	"615E": "zhang",
	"6C9A": "zhi",
	"7834": "po",
	"846C": "zang",
	"9667": "nie",
	"52DE": "lao",
	"5D00": "lang",
	"7DA2": "chou",
	"4F14": "chen",
	"55C6": "qiang",
	"5F64": "tong",
	"8E47": "jian",
	"903A": "yuan",
	"940B": "tang",
	"87AE": "di",
	"4FDE": "yu;shu",
	"5052": "tang",
	"608B": "lin",
	"6458": "zhai;zhe",
	"77BE": "zhao",
	"6DB6": "tuo",
	"8E6F": "fan",
	"6331": "suo",
	"73C8": "jia",
	"83FC": "tan",
	"6C22": "qing",
	"7004": "jie",
	"770D": "kou",
	"6829": "xu",
	"6E29": "wen",
	"7133": "jue",
	"8FE8": "dai",
	"9E65": "yi",
	"77A3": "huan",
	"7924": "ca",
	"8797": "tang",
	"8E6A": "tui",
	"525D": "bo",
	"5A99": "wei",
	"7768": "ni",
	"890B": "die",
	"8D13": "zang",
	"8D8A": "yue",
	"9229": "lu",
	"5950": "huan",
	"687E": "jun",
	"5423": "qin",
	"5F5B": "yi",
	"6669": "wan",
	"8369": "jin",
	"92C0": "dou",
	"9424": "ding",
	"5617": "chang",
	"5EF8": "di",
	"5CF2": "li",
	"7F44": "qing",
	"893B": "xie",
	"70C4": "jiao",
	"7373": "nou",
	"73C6": "yi",
	"9A72": "ri",
	"9EB9": "qu",
	"6270": "rao",
	"79C4": "zi",
	"8D88": "zhan",
	"9E1F": "niao;diao",
	"6F56": "pa",
	"68FD": "chen",
	"6B7F": "mo",
	"6E12": "pi",
	"83A0": "you",
	"5CA4": "xue",
	"785A": "qiao",
	"8067": "kui",
	"9693": "hui",
	"508D": "bang",
	"551A": "qin",
	"5A94": "mian",
	"9F98": "ta",
	"5ED0": "jiu",
	"7E0D": "bang",
	"80F4": "dong",
	"8262": "qiang",
	"8AD4": "zhu",
	"8F11": "yun",
	"90E6": "li",
	"98A3": "lei",
	"9B18": "man",
	"6A27": "sha",
	"73FA": "jun",
	"828E": "xiong",
	"8E31": "duo",
	"6741": "none",
	"852C": "shu",
	"5C7F": "yu",
	"6F31": "shu",
	"86FF": "han",
	"4EE6": "chao",
	"87DE": "bie",
	"90F6": "bu",
	"686C": "suo",
	"8EAE": "none",
	"98B6": "ju",
	"9AD8": "gao",
	"508B": "gou",
	"6427": "shan",
	"6581": "yi;du",
	"66B7": "chuan",
	"74A4": "none",
	"8575": "sun",
	"9C22": "ma",
	"64C0": "gan",
	"678B": "fang",
	"67B8": "gou;ju",
	"8496": "zhen",
	"888D": "pao",
	"98E0": "shi;si",
	"50FE": "ai",
	"5FC3": "xin",
	"80EF": "kua",
	"831B": "gen",
	"908B": "la",
	"92E7": "xian",
	"93FE": "san",
	"50D1": "qiao",
	"5FE4": "wu",
	"701C": "rong",
	"4F18": "you",
	"5B08": "rao",
	"7EF4": "wei",
	"897B": "pan",
	"97A5": "yi;eng",
	"5288": "pi",
	"53F1": "chi",
	"59B7": "zhi",
	"6108": "yu",
	"622F": "xi;hu",
	"76FF": "min",
	"81CB": "tun",
	"9EB6": "chi;li",
	"8229": "chuan",
	"8238": "ge",
	"89D9": "ji",
	"9621": "qian",
	"9E3A": "xiu",
	"9E45": "e",
	"9F80": "chen",
	"4FD2": "hun",
	"51AA": "mi",
	"588D": "ji",
	"6368": "she",
	"7CC3": "tang",
	"4E5D": "jiu",
	"50CB": "qiu",
	"601B": "da",
	"6695": "jian",
	"675E": "qi",
	"94BF": "dian;tian",
	"4F6E": "ge",
	"6058": "qiu",
	"606A": "ke;que",
	"63D2": "cha",
	"6B60": "chuo",
	"6C38": "yong",
	"7252": "die",
	"739C": "hong",
	"7598": "gong;gang",
	"69C1": "gao",
	"6AF7": "none",
	"6D77": "hai",
	"71DD": "none",
	"83D2": "gao",
	"86C1": "diao",
	"8DFD": "ji",
	"9344": "liang",
	"9733": "long",
	"9BBC": "qin",
	"9E04": "ji",
	"5D5B": "yu",
	"5D97": "lao",
	"6FDF": "ji",
	"79F8": "jie",
	"7BC1": "huang",
	"9E56": "he",
	"58B5": "tan",
	"6047": "kuang",
	"62A3": "none",
	"65DE": "sui",
	"874A": "none",
	"54FC": "heng;hng",
	"87B1": "wei",
	"9E7F": "lu",
	"50E5": "jiao;yao",
	"9AB9": "qiao",
	"6359": "yi",
	"661E": "bing",
	"67A7": "jian",
	"70A2": "zhu",
	"74B0": "huan",
	"7BC2": "xing",
	"863A": "li",
	"5530": "shua",
	"5674": "pen",
	"5D60": "xi",
	"66E4": "huo",
	"7C92": "li",
	"8D5B": "sai",
	"8E44": "ti",
	"93CF": "wei",
	"9B0F": "jiu",
	"52C2": "hao",
	"55BA": "xi",
	"7975": "kun",
	"7CE5": "nuo",
	"88BF": "gui",
	"621A": "qi",
	"7701": "sheng;xing",
	"7CAC": "qu",
	"5016": "xing",
	"509C": "yao",
	"510F": "none",
	"74CB": "zhe",
	"85DE": "la",
	"86DE": "kuo",
	"5A62": "bi",
	"5B3B": "du",
	"60F1": "nao",
	"550D": "guan",
	"5FEA": "zhong;song",
	"8D4B": "fu",
	"961F": "dui",
	"5782": "chui",
	"5E50": "teng",
	"8D2A": "tan",
	"8DC1": "pa",
	"9620": "xin;shen",
	"5703": "pu",
	"75FF": "wei",
	"76D5": "fan",
	"8766": "xia;ha",
	"5BDB": "kuan",
	"699B": "zhen",
	"93B9": "rong",
	"717A": "tui",
	"7380": "luo",
	"7600": "yu",
	"7C9D": "li",
	"89A3": "wei",
	"9279": "chi",
	"6711": "none",
	"68F9": "zhao;zhuo",
	"70F1": "jiong",
	"757C": "chang",
	"7633": "chou",
	"5691": "none",
	"5C25": "liao",
	"608A": "zhe;qi",
	"8E19": "ju",
	"503C": "zhi",
	"574D": "tan",
	"6ACB": "mian",
	"8873": "zhong",
	"8E30": "yu",
	"9DE0": "yu",
	"5151": "dui",
	"55D8": "ji",
	"5CA5": "bo",
	"6431": "zhi",
	"66A5": "yan",
	"784C": "luo;ge",
	"985F": "liao",
	"5963": "weng",
	"6356": "huan",
	"6EE5": "lan",
	"77AC": "shun",
	"79CD": "zhong;chong",
	"9467": "none",
	"686A": "xun",
	"7713": "huo",
	"77BD": "gu",
	"7B8D": "gu",
	"970B": "qi",
	"9A34": "yan",
	"8420": "meng",
	"5A7F": "xu",
	"703B": "dai",
	"7377": "guang",
	"9437": "ye",
	"5EB5": "an",
	"84E3": "yu",
	"8C5C": "jian",
	"9CC9": "jiang",
	"5501": "yan",
	"6162": "man",
	"61EB": "zhi",
	"61F9": "rang",
	"6859": "yu",
	"6BDF": "none",
	"7A04": "ze",
	"8002": "none",
	"8192": "none",
	"5256": "pou",
	"5E57": "guo",
	"6DAE": "shuan",
	"808E": "ken",
	"9850": "hun",
	"66DD": "pu;bao",
	"817E": "teng",
	"5BC4": "ji",
	"5D98": "zhan",
	"63EF": "geng",
	"664B": "jin",
	"6845": "wei",
	"7070": "hui",
	"7348": "yi",
	"7BA2": "yuan",
	"7F7F": "tong",
	"96B8": "li",
	"637E": "wo",
	"674A": "xun",
	"7D56": "kuang",
	"9551": "bang",
	"52C0": "ke",
	"54F3": "zha",
	"5D3B": "zhi",
	"9068": "ao",
	"9F46": "weng",
	"556C": "se",
	"661F": "xing",
	"757A": "jiang",
	"8B60": "zhan",
	"91D2": "jin",
	"954B": "tang",
	"5620": "ga",
	"86CF": "cheng",
	"88A4": "mao",
	"9139": "zou",
	"56FF": "you",
	"6FCE": "ding",
	"75BA": "fa",
	"77A7": "qiao;ya",
	"7B86": "bi",
	"812F": "fu;pu",
	"91CB": "shi",
	"59DD": "shu",
	"715F": "wu",
	"819C": "mo",
	"995C": "yan",
	"6937": "jian",
	"878F": "ji",
	"8B4B": "lan",
	"5F48": "dan;tan",
	"6DB2": "ye;yi",
	"78D1": "wei",
	"9FA4": "xie",
	"50E2": "chuan",
	"8CD0": "xun",
	"975D": "tian",
	"9DCB": "tu",
	"5235": "er",
	"575D": "ba",
	"5D1D": "cheng",
	"6783": "yun",
	"7A15": "zhun",
	"8687": "chi",
	"9562": "jue",
	"5029": "qian",
	"550A": "jia",
	"5999": "miao",
	"5DE6": "zuo",
	"664E": "hong",
	"9C0B": "yan",
	"7A44": "ji",
	"7C8F": "tai",
	"8212": "shu",
	"8DC0": "yue",
	"8EFE": "shi",
	"5312": "da",
	"5650": "qi",
	"95CE": "none",
	"9C65": "gui",
	"6C6E": "jun",
	"731A": "ya",
	"7F6B": "gua",
	"81F9": "xiu",
	"8570": "wen",
	"8A16": "qi",
	"97EC": "tao",
	"9CA1": "li",
	"4F83": "kan",
	"5DA5": "jue",
	"5E14": "pei",
	"6535": "po",
	"6BC7": "hui",
	"7916": "yu",
	"8248": "none",
	"95ED": "bi",
	"9C76": "xiang",
	"5517": "dou",
	"5D3F": "e",
	"563C": "xu",
	"5A97": "xuan",
	"61F3": "none",
	"6AB5": "ji",
	"78C7": "pi",
	"7950": "you",
	"8B50": "zun",
	"8B90": "chou",
	"5AB7": "ru",
	"7CB7": "ju",
	"8D03": "zhuan",
	"926C": "mu",
	"95C1": "none",
	"4E18": "qiu",
	"585F": "zang",
	"6B9C": "ye",
	"7486": "qiu",
	"8601": "wu;e",
	"8958": "hui",
	"98B3": "gua",
	"5B75": "fu",
	"647E": "jiang",
	"6935": "jia",
	"6E26": "wo;guo",
	"72ED": "xia",
	"8446": "bao",
	"873F": "wan",
	"9C32": "ao",
	"6BCC": "guan",
	"8A5D": "zhu",
	"8F93": "shu",
	"919A": "mi",
	"55E0": "luo",
	"6CB0": "tuo",
	"7942": "ta",
	"9D31": "ai",
	"5E2F": "dai",
	"75F5": "ji",
	"8A15": "shan",
	"9244": "tie",
	"534B": "shi",
	"5E9D": "tong",
	"61BE": "han",
	"647A": "zhe",
	"6A71": "chu",
	"8E0C": "chou",
	"90F4": "chen",
	"9173": "yin",
	"9BFE": "bian",
	"5051": "feng",
	"6F49": "none",
	"70F7": "wan",
	"939B": "bo",
	"629A": "fu",
	"991B": "hun",
	"69D5": "zhuo",
	"797B": "gu",
	"7BCD": "qiu",
	"990A": "yang",
	"74EA": "ban",
	"7A6A": "cheng",
	"7D67": "tong",
	"8391": "feng",
	"8FD2": "hang",
	"560B": "xiao",
	"5843": "huang",
	"6E30": "yan",
	"774C": "wan",
	"813E": "pi",
	"8D34": "tie",
	"904C": "e",
	"58AB": "zun",
	"6897": "geng",
	"8532": "kou",
	"85F9": "ai",
	"94C8": "shi",
	"4E03": "qi",
	"50ED": "jian",
	"5C78": "long",
	"6148": "ci",
	"667A": "zhi",
	"6EE0": "she",
	"932B": "xi",
	"623E": "li",
	"6DBE": "ta",
	"71A7": "zong",
	"7ECF": "jing",
	"9030": "you",
	"999C": "ni",
	"5715": "tu;shu;guan",
	"5A47": "cai",
	"62C0": "chu",
	"7258": "du",
	"96F9": "bao",
	"9F10": "nai",
	"5158": "shi",
	"5D6D": "beng",
	"6853": "huan",
	"6E38": "you",
	"7236": "fu",
	"9DC5": "li;piao",
	"547D": "ming",
	"65BC": "wu;yu",
	"6E0F": "none",
	"785B": "none",
	"8A69": "shi",
	"9A10": "yan",
	"5240": "kai",
	"697E": "none",
	"72B8": "ma",
	"7DC9": "liang",
	"82F3": "dong",
	"5BB3": "hai",
	"65DD": "guai",
	"745E": "rui",
	"7F11": "gou",
	"8191": "bin",
	"8B37": "ao",
	"8CEB": "ji",
	"5AF6": "qiao",
	"689A": "wan",
	"68D1": "pai",
	"7B17": "dong",
	"84C5": "liu",
	"896E": "bo",
	"8EE6": "huang",
	"572B": "yu",
	"5901": "yi",
	"633B": "shan",
	"7049": "yong",
	"76D9": "fu",
	"843C": "e",
	"8BA6": "jie",
	"9155": "mao",
	"586E": "xie",
	"60BF": "tian",
	"7577": "chuo",
	"8D2B": "pin",
	"934A": "lian",
	"9ADF": "biao;shan",
	"6A84": "xi",
	"6C52": "mang",
	"6F66": "liao;lao",
	"758D": "dan",
	"77B1": "ye",
	"7C8D": "li",
	"8906": "shi",
	"696D": "ye",
	"71DE": "none",
	"724A": "shao",
	"7279": "te",
	"8405": "chun",
	"8E7F": "cuan",
	"9EE9": "du",
	"555C": "chuo;chuai",
	"6994": "lang",
	"69B3": "ting",
	"6AF3": "long",
	"7660": "ji",
	"817B": "ni",
	"87BF": "jiang",
	"8AE3": "hua",
	"94C1": "tie",
	"9F4C": "ji",
	"5ED7": "dai",
	"65F8": "yang",
	"69CE": "cha",
	"6A19": "biao",
	"745C": "yu",
	"9718": "dong",
	"6E69": "zhong",
	"6F7F": "wei",
	"7DCB": "fei",
	"7F24": "bin",
	"9A99": "kui",
	"5061": "zhan",
	"6136": "xie",
	"82C6": "none",
	"8AFF": "qi",
	"8BE1": "gui",
	"95E7": "none",
	"9EA9": "fu",
	"643A": "xie",
	"7695": "bi",
	"868A": "wen",
	"91B0": "tan",
	"9A22": "xia",
	"5A40": "e",
	"5D3E": "yao",
	"8445": "ju",
	"8A05": "qiu",
	"96E6": "ji",
	"9C2A": "ge",
	"5A30": "si",
	"6D33": "ru",
	"71E8": "xi",
	"5C87": "ang",
	"5E7D": "you",
	"6B7A": "dai",
	"6C89": "chen",
	"8DFE": "shu",
	"945C": "shang",
	"4FC1": "yu",
	"5DE3": "chao",
	"5E27": "zhen",
	"8D6B": "he",
	"8E8C": "wu",
	"933E": "zan",
	"952D": "ding",
	"9696": "wu",
	"5A39": "xian",
	"64FD": "lue",
	"6A10": "lu",
	"78DB": "chan",
	"7E59": "fan",
	"80AB": "zhun",
	"5F33": "jing",
	"667D": "lin",
	"7D31": "fu",
	"868D": "pi",
	"8B0A": "huang",
	"9720": "yin",
	"5348": "wu",
	"6962": "you",
	"74E2": "piao",
	"96F7": "lei",
	"523F": "gui",
	"542C": "ting;yin",
	"88C0": "yin",
	"6262": "gu",
	"87C8": "guo",
	"9461": "chuo",
	"9710": "weng",
	"4E4C": "wu",
	"5D4C": "qian;kan",
	"71CB": "jiao",
	"74A2": "liu",
	"7E35": "man",
	"7EAE": "hong",
	"8579": "weng",
	"8688": "qian",
	"51C1": "shu",
	"5977": "qian",
	"7C50": "teng",
	"80A5": "fei",
	"8FCD": "zhun",
	"9255": "po",
	"9448": "nie",
	"601D": "si;sai",
	"7C46": "yue",
	"9BA3": "yin",
	"652B": "jue",
	"6625": "chun",
	"797C": "guan",
	"94A4": "qian",
	"9C79": "guan",
	"5FB6": "bie",
	"6020": "dai",
	"6633": "die",
	"668F": "du",
	"7A77": "qiong",
	"7AAA": "wa",
	"7FB7": "lian",
	"9825": "yi",
	"6DA3": "huan",
	"77F0": "zeng",
	"7EAB": "ren",
	"907D": "ju",
	"5B6D": "mie",
	"9084": "huan;hai;xuan",
	"4E32": "chuan",
	"6407": "qin",
	"6A81": "lin",
	"6E84": "none",
	"73E7": "yao",
	"83DB": "men",
	"8777": "li;xi",
	"56E8": "pian",
	"5BCB": "jian",
	"6A16": "ke",
	"781E": "mo",
	"7D11": "fou",
	"7F26": "man",
	"9353": "ji",
	"9592": "xian",
	"9E6B": "jiu",
	"51FF": "zao;zuo",
	"5F44": "kou",
	"61DB": "dai",
	"69A5": "huang",
	"6C39": "dang",
	"7785": "chou",
	"7912": "wo;yi",
	"79CC": "qiu",
	"84E4": "none",
	"8D74": "fu",
	"8E5D": "xi",
	"58D9": "kuang",
	"6816": "qi;xi",
	"79DB": "pi",
	"7DA1": "liang",
	"8B14": "nue;xue",
	"9C50": "su",
	"4E15": "pi",
	"5175": "bing",
	"55DF": "jie;jue",
	"6D94": "cen",
	"8F0C": "liang",
	"9225": "huo",
	"9E9B": "mi",
	"8372": "chu",
	"51D5": "ming",
	"5310": "fu",
	"7844": "kuang",
	"835B": "rao",
	"4E95": "jing",
	"6884": "you",
	"6C0B": "meng",
	"6C2D": "dong",
	"5450": "na;ne",
	"612D": "qi",
	"8C47": "jiang",
	"4F8C": "yin",
	"7C26": "deng",
	"7F2E": "shan",
	"859A": "tang",
	"97EB": "yun",
	"58FB": "xu",
	"6837": "yang",
	"7D8E": "ting",
	"9332": "lu",
	"9B32": "li;ge",
	"508F": "tang",
	"7781": "xu",
	"7A42": "sui",
	"8665": "zhan",
	"87AD": "chi",
	"8A42": "fu",
	"9469": "e",
	"97FE": "yin",
	"5830": "yan",
	"704A": "qian",
	"75F6": "tian",
	"891A": "chu;zhu",
	"6557": "bai",
	"7336": "you",
	"7657": "lei",
	"77D6": "xi",
	"7E43": "beng",
	"67C2": "yi",
	"7291": "ju",
	"770C": "xian",
	"962F": "zhi",
	"7175": "xia",
	"7452": "yang",
	"8B9A": "zan",
	"5DB4": "ao",
	"6449": "sou",
	"69EF": "cui",
	"755F": "ce",
	"76F1": "xu",
	"7949": "zhi",
	"806E": "lian",
	"9857": "yi",
	"9CD8": "min",
	"5FFE": "kai",
	"73CF": "jue",
	"8346": "jing",
	"85C4": "qi",
	"9A74": "lu",
	"5105": "dang",
	"5360": "zhan",
	"5A0A": "xian",
	"5BC2": "ji",
	"5D4D": "wu",
	"63F9": "bei",
	"6947": "huo",
	"7ABE": "kuan",
	"7D02": "zhou",
	"8E38": "chen",
	"5BCC": "fu",
	"6DBC": "liang",
	"73E4": "bao",
	"75DB": "tong",
	"78A6": "ke",
	"812D": "cheng",
	"81F6": "jian",
	"8D8E": "chu",
	"95B9": "yan",
	"9EBD": "mo;me",
	"5507": "chun",
	"5AC6": "yong",
	"6390": "qia",
	"64F5": "mo;ma",
	"6CF5": "beng",
	"8682": "ma",
	"580B": "peng;beng",
	"6D31": "er",
	"6FD6": "shu",
	"7132": "yi",
	"7428": "kun",
	"809B": "gang",
	"60A2": "liang",
	"69E4": "lian",
	"6B13": "dang",
	"74EC": "fang",
	"9B7F": "ling",
	"9C9D": "zha",
	"58C1": "bi",
	"5D4A": "sheng",
	"6216": "huo",
	"6AFB": "ying",
	"8244": "shao",
	"9CCC": "ao",
	"80F3": "ge;ga",
	"4E2D": "zhong",
	"4EA0": "tou",
	"6946": "yao",
	"6E7B": "chun",
	"7AA3": "su",
	"7B8E": "chi",
	"7DE2": "miao",
	"7FC4": "chi",
	"8765": "mao",
	"93A0": "gang",
	"60EC": "qie",
	"687B": "feng",
	"70EF": "xi",
	"7848": "jia",
	"7962": "mi;ni",
	"7966": "wu",
	"5C15": "ga",
	"746C": "liu",
	"9F36": "si",
	"5570": "luo",
	"7F63": "gua",
	"8CB1": "bi",
	"9346": "men",
	"4FDB": "mian",
	"5060": "yao",
	"6B29": "chao",
	"8477": "hun;xun",
	"9145": "xi",
	"918A": "chuo",
	"4E27": "sang",
	"7A0D": "shao",
	"9273": "bei",
	"9F4B": "zhai",
	"5297": "cuan",
	"6BCE": "mei",
	"6D37": "zhi",
	"6DA1": "wo;guo",
	"8768": "shi",
	"8B0E": "mi;mei",
	"5F6A": "biao",
	"69C0": "kao",
	"8541": "qian;xun",
	"99CF": "ju",
	"65C0": "none",
	"65F2": "tai",
	"72D4": "ni",
	"7D8D": "fu",
	"8BE9": "xu",
	"988C": "he;ge",
	"5F6F": "piao",
	"86F7": "qiu",
	"4F62": "ju",
	"566C": "shi",
	"5D2F": "yin",
	"63DA": "yang",
	"6887": "long",
	"7433": "lin",
	"74C8": "li",
	"7EA4": "xian;qian",
	"4E7A": "none",
	"51FD": "han",
	"66CC": "zhao",
	"708C": "kai",
	"756C": "yu",
	"8BED": "yu",
	"5AF7": "tuo",
	"6135": "ta",
	"720F": "li",
	"9EAC": "fu",
	"5554": "qi",
	"7125": "yue",
	"7558": "nan",
	"7B37": "mao",
	"7D5B": "tao",
	"89D4": "jin",
	"4E14": "qie;ju",
	"4F17": "zhong",
	"7088": "yi",
	"7E94": "cai",
	"85A9": "sa",
	"9B7C": "qu",
	"6618": "fang",
	"8469": "pa",
	"89FB": "li",
	"94AB": "fang",
	"96D5": "diao",
	"55EC": "he",
	"7199": "xi",
	"730F": "jian",
	"7C8B": "cui;sui",
	"801C": "si",
	"9690": "yin",
	"5905": "xiang",
	"71EF": "ling",
	"8E8A": "chou",
	"957D": "liao",
	"9DF0": "yan",
	"5C9C": "ba",
	"630C": "ge",
	"74E7": "none",
	"973C": "xi",
	"5C1C": "ga",
	"62AC": "tai",
	"62B1": "bao",
	"8029": "jiang",
	"8223": "yi",
	"84D1": "suo",
	"8694": "qi;chi",
	"5A2D": "xi",
	"60A3": "huan",
	"6512": "zan;cuan",
	"8B84": "lei",
	"99DC": "bi",
	"4F20": "chuan;zhuan",
	"5429": "fen",
	"9339": "ken",
	"9D96": "qiu",
	"4F99": "chi",
	"6070": "qia",
	"6750": "cai",
	"7346": "hao",
	"9F33": "ju",
	"6078": "tong",
	"7D52": "chou",
	"85EE": "qiao",
	"8FBA": "bian",
	"5636": "si",
	"5A89": "wu",
	"6B18": "zhu",
	"6E97": "sheng",
	"7889": "diao",
	"7A0A": "ti",
	"8557": "lu",
	"8F28": "guan",
	"92C3": "lang",
	"5206": "fen",
	"601C": "lian;ling",
	"774D": "xian",
	"99CB": "zhao",
	"503A": "zhai",
	"5D03": "lai",
	"639A": "liang",
	"6802": "mei",
	"6BA9": "cuan",
	"6F32": "zhang",
	"7CB1": "liang",
	"72CD": "pao",
	"737C": "mi",
	"725B": "niu",
	"934D": "du",
	"99EB": "jiong",
	"631A": "zhi",
	"78C9": "sang",
	"8194": "lu",
	"922A": "none",
	"9972": "si",
	"5E1A": "zhou",
	"5E6C": "chou;dao",
	"5EDC": "tu",
	"6283": "bian",
	"6C9D": "zhui",
	"7326": "feng",
	"8D6E": "xia",
	"9E11": "yue",
	"93AC": "hao;gao",
	"5E7F": "guang",
	"636F": "dao",
	"66F3": "ye;zhuai;yi",
	"793E": "she",
	"8C0F": "jian",
	"9D64": "none",
	"6854": "jie;ju",
	"6A2B": "jian",
	"72C3": "niu",
	"8560": "ru",
	"93FB": "lin",
	"9B9F": "an",
	"54CE": "ai",
	"5986": "zhuang",
	"6F59": "wei",
	"779E": "man",
	"5B56": "zi",
	"91CD": "zhong;chong",
	"9411": "jie",
	"7707": "miao",
	"979F": "kuo",
	"61E3": "men",
	"6EF2": "shen",
	"8538": "dou",
	"558F": "re;nuo",
	"5779": "xue",
	"69C7": "dian;zhen",
	"752B": "fu",
	"816E": "sai",
	"5050": "yan",
	"5BA0": "chong",
	"6037": "xi",
	"6780": "song",
	"6BF2": "duo",
	"7C0D": "lou",
	"85E2": "zhi",
	"9AB3": "bi",
	"75E3": "zhi",
	"8585": "hao",
	"545C": "wu",
	"5485": "pou",
	"58AE": "duo;hui",
	"7674": "luan",
	"8BF1": "you",
	"99E5": "rong",
	"5D5E": "tu",
	"5F03": "qi",
	"65CB": "xuan",
	"6F41": "ying",
	"997B": "xi",
	"7AA9": "wo",
	"8929": "ban",
	"9326": "jin",
	"778B": "chen",
	"75D7": "mei",
	"7FDF": "zhai;di",
	"8B43": "xu",
	"8F1F": "chuo",
	"9418": "zhong",
	"59E0": "shang",
	"6D95": "ti",
	"9E70": "ying",
	"4E1C": "dong",
	"570C": "chui",
	"7974": "gai;jie",
	"8F49": "zhuan;zhuai",
	"96D7": "han",
	"6772": "gao",
	"6B39": "yi;qi",
	"83B3": "shi",
	"9057": "yi;wei",
	"60E2": "rui",
	"7342": "yuan",
	"7E33": "zhuan",
	"4FE9": "liang",
	"80B8": "xi",
	"8255": "bang",
	"9944": "tang",
	"52E5": "qiang",
	"85F2": "shu",
	"8C83": "mo",
	"5FD5": "dai",
	"600D": "zuo",
	"7B30": "fu",
	"7F2F": "zeng",
	"822A": "hang",
	"9284": "shang",
	"5A53": "fei",
	"5B55": "yun",
	"5ECF": "jiu",
	"6BC4": "ji",
	"7FD5": "xi",
	"93FA": "po",
	"9481": "jue",
	"9A3A": "zhi",
	"9EA4": "cu",
	"5D85": "ao",
	"79F7": "zhi",
	"894F": "bo",
	"5A9A": "mei",
	"5ED9": "yi",
	"6341": "jiao",
	"731E": "she",
	"8015": "geng",
	"5E59": "mu",
	"6249": "fei",
	"69A3": "yao",
	"69C8": "nou",
	"4F49": "qu",
	"5EAA": "gui",
	"67EF": "ke",
	"6820": "ren",
	"75E2": "li",
	"7CB6": "lu",
	"8CDE": "shang",
	"9705": "zha",
	"5849": "ji",
	"5C8D": "qian",
	"5F16": "hu",
	"6AA2": "jian",
	"6ABC": "yin",
	"6543": "min",
	"6C58": "qian",
	"7D22": "suo",
	"85FD": "chen",
	"89F5": "gong",
	"91DF": "ba",
	"94EB": "yao;diao;tiao",
	"6BF8": "sui",
	"918E": "xian",
	"93B0": "yi",
	"944E": "kui",
	"658B": "zhai",
	"7030": "mi",
	"7606": "shen",
	"765F": "bie",
	"8113": "nong",
	"907E": "shi",
	"5249": "cuo",
	"63A1": "cai",
	"64C3": "kuo",
	"75AB": "yi",
	"769F": "ze",
	"7E9C": "lan",
	"9955": "tao",
	"9E21": "ji",
	"5576": "ding",
	"56F0": "kun",
	"5C5F": "xie",
	"6382": "dian",
	"7684": "de;di",
	"86AE": "te",
	"86DF": "jiao",
	"9510": "rui",
	"9542": "lou",
	"969D": "dao",
	"5711": "pu",
	"7B09": "zhen",
	"8152": "ju",
	"838F": "suo",
	"8685": "e",
	"62F8": "chi",
	"8739": "rui",
	"9354": "e",
	"54D3": "xiao",
	"6E52": "ji",
	"8821": "li",
	"53A7": "dian",
	"7086": "wen",
	"7CD9": "cao",
	"874D": "ji",
	"9059": "yao",
	"5523": "zao",
	"64C6": "zhuo",
	"78B4": "cha",
	"947F": "zao;zuo",
	"9636": "jie",
	"673F": "ci",
	"76ED": "li",
	"809D": "gan",
	"9DAB": "none",
	"8AFD": "ge",
	"9550": "hao;gao",
	"705A": "jiao",
	"742B": "beng",
	"8F75": "zhi",
	"953D": "huang",
	"6915": "bin",
	"6C0F": "shi;zhi",
	"6F6A": "di",
	"7553": "none",
	"6B17": "lan",
	"7FD9": "hui",
	"5267": "ju",
	"57EF": "an",
	"6968": "zhen",
	"79DD": "li",
	"8730": "fei",
	"97AD": "bian",
	"5303": "gai",
	"70B7": "zhu",
	"8264": "yi",
	"99E9": "quan",
	"5CA7": "tiao",
	"6FCA": "hui",
	"97FD": "yin;an",
	"62A1": "lun",
	"64ED": "huo",
	"69C9": "ji",
	"6D8E": "xian",
	"6FD8": "ning;neng",
	"8FA7": "bian",
	"93E5": "xiu",
	"9762": "mian",
	"5439": "chui",
	"54B7": "tao",
	"5BFB": "xun;xin",
	"5DCE": "nao",
	"6B6E": "se",
	"70EA": "none",
	"71CA": "shen",
	"77B7": "jian",
	"7DBF": "mian",
	"936A": "mou",
	"9897": "ke",
	"9A53": "zeng",
	"9C3F": "ji",
	"59ED": "xian",
	"7080": "yang",
	"70D5": "tong",
	"837B": "di",
	"674B": "fan",
	"7762": "sui",
	"81EB": "jiao",
	"8792": "han",
	"9DF1": "kao",
	"57C5": "fang",
	"5F2C": "yi",
	"63D1": "nie",
	"6CFB": "xie",
	"7766": "mu",
	"80F5": "zhi",
	"5556": "dan",
	"6461": "gai;xi",
	"6490": "cheng",
	"6D3F": "wu",
	"813B": "jie",
	"9E9A": "jia",
	"51A5": "ming",
	"52A4": "jing",
	"5770": "jiong",
	"5E8D": "bai",
	"6517": "mei",
	"97A2": "xie",
	"9D61": "wu",
	"4EBE": "wang",
	"79B8": "rou",
	"96DE": "ji",
	"5352": "zu;cu",
	"6E57": "feng",
	"7CB0": "fu",
	"5ADE": "yong",
	"61A3": "fan",
	"7B01": "zhu",
	"9B5C": "ren",
	"9D43": "zhou",
	"5796": "dui",
	"5A58": "quan",
	"7A5E": "lu",
	"7CF8": "mi",
	"8395": "xing",
	"7145": "duan",
	"7E56": "san",
	"88B9": "mo",
	"9603": "kun",
	"98A8": "feng",
	"5332": "lian",
	"584E": "yong",
	"5A3D": "lu",
	"75E4": "cuo",
	"7736": "kuang",
	"77FF": "kuang",
	"8318": "li",
	"8784": "si;shi",
	"57E4": "pi;bei;bi",
	"5E64": "bi",
	"9335": "hua",
	"4E21": "liang",
	"4EE9": "shang",
	"53F6": "ye;xie",
	"61B7": "chu",
	"73FC": "bei",
	"7D78": "jian",
	"8B19": "qian",
	"8CA5": "hang",
	"9614": "kuo",
	"9B2C": "dou",
	"4ED3": "cang",
	"8419": "none",
	"85FB": "zao",
	"9745": "fei",
	"5673": "yu",
	"642B": "pan",
	"73E3": "xun",
	"76A9": "huang",
	"86BB": "zha",
	"8F5D": "yu",
	"9B0C": "duo",
	"9D76": "ya",
	"507B": "lou;lu",
	"5415": "lu",
	"5A06": "rao",
	"794F": "shi",
	"5015": "chui",
	"5928": "ze",
	"5C42": "ceng",
	"6179": "zhi",
	"6A32": "er",
	"791C": "yu",
	"9B36": "gui",
	"6C6D": "rui",
	"96BD": "juan;jun",
	"4F46": "dan",
	"5E71": "lan",
	"847E": "yuan",
	"898D": "bian",
	"8A25": "ne;na",
	"95C4": "yao",
	"54CB": "di",
	"5C13": "er",
	"60CC": "yuan",
	"6945": "bi",
	"8407": "chang",
	"5E02": "shi",
	"7109": "yan",
	"88AC": "yu",
	"9421": "tie",
	"524A": "xue;xiao",
	"6D59": "zhe",
	"84C8": "lang",
	"93BF": "na",
	"96E9": "yu",
	"98C4": "piao",
	"5E5A": "bang",
	"62EC": "kuo;gua",
	"6FA6": "yu",
	"705D": "hao",
	"7590": "zhi",
	"768F": "peng",
	"8748": "guo",
	"8870": "shuai;cui",
	"4EC9": "zhang",
	"5663": "zhou",
	"79AF": "nong",
	"80EB": "jing",
	"9219": "qin",
	"8C98": "mo",
	"9817": "po",
	"9BE1": "fei",
	"5B7C": "nie",
	"6DA9": "se",
	"71EB": "lian",
	"8A7D": "yan",
	"51DC": "lin",
	"6375": "chen",
	"66A1": "weng",
	"6C93": "ta;da",
	"84C0": "sun",
	"8A86": "kuang",
	"5E1E": "mo",
	"668E": "ying",
	"769B": "jiong",
	"7F31": "qian",
	"8312": "none",
	"864C": "bie",
	"8BDB": "zhu",
	"9D58": "jun",
	"6B93": "lian",
	"7254": "bo",
	"5C9B": "dao",
	"6827": "yi",
	"730D": "li",
	"7628": "dian",
	"8DAE": "zao",
	"93AD": "zhen",
	"53EC": "zhao;shao",
	"586C": "yuan",
	"6610": "fen",
	"6B6A": "wai",
	"6CE8": "zhu",
	"72E2": "he;hao;mo",
	"50EB": "e",
	"6A9B": "zhua",
	"77C2": "ji",
	"7E25": "zhen",
	"77B4": "wu",
	"8AA0": "cheng",
	"6353": "ye",
	"6D97": "shui",
	"6F44": "shu",
	"74AB": "dang",
	"74FC": "none",
	"8BE5": "gai",
	"4F7F": "shi",
	"5610": "xiao",
	"5E8E": "jie",
	"8878": "xie",
	"9A58": "luo",
	"9AD6": "kuan",
	"8EE0": "ren",
	"9096": "shan",
	"9516": "qing;qiang",
	"516D": "liu;lu",
	"63E6": "la",
	"98CA": "none",
	"506F": "yi",
	"5CCD": "lu",
	"6C6B": "qing",
	"6DBA": "ju",
	"4F3E": "pi",
	"51D1": "cou",
	"5233": "ku",
	"8475": "kui",
	"88F5": "pei",
	"98C5": "liu",
	"8EDE": "mao",
	"92A7": "guang",
	"9B65": "que",
	"6192": "kui",
	"6B94": "yi",
	"6D17": "xi;xian",
	"91A2": "hai",
	"509A": "xiao",
	"54F8": "sui",
	"6CDF": "cheng",
	"7B04": "ji",
	"84D8": "gun",
	"4FC5": "qiu",
	"55BF": "cao",
	"5EC1": "ce;ci",
	"6548": "xiao",
	"6C48": "diao",
	"710A": "han",
	"8381": "wu",
	"8AC9": "wei",
	"57B6": "xing",
	"9571": "yi",
	"97D6": "rou",
	"56A1": "none",
	"7AAB": "ya",
	"4EDB": "cha",
	"5A98": "none",
	"5D78": "zong",
	"69A2": "jia",
	"6D56": "lie",
	"716F": "none",
	"8F48": "chao",
	"95B6": "chang",
	"5E80": "pi",
	"7B4C": "quan",
	"9DF8": "yu",
	"593D": "yun",
	"60D5": "ti",
	"629F": "tuan",
	"738B": "wang",
	"7FE7": "xuan",
	"9299": "kua",
	"97B1": "tao",
	"97F4": "za",
	"98B4": "xuan",
	"4EC8": "ba",
	"799D": "ji",
	"7AF1": "zhuan",
	"7E77": "nao",
	"8439": "pian;bian",
	"8E58": "liao",
	"9576": "xiang",
	"6A9A": "chu",
	"6DC7": "qi",
	"6DCC": "tang",
	"80DB": "jia",
	"9F35": "tu",
	"6AC2": "zhao",
	"6BA5": "yin",
	"8A61": "xu",
	"56B0": "mo",
	"815A": "ding",
	"8332": "zi",
	"8C31": "pu",
	"8D98": "xi",
	"8FDD": "wei",
	"9D40": "ren",
	"9EF7": "du",
	"5753": "xing",
	"5E16": "tie",
	"6B37": "xi",
	"97C7": "du",
	"56EB": "hu",
	"70FD": "feng",
	"73F1": "ying",
	"9C3D": "qiu",
	"9C4A": "jue",
	"5907": "bei",
	"5EAF": "bu",
	"67A2": "shu",
	"6B8B": "can",
	"6C98": "bi",
	"52D1": "lai",
	"62CA": "fu",
	"639E": "shan",
	"77E8": "ying",
	"9778": "sa",
	"9D8E": "none",
	"5403": "chi;ji",
	"8326": "ce",
	"96AF": "dao",
	"987A": "shun",
	"9DBB": "gu;hu",
	"9EC4": "huang",
	"57A2": "gou",
	"6634": "mao",
	"6CB4": "li",
	"74EF": "ou",
	"7D12": "jie",
	"7E65": "xi",
	"825A": "cao",
	"838B": "ji",
	"8911": "yuan",
	"9A02": "xing",
	"9AF0": "ti",
	"9D32": "zhi",
	"9D3C": "luo",
	"997C": "bing",
	"7F8F": "yang",
	"86E5": "she",
	"561C": "ma;mo",
	"87A5": "cang",
	"9E7B": "jian",
	"4F2D": "xuan",
	"7411": "suo",
	"887E": "qin",
	"8BB8": "xu",
	"9664": "chu",
	"670E": "ling",
	"6823": "ren",
	"6D57": "qiu",
	"8088": "zhao",
	"893C": "xian",
	"8BD7": "shi",
	"53AB": "ao",
	"6CAE": "ju",
	"7385": "miao",
	"7CE1": "jiang",
	"8910": "he",
	"64D5": "xie",
	"65DC": "zhan",
	"660F": "hun",
	"6630": "shi",
	"9CBB": "zi",
	"6602": "ang",
	"6642": "shi",
	"8001": "lao",
	"80F9": "er",
	"9336": "biao",
	"9EB4": "qu",
	"5876": "lu",
	"5EA4": "zhi",
	"6BBF": "dian",
	"6C21": "dong",
	"81F0": "chou;xiu",
	"8F97": "zhan",
	"937E": "zhong",
	"9661": "dou",
	"5F49": "kuang",
	"524B": "ke",
	"5A57": "ni",
	"5C6E": "che",
	"79C3": "tu",
	"7D71": "tong",
	"7F1F": "gao",
	"83AB": "mo",
	"87EE": "shan",
	"8A07": "hong",
	"8A17": "tuo",
	"8BF8": "zhu",
	"9017": "dou",
	"9C1B": "wen",
	"61E9": "yang",
	"6B0F": "luo",
	"6F93": "fu",
	"720A": "ao",
	"75A7": "xi",
	"7E1D": "zhen",
	"8F52": "fen",
	"5B76": "zi",
	"67B9": "bao;fu",
	"814D": "ren",
	"874C": "ke",
	"9E1E": "luan",
	"60BE": "kong",
	"64A4": "che",
	"6CC7": "jia",
	"7EDB": "jiang",
	"9D01": "yiao",
	"4F19": "huo",
	"5025": "kong",
	"5DC7": "xi",
	"69C2": "sun",
	"8B02": "wei",
	"8E9A": "xian",
	"924B": "bao",
	"6008": "yi",
	"67E0": "ning",
	"803A": "yun",
	"8FEE": "ze",
	"579C": "duo",
	"5ADD": "kang",
	"5FF0": "cui",
	"6343": "jun",
	"823F": "none",
	"8B5E": "xuan",
	"9C20": "sao",
	"521F": "ju",
	"6608": "hu",
	"8907": "fu",
	"9372": "min",
	"9EFA": "fen",
	"5A07": "jiao",
	"62AE": "zhen",
	"8492": "shi",
	"9D30": "gua",
	"4EBF": "yi",
	"5298": "mo",
	"63B0": "bai;bo",
	"9736": "pang",
	"98CC": "feng",
	"52B3": "lao",
	"5699": "nie",
	"6079": "yan",
	"8030": "you",
	"8358": "zhuang",
	"9271": "kuang",
	"93CA": "ao",
	"9A03": "ai",
	"58E9": "ba",
	"8068": "lian",
	"5567": "ze",
	"5686": "hao",
	"813F": "biao",
	"8C43": "han",
	"91BB": "chou",
	"5018": "tang;chang",
	"58A0": "shan",
	"79F0": "cheng",
	"8DB2": "zan",
	"92F2": "none",
	"51A7": "none",
	"59B8": "e",
	"6957": "jian",
	"69D6": "tuo",
	"78B1": "jian",
	"8B6C": "pi",
	"981A": "jing;geng",
	"6AC5": "ji",
	"89DD": "di",
	"9A73": "bo",
	"6364": "none",
	"8C33": "yan",
	"6682": "zan",
	"6A15": "su",
	"8E27": "cu",
	"9A40": "mo",
	"9DD0": "chen",
	"9EC0": "zou",
	"4E41": "yi",
	"4F41": "ai",
	"5E41": "xu",
	"703D": "jian",
	"77C5": "yao",
	"8A2E": "xian",
	"97D5": "none",
	"5495": "gu",
	"6323": "zheng",
	"8627": "qu",
	"8F09": "zai",
	"9016": "ti",
	"9143": "ling",
	"91F6": "ta;tuo",
	"5125": "du",
	"6991": "fu",
	"6C74": "bian",
	"6DAA": "fu",
	"6FB4": "huan",
	"72CA": "ju",
	"7828": "e",
	"9ED1": "hei",
	"9F64": "quan",
	"5921": "qi",
	"5C4B": "wu",
	"61C5": "qu",
	"641E": "gao",
	"69CF": "qian",
	"985D": "ku",
	"9B74": "fang",
	"5268": "huo",
	"76C1": "ying",
	"51FC": "dang",
	"6C02": "li",
	"809C": "rong",
	"853D": "bi",
	"9D1B": "yuan",
	"5564": "pi",
	"58D6": "ruan",
	"5AE8": "han;ran",
	"70FA": "lang",
	"77F9": "wu",
	"9152": "jiu",
	"9309": "min",
	"94C7": "bao",
	"9B75": "fen",
	"4EEA": "yi",
	"52FD": "bao",
	"5313": "jiu",
	"59E9": "nian",
	"5FE1": "chong",
	"6358": "jun",
	"654E": "jiao",
	"7F60": "min",
	"92B7": "xiao",
	"9CD3": "le",
	"51B6": "ye",
	"6727": "long",
	"7DEC": "mian",
	"7E06": "geng",
	"9BFA": "ju",
	"9E57": "e",
	"619A": "dan",
	"7280": "xi",
	"7440": "yu",
	"8311": "niao",
	"8BD4": "lei",
	"9EAB": "mian",
	"57A0": "yin",
	"7C19": "bo",
	"8CBE": "chi",
	"93D9": "cui",
	"6CFE": "jing",
	"7233": "none",
	"78FE": "di",
	"89DF": "hua",
	"57C8": "jun",
	"66A0": "gao",
	"7789": "kou",
	"6E31": "hong",
	"7F5D": "ju",
	"9577": "chang;zhang",
	"9C1C": "jian",
	"5543": "ken",
	"7039": "yue",
	"7996": "mei",
	"8344": "gai",
	"92AB": "se",
	"9933": "xing;tang",
	"555B": "cui",
	"5A3B": "dong",
	"625C": "yu",
	"8865": "bu",
	"8E62": "di;zhi",
	"92B6": "qiu",
	"96DF": "sui",
	"5E73": "ping",
	"5612": "hui",
	"6A2D": "none",
	"77D1": "lu",
	"90BE": "zhu",
	"9249": "xuan",
	"92E4": "chu",
	"86BD": "pi",
	"96A7": "sui",
	"9AD5": "bin",
	"51D0": "yin",
	"6C83": "wo",
	"76C6": "pen",
	"7868": "che",
	"893D": "wei",
	"8D31": "jian",
	"6E3D": "zai",
	"6FE6": "yin",
	"7AC0": "cheng",
	"7C72": "xu;yu",
	"7E36": "zhi",
	"92ED": "rui",
	"5B02": "zhi",
	"6555": "chi",
	"6FFF": "li",
	"708E": "yan",
	"7523": "chan",
	"8141": "pian",
	"8E51": "nie",
	"9BA0": "wei",
	"4ED0": "san",
	"5C5C": "ti",
	"6566": "dun;dui",
	"7344": "yu",
	"7E2D": "li",
	"84DC": "none",
	"9C83": "ba",
	"53FF": "hong",
	"6622": "pei",
	"6A22": "niao",
	"7662": "yang",
	"5072": "si;cai",
	"5B77": "li",
	"5C1A": "shang",
	"893E": "biao",
	"8A5E": "ci",
	"9ED7": "tuan",
	"4F70": "bai",
	"5511": "zuo",
	"5CC8": "luo",
	"66EB": "luan",
	"7F0B": "hui",
	"865E": "yu",
	"8945": "none",
	"8B0F": "xiao;sou",
	"8FFE": "lie",
	"52FC": "jiu",
	"564E": "ye",
	"60C0": "lun",
	"6E61": "yu",
	"77F8": "gan",
	"7832": "pao",
	"9000": "tui",
	"9C8B": "fu",
	"4EF9": "feng",
	"5358": "dan;chan",
	"8809": "xuan",
	"8CCF": "ying",
	"5E26": "dai",
	"758B": "pi;shu;ya",
	"99B7": "pei",
	"5630": "ji",
	"5765": "qu",
	"5831": "bao",
	"5956": "jiang",
	"5E49": "none",
	"5FC5": "bi",
	"60E6": "dian",
	"8662": "guo",
	"50AB": "lei",
	"620D": "shu",
	"77CE": "xuan",
	"881A": "he",
	"8BD9": "hui",
	"9E27": "cang",
	"5CAA": "fu",
	"7910": "que",
	"820A": "jiu",
	"84BD": "en",
	"4EAD": "ting",
	"55F4": "none",
	"5D48": "huan",
	"665B": "xian",
	"7ED5": "rao",
	"58A5": "dong",
	"7E75": "chan",
	"7085": "gui;jiong",
	"7400": "han",
	"953E": "huan",
	"74A8": "can",
	"75C6": "nie",
	"90D5": "cheng",
	"98AA": "none",
	"5C40": "ju",
	"9E5E": "yao",
	"5224": "pan",
	"6680": "wang",
	"6978": "qiu",
	"6C29": "ya",
	"708A": "chui",
	"51CA": "qing;jing",
	"582C": "yu",
	"5BF6": "bao",
	"62C4": "zhu",
	"7F4C": "ying",
	"55D7": "gong",
	"599A": "pei",
	"5F27": "hu",
	"795A": "zuo",
	"86CA": "gu",
	"9625": "yin",
	"9E8A": "mi",
	"5043": "yan",
	"53C3": "can;cen;shen;san",
	"58AF": "duo",
	"5B70": "shu",
	"5E83": "guang",
	"7854": "hong",
	"8FFA": "nai",
	"92A4": "mi",
	"594E": "kui",
	"6D98": "si",
	"7940": "si",
	"51A8": "fu",
	"6AB6": "qian",
	"744B": "wei",
	"800C": "er",
	"814C": "a;yan",
	"5A0E": "xie",
	"6960": "nan",
	"7E53": "zuo",
	"844F": "lu",
	"93CD": "luo",
	"4E0F": "mian",
	"5BB1": "zha",
	"6735": "duo",
	"6973": "mei",
	"8484": "guan",
	"9820": "wei",
	"63E7": "la",
	"8481": "shu",
	"9806": "shun",
	"6878": "xi",
	"7384": "xuan",
	"8DDE": "li;luo",
	"514E": "tu",
	"53B6": "si",
	"61C6": "cao",
	"6BB6": "zhu",
	"8B5B": "zen",
	"9306": "qing;qiang",
	"9386": "none",
	"5985": "hong",
	"8624": "wei",
	"8998": "zhan;chan",
	"8E0F": "ta",
	"5E1D": "di",
	"5FFC": "kang",
	"6089": "xi",
	"6D35": "xun",
	"7213": "yan",
	"7904": "qiao",
	"7CF0": "tuan",
	"8955": "lan",
	"8CC8": "jia;gu",
	"5873": "peng",
	"7D45": "jiong",
	"9B59": "zhan",
	"5B6B": "sun",
	"9117": "hao",
	"97BA": "tang",
	"56C1": "nie",
	"57A9": "e",
	"6096": "bei",
	"6554": "yu",
	"8268": "meng",
	"532D": "gui",
	"8E9C": "zuan",
	"9A7B": "zhu",
	"55CD": "suo",
	"5E60": "hu",
	"648B": "ruan",
	"6D46": "jiang",
	"7D15": "pi",
	"8942": "sen",
	"8C3E": "hong",
	"920F": "yin",
	"969E": "ao",
	"529A": "zhu",
	"5B57": "zi",
	"6497": "huang",
	"6704": "yin",
	"958C": "kang",
	"4FEF": "fu",
	"6794": "xun",
	"7A72": "li",
	"4E46": "jiu",
	"7CFB": "xi;ji",
	"9959": "fen",
	"50B0": "peng",
	"5F74": "zhuo",
	"5FB8": "chong",
	"7C53": "fan",
	"596A": "duo",
	"5C93": "qi",
	"73A0": "jie",
	"7BE4": "du",
	"8BDF": "gou",
	"9686": "long",
	"7131": "yan",
	"80FC": "pian",
	"5FDD": "tian",
	"6025": "ji",
	"70DC": "xuan",
	"8E78": "lin",
	"5C81": "sui",
	"6A7E": "shu",
	"7F51": "wang",
	"82D5": "tiao;shao",
	"92CA": "yu",
	"6AD4": "none",
	"8026": "ou",
	"917C": "hai",
	"96E5": "za",
	"5104": "yi",
	"57F9": "pei",
	"6473": "kou",
	"798D": "huo",
	"7D0A": "wen",
	"9966": "tuo",
	"5339": "pi;ya",
	"5A86": "ruan",
	"716B": "sui",
	"8E16": "ji",
	"9998": "guo",
	"9CD1": "pang",
	"5AE4": "jin",
	"6975": "ji",
	"8B75": "zhui",
	"9080": "yao",
	"94B4": "gu",
	"5126": "biao",
	"53D8": "bian",
	"68DA": "peng",
	"7089": "lu",
	"7A8C": "jiao",
	"7D27": "jin",
	"9D44": "chi",
	"5346": "zu",
	"641C": "sou",
	"7919": "ai",
	"7AFC": "peng",
	"84BC": "cang",
	"857E": "lei",
	"8DCB": "ba",
	"9568": "pu",
	"97AE": "di",
	"5CAE": "tuo",
	"7480": "cui",
	"9E97": "li",
	"6596": "wei",
	"96F8": "an",
	"61F4": "chan",
	"6C46": "cuan",
	"7538": "dian",
	"77E1": "jue",
	"7ACD": "shi;gong;sheng",
	"7FA5": "qian;qiang",
	"5280": "gua",
	"596C": "jiang",
	"5C24": "you",
	"6C85": "yuan",
	"7BB1": "xiang",
	"8F19": "zhe",
	"5B8E": "yao",
	"65DF": "yu",
	"6D4D": "hui;kuai",
	"73C7": "zu",
	"751C": "tian",
	"7D92": "fu",
	"948B": "po",
	"53C1": "san",
	"5DB5": "zui",
	"6734": "po;piao;pu",
	"8ABB": "ta",
	"9554": "bin",
	"9E6C": "yu",
	"4E30": "feng",
	"4F88": "chi",
	"58A1": "shan",
	"790D": "ke",
	"7935": "shuang",
	"7AAD": "ju",
	"5EBC": "qing",
	"7201": "lan",
	"8A82": "tiao;diao",
	"64E8": "ye",
	"6663": "zhe",
	"6B01": "nong",
	"8718": "zhi",
	"9151": "yu",
	"6314": "lu",
	"7737": "juan",
	"7DF4": "lian",
	"85D7": "su",
	"8717": "wo",
	"9990": "xiu",
	"9E2C": "lu",
	"5307": "none",
	"8F41": "tao",
	"9E66": "ying",
	"5698": "you",
	"58B0": "tan",
	"595F": "beng",
	"77B6": "kui",
	"7C3A": "sai",
	"83FA": "jian",
	"9994": "zhuan",
	"9F00": "cu",
	"5815": "duo;hui",
	"6A93": "hui",
	"72AD": "quan",
	"8ABA": "chi",
	"9CBA": "shi",
	"52E8": "xiang",
	"588F": "qiang",
	"6DDC": "peng",
	"6EA6": "wei",
	"8511": "mie",
	"98D9": "biao",
	"50FA": "qiao",
	"5AFB": "xian",
	"674D": "zi",
	"73BB": "bo",
	"890A": "bian",
	"8BA5": "ji",
	"9D26": "yang",
	"5ED2": "ao",
	"64A0": "ji",
	"6830": "fa",
	"7872": "yu",
	"83E6": "qin",
	"8B88": "li",
	"5FA7": "bian",
	"621C": "die",
	"7CBF": "guo",
	"82DD": "pei",
	"8704": "zhen",
	"5941": "lian",
	"5C38": "shi",
	"76A0": "cui",
	"6464": "chuang",
	"6870": "kuo",
	"7816": "zhuan",
	"7D58": "ci",
	"8354": "li",
	"850C": "su",
	"6A0A": "fan",
	"7378": "shou",
	"7464": "yao",
	"7BD8": "chou",
	"50C8": "man",
	"629D": "ao",
	"7D2A": "qi",
	"7E8B": "you",
	"8D7C": "ci",
	"8FF9": "ji",
	"979B": "beng",
	"5D33": "yu",
	"6284": "chao",
	"6731": "zhu",
	"764C": "ai;yan",
	"91E3": "diao",
	"94D7": "jia",
	"9D1A": "ge",
	"9E26": "ya",
	"565B": "nie",
	"680F": "lan",
	"7A94": "yao",
	"82B1": "hua",
	"5CFA": "geng",
	"8190": "lu",
	"9D94": "rou",
	"6C34": "shui",
	"767F": "qie",
	"8282": "jie",
	"850E": "she",
	"9E41": "bo",
	"5D0E": "qi",
	"7455": "xia",
	"9370": "huan",
	"6134": "chuang",
	"621D": "cai",
	"63BA": "chan;shan;can",
	"83BE": "mang",
	"843A": "mao",
	"9680": "chong",
	"9ABF": "pian",
	"6A8E": "qin",
	"7524": "rui",
	"80F6": "jiao",
	"8138": "lian",
	"5F77": "pang;fang",
	"6A56": "tang",
	"9416": "ji",
	"973E": "mai",
	"66B5": "han",
	"8A49": "nao",
	"9474": "xi",
	"52CB": "xun",
	"7288": "quan",
	"74C3": "lei",
	"50B2": "ao",
	"5A56": "tian",
	"5BB0": "zai",
	"761A": "jue",
	"8857": "jie",
	"8CCC": "gai",
	"5D1E": "guo",
	"7788": "weng",
	"77E7": "shen",
	"9CAD": "qing;zheng",
	"5544": "zhuo",
	"55A5": "du",
	"5B51": "jie",
	"642E": "li",
	"6D0A": "jian",
	"741F": "wei",
	"7CA7": "zhuang",
	"7F49": "none",
	"8BAC": "tuo",
	"58CF": "lan",
	"507A": "za;zan",
	"526B": "duo",
	"7255": "bang",
	"7261": "mu",
	"79A0": "chi",
	"80BD": "tai",
	"83F6": "beng",
	"8517": "zhe",
	"8CED": "du",
	"4E8E": "yu",
	"62B0": "yang",
	"6871": "jing",
	"68C3": "li",
	"7022": "wei",
	"7A4F": "wen",
	"65E1": "ji",
	"672E": "zhu",
	"7954": "fu",
	"876B": "zhu",
	"8D02": "chen",
	"5E28": "shui",
	"6538": "you",
	"667F": "chang",
	"86E4": "ha;ge",
	"8747": "ying",
	"8BFF": "wei",
	"4FCA": "jun;zun;juan",
	"5176": "qi;ji",
	"52B9": "xiao",
	"54ED": "ku",
	"6D40": "qu",
	"772B": "mi",
	"8E32": "dun",
	"90CA": "jiao",
	"91D3": "ga",
	"94B0": "yu",
	"76BD": "zhan",
	"7F2D": "liao",
	"80FB": "xing",
	"92C5": "xin",
	"92F0": "li",
	"9410": "liao",
	"5365": "xi",
	"633A": "ting",
	"64DA": "ju",
	"68C5": "bing",
	"6E4A": "cou",
	"74CE": "la",
	"7943": "ma",
	"88DD": "zhuang",
	"5B9E": "shi",
	"7355": "cui",
	"7C87": "kang",
	"8A5A": "da",
	"9975": "er",
	"9A35": "yuan",
	"5385": "ting",
	"5D8F": "bo",
	"6EC4": "cang",
	"7A52": "none",
	"7A8D": "qiao",
	"7E08": "ying",
	"823C": "hong",
	"8720": "jun",
	"9703": "chen",
	"5173": "guan",
	"6739": "qiu",
	"6B1F": "none",
	"6CF9": "dan",
	"7052": "zan",
	"70DB": "zhu",
	"755B": "zhen",
	"84C3": "none",
	"8BE6": "xiang",
	"8C59": "yi",
	"55F9": "lian",
	"5AE3": "yan",
	"6B62": "zhi",
	"7099": "zhi",
	"757E": "lei",
	"76CD": "he",
	"78AF": "nao",
	"802A": "pang",
	"9A09": "kun",
	"5D5C": "qi",
	"623C": "mao",
	"8CE5": "sui",
	"5340": "qu;ou",
	"5C36": "gan",
	"6389": "diao",
	"6F17": "cong",
	"705E": "ba",
	"8340": "xun",
	"602F": "qie;que",
	"6A8C": "zui",
	"7513": "pi",
	"7650": "guai",
	"587F": "lou",
	"58A2": "ba",
	"58EF": "zhuang",
	"5CE0": "none",
	"5E92": "none",
	"7A69": "wen",
	"7AAF": "yao",
	"5A27": "tui",
	"8FBB": "none",
	"93A7": "kai",
	"9A4F": "zhan",
	"5AED": "hu",
	"8A92": "e",
	"9CC3": "sai",
	"6371": "ai",
	"60FE": "zong",
	"9E68": "liu",
	"76A2": "xiao",
	"5A22": "han",
	"6C5C": "si",
	"6D48": "zhen",
	"82B9": "qin",
	"957B": "die",
	"5806": "dui;zui",
	"8F08": "zhou",
	"9201": "fang",
	"9923": "ye",
	"5EB7": "kang",
	"5F2F": "wan",
	"6452": "bing",
	"65E5": "ri",
	"7CD3": "gu;yu",
	"85CB": "di",
	"942E": "lian",
	"5BCF": "huan",
	"67FD": "cheng",
	"704E": "yan",
	"796B": "xia",
	"843E": "ying",
	"85DC": "li",
	"8977": "none",
	"849D": "yuan",
	"8B24": "biao",
	"8C6D": "jia",
	"9797": "tiao",
	"9D55": "xun",
	"577E": "zhu",
	"6A1A": "lu",
	"805C": "di",
	"84DF": "ji",
	"88A8": "xuan",
	"8C51": "zhi",
	"55E3": "si",
	"5687": "xia;he",
	"6C79": "xiong",
	"7579": "wan",
	"879F": "ming",
	"896B": "shi",
	"5F70": "zhang",
	"623F": "fang",
	"6AC6": "kui",
	"6BB2": "jian",
	"7B1A": "xia",
	"8172": "wei",
	"8ADE": "pian",
	"905D": "ta",
	"97B6": "pan",
	"558E": "kuai",
	"62E5": "yong",
	"70FF": "rong",
	"719E": "jian",
	"7D7D": "lu",
	"89DB": "dan",
	"9B3B": "yu",
	"9DCE": "liu",
	"6E9C": "liu",
	"72C0": "zhuang",
	"7C70": "yue",
	"8C00": "yu",
	"653F": "zheng",
	"802B": "ze",
	"97A4": "bang",
	"9CED": "diao",
	"6D11": "fu",
	"70A7": "duo",
	"7776": "chun",
	"9452": "jian",
	"9D27": "rong",
	"5BBB": "mi",
	"654A": "chu",
	"76A3": "ye",
	"7A1F": "bing",
	"8A7A": "ming",
	"8DDC": "ni",
	"511A": "meng",
	"517A": "none",
	"5AFE": "lian",
	"63D7": "shun",
	"6E6F": "tang;shang",
	"7416": "zhan",
	"841C": "tie",
	"5DCD": "wei",
	"6428": "ta",
	"6E13": "xi",
	"77A8": "pu",
	"7987": "zhe",
	"86F6": "lie",
	"9189": "zui",
	"531F": "kang",
	"7035": "fen",
	"767A": "fa",
	"851B": "hu",
	"9238": "ba",
	"92FF": "chang",
	"967C": "zhu",
	"98A4": "zhan;chan",
	"67E5": "cha;zha",
	"6D6F": "wu",
	"6F13": "li",
	"7383": "qu",
	"73B6": "ping",
	"92A2": "yong",
	"9953": "cheng",
	"529B": "li",
	"88CE": "cheng",
	"892C": "sang",
	"993F": "sou",
	"6EFC": "fan",
	"7B88": "chi",
	"7BE7": "zhuo",
	"8350": "jian",
	"8360": "ji;qi",
	"8B93": "rang",
	"8BF4": "shuo;shui;yue",
	"5068": "chai",
	"5201": "diao",
	"659B": "hu",
	"7362": "xiao",
	"84EC": "peng",
	"9156": "dan;zhen",
	"5F0F": "shi",
	"6776": "chun",
	"7979": "tao",
	"814E": "shen",
	"898B": "jian;xian",
	"9AE9": "bin",
	"52B2": "jing",
	"5ACA": "su",
	"6D03": "hui",
	"7BFD": "yu",
	"8669": "xi",
	"8C7C": "pi",
	"5654": "deng",
	"7C91": "ba",
	"8464": "zhou",
	"97A3": "rou",
	"6A31": "ying",
	"8336": "cha",
	"87D0": "none",
	"6065": "chi",
	"7968": "piao",
	"82FC": "sheng",
	"9E75": "lu",
	"7937": "lan",
	"8F3B": "fu",
	"9211": "ban",
	"6023": "you",
	"60D7": "nie",
	"6163": "guan",
	"6D2C": "su",
	"6D6B": "han",
	"71A1": "lou",
	"7463": "suo",
	"7F36": "fou",
	"8930": "qian",
	"5FB2": "chi",
	"68F2": "qi;xi",
	"89F8": "chu",
	"965B": "bi",
	"998F": "liu",
	"58F1": "yi",
	"7506": "ci",
	"7CE7": "liang",
	"825B": "lou",
	"8795": "bi",
	"9834": "ying",
	"9A8D": "xing",
	"9F17": "tao",
	"75C0": "ju",
	"76AD": "jiao",
	"7DA0": "lu",
	"93F3": "zheng",
	"9C0D": "qiu",
	"9F07": "ao",
	"59FA": "xian",
	"5AF8": "zhan",
	"60F8": "qiong",
	"6F8B": "heng",
	"8487": "chan",
	"8D7A": "qin",
	"993C": "xi",
	"572E": "pi",
	"7251": "bian",
	"7B0A": "zhao",
	"8982": "feng",
	"68EB": "yu",
	"6E5F": "huang",
	"86F4": "qi",
	"9471": "chan",
	"5579": "none",
	"6992": "nuo",
	"6C4E": "fan",
	"6D74": "yu",
	"768E": "jiao",
	"8059": "jing",
	"94BC": "mu",
	"556D": "zhuan",
	"5F8E": "cheng",
	"704C": "guan",
	"854D": "yu",
	"9358": "zha",
	"9682": "yin",
	"6631": "yu",
	"9840": "chui",
	"7324": "hu",
	"79F9": "ren",
	"862E": "ji",
	"8731": "pi",
	"9695": "yun",
	"5163": "li",
	"5741": "zhi",
	"58F6": "hu",
	"5D6E": "dian",
	"4E8A": "shi",
	"5938": "kua",
	"7082": "zhong",
	"82F5": "die",
	"9313": "kong",
	"99B3": "chi",
	"5706": "yuan",
	"581A": "hun",
	"5EE1": "wu",
	"600B": "min",
	"62CD": "pai",
	"6736": "duo",
	"7B76": "gao",
	"8DC6": "tai",
	"938A": "bang",
	"949A": "bu",
	"655C": "nie",
	"6F51": "po",
	"7057": "dan",
	"79D0": "yun",
	"867D": "sui",
	"90B3": "pi",
	"92DE": "xing",
	"9B56": "xu",
	"62DA": "pan;pin",
	"640E": "sun",
	"6D64": "hong",
	"7EDF": "tong",
	"829B": "wei",
	"85E0": "jiao",
	"8C6B": "yu",
	"8F8B": "wang",
	"99AB": "xing",
	"515B": "qian",
	"661D": "zan",
	"87F5": "none",
	"9BC6": "fu",
	"9CE3": "shan",
	"5207": "qie",
	"5B1D": "niao",
	"94A9": "gou",
	"6CBF": "yan",
	"8120": "shan",
	"6F4D": "wei",
	"8163": "di",
	"8668": "ban",
	"97E9": "han",
	"5AE6": "chang",
	"6D18": "kao",
	"78AC": "xia",
	"7AD3": "qian;fen;zhi;yi;gong;sheng",
	"8C82": "diao",
	"5196": "mi",
	"536E": "zhi",
	"576E": "tai",
	"6C0E": "die",
	"803F": "geng",
	"84AC": "yuan",
	"8987": "ba",
	"8C14": "e",
	"9DD6": "yi",
	"9F1D": "yuan",
	"5215": "li",
	"5AF3": "bi",
	"5C9F": "yang",
	"6715": "zhen",
	"6959": "mao",
	"6F7B": "shu",
	"7647": "xian",
	"91C5": "yan",
	"99A8": "xin;xing",
	"4FF6": "ti;chu",
	"5811": "qian",
	"6C25": "xi",
	"7339": "cha",
	"7DFA": "gua",
	"8086": "si",
	"83F4": "an",
	"5A93": "huang",
	"6B72": "sui",
	"7EE7": "ji",
	"863F": "luo",
	"5320": "jiang",
	"5629": "hua;ye",
	"6E71": "huo",
	"8603": "rui",
	"8E6E": "xian",
	"53E5": "ju;gou",
	"6AEE": "e",
	"6C51": "tuo",
	"773A": "tiao",
	"77C4": "xun",
	"7938": "zan",
	"98C1": "xi",
	"9D18": "bian",
	"59A3": "bi",
	"5F0C": "yi",
	"81F5": "ge",
	"8698": "hui",
	"8737": "quan",
	"9C4D": "bo",
	"5F14": "diao",
	"6FFC": "luo",
	"7AA6": "dou",
	"88D4": "yi",
	"8950": "xiang",
	"8CAF": "zhu",
	"9C4B": "qu",
	"559F": "kui",
	"81DF": "zang",
	"83A7": "xian",
	"8D48": "zhen",
	"8DB4": "pa",
	"542B": "han",
	"5467": "di",
	"6CBD": "gu",
	"7764": "pi",
	"94D3": "mang",
	"7559": "liu",
	"8EF9": "zhi",
	"9AA8": "gu",
	"4E25": "yan",
	"685F": "zhan",
	"6C55": "shan",
	"7CE4": "san",
	"81E6": "guang;wang",
	"6D7C": "mei",
	"6E6A": "none",
	"7F81": "ji",
	"80C3": "wei",
	"9638": "e",
	"4E55": "hu",
	"6850": "tong",
	"703E": "lan",
	"7AB2": "liao",
	"8FBD": "liao",
	"5BF8": "cun",
	"8609": "mang",
	"5F3C": "bi",
	"677E": "song",
	"7690": "gao",
	"7EB2": "gang",
	"808F": "cao",
	"888B": "dai",
	"918C": "kun",
	"9861": "yi",
	"4F9B": "gong",
	"5E44": "wo",
	"81F4": "zhi",
	"9D8A": "geng",
	"5B5B": "bei;bo",
	"69B2": "yun",
	"9B03": "zong",
	"5077": "tou",
	"5678": "dun",
	"57B0": "none",
	"75BC": "teng",
	"8164": "an",
	"84F1": "ping",
	"8848": "er",
	"5D94": "qin",
	"84E1": "can",
	"4EE5": "yi",
	"66E0": "kuang",
	"78B5": "none",
	"7A97": "chuang",
	"871C": "mi",
	"87D9": "zhi",
	"8F76": "yi",
	"9979": "le",
	"9EE1": "yan",
	"59FF": "zi",
	"5F54": "lu",
	"60C5": "qing",
	"82A8": "ji",
	"8474": "xian",
	"8684": "fang",
	"89C3": "yan",
	"4E85": "jue",
	"55F8": "ao",
	"570D": "wei",
	"8BFB": "du;dou",
	"8DCE": "tuo",
	"946D": "lan",
	"65E8": "zhi",
	"72B9": "you",
	"9E0A": "pi",
	"62F3": "quan",
	"755C": "chu;xu",
	"7F56": "none",
	"7F84": "zhao",
	"81CE": "cui",
	"8F51": "lao",
	"91F4": "yi",
	"9BD6": "qing;zheng",
	"9E9F": "lin",
	"6036": "pi",
	"8A33": "yi",
	"52FF": "wu",
	"6E85": "jian",
	"7BDE": "nie",
	"9A7F": "yi",
	"9DCD": "jiao",
	"614F": "ming",
	"62B3": "ni",
	"636E": "ju",
	"6F98": "shan",
	"8222": "shan",
	"945A": "zuan",
	"52E4": "qin",
	"7026": "zhu",
	"804A": "liao",
	"8479": "shi",
	"8E83": "bi",
	"6143": "yang",
	"7B68": "han",
	"7C35": "du",
	"990D": "yan",
	"9AC9": "bo",
	"7564": "zhi",
	"8E99": "lin",
	"9099": "mang",
	"93F0": "beng",
	"50BC": "han",
	"55C1": "ti",
	"56D5": "none",
	"867A": "hui",
	"4FEB": "lai",
	"5515": "zao",
	"5528": "zuo",
	"97CA": "lan",
	"9901": "ren",
	"5204": "ren",
	"5398": "li",
	"59F2": "yan",
	"8304": "qie;jia",
	"8D16": "shu",
	"5152": "er",
	"5913": "xia",
	"638B": "di",
	"6B8D": "piao",
	"904B": "yun",
	"9CC6": "fu",
	"6C5F": "jiang",
	"7D76": "jue",
	"545E": "shi",
	"7FC3": "hong",
	"8B08": "bo",
	"9651": "er",
	"5881": "man",
	"5606": "tan",
	"5DBC": "yu",
	"6044": "xi",
	"60FB": "ce",
	"7249": "pan",
	"60B6": "men",
	"7436": "pa;ba",
	"84CB": "gai;ge;he",
	"88CA": "niao",
	"859D": "zhan",
	"8A22": "xin",
	"9534": "kai",
	"9907": "tong",
	"5F97": "de;dei",
	"5FE5": "xi",
	"63E0": "ya",
	"79D7": "yu",
	"9F71": "chuo",
	"505A": "zuo",
	"53E1": "rui",
	"562D": "peng",
	"6677": "gui",
	"6C8E": "huo",
	"6D67": "ying",
	"70AA": "zhuo",
	"7ED7": "hang",
	"824B": "meng",
	"89B5": "jian",
	"5550": "cui",
	"7865": "mang",
	"7908": "zhui",
	"7EEE": "qi",
	"8B9B": "yi",
	"9128": "bi",
	"9C6D": "ji",
	"5014": "jue",
	"5F63": "zhang",
	"890D": "duan",
	"9028": "zui",
	"6F96": "xian",
	"7668": "huo",
	"9A36": "zou",
	"543C": "hou",
	"8435": "wo",
	"9558": "man",
	"9BAA": "wei",
	"9CAF": "qi",
	"605A": "hui",
	"8894": "he",
	"9775": "niu",
	"5534": "qiang",
	"5DD1": "cuan",
	"5E24": "ru",
	"6D5E": "zhuo",
	"7620": "ji",
	"8602": "rui",
	"8752": "mian",
	"89CE": "yu",
	"9824": "yi",
	"9D2D": "zhui",
	"58D7": "none",
	"6C1A": "chuan",
	"7CDF": "zao",
	"7EFE": "wan",
	"8156": "dong",
	"871B": "ju",
	"5927": "da;dai",
	"6C67": "qian",
	"7540": "bi",
	"5487": "bie",
	"5980": "ji",
	"5B0C": "jiao",
	"654B": "ge",
	"7CA5": "zhou;yu",
	"4F30": "gu",
	"5ECA": "lang",
	"6287": "hu",
	"9493": "diao",
	"9530": "meng",
	"5727": "ya",
	"6880": "cu",
	"8B5C": "pu",
	"4FA0": "xia",
	"6529": "dang",
	"6A52": "yun",
	"709F": "da",
	"7D33": "shen",
	"8C1F": "mo",
	"9909": "xiang",
	"527A": "li",
	"5657": "pu",
	"5AA0": "tuo",
	"653E": "fang",
	"735E": "tong",
	"9978": "he",
	"55E1": "weng",
	"6072": "peng",
	"60DF": "wei",
	"8E39": "chuai",
	"4FE4": "ti",
	"54C4": "hong",
	"56AA": "dan",
	"56E7": "jiong",
	"63DD": "zan",
	"6503": "sa",
	"6EE4": "lu",
	"73E9": "heng;hang",
	"7488": "ao",
	"74E4": "rang",
	"9EB8": "fu",
	"9EC8": "tou",
	"9F47": "zha",
	"5EE9": "lin",
	"5F60": "huo",
	"906A": "ce",
	"91FA": "qian",
	"504E": "wei",
	"5581": "yong",
	"5EED": "none",
	"6781": "ji",
	"684D": "ku",
	"69B5": "rong",
	"7066": "xian",
	"5092": "xi",
	"5615": "xian",
	"6003": "wu",
	"74FD": "dang",
	"7CB8": "qi",
	"86FB": "tui;shui",
	"8B4D": "ying",
	"8CFC": "gou",
	"9AD2": "zang",
	"5923": "meng",
	"5DF3": "si",
	"79F2": "zhi",
	"83D0": "pu",
	"8597": "yuan",
	"88E8": "bi;pi;bei",
	"4F1A": "hui;kuai",
	"5E85": "mo",
	"69DD": "none",
	"7945": "yao",
	"7CB9": "cui",
	"50C7": "lu",
	"61E7": "nuo",
	"8DD8": "pan",
	"9619": "que",
	"9982": "jun",
	"9E24": "shi",
	"6059": "yang",
	"88F2": "liang",
	"8A00": "yan",
	"9154": "zui",
	"6123": "leng",
	"6FAE": "kuai;hui",
	"7730": "die",
	"83C1": "jing",
	"8C5A": "tun",
	"56E6": "yuan",
	"6AB9": "yi",
	"6B00": "xiang",
	"799B": "zhen",
	"7A7D": "jing",
	"7B51": "zhu",
	"822C": "ban;bo;pan",
	"8E37": "zha",
	"514F": "chang;zhang",
	"6971": "cou",
	"7F1B": "ru",
	"6520": "mi",
	"7EAA": "ji",
	"977C": "da",
	"60BB": "xing",
	"74C9": "zan",
	"9500": "xiao",
	"4F86": "lai",
	"5DB9": "dao",
	"65E7": "jiu",
	"8706": "xian",
	"8890": "bi",
	"5725": "lu",
	"5D9F": "zun",
	"6844": "guang",
	"75E7": "sha",
	"8411": "huan",
	"8567": "fu",
	"900B": "bu",
	"6547": "ce",
	"86F8": "shao;xiao",
	"9EBA": "mian",
	"613F": "yuan",
	"6592": "ban",
	"67BD": "sang",
	"6C10": "di",
	"793D": "reng",
	"7C82": "none",
	"81A3": "zhi",
	"8928": "suo",
	"4EBD": "none",
	"671F": "qi;ji",
	"7732": "er",
	"8A47": "yang",
	"9F0F": "mi",
	"52BA": "mou",
	"5C90": "qi",
	"608D": "han",
	"68D9": "li",
	"7C48": "zhen",
	"87E1": "gui",
	"90F9": "ju",
	"9A3D": "xi",
	"9CF5": "bao",
	"5462": "ni;ne;na",
	"5879": "qian",
	"6EDB": "yin",
	"8136": "luo",
	"9513": "qin",
	"52F3": "xun",
	"55C4": "a;sha",
	"5BF3": "bao",
	"6807": "biao",
	"77EB": "jiao",
	"84E0": "li",
	"8D22": "cai",
	"5A78": "yang",
	"9B8B": "you",
	"574B": "fen",
	"5A21": "zhi",
	"5D4F": "zong",
	"9B83": "ping",
	"9F55": "he",
	"6112": "kai;qi",
	"7629": "da",
	"9455": "zhi",
	"9654": "gai",
	"52D4": "mian",
	"531C": "yi",
	"6FDE": "bi",
	"70A5": "fu",
	"710B": "zhuang",
	"7B48": "gua",
	"7FAC": "xian",
	"8C8B": "an",
	"9991": "jin",
	"503F": "none",
	"6CF7": "long;shuang",
	"799A": "zhuo",
	"7A9A": "cheng",
	"7F64": "ti",
	"7FCC": "yi",
	"84FA": "yi",
	"9010": "zhu",
	"9BDF": "dong",
	"51BE": "xia",
	"5802": "tang",
	"635C": "sou",
	"63ED": "jie",
	"625A": "diao",
	"64BB": "ta",
	"65F7": "kuang",
	"8536": "ze",
	"8A76": "chou",
	"94FC": "lai",
	"9808": "xu",
	"554A": "a",
	"5D1F": "yin",
	"6948": "xu",
	"726C": "bei",
	"80F2": "hai;gai",
	"8D91": "zi",
	"8FA4": "ci",
	"9112": "zou",
	"5C18": "chen",
	"6E8E": "gui",
	"8931": "huai",
	"5618": "xu;shi",
	"8531": "sha",
	"52C7": "yong",
	"59E6": "jian",
	"5CC2": "tong",
	"85F3": "gao",
	"879C": "hu",
	"61D6": "gua",
	"71AA": "yi",
	"8A4B": "zhou",
	"8CCE": "jian",
	"8E8B": "ji",
	"551D": "gong",
	"667E": "liang",
	"6D5D": "mang",
	"9A66": "shuang",
	"4E4A": "none",
	"5338": "xi",
	"66B0": "cong",
	"7D74": "xiang",
	"8182": "lu",
	"82FF": "wei",
	"840A": "lai",
	"910D": "ming",
	"9B5D": "ji",
	"9180": "wei",
	"9450": "xu",
	"5334": "suan",
	"5444": "ge",
	"6BC1": "hui",
	"6C28": "an",
	"6CDB": "fan",
	"7DD2": "xu",
	"7DF8": "yin",
	"9351": "fu",
	"9352": "rou",
	"3007": "ling",
	"590E": "zuo",
	"7024": "huai",
	"76B7": "gu",
	"7DB4": "zhui",
	"8127": "juan",
	"5AD9": "xuan",
	"8884": "ao",
	"9684": "ti",
	"5342": "xin",
	"68D7": "zao",
	"723B": "yao",
	"97CF": "juan",
	"5771": "yang",
	"68B5": "fan",
	"6F08": "ji",
	"8367": "ying",
	"5750": "zuo",
	"6B6F": "chi",
	"76B5": "que",
	"53BB": "qu",
	"5AB4": "yuan",
	"68CD": "gun",
	"7091": "mu",
	"7B2A": "da",
	"8841": "huang",
	"8A1A": "yin",
	"94B7": "po",
	"9CCD": "qi",
	"5066": "xu",
	"519B": "jun",
	"5CA9": "yan",
	"63FC": "none",
	"6419": "nu",
	"7003": "si",
	"8183": "wa",
	"54E4": "mang",
	"8401": "ji;qi",
	"8F83": "jiao",
	"6FAA": "ling",
	"942A": "lu",
	"9526": "jin",
	"987D": "wan",
	"61F8": "xuan",
	"6EF4": "di",
	"75EE": "zhang",
	"85BF": "ni",
	"88EB": "yuan",
	"89E5": "gong",
	"5FD7": "zhi",
	"7DEB": "zong",
	"9CD0": "yao",
	"5632": "chao;zhao",
	"56F2": "wei",
	"5BA5": "you",
	"6F21": "shang",
	"7641": "fu",
	"7D9F": "li",
	"5B19": "qiang",
	"6D30": "ju",
	"72F0": "zheng",
	"90AC": "wu",
	"50FD": "zhou",
	"796C": "zhi",
	"7F74": "pi",
	"87E4": "zhuan",
	"8BF0": "gao",
	"8E02": "nie",
	"940D": "jue",
	"9F29": "qu",
	"5091": "jie",
	"599D": "zhuang",
	"7CB5": "yue",
	"876F": "yuan",
	"87B7": "pi",
	"9106": "yun",
	"6B4F": "jin",
	"849F": "ju",
	"932D": "tao",
	"564F": "xi",
	"6692": "qing",
	"6CDA": "ci",
	"8970": "lai",
	"9CCE": "ta",
	"73C5": "shen",
	"7D2B": "zi",
	"8106": "cui",
	"5B7E": "ying",
	"62EA": "qian",
	"694C": "yan",
	"83A2": "jia",
	"8AF0": "xi",
	"8F9B": "xin",
	"964F": "duo",
	"6C81": "qin;shen",
	"87E6": "fei",
	"8D6A": "cheng",
	"64AA": "ben",
	"7102": "shu",
	"74D9": "dao",
	"7630": "luo",
	"7B4F": "fa",
	"8DBA": "fu",
	"944D": "ying",
	"59C7": "fu",
	"6C04": "rong",
	"7174": "yun",
	"7239": "die",
	"871D": "qi",
	"8E93": "zhi",
	"9A6C": "ma",
	"5363": "you",
	"7505": "none",
	"89C5": "mi",
	"9A7D": "nu",
	"6707": "pi;bi",
	"717B": "tang",
	"7555": "jiang",
	"860E": "ji",
	"8770": "kui",
	"5424": "jie",
	"5F82": "cu",
	"7990": "yuan",
	"59CA": "zi",
	"5DAC": "yi",
	"63CC": "sai",
	"67D1": "gan",
	"71D3": "fen",
	"80E8": "dong",
	"84F8": "cao",
	"8C70": "hu",
	"9B95": "gu",
	"4E36": "zhu;dian",
	"5101": "jun;juan",
	"6778": "shu",
	"79E0": "pi",
	"79F1": "tong",
	"7AF4": "cun",
	"947D": "zuan",
	"986E": "bin",
	"542E": "shun",
	"563D": "chan",
	"5D35": "yang",
	"5DE5": "gong",
	"6A09": "shuang",
	"810B": "xie",
	"8FDC": "yuan",
	"9B48": "xiao",
	"8C25": "shi",
	"943A": "dang;cheng",
	"99C8": "qu",
	"4FD6": "pai",
	"59D9": "ren",
	"5C48": "qu",
	"6B41": "kan",
	"6C26": "hai",
	"70B6": "han",
	"84BF": "hao",
	"7615": "jia;xia",
	"7EEB": "ling",
	"9A06": "zhou",
	"650B": "la",
	"6F57": "ji",
	"7F94": "gao",
	"7FC1": "weng",
	"873D": "liang",
	"955B": "yong",
	"9606": "lang",
	"98C9": "liao",
	"9DFE": "yi",
	"5848": "ji",
	"8ABE": "yin",
	"90BD": "gui",
	"5328": "cang;zang",
	"6E40": "kui",
	"6EEE": "biao",
	"711C": "kun",
	"7ED9": "ji;gei",
	"832B": "mang",
	"855A": "e",
	"996D": "fan",
	"9A07": "she",
	"9BB4": "none",
	"9BD0": "none",
	"9DB9": "liu",
	"533E": "bian",
	"57E9": "zheng",
	"5911": "none",
	"67BB": "yi",
	"725E": "jiu",
	"764F": "guan",
	"8A39": "xu",
	"9812": "ban",
	"4F2B": "zhu",
	"924A": "zhao",
	"619B": "tan",
	"6C31": "yang",
	"6FEF": "zhuo",
	"5BB7": "shen",
	"7C0A": "ji",
	"8E70": "chu",
	"942B": "juan",
	"561F": "du",
	"743E": "jie",
	"7DEE": "fu",
	"83ED": "tai",
	"9124": "fan",
	"54AA": "mi",
	"58D2": "kai",
	"599F": "yan",
	"7224": "lan",
	"8F00": "er",
	"5102": "nong",
	"7CAD": "none",
	"90A0": "bin",
	"5FF5": "nian",
	"7016": "huo",
	"713E": "none",
	"8FD6": "ta",
	"527E": "kou",
	"5466": "you",
	"5ABE": "gou",
	"5DCF": "quan",
	"6511": "qian",
	"6A1D": "zha",
	"6B6D": "chi",
	"8123": "chun",
	"8C1B": "di",
	"5277": "chan",
	"5AA9": "hu",
	"68B8": "li",
	"7DE6": "si",
	"8455": "yan",
	"8E7E": "dun",
	"9006": "ni",
	"9C72": "lie",
	"5CB8": "an",
	"7B81": "pu",
	"7FF5": "qu",
	"859F": "lian;xian",
	"902F": "lu",
	"4F73": "jia",
	"5006": "lia;liang",
	"77AA": "deng",
	"79C8": "xian",
	"7DB8": "lun;guan",
	"7F1D": "feng",
	"8089": "rou",
	"8596": "ke",
	"6E75": "you",
	"783F": "kuang",
	"7A88": "yao",
	"7C39": "dang",
	"96EA": "xue",
	"5C47": "tian",
	"5CF1": "nao",
	"5F8F": "zhi",
	"6C90": "mu",
	"6D07": "yin",
	"72D3": "pi",
	"8345": "da",
	"9C7B": "xian",
	"6259": "zhang",
	"6AE9": "yan",
	"7AE9": "yi",
	"8193": "chang",
	"9880": "qi",
	"5473": "wei",
	"9C1D": "hao",
	"5EB4": "ji",
	"6651": "xiang",
	"6E94": "yao",
	"7EB0": "pi",
	"6BBE": "xun",
	"6C14": "qi",
	"7CED": "zong",
	"9A1F": "yu",
	"5D79": "jiang",
	"7F3C": "que",
	"84F2": "qiu;ou",
	"4F4B": "shao",
	"4FA3": "lu",
	"4FD8": "fu",
	"5D37": "qiu",
	"6233": "chuo",
	"7176": "none",
	"7E48": "qiang",
	"51C9": "liang",
	"558B": "die;zha",
	"7A82": "lao",
	"7E7E": "qian",
	"8633": "tong",
	"8A24": "xiao",
	"4EEF": "chao",
	"6FED": "ai",
	"74C2": "gai",
	"77F1": "huo",
	"833C": "tong",
	"5183": "mao",
	"62E1": "kuo",
	"64DD": "none",
	"64EA": "ye",
	"7038": "jian",
	"71F5": "none",
	"7536": "fu",
	"9541": "mei",
	"9E07": "zhan",
	"617D": "qi",
	"767E": "bai;bo",
	"76A5": "hao",
	"8676": "yu",
	"4E54": "qiao",
	"634A": "pou",
	"8806": "chai",
	"709A": "guang",
	"7907": "yu",
	"9EBE": "hui",
	"4E69": "ji",
	"4FBB": "tuo",
	"525C": "wan",
	"57BA": "pei",
	"6EF6": "ao",
	"798A": "xi",
	"8DD2": "qia",
	"8C68": "xi",
	"8D50": "ci",
	"9598": "zha",
	"990B": "yang",
	"99F8": "qin",
	"4FEC": "si",
	"5217": "lie",
	"5F45": "none",
	"7DD9": "ke",
	"99F2": "none",
	"7C6D": "shai",
	"846D": "jia",
	"6333": "keng",
	"6EF7": "lu",
	"73F9": "cheng",
	"8054": "lian",
	"92E8": "e",
	"9942": "yun",
	"5470": "zi",
	"5FCE": "ren",
	"8240": "fu",
	"8590": "leng",
	"5BB8": "chen",
	"5EF9": "po",
	"6264": "wu",
	"6B80": "yao",
	"74D4": "ying",
	"8525": "cong",
	"7918": "qi",
	"8134": "pi",
	"8616": "nie",
	"511F": "chang",
	"5712": "yuan",
	"69F0": "beng",
	"713A": "sheng",
	"74D3": "lan",
	"8512": "xun",
	"886C": "chen",
	"8ACE": "ze",
	"8AEC": "qi",
	"5D0A": "none",
	"629C": "ba",
	"7301": "li",
	"7E44": "yi",
	"8B62": "sui",
	"6318": "none",
	"696F": "shun;dun",
	"6CE5": "ni",
	"71CF": "yu",
	"7D03": "xun",
	"7D26": "ba",
	"95DB": "tang",
	"99C4": "tuo;duo",
	"5000": "chang",
	"5552": "hu",
	"5BE8": "zhai",
	"60FF": "ti",
	"62E4": "qia",
	"65A2": "tiao;tou",
	"8DFF": "tu",
	"9EB1": "fu",
	"5E3B": "ze",
	"74C7": "rou",
	"8A96": "bei",
	"4EA3": "ta",
	"52EF": "dan",
	"6330": "cheng",
	"7896": "lun",
	"816A": "yun",
	"9D25": "yu",
	"9D57": "xi",
	"5035": "wu",
	"504B": "bing",
	"66B3": "hui",
	"6A74": "none",
	"80F0": "yi",
	"82E5": "ruo;re",
	"8AB5": "xiao",
	"8D61": "shan",
	"8E68": "nian",
	"92C6": "yun",
	"4E67": "none",
	"540C": "tong",
	"5F07": "yan",
	"749F": "jing",
	"802E": "lao",
	"8387": "zhu",
	"4FF9": "ya",
	"542A": "e",
	"6470": "chi",
	"6D7E": "cheng",
	"81F8": "zhi",
	"512E": "li",
	"5EDE": "xin",
	"8654": "qian",
	"871E": "qi",
	"8FFD": "zhui",
	"682C": "zui",
	"88E7": "tan",
	"51BD": "lie",
	"57AF": "da",
	"7915": "pi",
	"82F2": "zha",
	"86CE": "li",
	"89F3": "hu",
	"8CF7": "ji",
	"5646": "can",
	"6EAA": "xi;qi",
	"7ACE": "fu",
	"84B0": "pan",
	"590A": "sui",
	"6FEE": "pu",
	"7C1A": "mi",
	"98C7": "biao",
	"545F": "quan",
	"6280": "ji",
	"628F": "wan",
	"64DC": "none",
	"6FC9": "sui",
	"7B7D": "none",
	"8746": "yang",
	"90FA": "yong",
	"80F7": "xiong",
	"779A": "shun",
	"84F3": "jin",
	"942F": "zhuo",
	"52BD": "lie",
	"53C9": "cha",
	"5DF0": "qiu",
	"5E9F": "fei",
	"6860": "ya",
	"8B0C": "ge",
	"9A3C": "lu",
	"9C2D": "qi",
	"9E1A": "ying",
	"5F56": "tuan",
	"667B": "an",
	"877E": "rong",
	"88B4": "ku",
	"8EA5": "cuan",
	"9434": "bi",
	"94CF": "xing",
	"4EA5": "hai",
	"544E": "chi",
	"79B4": "yue",
	"7FE8": "shi",
	"8334": "hui",
	"8342": "kua",
	"8437": "xiao",
	"8696": "yuan",
	"86D9": "wa",
	"8CBF": "mao",
	"912B": "ceng",
	"9B33": "juan",
	"6CE3": "qi;xie",
	"707D": "zai",
	"7948": "qi",
	"7F6E": "zhi",
	"8AAE": "none",
	"9200": "ba;pa",
	"60D6": "ti",
	"7058": "tan",
	"5C4F": "ping;bing",
	"6412": "bang;peng",
	"6ADD": "du",
	"8728": "die",
	"8EFA": "yao",
	"953A": "zhong",
	"5190": "mao;mo",
	"6E21": "du",
	"7EB6": "lun;guan",
	"8A5F": "zhe",
	"505E": "ye",
	"658E": "zhai",
	"702F": "ying",
	"7245": "die",
	"7B4A": "jiao",
	"7BF5": "cong",
	"914C": "zhuo",
	"57E1": "wu;ya",
	"5A19": "keng",
	"5E40": "zhen;zheng",
	"6FFE": "lu",
	"5AF1": "qiang",
	"5B68": "chan",
	"7CC4": "bian",
	"8112": "mi",
	"859C": "bi;bo",
	"8641": "nao",
	"96C2": "qin",
	"5262": "zhuo",
	"546E": "qi",
	"73EC": "xu",
	"7F8C": "qiang",
	"81A1": "ying",
	"8FB6": "chuo",
	"9338": "lai",
	"6F7A": "chan",
	"8155": "wan",
	"8D25": "bai",
	"922D": "zi",
	"9EF3": "yi",
	"5BA9": "shi",
	"5E32": "ping",
	"640C": "zhan",
	"7D55": "jue",
	"8F2B": "pai",
	"565C": "lu",
	"5AEB": "mo",
	"61E1": "mo",
	"695F": "ting",
	"6D24": "quan",
	"763D": "jin",
	"7BF3": "bi",
	"8F91": "ji",
	"937C": "zhen",
	"9F5A": "ze",
	"4FBF": "bian;pian",
	"501A": "yi",
	"5624": "ying",
	"5EE4": "none",
	"675B": "gong",
	"7E13": "quan",
	"54EA": "na;nei;nai",
	"6E50": "mo",
	"846E": "duan",
	"52D2": "le;lei",
	"6EB6": "rong",
	"7029": "dui",
	"7947": "zhi;qi",
	"9092": "ting",
	"9B5F": "hong",
	"7491": "wu",
	"768B": "gao",
	"7893": "dui",
	"7A4C": "su;wei",
	"7BEC": "qiang",
	"8FF7": "mi",
	"5955": "yi",
	"5A70": "dian",
	"617C": "qi",
	"6A6C": "cen",
	"7C00": "ze;kui",
	"9348": "ying",
	"97B3": "ta",
	"52AA": "nu;nao",
	"5B31": "can",
	"6380": "xian",
	"76BE": "du",
	"790C": "lei",
	"83C9": "lu",
	"9B0D": "hu",
	"5469": "shi",
	"5CAD": "ling",
	"64D0": "huan",
	"862C": "kui",
	"56C7": "li",
	"5C0D": "dui",
	"6161": "shuang",
	"78DD": "ao",
	"865A": "xu",
	"9287": "lei",
	"9618": "da;ta",
	"4FFD": "xin",
	"67E4": "zha",
	"743B": "none",
	"5C5A": "lou",
	"7C71": "zhuo",
	"8122": "mei",
	"94E0": "kai",
	"59F6": "yan",
	"5C26": "liao",
	"7B1B": "di",
	"7F52": "gang",
	"909E": "fu",
	"6BBA": "sha;shai",
	"9331": "zhen",
	"4F02": "pei",
	"5393": "ya",
	"60A9": "nao",
	"633E": "xie;jia;xia",
	"7124": "fu",
	"73CC": "bi",
	"7E71": "cong",
	"95FF": "kai",
	"536D": "qiong",
	"5F9D": "zhi",
	"6E27": "di",
	"6FFD": "luo",
	"8E77": "jue",
	"5521": "liang",
	"5D72": "nie",
	"6485": "jue",
	"7043": "feng",
	"7D6E": "xu",
	"8E21": "quan",
	"578F": "lu",
	"68F3": "zhuo",
	"6FCC": "ta",
	"74EE": "weng",
	"78B7": "none",
	"8F56": "se",
	"8F8D": "chuo",
	"5113": "tai",
	"5760": "zhui",
	"59F3": "ming",
	"62BE": "qu",
	"9A56": "tie",
	"5CFE": "yin",
	"6B5B": "lian",
	"72F2": "sun",
	"8FF8": "beng",
	"912D": "zheng",
	"5761": "po",
	"6587": "wen",
	"817C": "mian",
	"4E7E": "qian;gan",
	"736F": "xun",
	"82BF": "reng",
	"8418": "nai",
	"9D08": "yan",
	"754A": "geng",
	"97C5": "xian",
	"4E8C": "er",
	"58C7": "tan",
	"58CA": "huai;pi",
	"64FF": "zhi",
	"7272": "sheng",
	"76BF": "min",
	"8186": "su",
	"9631": "jing",
	"5186": "yuan",
	"587A": "mei",
	"5CC9": "e",
	"8300": "fu",
	"831D": "chai",
	"885F": "dao",
	"9AAA": "wei",
	"546D": "yi",
	"5705": "han",
	"57AC": "hong",
	"5B35": "mian",
	"5C3B": "kao",
	"7797": "diao",
	"8C62": "huan",
	"950B": "feng",
	"967B": "yin",
	"5264": "ji",
	"546B": "zhan",
	"6A08": "qing",
	"8440": "gua",
	"8DA6": "zi",
	"9912": "nei",
	"9BCF": "none",
	"62B6": "chi",
	"75CD": "yi",
	"7E72": "jie",
	"824F": "shou",
	"93C9": "shou",
	"99B5": "zhu",
	"9D5E": "e",
	"551E": "dou",
	"8482": "di",
	"92C8": "wu",
	"5254": "ti",
	"56A6": "li",
	"8680": "shi",
	"8887": "ran",
	"569C": "mo",
	"6106": "qian",
	"6591": "ban",
	"7869": "che",
	"7C59": "lu",
	"7DE9": "huan",
	"8468": "wei",
	"9635": "zhen",
	"4E72": "none",
	"5A03": "wa",
	"5B7F": "luan",
	"68E7": "zhan",
	"7D75": "hui",
	"808A": "yi",
	"8D09": "tan",
	"91C1": "xin",
	"9C85": "ba",
	"6444": "she",
	"709E": "bian",
	"774B": "e",
	"813D": "shui",
	"87AB": "shi;zhe",
	"54D2": "da",
	"598B": "fu",
	"6C6F": "hong",
	"6E16": "shen",
	"7195": "none",
	"8C5E": "hou",
	"8F50": "pu",
	"939E": "bi",
	"5B64": "gu",
	"5BFF": "shou",
	"663C": "zhou",
	"9CE8": "li",
	"4F7C": "jiao",
	"513F": "er",
	"823E": "xi",
	"941C": "dui",
	"4EDF": "qian",
	"5305": "bao",
	"603A": "none",
	"6621": "xuan",
	"75B2": "pi",
	"7AA7": "none",
	"7E39": "piao",
	"8C61": "xiang",
	"9265": "shu",
	"93D6": "ao",
	"98F2": "yin",
	"65C8": "liu",
	"67DE": "zuo;zha",
	"7FB4": "shan",
	"89A7": "lan",
	"98B8": "si",
	"9BA7": "yi",
	"9F1F": "teng",
	"61F0": "liu",
	"64F4": "kuo",
	"6B1D": "yu",
	"7500": "chui",
	"875B": "wei",
	"8CE9": "cong",
	"69A9": "qian",
	"84CA": "weng",
	"8FCB": "wang",
	"5B9B": "wan;yuan",
	"63E1": "wo",
	"7B5F": "fu",
	"95A8": "gui",
	"961A": "kan;han",
	"9A51": "liu",
	"9B9B": "shua",
	"9D95": "fu",
	"694B": "la",
	"6F86": "jiao",
	"7546": "mu",
	"93A9": "sha",
	"9EA7": "ge",
	"5E8C": "ya",
	"7194": "rong",
	"52B6": "kou",
	"6771": "dong",
	"6DD7": "ju",
	"7499": "liao",
	"9565": "lu",
	"970C": "chou",
	"5DD8": "yan",
	"6227": "chuang;qiang",
	"63CA": "pi",
	"7154": "tian",
	"7F7D": "ji",
	"8C18": "zi",
	"9999": "xiang",
	"6243": "jiong",
	"70E5": "none",
	"9046": "ti",
	"5DEE": "cha;chai;ci",
	"6006": "chuang",
	"6913": "zhuo",
	"6D9F": "lian",
	"8107": "xie",
	"8ED4": "ren",
	"9E8C": "wu",
	"9E99": "yan",
	"6DE2": "yu",
	"8769": "chong",
	"895F": "jin",
	"8F5A": "ji",
	"94CB": "bi",
	"56AF": "huo",
	"58DC": "tan",
	"7757": "shi",
	"90E1": "jun",
	"9414": "tan;chan;xin",
	"4E93": "qi",
	"50F5": "jiang",
	"6366": "qin",
	"7D14": "chun",
	"9506": "gao",
	"9A61": "peng",
	"9F2F": "wu",
	"5FCB": "gai",
	"61BF": "jiao",
	"6F7C": "tong",
	"7A08": "gan",
	"9A44": "cong",
	"95E4": "huan",
	"963A": "di",
	"98D4": "si",
	"9F08": "bie",
	"6AAA": "li;yue",
	"56A9": "mo",
	"5889": "yong",
	"5D49": "ting",
	"6699": "chun",
	"76A1": "hao",
	"80BA": "fei",
	"957E": "mi",
	"9BC8": "chou",
	"664F": "yan",
	"6D09": "hou",
	"7753": "tian",
	"52BB": "kuang",
	"5C77": "none",
	"5CF3": "you",
	"6806": "none",
	"7203": "rong",
	"75B7": "qi",
	"89C1": "jian;xian",
	"5B43": "niang",
	"66E1": "die",
	"760E": "shen",
	"847B": "lan",
	"88BC": "ge",
	"54CF": "gen",
	"5870": "none",
	"62DC": "bai",
	"679C": "guo",
	"7048": "qu",
	"7265": "fang",
	"7DE3": "yuan",
	"6F62": "huang",
	"706F": "deng",
	"866A": "shu",
	"9196": "yun",
	"4F6B": "he",
	"580C": "gu",
	"7779": "du",
	"8988": "he",
	"8F45": "yuan",
	"9595": "xia",
	"5BB6": "jia;gu;jie",
	"6209": "yue",
	"6C91": "rou",
	"7A22": "yu",
	"7BA7": "qie",
	"7E22": "teng",
	"8552": "mai",
	"8A8A": "teng",
	"6383": "sao",
	"9CA3": "jian",
	"5D69": "song",
	"69B4": "liu",
	"71E7": "sui",
	"7793": "shui",
	"7BD5": "he",
	"9B07": "zheng",
	"578A": "none",
	"5C98": "xian",
	"646B": "gui",
	"780B": "zhi",
	"7DA5": "qi",
	"831F": "yu",
	"890F": "xiu",
	"9535": "qiang",
	"9757": "cheng",
	"684B": "yi",
	"6875": "rui",
	"737E": "huan",
	"7496": "qu",
	"9033": "yu",
	"946F": "jian",
	"4F2E": "nao;nu",
	"64AC": "qiao",
	"67BA": "mo",
	"74A6": "ai",
	"6426": "nuo",
	"6773": "yao;miao",
	"6AFA": "ling",
	"6CD2": "gu",
	"6E14": "yu",
	"7870": "cuo",
	"5988": "ma",
	"5C63": "xi",
	"6747": "wu",
	"6E41": "shi",
	"6E7C": "nie",
	"6FEB": "lan",
	"7873": "none",
	"960D": "hun",
	"9A43": "piao;biao",
	"66AB": "zan;zhan",
	"85B3": "wei",
	"5510": "tang",
	"6504": "shu",
	"7FFB": "fan",
	"8FF2": "none",
	"9525": "zhui",
	"53B3": "yan",
	"68EA": "yan",
	"6CCC": "mi;bi",
	"8031": "mo",
	"8D81": "chen",
	"5669": "e",
	"59AD": "ba",
	"74F6": "ping",
	"88D3": "ge",
	"9F41": "hou",
	"6D32": "zhou",
	"7F68": "yan",
	"91ED": "gong;gang",
	"5137": "li",
	"6013": "nao",
	"75EB": "xian",
	"8FB1": "ru",
	"930A": "zui",
	"98A7": "quan",
	"5039": "jian",
	"6513": "qian",
	"6D16": "wu",
	"8F66": "che;ju",
	"8AA1": "jie",
	"5063": "yan",
	"5BE9": "shen",
	"71D5": "yan",
	"7A2D": "jie",
	"7B82": "lai",
	"932A": "dian",
	"9788": "jia",
	"8A1C": "fen",
	"96DB": "chu",
	"67D0": "mou",
	"7576": "dang",
	"767C": "fa",
	"80A4": "fu",
	"7F71": "lan",
	"9AB6": "di",
	"6E82": "la",
	"7599": "ge",
	"91D7": "zhao",
	"59FE": "quan",
	"68AF": "ti",
	"7F93": "ba",
	"93C3": "zu;cu",
	"9587": "bi",
	"9EDC": "chu",
	"5A6A": "lan",
	"5EB0": "bing",
	"6B22": "huan",
	"848B": "jiang",
	"5803": "kun",
	"7DE7": "qiu",
	"7F19": "jin",
	"9E4D": "kun",
	"77F3": "shi;dan",
	"80E0": "qu",
	"848F": "none",
	"5668": "qi",
	"8090": "ge",
	"826C": "chan",
	"83DD": "ba",
	"87F9": "xie",
	"974A": "feng",
	"9B3D": "mei",
	"5F39": "dan;tan",
	"70B4": "yang",
	"7841": "keng",
	"8BF3": "kuang",
	"51EC": "feng",
	"54C9": "zai",
	"6763": "none",
	"7B6F": "zhu",
	"81BF": "nong",
	"83AC": "wen",
	"8426": "ying",
	"85DD": "yi",
	"4F89": "kua",
	"5584": "shan",
	"6568": "dou",
	"8F9C": "gu",
	"55C0": "huo",
	"7FAA": "yang",
	"8339": "ru",
	"83A1": "cuo",
	"8C1D": "pian",
	"8D76": "gan",
	"8DA8": "qu;cu",
	"9B6C": "fan",
	"9C67": "li",
	"9CEF": "feng",
	"5C74": "li",
	"5D3C": "shi",
	"6851": "sang",
	"71DF": "ying",
	"74E9": "qian;wa",
	"7BD2": "none",
	"8A66": "shi",
	"8FAD": "ci",
	"5C8C": "ji",
	"61EC": "xing",
	"69D4": "gao",
	"69F5": "huan",
	"7358": "bi",
	"89FE": "yan",
	"987F": "dun",
	"7566": "qi;xi",
	"792D": "que",
	"79B6": "zan",
	"8AC8": "chui",
	"51C0": "jing",
	"61A7": "chong",
	"719A": "bi",
	"93B5": "jia",
	"95CA": "kuo",
	"9D88": "qi",
	"53FA": "chi",
	"7CAE": "liang",
	"8DAC": "qiao",
	"97BC": "gui",
	"6528": "wa",
	"696E": "chu",
	"9881": "ban",
	"6F1D": "xi",
	"7D4A": "zui",
	"822F": "zhong",
	"6219": "dong",
	"9304": "lu",
	"9646": "lu;liu",
	"81E8": "lin",
	"91EF": "mang",
	"4F24": "shang",
	"509D": "ta",
	"5D58": "rong",
	"7200": "he",
	"7C08": "ping",
	"8B3D": "jiang",
	"9D59": "ju",
	"4ED4": "zi;zai",
	"52D3": "kai",
	"6494": "heng",
	"6A4A": "liu",
	"6B99": "hun",
	"859B": "xue",
	"8A2F": "sa",
	"975B": "dian",
	"5751": "keng",
	"611F": "gan",
	"63B2": "jie",
	"678C": "fen",
	"69FC": "gui",
	"7371": "bian",
	"78EE": "none",
	"4F78": "huo",
	"5DD4": "dian",
	"6165": "zao",
	"7B20": "li",
	"8643": "jian",
	"8742": "ban",
	"9612": "qu",
	"9634": "yin",
	"520D": "chu",
	"5D20": "dong",
	"74F9": "juan",
	"7FF6": "none",
	"83C2": "di",
	"8A21": "yin",
	"5835": "du",
	"6CCF": "chu",
	"7517": "yan",
	"77DF": "shuo",
	"8230": "jian",
	"982D": "tou",
	"99EC": "er",
	"9C12": "fu",
	"9CC2": "wei",
	"7AF8": "jing",
	"8AFC": "xuan",
	"8EF6": "e",
	"63B1": "shou;pa",
	"65AD": "duan",
	"79D8": "mi;bi;lin",
	"7EC8": "zhong",
	"983D": "tui",
	"5571": "yan",
	"5EC4": "jiu",
	"645C": "guan",
	"65B1": "zhuo",
	"682B": "jian",
	"777B": "xuan",
	"79E7": "yang",
	"80CC": "bei",
	"969A": "tang",
	"9CEC": "fu",
	"9DC4": "ji",
	"895B": "nong",
	"95FD": "min",
	"99E7": "dong",
	"9B97": "none",
	"5BAA": "xian",
	"69F6": "kui",
	"6EFB": "chan",
	"4FC7": "kuang",
	"5875": "chen",
	"5F87": "xun",
	"5FA0": "lai",
	"60DD": "chang",
	"6FA1": "zao",
	"81A5": "chun",
	"92E0": "shen",
	"962D": "yun",
	"548C": "he;huo;hai",
	"564A": "yu",
	"6749": "shan",
	"768D": "ji",
	"8A3C": "zheng",
	"4F67": "ka",
	"53DF": "sou",
	"5460": "pen",
	"5A6F": "li",
	"6267": "zhi",
	"6686": "yi",
	"677F": "ban",
	"6B3B": "hu",
	"8E05": "xue",
	"8E17": "nie",
	"9D0C": "feng",
	"517B": "yang",
	"6465": "tang",
	"6881": "liang",
	"7027": "long;shuang",
	"737F": "nao",
	"7382": "qi",
	"798B": "yin",
	"862B": "lan",
	"9C5D": "fen",
	"68DE": "hun",
	"70E3": "hui",
	"754B": "tian",
	"85A6": "jian",
	"86EC": "gong",
	"8947": "jian",
	"8E8F": "lin",
	"9BA2": "zhu",
	"55F2": "dia",
	"5958": "zhuang;zang",
	"5D10": "kun",
	"6196": "yin",
	"7BEE": "lan",
	"814F": "chuo;duo",
	"8DC9": "ling",
	"97E5": "du",
	"9E3E": "luan",
	"9F73": "nian",
	"569F": "li",
	"5CBC": "none",
	"6532": "qi",
	"7368": "du",
	"7A06": "lu",
	"7FF4": "lian",
	"9C31": "lian",
	"9E6E": "huan",
	"5651": "hao",
	"81ED": "chou;xiu",
	"8798": "yi",
	"9E9C": "li",
	"4F1E": "san",
	"6931": "fu",
	"7B93": "lu",
	"5CEC": "bu",
	"6033": "huang",
	"6626": "hao",
	"6E54": "jian",
	"70A6": "ba",
	"740D": "li",
	"8B52": "bo",
	"9783": "hong",
	"9958": "zhan",
	"9E3D": "ge",
	"9F6C": "yu",
	"5071": "xun",
	"5362": "lu",
	"5559": "zi",
	"7556": "wa",
	"9DB7": "xia",
	"5AF2": "none",
	"60E0": "hui",
	"651E": "luo",
	"71BB": "xi",
	"7562": "bi",
	"7581": "liu",
	"8272": "se;shai",
	"4F5E": "ning",
	"54D9": "kuai",
	"5C86": "yao",
	"6B2C": "kai",
	"7C7E": "ni",
	"8ACC": "jian",
	"921E": "jun",
	"5030": "leng",
	"71E5": "zao",
	"73D8": "zhou",
	"76CF": "zhan",
	"9DD5": "yao",
	"50EA": "jue",
	"511E": "ni",
	"64B7": "xie",
	"6583": "bi",
	"6939": "shen;zhen",
	"7FD2": "xi",
	"914D": "pei",
	"9AD4": "ti",
	"9DFC": "xian",
	"64CE": "qing",
	"778C": "ke",
	"7DB9": "liu",
	"8776": "die",
	"912A": "bi",
	"9937": "cha",
	"9A23": "zong",
	"5D04": "xian",
	"6F48": "none",
	"86A5": "fu",
	"8DE1": "ji",
	"5412": "zha",
	"7005": "ying",
	"7A26": "yi",
	"817F": "tui",
	"8428": "sa",
	"55A3": "xu",
	"5DA7": "yi",
	"5E6F": "jie",
	"7B7A": "kuang",
	"7BF4": "di",
	"7BFE": "mie",
	"6204": "jue",
	"63AE": "qian",
	"5BB5": "xiao",
	"5DE2": "chao",
	"5DFB": "juan",
	"60C1": "xi",
	"8490": "sou",
	"8840": "xue;xie",
	"8D1A": "long",
	"4E17": "shi",
	"608E": "hao",
	"7568": "pan",
	"8520": "zhong",
	"8D9C": "ju",
	"9724": "liu",
	"69AD": "xie",
	"6D45": "qian;jian",
	"6EAB": "wen",
	"8A19": "xun",
	"91DA": "qiu",
	"5294": "jian",
	"639C": "yi",
	"7B3D": "none",
	"82DF": "gou",
	"85DF": "lei",
	"8781": "tun",
	"94E8": "quan",
	"626C": "yang",
	"672C": "ben",
	"7205": "mo",
	"7BEA": "chi",
	"8491": "yin",
	"5F17": "fu",
	"7774": "gun",
	"7837": "shen",
	"7C4D": "ji",
	"84EE": "lian",
	"4FF0": "he",
	"5C43": "xi",
	"64B1": "tuo",
	"8881": "yuan",
	"8E3F": "zu",
	"9494": "men",
	"9EA1": "qi",
	"6AE4": "none",
	"7AC8": "zao",
	"9E7E": "cuo",
	"6569": "xiao",
	"6E4F": "xu",
	"7B61": "tu",
	"901B": "guang",
	"54FF": "ge",
	"898A": "ji",
	"5C9E": "zuo",
	"9DA9": "mu;wu",
	"52C5": "chi",
	"5549": "lin",
	"5EBF": "miao",
	"697A": "rou",
	"5214": "jue",
	"5EB1": "cheng",
	"7787": "mi",
	"93DD": "man",
	"9CAE": "ling",
	"744C": "ruan",
	"7623": "lei",
	"803D": "dan",
	"8352": "huang",
	"8CD6": "she",
	"5405": "xuan",
	"559E": "ji",
	"88D0": "juan",
	"99C3": "kuai",
	"578B": "xing",
	"7E4E": "ran",
	"4E0E": "yu",
	"4FB6": "lu",
	"57EE": "tan",
	"5FD3": "gan",
	"6381": "cheng",
	"70BD": "chi",
	"7E1C": "yun",
	"8226": "tai",
	"5430": "hu",
	"552A": "feng",
	"976D": "ren",
	"4EC1": "ren",
	"5180": "ji",
	"569E": "zhe",
	"5A88": "none",
	"67A9": "song",
	"7ABC": "ju",
	"7F72": "shu",
	"8DA7": "ti",
	"5219": "ze",
	"6A17": "chu;shu",
	"8F92": "wen",
	"549C": "zha",
	"5B3E": "lan",
	"61C4": "qin",
	"62FB": "hui",
	"6B90": "su",
	"6DC5": "xi",
	"6E43": "pai",
	"805D": "guo",
	"9A2D": "zhi",
	"5108": "kuai",
	"5A38": "qi",
	"6789": "wang",
	"715D": "mei",
	"7264": "mang",
	"7AEB": "jing",
	"962C": "keng",
	"5F7A": "wang",
	"656E": "xia",
	"7544": "liu",
	"77DC": "jin;qin;guan",
	"7D83": "xiao",
	"7DE0": "di",
	"92EF": "gao",
	"9345": "none",
	"9A8E": "qin",
	"51EB": "fu",
	"5389": "li",
	"6F27": "qian",
	"79EC": "ju",
	"8A0A": "xun",
	"5FB1": "piao",
	"6060": "guai",
	"64E7": "ju",
	"661C": "yang",
	"791D": "ruan",
	"82A4": "kou",
	"9C71": "li",
	"5746": "fen",
	"8CE1": "geng",
	"99A9": "fen",
	"5B79": "bo",
	"7652": "yu",
	"7F8A": "yang",
	"85CD": "lan",
	"861E": "lian",
	"9233": "ke",
	"9809": "yi",
	"6295": "tou",
	"6E20": "qu",
	"88B1": "fu",
	"5680": "ning",
	"5863": "cheng",
	"5FC1": "bao",
	"6265": "tuo",
	"6460": "zong",
	"7398": "qi",
	"81C8": "la;xi",
	"9F87": "zi",
	"6C0C": "lu",
	"75A8": "xia",
	"8556": "qu",
	"902D": "huan",
	"9CC8": "quan",
	"686E": "bei",
	"87BD": "zhong",
	"9B81": "ba",
	"5DFA": "xun",
	"604C": "tiao",
	"6E62": "bi",
	"79F5": "yin",
	"9363": "zhao",
	"6F19": "tuan",
	"959C": "ke",
	"64B5": "nian",
	"6744": "qian",
	"6A24": "tiao",
	"7098": "xin",
	"7548": "fan",
	"9725": "meng",
	"9D33": "yan",
	"5D73": "cuo",
	"5FA4": "jian",
	"63D0": "ti;di;shi",
	"671A": "huang",
	"6A0D": "ji",
	"7419": "yu",
	"814B": "ye;yi",
	"8B9F": "du",
	"5A1E": "sui",
	"6717": "lang",
	"697F": "gui",
	"99D4": "zang",
	"50BD": "zhang",
	"52E6": "jiao;chao",
	"6175": "yong",
	"6DAC": "xing",
	"7065": "quan",
	"71F3": "zhao",
	"89A2": "shan",
	"5969": "lian",
	"5B87": "yu",
	"7FA2": "rong",
	"857A": "ji",
	"87C6": "ma",
	"87CF": "xiao",
	"9754": "qi",
	"5960": "dian",
	"5AC9": "ji",
	"5E72": "gan",
	"627D": "dun",
	"68D0": "fei",
	"6FF6": "kuo",
	"8F32": "chuan",
	"90CF": "jia",
	"9D5F": "kuang",
	"9E1C": "qu",
	"56DE": "hui",
	"7705": "pan",
	"776F": "hun",
	"789B": "qi",
	"7911": "dang",
	"795D": "zhu",
	"5F8D": "wang",
	"7FD8": "qiao",
	"8ECA": "che;ju",
	"94E2": "zhu",
	"99A7": "wen",
	"4F80": "xing",
	"54E6": "e;o;wo",
	"5FA3": "jie",
	"6D9A": "shui",
	"9005": "hou",
	"90DD": "hao",
	"947C": "luo",
	"4E04": "shang",
	"5A3E": "ai",
	"73BE": "jia",
	"9CD6": "bie",
	"67E6": "dan",
	"7163": "rou",
	"71F0": "wei",
	"74B7": "fu",
	"7BC3": "mei",
	"8096": "xiao",
	"8499": "meng",
	"8DE4": "jiao",
	"55A9": "yu",
	"7424": "cheng",
	"7587": "chou",
	"7F59": "mi",
	"6F7D": "pu",
	"74BE": "ji",
	"7D89": "xiu",
	"8A87": "kua",
	"8AA2": "xian",
	"5A5A": "hun",
	"63EB": "jiu",
	"8608": "tui",
	"87E2": "xi",
	"4E6F": "none",
	"6F15": "cao",
	"7009": "xie",
	"7BB7": "shi;yi",
	"8995": "mie",
	"8D52": "zhou",
	"8D8B": "qu",
	"9744": "ai",
	"9A80": "tai;dai",
	"9DD3": "zhe",
	"4E12": "chou",
	"691B": "none",
	"75FC": "gu",
	"91F9": "nu",
	"58CC": "rang",
	"5B8A": "tu",
	"666F": "jing;ying",
	"6953": "feng",
	"7069": "yan",
	"7621": "chuang",
	"7680": "bi",
	"9123": "zhang",
	"6944": "bian",
	"6FA8": "shi",
	"775B": "jing",
	"877F": "ying",
	"5045": "zhong",
	"6103": "xuan",
	"6FD9": "ying",
	"83AF": "mu",
	"8AAD": "du;dou",
	"9B27": "nao",
	"6098": "yi",
	"6A62": "tuo",
	"70E4": "kao",
	"7812": "pi",
	"7B4E": "ru",
	"830E": "jing",
	"90F1": "ping",
	"94FD": "te",
	"5A4D": "qi",
	"5B48": "shuai",
	"69F7": "yi",
	"6D54": "xun",
	"7208": "di",
	"5B42": "jiao",
	"7EA0": "jiu",
	"8056": "sheng",
	"4E77": "sha",
	"646D": "zhi",
	"6993": "mi",
	"73C4": "sheng",
	"7AEC": "qu",
	"7AED": "jie",
	"9640": "tuo",
	"98AE": "biao",
	"53D7": "shou",
	"5E38": "chang",
	"5F47": "xiao",
	"602B": "fu;fei",
	"6102": "bei",
	"6302": "gua",
	"71FA": "kao",
	"885E": "wei",
	"9409": "chuan",
	"97A1": "la",
	"5252": "cuo",
	"5983": "fei",
	"5BBF": "su;xiu",
	"9D1E": "xiao",
	"9EDB": "dai",
	"62F2": "gong",
	"6698": "yang",
	"688F": "gu",
	"731C": "cai",
	"8D64": "chi",
	"9615": "que",
	"96E7": "ji",
	"9DBF": "zi",
	"9E40": "wu",
	"55A0": "zhong",
	"79DF": "zu",
	"83A6": "shao",
	"8436": "chun",
	"89FF": "xi",
	"9085": "zhan",
	"910E": "xi",
	"99D3": "pi",
	"9AA0": "piao;biao",
	"5C6D": "xi",
	"79EE": "tai",
	"7C96": "mo",
	"911A": "mao",
	"5868": "gong",
	"6447": "yao",
	"6B05": "ju",
	"758E": "shu",
	"7A2F": "zong",
	"86D7": "fu",
	"91DE": "zhi",
	"9CEA": "bu",
	"7572": "she",
	"7D1D": "ren",
	"8101": "tiao",
	"82D4": "tai",
	"899B": "mo",
	"95B2": "yue",
	"9C1A": "none",
	"554D": "tun",
	"5827": "ruan",
	"5C55": "zhan",
	"6064": "xu",
	"6118": "qia",
	"8267": "huo",
	"89E9": "qiu",
	"5A46": "po",
	"626F": "che",
	"8E9D": "lan",
	"6AD2": "sa",
	"7E54": "zhi",
	"98D7": "liu",
	"4FE5": "che",
	"6801": "liu",
	"6E8D": "jin",
	"6EA0": "zha",
	"9B3F": "qi",
	"6F5E": "lu",
	"74CA": "qiong",
	"7B7C": "yun",
	"88EC": "ling",
	"8BEA": "zhou",
	"936F": "huo",
	"553D": "xi",
	"6722": "wang",
	"6791": "hu",
	"68CC": "cai",
	"72E9": "shou",
	"8921": "da",
	"53AE": "si",
	"6B75": "cuo",
	"9320": "ding",
	"5724": "yan",
	"58DF": "long",
	"5D87": "qu",
	"86B1": "zha",
	"8C2F": "qiao",
	"8317": "ming",
	"718A": "xiong",
	"8174": "yu",
	"8534": "ma",
	"8653": "xiao",
	"86D2": "ge",
	"4EA7": "chan",
	"522D": "jing",
	"7688": "gui",
	"7DB2": "wang",
	"88B7": "jia;qia",
}
