/*
 * Atom-4 triboard
 * Header file
 *
 * $Id: board4.h,v 1.4 2003/04/08 09:56:28 hsteoh Exp hsteoh $
 */

#ifndef BOARD4_H
#define BOARD4_H

#include <stdlib.h>			// for NULL
#include <list.h>			// MUST be prog/lib version!
#include "color4.h"
#include "triboard.h"


// Representation for a unit of change on the board
struct boardchange {
  int x,y;
  color4 cell;

  boardchange(int xcoor, int ycoor, color4 c) : x(xcoor), y(ycoor), cell(c) {}
};

class board4 : public triboard {
public:
  board4(unsigned int width, unsigned int height) : triboard(width,height) {}
  board4(board4 &b) : triboard(b) {}
  board4 &operator= (board4 &b);
  ~board4();

  // Check if it's legal to place a tile here
  int check_legal(int x, int y);

  // Compute color changes caused by actor at (x,y). Note that the actor
  // itself is included in the delta as the first board change.
  void compute_splash(int x, int y, color4 actor, elist<boardchange> &delta);

  // Apply changes specified by &delta. Also computes reverse delta that can
  // be applied to reverse changes, unless *undo == NULL.
  void applychanges(elist<boardchange> &delta, elist<boardchange> *undo);

  // Counts the number of consecutive matching marbles in the given direction
  // from (x,y).
  int count_marbles(color4 marble, int x, int y, int dir, int max);

  // Check if there's a row of N same colored marbles in any direction from
  // (x,y).
  int check_row(color4 marble, int x, int y, int length);

  // Check the locations indicated in &lastchanges to see if there's a winning
  // row in any of them.
  int check_win(elist<boardchange> &lastchanges, color4 piece, int rowlen);
};


#endif // BOARD4_H
