/*
 * Generic text formatting utilities
 * Header file
 * ---------------------------------------------------------------------------
 * $Id: txtutil.h,v 1.1 2002/03/23 19:53:39 hsteoh Exp hsteoh $
 */

#ifndef	TXTUTIL_H
#define	TXTUTIL_H

#include <list.h>			// MUST be prog/lib/ version!


/* CLASSES */

// class text: represents a list of lines. This class is intended to represent
// formatted text; it has the default (and currently, the only) strategy of
// word-wrapping, left-justification.
// Programmer's notes:
// - eventually, ctor should provide parms to select which formatting strategy
//   should be used.
class text {
  int width;				// max width
  olist<char> lines;			// the actual lines

  char *line;				// current line
  int x;				// current xcoor (for typesetting)
  int need_space;			// need interword space for next word?
					// (MUST be either 0 or 1)

  char *make_line();			// create new line
  void dumb_wrap(char *word, int len);	// dumb character-wrapping for words
					// that don't even fit on a line.
public:
  text(int max_wd, int startx=0) : width(max_wd), line(0), x(startx) {}
  ~text() {}

  void add_word(char *start, int len);	// appends a word into the buffer.
					// Words that don't fit on the current
					// line are wrapped.
  void add_string(char *string);	// parses the string into words and
					// inserts words into buffer.
  void add_lines(char *string);		// same as add_string() but respects
					// linebreaks.
  void linebreak();			// force a linebreak on current line

  int maxwidth() { return width; }
  int numlines() { return lines.num_elem(); }
  olistiter<char> first_line() { return lines.headp(); }
};


/* FUNCTION PROTOTYPES */

char *eat_spaces(char *s);		// standard whitespace skipping func


#endif // TXTUTIL_H
