(ns digest-test
  (:use [digest] :reload-all)
  (:use [clojure.string :only (lower-case)])
  (:use [clojure.test])
  (:import java.io.File))

(deftest md5-test
  (is (= (digest "md5" "foo") "acbd18db4cc2f85cedef654fccc4a4d8")))

(deftest sha-256-test
  (is (= (sha-256 "foo") 
         "2c26b46b68ffc68ff99b453c1d30413413422d706483bfa0f98a5e886266e7ae")))

(deftest algorithms-test
  (let [names (algorithms)]
    (is not (empty? names))
    (is (names "SHA-1"))))

(deftest utils-test
  (for [name (algorithms)]
    (dorun (is (ns-resolve *ns* (symbol (lower-case name)))))))

(def ^:dynamic *logo-md5* "59ef6e166bab377a48a348be2ac46c15")
(def ^:dynamic *logo-sha256* 
  "ff83aa6a4f8597ef45742e4c4837f1964fa14bd64a950388bce0bfe987acbd32")

(deftest file-test
  (let [f (File. "test/clojure.png")]
    (is (= (md5 f) *logo-md5*))
    (is (= (sha-256 f) *logo-sha256*))))

; Just making sure that we don't explode on nil
(deftest nil-test
  (md5 nil))

(deftest length-test
  (is (= (sha (File. "test/length.txt")) 
        "007b65165b253172d054189e8e3175f3bcb9e28e")))
