*-----------------------------------------------------------------------
*     TMSTLC : THE ROUTINE FOR DRAWING STREAM LINES
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2017 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMSTLC( X, Y, U, V, NX, NY )

      IMPLICIT NONE
      INTEGER NXZ
      PARAMETER (NXZ=10)
      INTEGER NYZ
      PARAMETER (NYZ=10)


*-- AGREENMENT
      INTEGER  NX        !* GRID NUMBERS FOR X-DIRECTION
      INTEGER  NY        !* GRID NUMBERS FOR Y-DIRECTION
      REAL     U(NX,NY)  !* VECTOR COMPONENT OF X-DIRECTION
      REAL     V(NX,NY)  !* VECTOR COMPONENT OF Y-DIRECTION
      REAL     X(NX)     !* GRID POINTS OF X-DIRECTION [UNIT:LENGTH]
      REAL     Y(NY)     !* GRID POINTS OF Y-DIRECTION [UNIT:LENGTH]

*-- INTERNAL VARIABLES
      REAL     TRX(2,NXZ*NYZ,NXZ*NYZ)  !* STREAM LINE OF X-COORDINATE
      REAL     TRY(2,NXZ*NYZ,NXZ*NYZ)  !* STREAM LINE OF Y-COORDINATE
      INTEGER  NM(2,NXZ*NYZ,NXZ*NYZ)         !* ARRAY NUMBER IN EACH STREAM LINE

      CALL TMZTLC( X, Y, U, V, NX, NY,TRX,TRY,NM )

      END SUBROUTINE TMSTLC

