# 計算器|deepin-calculator|

## 概述

計算器是一款功能強大的桌面計算器，支援標準模式、科學模式和程式設計師模式。完美支援鍵盤輸入，在鍵盤輸入時還支援符號容錯及計算結果同步。

## 功能介紹
在計算器介面，單擊 ![icon_menu](../common/icon_menu.svg) > **模式**，您可以：
   - 選擇 **標準**，切換到標準模式介面，執行基本的加減乘除運算。
   - 選擇 **科學**，切換到科學模式介面，執行函數、指數、方根等進階運算。
   - 選擇 **程式設計師**，切換到程式設計師模式介面，執行二進位制、八進位制、十進位制、十六進位制等複雜運算。

### 標準模式

![0|standard](fig/standard_mode.png)



| 圖示                       | 名稱     | 說明                                                         |
| -------------------------- | :------- | ------------------------------------------------------------ |
| 0~9                        | 數字鍵   | 基本阿拉伯數字。                                             |
| MC                | 清除鍵 | 清除所有記憶體。                                           |
|  MR                 | 儲存鍵  | 重新呼叫記憶體。 |
| M+                 | 儲存鍵 | 記憶體增加；將目前數值累加到儲存器中，中斷數字輸入。    |
|  M-                 | 儲存鍵 | 記憶體減少；從儲存器內容中減去目前顯示值，中斷數字輸入。           |
|  MS                  | 儲存鍵  | 記憶體儲存；將輸入框中的數值添加到記憶體列表中。                       |
|  ![icon](../common/M.png)           | 儲存鍵  | 單擊![icon](../common/M.png)展開記憶體列表，再次單擊摺疊記憶體列表；關閉應用後記憶體清零。 |
| C/AC                          | 清除     | 單擊一次清除目前的表達式內容，連續按兩次清空所有歷史表達式。 |
| %                          | 百分號   | 用來輸入百分號。                                             |
| ![delete](../common/delete.svg) | 刪除     | 單擊一次向前刪除1個字元。                                   |
| +-×÷                       | 加減乘除 | 基本數學運算符，用來進行加法、減法、乘法、除法運算。         |
| .                          | 小數點   | 用來輸入小數點。                                             |
| ()                         | 括號     | 用來輸入括號，單擊同時顯示左右括號。如果從鍵盤輸入，輸入左括號則出現左括號，輸入右括號則出現右括號，若只出現一側括號，則表達式計算錯誤。 |
| =                          | 等於     | 用來得出計算結果。                                           |



### 科學模式 

![0|standard](fig/scientific_mode.png)



| 圖示                       | 名稱     | 說明                                                         |
| ------------------------------------------------------------ | :--------- | ------------------------------------------------------------ |
| F-E                                                          | 科學計數 | 單擊 **F-E** 開啟科學計數，再次單擊關閉科學計數。 |
| ![icon](fig/MH.png)                                          | 儲存鍵     | 展示記憶體列表及歷史記錄。                        |
| ![icon](fig/deg.png)/![icon](fig/grad.png)/![icon](fig/rad.png) | 度量轉換 | 分別計算角度、梯度、弧度。                      |
| sin、cos、tan、cot                                           | 三角函數 | 分別計算數值的正弦、餘弦、正切、餘切。    |
| sin<sup>-1</sup>、cos<sup>-1</sup>、tan<sup>-1</sup>、cot<sup>-1</sup> | 反三角函數 | 單擊 **2<sup>nd</sup>** 切換到第二功能介面，分別計算sin、cos、tan、cot的反三角函數。 |
| &#124;x&#124;、Rand                                          | F函數      | 分別計算數值的絕對值和隨機顯示一個31位的小數。 |
| 2<sup>nd</sup>                                               | 第二功能鍵 | 單擊 **2<sup>nd</sup>** 切換到第二功能介面，再次單擊切換到三角函數與次方運算介面。 |
| x<sup>2</sup>、x<sup>3</sup> 、x<sup>y</sup>                 | 冪函數  | 分別計算數值的平方、立方、y次方。           |
| 10<sup>x</sup>、2<sup>x</sup>、e<sup>x</sup>                 | 指數函數 | 分別計算10的x次方、2的x次方和e的x次方。其中2<sup>x</sup>和e<sup>x</sup>為第二功能介面按鈕。 |
| ![icon](fig/square_root.png)、![icon](fig/cube_root.png)、![icon](fig/y_root.png) | 冪函數  | 單擊 **2<sup>nd</sup>** 切換到第二功能介面，分別計算數值的平方根、立方根、x的y次方根。 |
| log、In、log<sub>y</sub><sup>x</sup>                         | 對數函數 | 分別以10為底的對數值、以e為底的對數值、以y為底x的對數。其中log<sub>y</sub><sup>x</sup> 為第二功能介面按鈕。 |
| π                                                            | 圓周率  | 約等於3.14159......，可精確到小數點後31位。 |
| e                                                            | 自然常數 | 約等於2.71828......，可精確到小數點後31位。 |
| Mod                                                          | 求余函數 | 顯示x/y的模數或餘數。                            |
| 1/x                                                          | 反比例函數 | 計算顯示數值的倒數。                               |
| x!                                                           | 階乘     | 計算顯示數字的階乘。                               |
| exp                                                          | 指數     | 允許輸入用科學計數法表示的數字。             |



### 程式設計師模式

![0|scientific](fig/programmer.png)



| 圖示                       | 名稱     | 說明                                                         |
| ------------------------------------------------------------ | :--------- | ------------------------------------------------------------ |
| HEX、DEC、OCT、BIN                                           | 進位制      | 分別為十六進位制、十進位制、八進位制、二進位制；其中十進位制為預設進位制。 |
| ![icon](../common/back.svg)                                  | 全鍵盤  | 單擊返回至全鍵盤介面。                            |
| ![icon](../common/bit.svg)                                   | 位切換鍵盤 | 展示0～63位bit位，支援單擊每一位bit位。 |
| QWORD/DWORD/WORD/BYTE                                        | 資料類型 | 單擊按鈕選擇模式；分別為四字（64位）、雙字（32位）、字（16位）、位元組（8位）。 |
| ![icon](../common/arithmetic.svg)/![icon](../common/logical.svg)/![icon](../common/circular.svg)/![icon](../common/rotate.svg) | 移位切換 | 分別為算術移位、邏輯移位、循環移位、帶進位循環移位。 |
| AND、OR、NOT、NAND、NOR、XOR                                 | 邏輯運算符 | 分別為與、或、非、與非、或非、異或。       |
| A~F                                                          | 字母     | 僅在16進位制下被啟動。                            |
| <<、>>                                                       | 移位操作符 | 分別為左移位、右移位。                            |



### 數學符號容錯

計算器支援鍵盤操作，除了一般的數字和運算符支援之外，還支援數學符號容錯功能，讓您在鍵盤輸入表達式時，鍵盤的中英文狀態和大小寫狀態，都不會影響輸入表達式。

另外還支援一些特殊的符號容錯：

- 乘法符號容錯處理：使用者輸入 *（星號）和x （字母x）都會觸發乘法符號啟動；
- 除法符號容錯處理：輸入 / 字元觸發除法符號啟動；
- 加法符號容錯處理：輸入 +（加號）會觸發加法符號啟動； 
- 減法符號容錯處理：輸入 - （減號）和_ （下劃線）都會觸發減法符號啟動；
- 百分號符號容錯處理：輸入 % 字元觸發餘數百分號啟動；
- 小數點符號容錯處理：輸入 . （英文小數點）和。（中文句號）都會觸發小數點符號啟動； 
- 括號符號容錯處理：輸入 左圓括號、右圓括號都會觸發括號符號啟動；
- 等於號 符號容錯處理：輸入 =（等於號）、按下 **Enter** 鍵都會觸發等於號符號啟動；
- 清除符號容錯處理：按下 **Esc** 鍵觸發清除符號啟動；
- 刪除符號容錯處理：按下 **Backspace** 鍵觸發刪除符號啟動；
- 字母符號容錯處理：無論鍵盤上處於大寫或小寫狀態，按下 **A～F** 鍵都會觸發字母啟動。

### 表達式


+ 在目前輸入表達式區域單擊 =（等號）、或按下鍵盤上的 **Enter** 鍵執行計算，目前輸入框中顯示計算結果數字，表達式進入歷史表達式區域。 
+ 重新編輯：單擊單條歷史表達式，可重新編輯表達式，表達式顯示在輸入表達式區域 ，重新編輯後按下鍵盤上的 **Enter** 鍵或 **=** （等號），可修改歷史表達式及同步表達式的數字結果。
+ 表達式錯誤：如輸入的表達式錯誤，無法計算，則顯示表達式錯誤。



### 科學計數法

在標準模式和科學模式下，計算結果分別大於16位和32位時用科學計數法顯示，即計算結果取前16位/32位乘以10的正負n次方。

   + 當計算結果為整數且大於16位/32位時，顯示數字+小數點後15位/31位+E+數字。
   + 當計算結果為小數且大於16位/32位時，顯示數字+小數點後15位/31位+E-數字。

![0|scientific-notation](fig/scientific_notation.png)



### 數字同步

- 當一個計算表達式顯示數字結果後，可以繼續輸入操作符號，此時，新表達式的第一個數就是上一個表達式的計算結果。

  例如，目前表達式是 10 + 20 = 30， 顯示計算結果 30 後，鍵入 + 號，再輸入數字9，會建立一個新的表達式為 30 + 9，按 **Enter** 鍵，得出新表達式的計算結果為39。

- 兩個表達式產生同步後，修改上一個表達式的數字和操作符，如果其計算結果改變，則會影響與其同步的新表達式的結果。

  例如，兩個表達式 10 + 20 = 30 和 30 + 9 = 39 產生同步，如果將第一個表達式的操作符 + 號修改為 x 號，算式為 10 x 20 = 200 ， 則第二個表達式自動轉變為 200 + 9 = 209；根據此規則，最多可支援9條表達式同步。

- 重新編輯含有同步數字的表達式時，修改同步數字或同步數字的表達式錯誤時，同步解除，同時會取消數字突顯顯示。

> ![icon](../common/notes.svg)說明：僅在標準模式下支援數字同步。

## 主選單

在主選單中，您可以切換視窗主題、查看說明手冊，了解計算器的更多訊息。

### 主題

視窗主題包含亮色主題、暗色主題和系統主題。

1. 在計算器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **主題**，選擇一個主題顏色。

### 說明

查看說明手冊，進一步了解和使用計算器。

1. 在計算器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **說明**。
3. 查看計算器的說明手冊。


### 關於

1. 在計算器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **關於**。
3. 查看計算器的版本和介紹。


### 退出

1. 在計算器介面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 單擊 **退出**。

