
# Deepin 修复工具开发文档

# 架构设计

`deepin-repair-tools` 主要分为两部分，主界面部分与插件部分。

插件部分是修复工具的重点。实质上，修复工具就是靠主界面加载众多修复插件进行工作的，不同的插件提供了不同种类的修复功能，在需要支持更多修复功能时，只需要编写对应的插件即可扩充修复工具的功能。

修复工具主要分为两个界面，即磁盘检查界面（由内置的 fsck 插件提供）与插件功能界面（加载外部插件）。

## 基本流程

修复工具的基本工作流程为

- 初始化 DiskUtil
- 检查磁盘是否需要修复
- 加载插件

- 读取所有分区的信息，收集各个分区的信息，调整挂载状态以方便进行各种修复工具工作。
- 加载修复插件，根据用户选择执行各种操作。

### 初始化 DiskUtil

由 `DiskUtils` 类开始对磁盘进行检测，目前检测的几个重点为：

- 收集分区内 OS 信息，为 grub 修复或 dpkg 修复等工具提供 OS 安装信息。
- 对于未挂载的分区，将其挂载到一个临时目录，以便工具对分区内容进行操作。
- 对于以 ro 参数挂载的分区，将尝试以 rw 参数进行重新挂载，避免工具无权限进行操作。
- 读取 `/proc/mounts` 文件并解析出所有块设备的挂载信息
- 最终得到这样的一个数据结构：[ (diskPath, mountPath, format, osName, userInfo), (...) ]

对 OS 的检测由 `os-prober` 命令完成，检测的结果保存在 `OSProberInfo` 中，它包含以下数据：

- osName： 分区内 OS 的名称
- mountPoint: 分区内 OS 的根分区挂载点

### 检查磁盘是否需要修复

检查磁盘的各个分区，如果磁盘需要修复，则转到内置磁盘修复插件。

### 加载插件

插件的加载不是在程序启动后立即开始的，而是经过前面提到的两步之后，在 ToolPage::setModel 中开始。
插件加载完毕后初始化左侧的导航栏，并加载第一个工具界面


## 提权设计

安装在 `/usr/sbin` 下的 `deepin-repair-tools-pkexec` 将利用 `pkexec` 进行提权并启动真正的修复工具。如果以普通用户直接运行修复工具，将会检查权限不足而自动退出。

## 插件设计

插件接口可以参考[插件接口设计](technology-overview.md#插件接口设计)。

### 插件一般的工作流程

插件一般的工作流程为：

1. 运行检查脚本，获取执行结果
2. 分析结果，判断是否存在问题，是否可修复
3. 运行修复脚本，修复对应问题，获取执行结果
4. 分析结果，提示修复结果

由于各个修复工作一般都是需要在某个目录下执行某个修复脚本，插件可通过标准接口或者插件自己实现的某些逻辑获取到当前机器上的信息，当用户执行对应操作时，通过调用插件接口中的 `execAsChroot*` 接口来执行对应脚本，获取执行结果。

以下是主框架对插件提供的一些自动功能：

#### chroot 环境的创建与恢复

当插件通过 `execAsChroot*` 接口在对应 OS 的环境中执行命令时，会自动重新以 `--bind` 方式挂载当前主机的以下几个目录到 chroot 环境中，以维持在 chroot 环境中需要的一些信息：

- `/proc`
- `/dev`
- `/run`
- `/sys`

### 插件的一般结构

插件一般分为以下几个模块：

- 主控制模块：通过插件接口与主程序通信，提供一些数据或是获取系统信息，通过接口执行自己的脚本并获取结果等。
- 修复前端模块：每个插件的主要修复逻辑，显示当前插件的工作状态，执行进度与结果等。
- 修复后端模块：每个插件的工作线程，通过与前端发送数据来进行进度反馈。

### 内置 fsck 插件

进行大多数修复的前提是磁盘是可用状态，所以检查磁盘是否可用是非常有必要的。这个功能被做到了启动过程中进行强制检查，其基本流程与标准插件没有太大区别。

# 接口设计

## 插件接口设计

插件获取信息主要通过以下两个文件所定义的接口：

- repairtoolsinterface.h
- repairtoolsproxy.h

接口文件中定义了以下数据结构：

### DiskInfo

每个磁盘分区的信息，它包含以下数据：

- diskPath： 当前磁盘分区的设备地址，如 `/dev/sda1`
- mountPoint： 当前磁盘分区的挂载地址
- format： 当前磁盘分区的分区格式
- osName： 如果当前磁盘分区中有 OS，则是 OS 名称，否则为空
- userList： 如果当前磁盘分区中有 OS，则为 OS 中的用户列表，否则为空

### UserInfo

每个磁盘分区中用户的信息：

- name： 用户名称
- homeDir： 用户的家目录地址

### RunResult

当通过插件接口执行某些修复操作时，返回的执行结果信息:

- exitCode： 脚本的返回值
- standardOutput： 脚本的标准输出
- standardError： 脚本的标准错误输出

# 裁剪与定制

目前的定制需求只有在某些平台上，由于平台特性，无法进行 grub 修复，可以通过添加编译选项 `NO_GRUB_REPAIR_PLUGIN` 来禁止 grub 插件。
