/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <stdio.h>

#ifndef __GLUE_GUI_GTK_PLUS_MINUS_BUTTON_H_INCLUDED
#define __GLUE_GUI_GTK_PLUS_MINUS_BUTTON_H_INCLUDED

typedef struct {
	GtkVBox parent;
	GtkWidget *title_label;
	GtkWidget *value_label; 
	GtkWidget *plus_button;
	GtkWidget *minus_button;
	int offset;
	int pixel_step;
	int number_items;
	char **items;
	int current_item;
} GuiGtkPlusMinusButton;

#define GUI_GTK_TYPE_PLUS_MINUS_BUTTON	(gui_gtk_plus_minus_button_get_type())
#define GUI_GTK_PLUS_MINUS_BUTTON(obj)	(G_TYPE_CHECK_INSTANCE_CAST((obj), GUI_GTK_TYPE_PLUS_MINUS_BUTTON, GuiGtkPlusMinusButton))

extern GType
gui_gtk_plus_minus_button_get_type(void);

extern GtkWidget *
gui_gtk_plus_minus_button_new(const char *desc, 
				int number_items, 
				const char **items);

extern void
gui_gtk_plus_minus_button_set_value(gpointer _plus_minus_button, char *value_string);

extern void
gui_gtk_plus_minus_button_destroy(gpointer plus_minus_button);
#endif /* __GLUE_GUI_GTK_PLUS_MINUS_BUTTON_H_INCLUDED */
