/*
 * Copyright (C) 2004-2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

extern uint8_t
ide_harddisk_read_chs(
	uint8_t device,
	uint8_t num, 
	uint16_t cylinder, 
	uint8_t head,
	uint8_t sector,
	uint16_t buffer_seg,
	uint16_t buffer_off
);
extern uint8_t
ide_harddisk_write_chs(
	uint8_t device,
	uint8_t num, 
	uint16_t cylinder, 
	uint8_t head,
	uint8_t sector,
	uint16_t buffer_seg,
	uint16_t buffer_off
);

extern uint8_t
ide_harddisk_read_lba(
	uint8_t controller,
	uint8_t unit,
	uint8_t num, 
	uint32_t /* long long */ start,
	uint16_t buffer_seg,
	uint16_t buffer_off
);
extern uint8_t
ide_harddisk_write_lba(
	uint8_t controller,
	uint8_t unit,
	uint8_t num, 
	uint32_t /* long long */ start,
	uint16_t buffer_seg,
	uint16_t buffer_off
);

#endif /* RUNTIME_RM */
/* ==================== REAL-MODE INIT ==================== */
#ifdef INIT_RM

extern uint8_t
recalibrate(uint8_t contr, uint8_t drive);

#endif /* INIT_RM */
