/* ChartLyrics.c generated by valac 0.12.0, the Vala compiler
 * generated from ChartLyrics.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
/**
     * Gmpc.Plugin.MetaDataIface
     */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <plugin.h>
#include <config1.h>
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <misc.h>
#include <metadata.h>
#include <gmpc_easy_download.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

typedef struct _GmpcProviderChartLyricsProp GmpcProviderChartLyricsProp;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _meta_data_free0(var) ((var == NULL) ? NULL : (var = (meta_data_free (var), NULL)))
#define __g_list_free__meta_data_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__meta_data_free0_ (var), NULL)))

struct _GmpcProviderChartLyricsProp {
	mpd_Song* song;
	GmpcProviderChartLyrics* this;
	GmpcPluginMetaDataCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GList* list;
};


static gpointer gmpc_provider_chart_lyrics_parent_class = NULL;
static GmpcPluginMetaDataIfaceIface* gmpc_provider_chart_lyrics_gmpc_plugin_meta_data_iface_parent_iface = NULL;

#define use_transition_ppclyr TRUE
#define some_unique_name_ppclyr VERSION
#define log_domain_ppclyr "Gmpc.Provider.ChartLyrics"
enum  {
	GMPC_PROVIDER_CHART_LYRICS_DUMMY_PROPERTY
};
#define GMPC_PROVIDER_CHART_LYRICS_query "http://api.chartlyrics.com/apiv1.asmx/SearchLyricDirect?artist=%s&song" \
"=%s"
static gint* gmpc_provider_chart_lyrics_real_get_version (GmpcPluginBase* base, int* result_length1);
static const gchar* gmpc_provider_chart_lyrics_real_get_name (GmpcPluginBase* base);
static void gmpc_provider_chart_lyrics_real_set_priority (GmpcPluginMetaDataIface* base, gint priority);
static gint gmpc_provider_chart_lyrics_real_get_priority (GmpcPluginMetaDataIface* base);
static void gmpc_provider_chart_lyrics_real_get_metadata (GmpcPluginMetaDataIface* base, const mpd_Song* song, MetaDataType type, GmpcPluginMetaDataCallback callback, void* callback_target);
static GmpcProviderChartLyricsProp* gmpc_provider_chart_lyrics_prop_new (void);
static GmpcProviderChartLyricsProp* gmpc_provider_chart_lyrics_prop_new (void);
static void gmpc_provider_chart_lyrics_prop_free (GmpcProviderChartLyricsProp* self);
static void gmpc_provider_chart_lyrics_handle_chart_download (GmpcProviderChartLyrics* self, const GEADAsyncHandler* handle, GEADStatus status, void* d);
static void _gmpc_provider_chart_lyrics_handle_chart_download_gmpc_async_download_callback_vala (const GEADAsyncHandler* handle, GEADStatus status, void* p, gpointer self);
static void gmpc_provider_chart_lyrics_parse_data (GmpcProviderChartLyrics* self, GmpcProviderChartLyricsProp* p, guchar* data, int data_length1);
static guchar* _vala_array_dup2 (guchar* self, int length);
static GObject * gmpc_provider_chart_lyrics_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gmpc_provider_chart_lyrics_prop_instance_init (GmpcProviderChartLyricsProp * self);
static void _meta_data_free0_ (gpointer var);
static void _g_list_free__meta_data_free0_ (GList* self);

static const gint GMPC_PROVIDER_CHART_LYRICS_version[3] = {0, 0, 2};

/** Return the plugin version. For an internal plugin this is not that interresting.
     * But we implement it anyway 
     */
static gint* gmpc_provider_chart_lyrics_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcProviderChartLyrics * self;
	gint* result = NULL;
	gint* _tmp0_;
	self = (GmpcProviderChartLyrics*) base;
	_tmp0_ = GMPC_PROVIDER_CHART_LYRICS_version;
	*result_length1 = G_N_ELEMENTS (GMPC_PROVIDER_CHART_LYRICS_version);
	result = _tmp0_;
	return result;
}


/**
     * The name of the plugin 
     */
static const gchar* gmpc_provider_chart_lyrics_real_get_name (GmpcPluginBase* base) {
	GmpcProviderChartLyrics * self;
	const gchar* result = NULL;
	self = (GmpcProviderChartLyrics*) base;
	result = "ChartLyrics Plugin";
	return result;
}


/**
     * Priority of the plugin, default 50
     */
static void gmpc_provider_chart_lyrics_real_set_priority (GmpcPluginMetaDataIface* base, gint priority) {
	GmpcProviderChartLyrics * self;
	const gchar* _tmp0_ = NULL;
	self = (GmpcProviderChartLyrics*) base;
	_tmp0_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	cfg_set_single_value_as_int (config, _tmp0_, "priority", priority);
}


static gint gmpc_provider_chart_lyrics_real_get_priority (GmpcPluginMetaDataIface* base) {
	GmpcProviderChartLyrics * self;
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	self = (GmpcProviderChartLyrics*) base;
	_tmp0_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	_tmp1_ = cfg_get_single_value_as_int_with_default (config, _tmp0_, "priority", 50);
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static void _gmpc_provider_chart_lyrics_handle_chart_download_gmpc_async_download_callback_vala (const GEADAsyncHandler* handle, GEADStatus status, void* p, gpointer self) {
	gmpc_provider_chart_lyrics_handle_chart_download (self, handle, status, p);
}


static void gmpc_provider_chart_lyrics_real_get_metadata (GmpcPluginMetaDataIface* base, const mpd_Song* song, MetaDataType type, GmpcPluginMetaDataCallback callback, void* callback_target) {
	GmpcProviderChartLyrics * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GmpcProviderChartLyricsProp* _tmp2_ = NULL;
	GmpcProviderChartLyricsProp* p;
	GmpcProviderChartLyrics* _tmp3_;
	mpd_Song* _tmp4_;
	GmpcPluginMetaDataCallback _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* path;
	self = (GmpcProviderChartLyrics*) base;
	g_return_if_fail (song != NULL);
	if (type != META_SONG_TXT) {
		callback (NULL, callback_target);
		return;
	}
	if (song == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = song->artist == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = song->title == NULL;
	}
	if (_tmp0_) {
		g_log (log_domain_ppclyr, G_LOG_LEVEL_DEBUG, "ChartLyrics.vala:99: Insufficient information. doing nothing");
		callback (NULL, callback_target);
		return;
	}
	_tmp2_ = gmpc_provider_chart_lyrics_prop_new ();
	p = _tmp2_;
	_tmp3_ = _g_object_ref0 (self);
	_g_object_unref0 (p->this);
	p->this = _tmp3_;
	_tmp4_ = _mpd_songDup0 (song);
	_mpd_freeSong0 (p->song);
	p->song = _tmp4_;
	_tmp5_ = callback;
	(p->callback_target_destroy_notify == NULL) ? NULL : (p->callback_target_destroy_notify (p->callback_target), NULL);
	p->callback = NULL;
	p->callback_target = NULL;
	p->callback_target_destroy_notify = NULL;
	p->callback = _tmp5_;
	p->callback_target = callback_target;
	p->callback_target_destroy_notify = NULL;
	_tmp6_ = gmpc_easy_download_uri_escape (song->artist);
	_tmp7_ = _tmp6_;
	_tmp8_ = gmpc_easy_download_uri_escape (song->title);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf (GMPC_PROVIDER_CHART_LYRICS_query, _tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	path = _tmp11_;
	g_log (log_domain_ppclyr, G_LOG_LEVEL_DEBUG, "ChartLyrics.vala:112: Query song txt: %s ", path);
	gmpc_easy_async_downloader_vala (path, p, _gmpc_provider_chart_lyrics_handle_chart_download_gmpc_async_download_callback_vala, self);
	_g_free0 (path);
}


/** 
     * Parse the result 
     */
static void gmpc_provider_chart_lyrics_parse_data (GmpcProviderChartLyrics* self, GmpcProviderChartLyricsProp* p, guchar* data, int data_length1) {
	xmlDoc* _tmp0_ = NULL;
	xmlDoc* doc;
	xmlNode* _tmp1_ = NULL;
	xmlNode* root;
	g_return_if_fail (self != NULL);
	_tmp0_ = xmlParseMemory ((const gchar*) data, data_length1);
	doc = _tmp0_;
	if (doc == NULL) {
		return;
	}
	_tmp1_ = xmlDocGetRootElement (doc);
	root = _tmp1_;
	if (root != NULL) {
		{
			xmlNode* child;
			child = root->children;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					if (!_tmp2_) {
						child = child->next;
					}
					_tmp2_ = FALSE;
					if (!(child != NULL)) {
						break;
					}
					if (g_strcmp0 (child->name, "LyricSong") == 0) {
						gchar* _tmp3_ = NULL;
						gchar* tsong;
						gchar* _tmp4_ = NULL;
						gchar* _tmp5_ = NULL;
						gchar* ot_song;
						gint _tmp6_;
						_tmp3_ = xmlNodeGetContent (child);
						tsong = _tmp3_;
						_tmp4_ = g_utf8_strdown (tsong, (gssize) (-1));
						_g_free0 (tsong);
						tsong = _tmp4_;
						_tmp5_ = g_utf8_strdown (p->song->title, (gssize) (-1));
						ot_song = _tmp5_;
						_tmp6_ = g_utf8_collate (ot_song, tsong);
						if (_tmp6_ != 0) {
							g_log (log_domain_ppclyr, G_LOG_LEVEL_DEBUG, "ChartLyrics.vala:141: Skipping: %s-%s ", tsong, ot_song);
							_g_free0 (ot_song);
							_g_free0 (tsong);
							return;
						}
						_g_free0 (ot_song);
						_g_free0 (tsong);
					}
					if (g_strcmp0 (child->name, "Lyric") == 0) {
						gchar* _tmp7_ = NULL;
						gchar* lyric;
						gint _tmp8_;
						_tmp7_ = xmlNodeGetContent (child);
						lyric = _tmp7_;
						_tmp8_ = strlen (lyric);
						if (_tmp8_ > 0) {
							MetaData* _tmp9_ = NULL;
							MetaData* pitem;
							const gchar* _tmp10_ = NULL;
							MetaData* _tmp11_;
							_tmp9_ = meta_data_new ();
							pitem = _tmp9_;
							pitem->type = META_SONG_TXT;
							_tmp10_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
							pitem->plugin_name = _tmp10_;
							pitem->content_type = META_DATA_CONTENT_TEXT;
							meta_data_set_text (pitem, lyric);
							_tmp11_ = pitem;
							pitem = NULL;
							p->list = g_list_append (p->list, _tmp11_);
							_meta_data_free0 (pitem);
						}
						_g_free0 (lyric);
					}
				}
			}
		}
	}
}


/**
     * This function handles the callback from Gmpc.AsyncDownload 
     */
static guchar* _vala_array_dup2 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


static void gmpc_provider_chart_lyrics_handle_chart_download (GmpcProviderChartLyrics* self, const GEADAsyncHandler* handle, GEADStatus status, void* d) {
	GmpcProviderChartLyricsProp* p;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	p = (GmpcProviderChartLyricsProp*) d;
	if (status == GEAD_DONE) {
		gint _tmp0_;
		guchar* _tmp1_ = NULL;
		guchar* _tmp2_;
		guchar* _tmp3_;
		guchar* data;
		gint data_length1;
		gint _data_size_;
		guint _tmp4_;
		GList* _tmp5_;
		_tmp1_ = gmpc_easy_handler_get_data_vala_wrap (handle, &_tmp0_);
		_tmp2_ = (_tmp3_ = _tmp1_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup2 (_tmp3_, _tmp0_));
		data = _tmp2_;
		data_length1 = _tmp0_;
		_data_size_ = _tmp0_;
		if (data != NULL) {
			gmpc_provider_chart_lyrics_parse_data (self, p, data, data_length1);
		}
		_tmp4_ = g_list_length (p->list);
		g_log (log_domain_ppclyr, G_LOG_LEVEL_DEBUG, "ChartLyrics.vala:182: Download done: results: %u ", _tmp4_);
		_tmp5_ = p->list;
		p->list = NULL;
		p->callback (_tmp5_, p->callback_target);
		gmpc_provider_chart_lyrics_prop_free (p);
		data = (g_free (data), NULL);
	} else {
		if (status == GEAD_PROGRESS) {
		} else {
			p->callback (NULL, p->callback_target);
			gmpc_provider_chart_lyrics_prop_free (p);
		}
	}
}


GmpcProviderChartLyrics* gmpc_provider_chart_lyrics_construct (GType object_type) {
	GmpcProviderChartLyrics * self = NULL;
	self = (GmpcProviderChartLyrics*) gmpc_plugin_base_construct (object_type);
	return self;
}


GmpcProviderChartLyrics* gmpc_provider_chart_lyrics_new (void) {
	return gmpc_provider_chart_lyrics_construct (GMPC_PROVIDER_TYPE_CHART_LYRICS);
}


static GObject * gmpc_provider_chart_lyrics_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcProviderChartLyrics * self;
	parent_class = G_OBJECT_CLASS (gmpc_provider_chart_lyrics_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_PROVIDER_CHART_LYRICS (obj);
	((GmpcPluginBase*) self)->plugin_type = 8 + 32;
	return obj;
}


static void _meta_data_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (meta_data_free (var), NULL));
}


static void _g_list_free__meta_data_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _meta_data_free0_, NULL);
	g_list_free (self);
}


static GmpcProviderChartLyricsProp* gmpc_provider_chart_lyrics_prop_new (void) {
	GmpcProviderChartLyricsProp* self;
	self = g_slice_new0 (GmpcProviderChartLyricsProp);
	gmpc_provider_chart_lyrics_prop_instance_init (self);
	return self;
}


static void gmpc_provider_chart_lyrics_prop_instance_init (GmpcProviderChartLyricsProp * self) {
	self->list = NULL;
}


static void gmpc_provider_chart_lyrics_prop_free (GmpcProviderChartLyricsProp* self) {
	_mpd_freeSong0 (self->song);
	_g_object_unref0 (self->this);
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
	self->callback = NULL;
	self->callback_target = NULL;
	self->callback_target_destroy_notify = NULL;
	__g_list_free__meta_data_free0_0 (self->list);
	g_slice_free (GmpcProviderChartLyricsProp, self);
}


static void gmpc_provider_chart_lyrics_class_init (GmpcProviderChartLyricsClass * klass) {
	gmpc_provider_chart_lyrics_parent_class = g_type_class_peek_parent (klass);
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_provider_chart_lyrics_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_provider_chart_lyrics_real_get_name;
	G_OBJECT_CLASS (klass)->constructor = gmpc_provider_chart_lyrics_constructor;
}


static void gmpc_provider_chart_lyrics_gmpc_plugin_meta_data_iface_interface_init (GmpcPluginMetaDataIfaceIface * iface) {
	gmpc_provider_chart_lyrics_gmpc_plugin_meta_data_iface_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_priority = (void (*)(GmpcPluginMetaDataIface* ,gint)) gmpc_provider_chart_lyrics_real_set_priority;
	iface->get_priority = (gint (*)(GmpcPluginMetaDataIface*)) gmpc_provider_chart_lyrics_real_get_priority;
	iface->get_metadata = (void (*)(GmpcPluginMetaDataIface* ,const mpd_Song* ,MetaDataType ,GmpcPluginMetaDataCallback ,void*)) gmpc_provider_chart_lyrics_real_get_metadata;
}


static void gmpc_provider_chart_lyrics_instance_init (GmpcProviderChartLyrics * self) {
}


/**
 * Plugin implements the Base class and the Metadata interface
 */
GType gmpc_provider_chart_lyrics_get_type (void) {
	static volatile gsize gmpc_provider_chart_lyrics_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_provider_chart_lyrics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcProviderChartLyricsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_provider_chart_lyrics_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcProviderChartLyrics), 0, (GInstanceInitFunc) gmpc_provider_chart_lyrics_instance_init, NULL };
		static const GInterfaceInfo gmpc_plugin_meta_data_iface_info = { (GInterfaceInitFunc) gmpc_provider_chart_lyrics_gmpc_plugin_meta_data_iface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gmpc_provider_chart_lyrics_type_id;
		gmpc_provider_chart_lyrics_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcProviderChartLyrics", &g_define_type_info, 0);
		g_type_add_interface_static (gmpc_provider_chart_lyrics_type_id, GMPC_PLUGIN_TYPE_META_DATA_IFACE, &gmpc_plugin_meta_data_iface_info);
		g_once_init_leave (&gmpc_provider_chart_lyrics_type_id__volatile, gmpc_provider_chart_lyrics_type_id);
	}
	return gmpc_provider_chart_lyrics_type_id__volatile;
}



