// Code generated by "./generator ./org.freedesktop.screensaver"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package screensaver

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type ScreenSaver interface {
	screenSaver // interface org.freedesktop.ScreenSaver
	proxy.Object
}

type objectScreenSaver struct {
	interfaceScreenSaver // interface org.freedesktop.ScreenSaver
	proxy.ImplObject
}

func NewScreenSaver(conn *dbus.Conn) ScreenSaver {
	obj := new(objectScreenSaver)
	obj.ImplObject.Init_(conn, "org.freedesktop.ScreenSaver", "/org/freedesktop/ScreenSaver")
	return obj
}

type screenSaver interface {
	GoInhibit(flags dbus.Flags, ch chan *dbus.Call, name string, reason string) *dbus.Call
	Inhibit(flags dbus.Flags, name string, reason string) (uint32, error)
	GoSetTimeout(flags dbus.Flags, ch chan *dbus.Call, seconds uint32, interval uint32, blank bool) *dbus.Call
	SetTimeout(flags dbus.Flags, seconds uint32, interval uint32, blank bool) error
	GoSimulateUserActivity(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	SimulateUserActivity(flags dbus.Flags) error
	GoUnInhibit(flags dbus.Flags, ch chan *dbus.Call, cookie uint32) *dbus.Call
	UnInhibit(flags dbus.Flags, cookie uint32) error
	ConnectIdleOn(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectCycleActive(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectIdleOff(cb func()) (dbusutil.SignalHandlerId, error)
}

type interfaceScreenSaver struct{}

func (v *interfaceScreenSaver) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceScreenSaver) GetInterfaceName_() string {
	return "org.freedesktop.ScreenSaver"
}

// method Inhibit

func (v *interfaceScreenSaver) GoInhibit(flags dbus.Flags, ch chan *dbus.Call, name string, reason string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Inhibit", flags, ch, name, reason)
}

func (*interfaceScreenSaver) StoreInhibit(call *dbus.Call) (cookie uint32, err error) {
	err = call.Store(&cookie)
	return
}

func (v *interfaceScreenSaver) Inhibit(flags dbus.Flags, name string, reason string) (uint32, error) {
	return v.StoreInhibit(
		<-v.GoInhibit(flags, make(chan *dbus.Call, 1), name, reason).Done)
}

// method SetTimeout

func (v *interfaceScreenSaver) GoSetTimeout(flags dbus.Flags, ch chan *dbus.Call, seconds uint32, interval uint32, blank bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetTimeout", flags, ch, seconds, interval, blank)
}

func (v *interfaceScreenSaver) SetTimeout(flags dbus.Flags, seconds uint32, interval uint32, blank bool) error {
	return (<-v.GoSetTimeout(flags, make(chan *dbus.Call, 1), seconds, interval, blank).Done).Err
}

// method SimulateUserActivity

func (v *interfaceScreenSaver) GoSimulateUserActivity(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SimulateUserActivity", flags, ch)
}

func (v *interfaceScreenSaver) SimulateUserActivity(flags dbus.Flags) error {
	return (<-v.GoSimulateUserActivity(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method UnInhibit

func (v *interfaceScreenSaver) GoUnInhibit(flags dbus.Flags, ch chan *dbus.Call, cookie uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnInhibit", flags, ch, cookie)
}

func (v *interfaceScreenSaver) UnInhibit(flags dbus.Flags, cookie uint32) error {
	return (<-v.GoUnInhibit(flags, make(chan *dbus.Call, 1), cookie).Done).Err
}

// signal IdleOn

func (v *interfaceScreenSaver) ConnectIdleOn(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "IdleOn", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".IdleOn",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal CycleActive

func (v *interfaceScreenSaver) ConnectCycleActive(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "CycleActive", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".CycleActive",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal IdleOff

func (v *interfaceScreenSaver) ConnectIdleOff(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "IdleOff", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".IdleOff",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}
