#pragma once

#include <QDBusContext>
#include <QObject>
#include <QScopedPointer>

class AdaptorPrivate;
class Adaptor : public QObject, protected QDBusContext {
    Q_OBJECT
    Q_DECLARE_PRIVATE(Adaptor)
    QScopedPointer<AdaptorPrivate> d_ptr;

public:
    Adaptor(QObject *parent = nullptr);
    ~Adaptor() override;
Q_SIGNALS:  // SIGNALS
    void EnrollStatus(const QString &id, int code, const QString &msg);
    void VerifyStatus(const QString &id, int code, const QString &msg);
    void capabilityChanged();
    void nameChanged();
    void stateChanged();
    void typeChanged();

public:  // PROPERTIES
    Q_PROPERTY(int Capability READ capability NOTIFY capabilityChanged)
    int capability() const;

    Q_PROPERTY(QString Name READ name NOTIFY nameChanged)
    QString name() const;

    Q_PROPERTY(int State READ state NOTIFY stateChanged)
    int state() const;

    Q_PROPERTY(int Type READ type NOTIFY typeChanged)
    int type() const;
public Q_SLOTS:  // METHODS
    void        Claim(const QString &id, bool claimed);
    void        DeleteAllFingers(const QString &id);
    void        DeleteFinger(const QString &id, const QString &finger);
    void        Enroll(const QString &id, const QString &finger);
    QStringList ListFingers(const QString &id);
    void        RenameFinger(const QString &id,
                             const QString &finger,
                             const QString &newName);
    void        StopEnroll();
    void        StopVerify();
    void        Verify(const QString &finger);
};
