import pytest
import os

tmpdir = os.getenv("AUTOPKGTEST_TMP")

if tmpdir is None:
    print("Need the environment variable AUTOPKGTEST_TMP.")
    exit(1)

cwd = os.getcwd()
test_path = cwd + "/cython/test"

os.chdir(tmpdir)

print("Running tests from %s with cwd %s." %(test_path, os.getcwd()))

exit(pytest.main([test_path]))
