
/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/// This file is generated by create-http-header-name-table, do not edit.

#ifndef HTTPHeaderNames_h
#define HTTPHeaderNames_h

#include <wtf/Forward.h>

namespace PurCFetcher {

enum class HTTPHeaderName {
    Accept,
    AcceptCharset,
    AcceptEncoding,
    AcceptLanguage,
    AcceptRanges,
    AccessControlAllowCredentials,
    AccessControlAllowHeaders,
    AccessControlAllowMethods,
    AccessControlAllowOrigin,
    AccessControlExposeHeaders,
    AccessControlMaxAge,
    AccessControlRequestHeaders,
    AccessControlRequestMethod,
    Age,
    Authorization,
    CacheControl,
    Connection,
    ContentDisposition,
    ContentEncoding,
    ContentLanguage,
    ContentLength,
    ContentLocation,
    ContentRange,
    ContentSecurityPolicy,
    ContentSecurityPolicyReportOnly,
    ContentType,
    Cookie,
    Cookie2,
    CrossOriginResourcePolicy,
    DNT,
    Date,
    DefaultStyle,
    ETag,
    Expect,
    Expires,
    Host,
    IcyMetaInt,
    IcyMetadata,
    IfMatch,
    IfModifiedSince,
    IfNoneMatch,
    IfRange,
    IfUnmodifiedSince,
    KeepAlive,
    LastEventID,
    LastModified,
    Link,
    Location,
    Origin,
    PingFrom,
    PingTo,
    Pragma,
    ProxyAuthorization,
    Purpose,
    Range,
    Referer,
    ReferrerPolicy,
    Refresh,
    SecWebSocketAccept,
    SecWebSocketExtensions,
    SecWebSocketKey,
    SecWebSocketProtocol,
    SecWebSocketVersion,
    ServerTiming,
    ServiceWorker,
    ServiceWorkerAllowed,
    SetCookie,
    SetCookie2,
    SourceMap,
    TE,
    TimingAllowOrigin,
    Trailer,
    TransferEncoding,
    Upgrade,
    UpgradeInsecureRequests,
    UserAgent,
    Vary,
    Via,
    XContentTypeOptions,
    XDNSPrefetchControl,
    XFrameOptions,
    XSourceMap,
    XTempTablet,
    XXSSProtection,
};

const unsigned numHTTPHeaderNames = 84;
const size_t minHTTPHeaderNameLength = 2;
const size_t maxHTTPHeaderNameLength = 35;

bool findHTTPHeaderName(StringView, HTTPHeaderName&);
PURC_EXPORT StringView httpHeaderNameString(HTTPHeaderName);

} // namespace PurCFetcher

namespace PurCWTF {

template<> struct EnumTraits<PurCFetcher::HTTPHeaderName> {
    using values = EnumValues<
        PurCFetcher::HTTPHeaderName,
        PurCFetcher::HTTPHeaderName::Accept,
        PurCFetcher::HTTPHeaderName::AcceptCharset,
        PurCFetcher::HTTPHeaderName::AcceptEncoding,
        PurCFetcher::HTTPHeaderName::AcceptLanguage,
        PurCFetcher::HTTPHeaderName::AcceptRanges,
        PurCFetcher::HTTPHeaderName::AccessControlAllowCredentials,
        PurCFetcher::HTTPHeaderName::AccessControlAllowHeaders,
        PurCFetcher::HTTPHeaderName::AccessControlAllowMethods,
        PurCFetcher::HTTPHeaderName::AccessControlAllowOrigin,
        PurCFetcher::HTTPHeaderName::AccessControlExposeHeaders,
        PurCFetcher::HTTPHeaderName::AccessControlMaxAge,
        PurCFetcher::HTTPHeaderName::AccessControlRequestHeaders,
        PurCFetcher::HTTPHeaderName::AccessControlRequestMethod,
        PurCFetcher::HTTPHeaderName::Age,
        PurCFetcher::HTTPHeaderName::Authorization,
        PurCFetcher::HTTPHeaderName::CacheControl,
        PurCFetcher::HTTPHeaderName::Connection,
        PurCFetcher::HTTPHeaderName::ContentDisposition,
        PurCFetcher::HTTPHeaderName::ContentEncoding,
        PurCFetcher::HTTPHeaderName::ContentLanguage,
        PurCFetcher::HTTPHeaderName::ContentLength,
        PurCFetcher::HTTPHeaderName::ContentLocation,
        PurCFetcher::HTTPHeaderName::ContentRange,
        PurCFetcher::HTTPHeaderName::ContentSecurityPolicy,
        PurCFetcher::HTTPHeaderName::ContentSecurityPolicyReportOnly,
        PurCFetcher::HTTPHeaderName::ContentType,
        PurCFetcher::HTTPHeaderName::Cookie,
        PurCFetcher::HTTPHeaderName::Cookie2,
        PurCFetcher::HTTPHeaderName::CrossOriginResourcePolicy,
        PurCFetcher::HTTPHeaderName::DNT,
        PurCFetcher::HTTPHeaderName::Date,
        PurCFetcher::HTTPHeaderName::DefaultStyle,
        PurCFetcher::HTTPHeaderName::ETag,
        PurCFetcher::HTTPHeaderName::Expect,
        PurCFetcher::HTTPHeaderName::Expires,
        PurCFetcher::HTTPHeaderName::Host,
        PurCFetcher::HTTPHeaderName::IcyMetaInt,
        PurCFetcher::HTTPHeaderName::IcyMetadata,
        PurCFetcher::HTTPHeaderName::IfMatch,
        PurCFetcher::HTTPHeaderName::IfModifiedSince,
        PurCFetcher::HTTPHeaderName::IfNoneMatch,
        PurCFetcher::HTTPHeaderName::IfRange,
        PurCFetcher::HTTPHeaderName::IfUnmodifiedSince,
        PurCFetcher::HTTPHeaderName::KeepAlive,
        PurCFetcher::HTTPHeaderName::LastEventID,
        PurCFetcher::HTTPHeaderName::LastModified,
        PurCFetcher::HTTPHeaderName::Link,
        PurCFetcher::HTTPHeaderName::Location,
        PurCFetcher::HTTPHeaderName::Origin,
        PurCFetcher::HTTPHeaderName::PingFrom,
        PurCFetcher::HTTPHeaderName::PingTo,
        PurCFetcher::HTTPHeaderName::Pragma,
        PurCFetcher::HTTPHeaderName::ProxyAuthorization,
        PurCFetcher::HTTPHeaderName::Purpose,
        PurCFetcher::HTTPHeaderName::Range,
        PurCFetcher::HTTPHeaderName::Referer,
        PurCFetcher::HTTPHeaderName::ReferrerPolicy,
        PurCFetcher::HTTPHeaderName::Refresh,
        PurCFetcher::HTTPHeaderName::SecWebSocketAccept,
        PurCFetcher::HTTPHeaderName::SecWebSocketExtensions,
        PurCFetcher::HTTPHeaderName::SecWebSocketKey,
        PurCFetcher::HTTPHeaderName::SecWebSocketProtocol,
        PurCFetcher::HTTPHeaderName::SecWebSocketVersion,
        PurCFetcher::HTTPHeaderName::ServerTiming,
        PurCFetcher::HTTPHeaderName::ServiceWorker,
        PurCFetcher::HTTPHeaderName::ServiceWorkerAllowed,
        PurCFetcher::HTTPHeaderName::SetCookie,
        PurCFetcher::HTTPHeaderName::SetCookie2,
        PurCFetcher::HTTPHeaderName::SourceMap,
        PurCFetcher::HTTPHeaderName::TE,
        PurCFetcher::HTTPHeaderName::TimingAllowOrigin,
        PurCFetcher::HTTPHeaderName::Trailer,
        PurCFetcher::HTTPHeaderName::TransferEncoding,
        PurCFetcher::HTTPHeaderName::Upgrade,
        PurCFetcher::HTTPHeaderName::UpgradeInsecureRequests,
        PurCFetcher::HTTPHeaderName::UserAgent,
        PurCFetcher::HTTPHeaderName::Vary,
        PurCFetcher::HTTPHeaderName::Via,
        PurCFetcher::HTTPHeaderName::XContentTypeOptions,
        PurCFetcher::HTTPHeaderName::XDNSPrefetchControl,
        PurCFetcher::HTTPHeaderName::XFrameOptions,
        PurCFetcher::HTTPHeaderName::XSourceMap,
        PurCFetcher::HTTPHeaderName::XTempTablet,
        PurCFetcher::HTTPHeaderName::XXSSProtection
    >;
};

} // namespace PurCWTF

#endif // HTTPHeaderNames_h
