set(UNIVERSAL_BUILD FALSE CACHE BOOL "Indigo C++11 universal build without dependency on libstdc++")

if(NOT MSVC AND NOT BINGO)
    set(VISIBILITY_HIDDEN YES)
endif()

if (NOT CMAKE_BUILD_TYPE)
    if(NOT BUILD_DEBUG)
        message(STATUS "Set CMAKE_BUILD_TYPE to Release")
        set(CMAKE_BUILD_TYPE Release)
    else()
        message(STATUS "Set CMAKE_BUILD_TYPE to Debug")
        set(CMAKE_BUILD_TYPE Debug)
    endif()
endif()
message(STATUS "CMAKE_BUILD_TYPE=${CMAKE_BUILD_TYPE}")

if(MSVC)
    add_definitions(/D "_CRT_SECURE_NO_WARNINGS")
    if (CMAKE_BUILD_TYPE MATCHES Debug)
        add_definitions(/Z7)
    endif()
elseif(UNIX AND NOT APPLE OR MINGW)
    if (CMAKE_SYSTEM_PROCESSOR MATCHES "^(amd64|i.86|powerpc|ppc|sparc|x86_64)")
        if (SUBSYSTEM_NAME MATCHES "x86")
            set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -m32")
            set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -m32")
        elseif(SUBSYSTEM_NAME MATCHES "x64")
            if(CMAKE_SYSTEM_NAME MATCHES "Linux")
                set(CMAKE_C_FLAGS "-include ${CMAKE_CURRENT_LIST_DIR}/../hacks/gcc_preinclude.h ${CMAKE_C_FLAGS}")
                set(CMAKE_CXX_FLAGS "-include ${CMAKE_CURRENT_LIST_DIR}/../hacks/gcc_preinclude.h ${CMAKE_CXX_FLAGS}")
            endif()
            set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -m64")
            set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -m64")
        endif()
    endif()

    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++11")

    if (DEFINED ENV{UNIVERSAL} OR UNIVERSAL_BUILD)
        set(CMAKE_C_CREATE_SHARED_LIBRARY   "python ${CMAKE_CURRENT_LIST_DIR}/linkhack.py | gcc | <LINK_FLAGS> -shared | <OBJECTS> | <LINK_LIBRARIES> | <TARGET>")
        set(CMAKE_C_LINK_EXECUTABLE "python ${CMAKE_CURRENT_LIST_DIR}/linkhack.py | gcc | <LINK_FLAGS> | <OBJECTS> | <LINK_LIBRARIES> | <TARGET>")
        set(CMAKE_CXX_CREATE_SHARED_LIBRARY "python ${CMAKE_CURRENT_LIST_DIR}/linkhack.py | g++ | <LINK_FLAGS> -shared | <OBJECTS> | <LINK_LIBRARIES> | <TARGET>")
        set(CMAKE_CXX_LINK_EXECUTABLE "python ${CMAKE_CURRENT_LIST_DIR}/linkhack.py | g++ | <LINK_FLAGS> | <OBJECTS> | <LINK_LIBRARIES> | <TARGET>")
    endif()
elseif(APPLE)
    include(MacFrameworks)

    set(CMAKE_OSX_ARCHITECTURES "i386;x86_64")
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -arch i386 -arch x86_64 ")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -arch i386 -arch x86_64 ")
   
    if(UNIVERSAL_BUILD)
        # All parameters: <CMAKE_C_COMPILER> <CMAKE_SHARED_LIBRARY_C_FLAGS> <LINK_FLAGS> <CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS> -o <TARGET><TARGET_VERSION><TARGET_VERSION_SUFFIX> <OBJECTS> <LINK_LIBRARIES>; <CMAKE_SYMLINK> <TARGET><TARGET_VERSION_SUFFIX> <TARGET><TARGET_SOVERSION_SUFFIX>; <CMAKE_SYMLINK> <TARGET><TARGET_SOVERSION_SUFFIX> <TARGET>
        set(CMAKE_C_CREATE_SHARED_LIBRARY "python ${CMAKE_CURRENT_LIST_DIR}/linkhack.py | clang | <LINK_FLAGS> -dynamiclib | <OBJECTS> | <LINK_LIBRARIES> | <TARGET>")
        set(CMAKE_C_LINK_EXECUTABLE "python ${CMAKE_CURRENT_LIST_DIR}/linkhack.py | clang | <LINK_FLAGS> | <OBJECTS> | <LINK_LIBRARIES> | <TARGET>")
        set(CMAKE_CXX_CREATE_SHARED_LIBRARY "python ${CMAKE_CURRENT_LIST_DIR}/linkhack.py | clang++ | <LINK_FLAGS> -dynamiclib | <OBJECTS> | <LINK_LIBRARIES> | <TARGET>")
        set(CMAKE_CXX_LINK_EXECUTABLE "python ${CMAKE_CURRENT_LIST_DIR}/linkhack.py | clang++ | <LINK_FLAGS> | <OBJECTS> | <LINK_LIBRARIES> | <TARGET>")
        set(CMAKE_OSX_DEPLOYMENT_TARGET 10.8)
    else()
        set(CMAKE_OSX_DEPLOYMENT_TARGET ${SUBSYSTEM_NAME})
        message(STATUS "Deployment target: ${CMAKE_OSX_DEPLOYMENT_TARGET}")
    endif()

    if (UNIVERSAL_BUILD)
        set(SDK_SUBSYSTEM_NAME 10.8)
    else()
        set(SDK_SUBSYSTEM_NAME ${SUBSYSTEM_NAME})
    endif()

    if (${XCODE_VERSION} GREATER 4.2)
        set(CMAKE_OSX_SYSROOT /Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX${SDK_SUBSYSTEM_NAME}.sdk)
    else()
        set(CMAKE_OSX_SYSROOT /Developer/SDKs/MacOSX${SDK_SUBSYSTEM_NAME}.sdk)
    endif()

    message(STATUS "SDK: ${CMAKE_OSX_SYSROOT}")
    message(STATUS "CMAKE_OSX_ARCHITECTURES ${CMAKE_OSX_ARCHITECTURES}")
    message(STATUS "CMAKE_C_FLAGS ${CMAKE_C_FLAGS}")
    message(STATUS "CMAKE_CXX_FLAGS ${CMAKE_CXX_FLAGS}")    

    set(COMPILE_FLAGS "${COMPILE_FLAGS}")
    set(LINK_FLAGS "${LINK_FLAGS} -Wl,-no_compact_unwind")
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++11 -stdlib=libc++")

endif()

if(UNIX OR APPLE)
    set(COMPILE_FLAGS "${COMPILE_FLAGS} -fPIC")

    #Set RPATH
    set(CMAKE_SKIP_BUILD_RPATH  FALSE)
    set(CMAKE_BUILD_WITH_INSTALL_RPATH FALSE)
    if(APPLE)
            set(CMAKE_INSTALL_RPATH "\@loader_path")
    else()
            set(CMAKE_INSTALL_RPATH "\$ORIGIN")
    endif()
    set(CMAKE_INSTALL_RPATH_USE_LINK_PATH TRUE)
endif()


if(VISIBILITY_HIDDEN)
    set(COMPILE_FLAGS "${COMPILE_FLAGS} -fvisibility=hidden")
endif()
