// This file is a part of Julia. License is MIT: https://julialang.org/license

/* Pregenerated tables for crc32c.c, produced by compiling with -DGEN_CRC32C_TABLES. */
#if POLY != 0x82f63b78
#  error "tables generated for different polynomial"
#endif

JL_UNUSED static const uint32_t crc32c_table[8][256] = {
    { 0,4067132163,3778769143,324072436,3348797215,904991772,648144872,3570033899,2329499855,2024987596,1809983544,2575936315,1296289744,3207089363,2893594407,1578318884,274646895,3795141740,4049975192,51262619,3619967088,632279923,922689671,3298075524,2592579488,1760304291,2075979607,2312596564,1562183871,2943781820,3156637768,1313733451,549293790,3537243613,3246849577,871202090,3878099393,357341890,102525238,4101499445,2858735121,1477399826,1264559846,3107202533,1845379342,2677391885,2361733625,2125378298,820201905,3263744690,3520608582,598981189,4151959214,85089709,373468761,3827903834,3124367742,1213305469,1526817161,2842354314,2107672161,2412447074,2627466902,1861252501,1098587580,3004210879,2688576843,1378610760,2262928035,1955203488,1742404180,2511436119,3416409459,969524848,714683780,3639785095,205050476,4266873199,3976438427,526918040,1361435347,2739821008,2954799652,1114974503,2529119692,1691668175,2005155131,2247081528,3690758684,697762079,986182379,3366744552,476452099,3993867776,4250756596,255256311,1640403810,2477592673,2164122517,1922457750,2791048317,1412925310,1197962378,3037525897,3944729517,427051182,170179418,4165941337,746937522,3740196785,3451792453,1070968646,1905808397,2213795598,2426610938,1657317369,3053634322,1147748369,1463399397,2773627110,4215344322,153784257,444234805,3893493558,1021025245,3467647198,3722505002,797665321,2197175160,1889384571,1674398607,2443626636,1164749927,3070701412,2757221520,1446797203,137323447,4198817972,3910406976,461344835,3484808360,1037989803,781091935,3705997148,2460548119,1623424788,1939049696,2180517859,1429367560,2807687179,3020495871,1180866812,410100952,3927582683,4182430767,186734380,3756733383,763408580,1053836080,3434856499,2722870694,1344288421,1131464017,2971354706,1708204729,2545590714,2229949006,1988219213,680717673,3673779818,3383336350,1002577565,4010310262,493091189,238226049,4233660802,2987750089,1082061258,1395524158,2705686845,1972364758,2279892693,2494862625,1725896226,952904198,3399985413,3656866545,731699698,4283874585,222117402,510512622,3959836397,3280807620,837199303,582374963,3504198960,68661723,4135334616,3844915500,390545967,1230274059,3141532936,2825850620,1510247935,2395924756,2091215383,1878366691,2644384480,3553878443,565732008,854102364,3229815391,340358836,3861050807,4117890627,119113024,1493875044,2875275879,3090270611,1247431312,2660249211,1828433272,2141937292,2378227087,3811616794,291187481,34330861,4032846830,615137029,3603020806,3314634738,939183345,1776939221,2609017814,2295496738,2058945313,2926798794,1545135305,1330124605,3173225534,4084100981,17165430,307568514,3762199681,888469610,3332340585,3587147933,665062302,2042050490,2346497209,2559330125,1793573966,3190661285,1279665062,1595330642,2910671697 },
    { 0,329422967,658845934,887597209,1317691868,1562966443,1775194418,2054015301,2635383736,2394315727,3125932886,2851302177,3550388836,3225172499,4108030602,3883469565,1069937025,744974838,411091311,186800408,1901039709,1659701290,1443537075,1168652484,2731618873,2977147470,2241069783,2520160928,3965408229,4294560658,3407766283,3636263804,2139874050,1814657909,1489949676,1265388443,822182622,581114537,373600816,98970183,3802079418,4047354061,3319402580,3598223395,2887074150,3216496913,2337304968,2566056447,1078858371,1408010996,1728782957,1957280282,247755615,493284136,696337329,975428550,3713716539,3472378188,4196393429,3921508770,2479927527,2154965136,3029696521,2805405822,4279748100,3971309171,3629315818,3421531805,2979899352,2722054063,2530776886,2239369025,1644365244,1906417099,1162229074,1457827109,747201632,1059847191,197940366,409914617,3235002245,3547377650,3885434731,4097154844,2388153945,2650459694,2837276343,3133144768,1573319741,1315204170,2055455955,1763794084,323786209,15601046,873047311,665533816,2157716742,2470362481,2816021992,3027996063,3457565914,3719617709,3914560564,4210158659,495511230,237665993,986568272,695160359,1392674658,1084235541,1950857100,1743073275,3210335367,2902150384,2552030313,2344516638,4057183579,3799067948,3600188853,3308527042,575477567,837783368,84420561,380288934,1825011427,2137386644,1266828813,1478549114,4223924985,3898696334,3699821079,3475264096,3041499941,2800419666,2450303947,2175677372,1725380929,1970643254,1100089775,1378914776,677206173,1006616810,253257843,482013188,3288730488,3617886991,3812834198,4041319393,2324458148,2569990867,2915654218,3194733117,1494403264,1253068983,2119694382,1844797529,395880732,70922603,819829234,595526021,2219317755,2548728204,2735548693,2964304226,3401742375,3647004752,3985066185,4263891134,425515587,184435252,1041885869,767259354,1473690527,1148462056,1888717681,1664160518,3146639482,2821681165,2630408340,2406105315,4110911910,3869577681,3527588168,3252691263,647572418,893105077,31202092,310281051,1746094622,2075251305,1331067632,1559552647,81018109,393651338,596708371,808686692,1247698209,1509737814,1830514127,2126116280,2579562309,2321704754,3196440491,2905036764,3611991705,3303540462,4027559543,3819779584,991022460,682841355,475331986,267806181,1973136544,1715025111,1390320718,1098646585,2785349316,3047659187,2168471082,2464327261,3901714200,4214093679,3486146550,3697854337,2069880831,1761429384,1545269009,1337489254,903200291,645342804,311463629,20059834,3863682119,4125721648,3238931625,3534533854,2831252891,3143886316,2407812469,2619790594,1150955134,1463334409,1675566736,1887274727,168841122,431151061,760577868,1056433979,3650022854,3391911345,4274773288,3983099231,2533657626,2225476717,2957098228,2749572227 },
    { 0,2772537982,1332695565,3928932467,2665391130,1000289892,3518101015,1961911401,944848581,2635115707,2000579784,3531603638,2794429151,63834273,3923822802,1285642924,1889697162,3588485108,1070411655,2592914937,4001159568,1262308334,2702412701,72489443,1223902031,3987919153,127668546,2732426044,3593332565,1936487723,2571285848,1006839590,3779394324,1141205354,2922096921,191511399,2140823310,3671838064,821366019,2511642493,3642082769,2085902255,2524616668,859506082,1204511179,3800757173,144978886,2917507512,2447804062,883365088,3733574803,2076722925,255337092,2860101882,1079472265,3843482359,2847389787,217459237,3872975446,1134131240,929635393,2452131391,2013679180,3712474162,3345318105,1646531239,2282410708,759906474,1505436867,4244289213,383022798,3012945072,4281646620,1517628514,2958814225,354057839,1642732038,3299575928,780486667,2344934005,3083337043,310800173,4171804510,1575566624,689527113,2354629431,1719012164,3275200826,2409022358,718754280,3237581211,1706558437,289957772,3020551666,1579627905,4217808895,639728589,2204166579,1766730176,3423583166,3103776727,499010985,4153445850,1389436836,510674184,3140605814,1360992005,4099835259,2158944530,636449644,3485578015,1786782049,1451427399,4089615417,434918474,3165505076,3361579613,1830563875,2268262480,577987118,1859270786,3415452412,566061711,2231171313,4027358360,1431113446,3210989205,438459627,2334619459,778495293,3293062478,1628026672,368694105,2964865319,1519812948,4292285226,3010873734,372759544,4229503883,1498974709,766045596,2297004002,1657257873,3347459567,4219800265,1589942455,3035257028,296471226,1700507347,3222944941,708115678,2406837920,3285464076,1721083506,2361091585,704312447,1560973334,4165665384,308658715,3072610405,1784908887,3475119657,621600346,2152549412,4106037325,1375517235,3151133248,513009726,1379054226,4151517420,492691615,3088872161,3438024328,1772979446,2206418053,650303227,448917981,3212862371,1437508560,4042207662,2216646087,559859641,3413116874,1848743348,579915544,2278645094,1845468437,3367898987,3159255810,420477308,4079040783,1449175921,1279457178,3909314020,53323159,2792110057,3533460352,2011021822,2649948557,951227379,1947453791,3511835425,998021970,2654800172,3939331397,1334640443,2778873672,14921014,1021348368,2577471598,1938806813,3603843683,2721984010,125811828,3981540359,1209069177,78755029,2716870315,1272899288,4003427494,2590970063,1060012721,3573564098,1883361468,2902854798,138911472,3798556291,1193856253,869836948,2526624490,2092432025,3656804583,2505519691,806789173,3661127750,2138698296,193566289,2932343855,1155974236,3785840162,3718541572,2028331898,2462786313,931836279,1132123422,3862644576,202737427,2840860013,3858059201,1085595071,2862226892,266047410,2066475995,3731519909,876919254,2433035176 },
    { 0,3712330424,3211207553,1646430521,2065838579,2791807819,3292861042,419477706,4131677158,721537374,1227047015,2489772767,2372293141,1344534701,838955412,4014267180,3915690301,874584965,1443074748,2336634884,2454094030,1325607542,757179215,4033087991,522244827,3261429859,2689069402,2097306594,1677910824,3108456848,3680878761,102787601,3609531531,174112307,1749169930,3037175218,2886149496,1900187584,325060345,3458575425,560035693,4230274517,2651215084,1128529492,1514358430,2265377830,3844367647,945934247,1044489654,3808694030,2166785591,1550003343,1164153925,2552643325,4194613188,658578812,3355821648,356543720,2002970065,2854702953,3005740963,1851940123,205575202,3506798234,2879807463,1994650975,348224614,3380926174,3498339860,230802604,1877167509,2997282605,1575107585,2158466745,3800375168,1069593912,650120690,4219840330,2577870451,1155695819,1120071386,2676442210,4255501659,551577571,971038505,3836048785,2257058984,1539462672,3028716860,1774397316,199339709,3601073157,3483679951,316741239,1891868494,2911254006,2088979308,2714165716,3286526189,513917525,128023199,3672428583,3100006686,1703146406,2328307850,1468170802,899681035,3907363251,4058323321,748729281,1317157624,2479329344,2515008081,1218597097,713087440,4156912488,4005940130,864051482,1369630755,2363966107,1671666103,3202757391,3703880246,25235598,411150404,3317957372,2816904133,2057511293,1386268991,2414175111,3989301950,813842438,696449228,4106703476,2531646285,1268806133,2766449369,2040594529,461605208,3334874080,3754335018,42152338,1621211307,3185840659,3150215170,1719784122,77814659,3655790907,3236317681,497279817,2139187824,2730803400,1300241380,2428875100,4075239525,799183581,916597271,3957817519,2311391638,1417716526,2240142772,1489008396,987954741,3886503053,4272417863,602031871,1103155142,2625987966,1942077010,2927891690,3433471443,300103531,149131169,3584435481,3078925344,1791035032,1826712713,2980365873,3548794632,247719344,398679418,3397842882,2829352699,1977734211,2594508655,1205904855,633482478,4169631318,3783736988,1019384868,1591745821,2208675749,4177958616,608386144,1180808537,2602835937,2183440171,1600195987,1027835050,3758501394,256046398,3523698566,2955269823,1835039751,1952498893,2837802613,3406292812,373444084,274868197,3441921373,2936341604,1916841692,1799362070,3053829294,3559339415,157458223,3861267459,996404923,1497458562,2214907194,2634315248,1078058824,576935537,4280745161,774079059,4083558635,2437194194,1275136874,1426174880,2286164248,3932590113,925055641,3630686645,86133517,1728102964,3125110924,2739261510,2113960702,472052679,3244775807,3343332206,436378070,2015367407,2774907479,3160736413,1629530149,50471196,3729230756,822300808,3964074544,2388947721,1394727345,1243701627,2539965379,4115022586,671344706 },
    { 0,940666796,1881333592,1211347188,3762667184,3629437212,2422694376,2826309188,3311864721,4252394557,3041252553,2371140453,623031585,489937549,1426090617,1829832149,2401395155,3073576575,4278238859,3339833639,1869078371,1467396303,524615739,659845015,1246063170,1918109166,979875098,41343670,2852181234,2450635614,3659664298,3795018758,464041303,599382779,1804233231,1402668451,4226616295,3288097867,2345653439,3017718547,3738156742,3873362282,2934792606,2533101106,1049231478,110850010,1319690030,1991880834,2492126340,2895887144,3836218332,3703137392,1959750196,1289618840,82687340,1023204032,1374543637,1778167993,567214157,434008033,2980602277,2310606345,3247095549,4187738449,928082606,255853826,1198765558,2137184858,3608466462,4010130354,2805336902,2670159082,4063650111,3391557267,2182397543,3120943563,309583759,711110691,1649475799,1514172283,3094547325,2153931985,3360805925,4030774153,1479980493,1613224545,672426645,268764473,2098462956,1157984064,221700020,891793432,2639380060,2772488688,3983761668,3579973288,754573305,350793813,1557856417,1690988301,3434897737,4104982245,3164519953,2224017853,3919500392,3515857860,2579237680,2712495260,165374680,835323252,2046408064,1105779244,2749087274,2613760390,3556335986,3957853918,1134428314,2072997686,868016066,195932270,1723643323,1588451863,379480803,781124943,2264468235,3202901159,4141601875,3469392895,1856165212,1454619376,511707652,647062952,2397531116,3069576256,4274369716,3335838488,2881871565,2480189793,3689349525,3824578105,1266704509,1938886609,1000521509,62115977,3783308431,3650214691,2443340759,2847081595,29690431,970220947,1911018855,1240906443,619167518,485937330,1422221382,1825837034,3298951598,4239617538,3028344566,2358358362,1963614219,1293619111,86556499,1027199231,2505039547,2908664087,3849126371,3715919439,2959960986,2289828918,3226449090,4166966126,1344853290,1748613766,537528946,404448734,4196925912,3258543732,2315968128,2988159276,443400040,578605252,1783586864,1381896092,1062144585,123626981,1332598033,2004662973,3742020857,3877362517,2938661793,2537096205,1509146610,1642254430,701587626,297799430,3115712834,2175233774,3381976602,4052070838,2626991203,2760235983,3971377979,3567715479,2094074579,1153459583,217306507,887274023,3604078113,4005605773,2800943481,2665639637,915693713,243601213,1186381769,2124927077,330749360,732412444,1670646504,1535468868,4092816128,3420587180,2211558488,3149978612,1113262757,2051695881,846845437,174635601,2719921173,2584730553,3527174989,3928818913,2268856628,3207425688,4145995372,3473912256,1736032132,1600704552,391864540,793382768,3447286646,4117234906,3176903726,2236275586,758961606,355318378,1562249886,1695507762,136208615,806293323,2017247167,1076744211,3898334807,3494556155,2558066959,2691198627 },
    { 0,4012927769,3683426499,884788186,3002414967,1573215342,1769576372,2252995757,1611012127,2402710278,3146430684,1421530053,3539152744,1036207217,159354795,3863995570,3222024254,792484647,461410557,4105239524,1928922953,2647223376,2843060106,1178979475,2685020193,1329218360,2072414434,2495013883,318709590,4258231375,3379806101,641979532,2247366285,1791262100,1584969294,2974342487,922821114,3627109091,3968696633,62777888,3857845906,180512139,1048489553,3511600456,1460091365,3090633468,2357958950,1673261631,1173890739,2865253802,2658436720,1900342633,4144828868,406682333,746696967,3283212830,637419180,3402519989,4268924527,289600886,2534083035,2017157826,1283959064,2746728961,235166699,3778294002,3582524200,985174065,3169938588,1405159301,1736297567,2286790470,1845642228,2167548141,3046040375,1522436142,3707204739,868687770,125555776,3897278297,3456658389,557318348,361024278,4206141455,2096979106,2479699899,2809265249,1212258168,2920182730,1094588627,1971507977,2595403792,486229181,4090179492,3346523262,675778407,2347781478,1690314367,1350364581,3209463484,956660241,3593801992,3800685266,230273483,3958789497,80100960,813364666,3746209443,1493393934,3056797975,2190459597,1841277396,1274838360,2764838465,2423315867,2134947458,4178135599,372842806,579201772,3451224565,737830215,3301576286,4034315652,524725917,2567918128,1983854889,1115943667,2914228714,470333398,4080590031,3347322645,682916876,2935849121,1104014264,1970348130,2587970427,2081337289,2470364368,2810318602,1219650579,3472595134,567014311,360134781,4198978404,3691284456,859106545,126363435,3904392242,1861333151,2176965510,3044872284,1515027269,3154288631,1395848430,1737375540,2294174765,251111552,3787965337,3581610051,978019162,2583470427,1993132610,1114636696,2906679937,722048556,3292134709,4035262191,531979766,4193958212,382390877,578165127,3443946142,1259310643,2755650858,2424516336,2142455273,1508938085,3066100348,2189177254,1833720511,3943015954,70634763,814286545,3753471432,972458362,3603358307,3799656889,222970528,2332278285,1681118484,1351556814,3216995799,302836797,4248602404,3380628734,649078759,2700729162,1338617939,2071296905,2487554192,1913320482,2637864763,2844153057,1186349048,3237987157,802138188,460546966,4098033807,3523271683,1026602778,160201920,3871086553,1626729332,2412085357,3145288631,1414078638,2986787868,1563864837,1770677471,2260340678,15987563,4022573170,3682554792,877607089,2549676720,2026410409,1282693747,2739155306,621661639,3393038046,4269894916,296814109,4160676527,416188854,745685612,3275893109,1158403544,2856042177,2659677467,1907826178,1475660430,3099894167,2356701773,1665663316,3842113017,171022048,1049451834,3518838307,938660497,3636640136,3967709778,55449931,2231887334,1782025983,1586185509,2981834300 },
    { 0,1745038536,3490077072,3087365464,2782971345,3454265625,1978047553,501592201,1311636819,640602523,2653660355,4129851403,3956095106,2211320906,1003184402,1405636058,2623273638,4099462766,1281205046,610177022,968572791,1371018175,3921503975,2176731695,3530950645,3128240957,40918629,1785950893,2006368804,529919724,2811272116,3482564476,1029407677,1431875445,3982350893,2237593317,2562410092,4038617764,1220354044,549335860,1937145582,460673574,2742036350,3413314486,3600202559,3197474807,110158511,1855180391,2701162779,3372438995,1896226955,419761219,81837258,1826852866,3571901786,3169175954,4012737608,2267981952,1059839448,1462300944,1254965657,583953745,2597001225,4073206977,2058815354,313797554,2863750890,3266474530,3747070635,3075796579,257006395,1733474291,882571817,1553585889,3835470777,2359267185,2440708088,4185461552,1098671720,696208032,3874291164,2398081300,921347148,1592363140,1124874253,722408645,2466931101,4211690837,2831220879,3233950791,2026330399,281310679,220317022,1696786838,3710360782,3039080454,1206682823,804235279,2548751703,4293521823,3792453910,2316266974,839522438,1510552654,163674516,1640125788,3653705732,2982415564,2887892037,3290599565,2082989525,337955101,3686235745,3014939305,196159473,1672612665,2119678896,374642552,2924601888,3327315688,2509931314,4254707706,1167907490,765458026,813319907,1484352043,3766230899,2290037691,4117630708,2641175100,627595108,1298889644,1351535397,948824045,2156434101,3901472381,3141792679,3544244079,1799727671,54953727,514012790,1990204094,3466948582,2795914030,1765143634,20371610,3107171778,3509616906,3436523907,2765495627,483616787,1959806171,655886593,1327179209,4145959057,2669509721,2197343440,3942375448,1392416064,989706632,3358952777,2687934849,406050009,1882257425,1842694296,97936464,3184726280,3587194304,2249748506,3994770642,1444817290,1042089282,603502027,1274779907,4093570139,2617098387,1416525807,1013799719,2221420159,3966436023,4052660798,2576195318,562621358,1233897318,440634044,1916839540,3393573676,2722562020,3215150957,3617612709,1873090301,128334389,2413365646,3889833286,1608470558,937196758,708430943,1111154839,4198471119,2453453063,3254056157,2851592213,301116749,2045870469,1679044876,202841540,3021105308,3692119124,327349032,2072109024,3280251576,2877785712,3059889913,3730905649,1717858153,241648545,1571753595,900473523,2376685547,3853155107,4165979050,2420959074,675910202,1078640370,2994899507,3665929979,1652872099,176684907,392318946,2137088810,3345225330,2942778042,4239357792,2494323624,749285104,1151992376,1498395313,827104889,2303322913,3779774441,786002069,1188715613,4276037893,2531001805,2335814980,3812268428,1530916052,859619356,1626639814,150446350,2968704086,3639736478,3306440727,2903991519,353505671,2098281807 },
    { 0,1228700967,2457401934,3678701417,555582061,1747058506,3009771555,4200137988,1111164122,185039357,3494117012,2575270835,1663469239,706411408,4049501433,3093430750,2222328244,3444208787,370078714,1597148893,2775288793,3965187838,924021143,2117012656,3326938478,2406576201,1412822816,487164423,3880816387,2926375460,1965585741,1007945834,218129817,1144789182,2675482583,3594838768,740157428,1696701139,3194297786,4149829789,1329291587,101129316,3712195341,2491409962,1848042286,656055817,4234025312,3043124295,2306239533,3226079498,453940835,1379068740,2825645632,3780612967,974328846,1932486953,3410847991,2188449232,1496683193,269086622,3931171482,2741802941,2015891668,823422451,436259634,1396487701,2289578364,3242478683,991775071,1914778744,2842014481,3763981878,1480314856,285717199,3393402278,2206156929,2032553349,807022754,3948853195,2724383468,2658583174,3612000161,202258632,1160922607,3211477227,4132912588,756267685,1680852866,3696084572,2507258747,1312111634,118047029,4249895985,3026991382,1864941183,638894936,385920683,1581044620,2239255781,3427019202,907881670,2132890081,2758137480,3982076847,1429973617,470275926,3343077439,2390699288,1948657692,1025135931,3864973906,2942480245,2474026783,3662338616,17718609,1211244662,2993366386,4216805461,538173244,1764729371,3511526341,2557599458,1127569803,168371372,4031783336,3110886543,1646844902,722773697,872519268,2101209923,2792975402,4014280973,354161673,1545627950,2271538759,3461911392,1983550142,1057419161,3829557488,2910721495,1462178003,505114100,3311397533,2355337146,2960629712,4182500087,571434398,1798510777,2439650749,3629539482,51570675,1244568276,4065106698,3144738349,1614045508,688397411,3545307495,2590860352,1093264169,135634446,956429309,1883082458,2876836275,3796202644,404517264,1361054903,2321845214,3277387513,2067461927,839289344,3913420137,2692640846,1512535370,320538733,3361705732,2170810915,3178756681,4098590574,789512199,1714650400,2624223268,3579184387,236094058,1194262349,4283235987,3060827060,1832125661,604535290,3729882366,2540503513,1277789872,85326743,771841366,1732059249,3162089240,4114995775,253550395,1176543772,2640586101,3562559570,1815763340,621159595,4265780162,3078545125,1294457825,68921030,3747553711,2523094152,2859947234,3813353925,940551852,1899221899,2339034767,3260459944,420621505,1345212902,3897315384,2708483359,2050271862,856217425,3377582677,2154671986,1529423899,303387964,587282639,1782400488,2977546881,4165320614,35437218,1260439429,2422489324,3646438859,1631206421,671498546,4081239643,3128867708,1076346488,152814431,3529458742,2606971153,2809606523,3997912156,890227509,2083763730,2255139606,3478572593,336742744,1563309183,3846976929,2893039750,1999949807,1040757448,3293689804,2372782827,1445547394,521482405 }
};

JL_UNUSED static const uint32_t crc32c_long[4][256] = {
    { 0,3762348204,3312301993,623728389,2402752931,1870133519,1247456778,2853850790,461522359,4223837467,3740267038,1051660978,2494913556,1962261688,1373170621,2979531537,923044718,3611585474,4066983111,304733291,3090387661,1483960929,2103321956,2636039624,747032281,3435540085,3924523376,162240988,2746341242,1139881942,1725718739,2258403455,1846089436,2387211888,2875498869,1260667353,3778940799,25096147,609466582,3289602170,1972065131,2513155015,2967921858,1353057390,4206643912,452766308,1070726497,3750829517,1494064562,3108863262,2623547931,2082523831,3594159121,913990845,324481976,4078424852,1116723205,2731489449,2279763884,1738706688,3451437478,771236106,148207119,3902117539,3692178872,1012059412,427792913,4181686973,1394947099,3009795255,2521334706,1980261150,3348129807,667977891,50192294,3804053258,1218933164,2833748224,2378876421,1837770409,3944130262,190203514,779817343,3460035027,1679933301,2220974041,2706114780,1091364976,4036289377,282330061,905532616,3585717348,2141452994,2682460782,3134082411,1519300039,2988129124,1381751752,2004257997,2536926305,1026302663,3714892395,4165047662,402748866,2845408979,1238998655,1827981690,2360617430,648963952,3337521116,3821261017,58929269,2233446410,1700745382,1081214883,2687690511,170437033,3932702981,3477413376,788922028,2661152189,2128418065,1542472212,3148915384,296414238,4058647730,3569834935,881310491,3184012673,1569246509,2024118824,2565175940,855585826,3535787150,4153574283,399663911,2789894198,1175095450,1663557535,2204581683,696086933,3376255289,3960522300,206579344,2328667887,1787577923,1335955782,2950820330,100384588,3854262240,3231058149,550955081,2437866328,1896743924,1411601649,3026433117,511310587,4265155159,3675540818,995405310,3552656221,864148465,380407028,4142689368,1559634686,3166093906,2577110359,2044425723,3359866602,671325766,221169987,3983419887,1198810953,2805237733,2182729952,1650012236,3838160947,75845791,564660122,3253266230,1811065232,2343717180,2929663545,1323302549,4282905988,520557864,975847981,3664421505,1886448679,2419068043,3038600078,1432206114,1641676857,2174410901,2763503504,1157060412,4008515994,246282550,729853491,3418377887,2052605326,2585306402,3207983655,1601507979,4117716013,355449985,805497732,3493989160,1457425239,3063835643,2477997310,1945361490,3655963380,967406168,478422365,4240754161,1297927904,2904305228,2284943689,1752275429,3261847363,573257711,117858538,3880157254,265492197,4019451465,3401490764,721306080,2162429766,1621422058,1166653679,2781435971,340874066,4094800894,3510428923,830211159,2607172337,2066131549,1577844056,3192593908,953654667,3633806631,4256836130,502975118,3084944424,1470129284,1921856385,2462962477,592828476,3272947856,3862458261,108564281,2892153247,1277305139,1762620982,2303694490 },
    { 0,2122067443,4244134886,2189719061,4229742909,2187390158,14981851,2123937576,4258657419,2208946552,19771245,2136048286,29963702,2142574661,4247875152,2202878883,4266106855,2151395860,46121985,2093214194,39542490,2082960169,4272096572,2162108623,59927404,2112767647,4285149322,2165710201,4287539793,2180155298,58126775,2097863748,4184033599,2266981580,94048985,2078752554,92243970,2063836657,4186428388,2281438743,79084980,2060095559,4165920338,2251475873,4171922569,2262192506,72492911,2049837724,119854808,2035874603,4225535294,2241896653,4214757349,2235841046,130042883,2042388976,4210106963,2223837088,101284277,2020955206,116253550,2022821533,4195727496,2221512059,4146783375,2304166268,198360937,1974375066,188097970,1967786049,4157505108,2310165415,184487940,1954758135,4127673314,2289788433,4142125369,2292186314,169577183,1952950060,158169960,1997624987,4120191118,2347306365,4117871189,2332923814,160031155,2012597312,4105736163,2328142352,138466309,1983707638,144985822,1993892653,4099675448,2317367499,239709616,1882554435,4071749206,2362301349,4065684621,2351513982,246232939,1892752024,4087109947,2380297416,258212573,1897410350,260085766,1912387061,4084777952,2365910547,4027462231,2389843876,217475505,1921664066,202568554,1919868569,4041910412,2392229247,232507100,1940384559,4045643066,2405413065,4056352737,2411407890,222256135,1933799924,3954819055,2512753180,390194185,1765657082,396721874,1775850273,3948750132,2501970119,376195940,1745905303,3935572098,2498248049,3933243993,2483857322,378065343,1760885836,368975880,1803685371,3909516270,2541377053,3923960117,2543766726,354073299,1801885472,3895186563,2522347888,349409125,1789895318,339154366,1783314509,3905900120,2528338859,316339920,1822874403,3995249974,2422112453,4005967853,2428115486,306080779,1816281592,4010738267,2440245160,334977469,1837855822,320062310,1836052117,4025194624,2442638707,3969739063,2464236740,275067601,1847140130,276932618,1862108665,3967415276,2449858079,289971644,1865723983,3987785306,2479680425,3981728897,2468901234,296486759,1875913364,479419232,1659860627,3765108870,2652319093,3767507549,2666772398,477610427,1644948552,3779506155,2671411736,499053581,1673714174,492465878,1663451941,3785504048,2682132675,3805594759,2628315508,506240865,1615901330,516425146,1622419529,3794820700,2622256047,520171532,1635589631,3824774122,2642757145,3810390321,2640436418,535145175,1637451556,3857715807,2609659820,419973561,1735681098,434951010,1737555601,3843328132,2607326583,405137108,1717160743,3839737138,2594279617,3828951017,2588215834,415333391,1723683324,465014200,1707843659,3880769118,2570320813,3886763141,2581029238,458430307,1697594000,3865213235,2552124608,446309077,1692798758,444512270,1677891069,3867599848,2566573595 },
    { 0,3533637935,2698142895,1917676928,1145618351,2530719360,3835353856,906351151,2291236702,1510897265,675486705,4208726750,3436822769,507955678,1812702302,3197414769,349079629,3327230306,3021794530,1719920077,1350973410,2182692557,4032058189,583752290,2623534867,1321270844,1015911356,3994196627,3625404604,176701843,2026187795,2858034492,698159258,4211218869,2303685685,1540390170,1842720565,3209340442,3439840154,530105013,2701946820,1939039979,31329131,3544252996,3846492267,937154884,1167504580,2533998059,1028888791,4023161336,2642541688,1327428951,2031822712,2877566551,3653845975,190204664,3049449353,1734209190,353403686,3348072969,4052375590,588599561,1364737161,2210870694,1396318516,2175084571,4092085659,561466548,393387675,3320682420,3080780340,1698689819,3685441130,154425157,2071542469,2850436074,2682511813,1300031722,1060210026,3987639365,1207216505,2506858582,3878079958,901367033,62658262,3508740089,2741924473,1911651158,3479557671,502980360,1874309768,3173563303,2335009160,1504862375,738135335,4183819272,2057777582,2822256769,3665122561,149576750,1055886849,3966797614,2654857902,1285743489,4063645424,547964895,1390684767,2155553648,3061772639,1692530800,380409328,3291716831,1852422627,3170283724,3468418380,472175715,706807372,4173205347,2331206371,1483500492,3875063485,879218578,1177199122,2494933821,2729474322,1882157117,39984573,3506246802,2792637032,1961577287,111552199,3560517608,3795647943,816051432,1122933096,2423361607,786775350,4235867161,2385992089,1554534582,1789756057,3090320310,3397379638,417394457,2998585893,1613087498,308850314,3237455781,4143084938,611155109,1444942117,2227116042,975943035,3904158804,2600063444,1214699771,2120420052,2902197243,3736170107,204367700,2414433010,1568037853,792409693,4255399794,3416386909,423552114,1802734066,3119284445,125316524,3588695171,2812954883,1966424108,1127256579,2444204844,3823302316,830340995,2603080383,1236849552,1005960720,3916085055,3748619536,233860159,2143093183,2904688784,330737121,3240733902,3009724750,1643890785,1476270670,2237731681,4146888417,632518606,4115555164,668035699,1436289011,2265124572,2970017011,1671026140,299153500,3276517747,2111773698,2940212525,3708647597,261255554,966239149,3943213698,2571486978,1272630829,3783322385,857727550,1095929790,2479720081,2781369534,2002214289,85602321,3615832382,1762759759,3146685792,3385061600,459078095,760818656,4291175119,2374717263,1595164256,3704845254,239893225,2080446313,2929598022,2560347241,1241826630,944351430,3939934697,1413614744,2262631863,4103104567,638542104,269136695,3264592408,2967000984,1648877239,3357408139,444789412,1758437156,3125843467,2354398244,1590316299,747053195,4262996388,1082950869,2450755066,3764314234,851568981,79969146,3596300885,2752929749,1988712186 },
    { 0,1225060897,2450121794,3675068003,570408565,1761299540,3019266615,4210206742,1140817130,184258251,3522599080,2566023817,1644216991,721694910,4027131613,3104691452,2281634260,3472493557,368516502,1559490487,2785101729,4010128768,872981475,2097959362,3288433982,2365945631,1443389820,520917853,3858643787,2902116714,2012733193,1056124200,168920409,1125480312,2551734555,3508310842,737033004,1659554061,3118980974,4041420111,1240398259,15338386,3689356785,2464411600,1745962950,555070951,4195918724,3004977573,2381282445,3303771820,535206095,1457679086,2886779640,3843305689,1041835706,1998443675,3457155175,2266296902,1545200677,354227716,4025466386,2800438323,2112248400,887269489,337840818,1562900627,2250960624,3475905745,903656647,2094548710,2815774853,4006716068,1474066008,517506169,3319108122,2362531899,1982056493,1059535372,3827969135,2905529934,2480796518,3671654727,30676772,1221649669,2988592403,4213620530,539732305,1764711280,3491925900,2569436589,1110141902,187668975,4057805305,3101279192,1674892731,718284698,506630123,1463188938,2352704425,3309279624,1070412190,1992934335,2915358172,3837798397,1573778177,348717344,3485734723,2260788578,2083671412,892780373,3996887350,2805947159,2580313663,3502801950,197497469,1119969372,3090401354,4046928491,708455432,1665064489,3660778197,2469918964,1211821719,20847798,4224496800,2999469697,1774538978,549561027,675681636,1631774533,3125801254,4081779463,163162897,1086150960,2612023123,3535060338,1807313294,582851503,4189097420,2964619245,1246156795,54666714,3629069241,2437661080,2948132016,3871088273,1035012338,1958083283,2387038917,3343098084,474920583,1430930598,3964112986,2772656763,2119070744,927630905,3451399727,2226969614,1605487213,380975180,576163901,1800626716,2958980223,4183459422,61353544,1252842601,2443299338,3634706475,1638460631,682368758,4087416981,3131439796,1079464610,156475523,3529422560,2606384321,2779343337,3970800584,933268907,2124709770,2220283804,3444712893,375337950,1599848959,3864401155,2941445922,1952444737,1029374816,3349785462,2393725271,1436569396,480558357,1013260246,1969352183,2926377876,3882355125,496673187,1419662210,2408793569,3331831744,2140824380,916361501,3985868670,2761389407,1583734089,392245096,3429644555,2238237482,3147556354,4070511651,697434688,1620504673,2590267511,3546327638,141409333,1097420308,4167342824,2975885513,1785560746,594119819,3650823325,2426394300,1267908831,43397886,913611407,2138073262,2759687885,3984166124,394994938,1586484955,2239938744,3431346841,1972102757,1016009796,3884057127,2928078854,1416910864,493922865,3330128978,2407091827,2978636635,4170092922,595822361,1787262264,2423643438,3648073487,41695596,1266207565,4067762097,3144805776,1618803699,695732690,3549077956,2593018853,1099122054,143112103 }
};
JL_UNUSED static const uint32_t crc32c_short[4][256] = {
    { 0,3702618788,3163456441,1614805277,2096198019,2688551719,3229610554,483297438,4192396038,626235810,1164730559,2581404187,2232652421,1503848481,966594876,3844893592,4129927421,714656345,1252471620,2518043104,2329461118,1449769946,911622855,3941021795,264983547,3547998559,3007696962,1878305510,1933189752,2945145052,3484721601,319150949,3921614603,890138031,1429312690,2306928150,2504943240,1241455660,700507441,4117864341,274592781,3438055081,2899539892,1885474064,1823245710,2954755882,3491890743,210992275,529967094,3274169682,2736268367,2141806315,1667749493,3218517201,3756611020,56110952,3866379504,986005076,1526384457,2253110765,2592421235,1177833431,638301898,4206546030,3599915239,170074691,1780276062,3064832506,2858625380,1993495488,384674525,3395080313,795917281,4089561413,2482911320,1330594556,1401014882,2402332870,4010756571,868103039,549185562,4228551358,2620746659,1082396935,1548392857,2163991357,3770948128,1014325380,3646491420,99119544,1708624037,3110531585,2779282079,2031681595,421984550,3315041154,1059934188,3818665288,2208549973,1595062001,1138507375,2674738379,4283612630,602130290,3335498986,444520014,2051092307,2800768503,3124682089,1720690637,112221904,3657507956,3372547857,364217781,1972010152,2839217676,3052768914,1766126646,159059243,3586815887,820386839,3965150899,2355666862,1356457226,1276603796,2426804016,4036619821,740856969,2831730495,1954135451,340149382,3371646498,3560552124,143182872,1756837125,3020312481,1361716281,2375769757,3986990976,823516452,769349050,4050267934,2438321667,1306832039,1591834562,2186284390,3798987899,1054772959,571475521,4271996133,2661189112,1110441820,2802029764,2075324000,462231421,3342626265,3690128711,121872355,1736206078,3150781530,1098371124,2647042704,4260975501,558377257,1032233399,3778534163,2164793870,1572427946,3096785714,1680099734,68923531,3635071535,3294905009,416626709,2028650760,2757475244,3076415689,1810831981,198239088,3613497812,3417248074,387869678,1998689011,2878400599,1320977359,2450389355,4063363190,780368594,843969100,4009527528,2395173365,1383205713,2119868376,2733368700,3268680801,509961925,44822107,3726284031,3190124002,1653872454,2277014750,1527318138,993460071,3884418499,4215868765,670595065,1204260580,2608264256,2289250085,1422022017,889040028,3897349688,4102184614,674440194,1208802591,2495457211,1905380387,2904602247,3441381274,296629566,224443808,3520186116,2985180697,1834960061,2548402387,1263858295,728435562,4158288334,3944020304,933594100,1469741801,2334851149,1845980117,2998276465,3532253292,238588616,318118486,3460784370,2927139311,1925833547,1640773678,3179102858,3712138135,32751923,490555821,3247190793,2712914452,2097328304,2553207592,1151312268,614488209,4161872437,3839863467,946786319,1481713938,2229294006 },
    { 0,1417541775,2835083550,4236642705,1411093709,6712386,4242564563,2828901724,2822187418,4232761621,13424772,1420894219,4230790487,2823898584,1423395913,11187398,1434592709,33545546,4252619995,2835622996,26849544,1441024391,2841788438,4246714521,4256500831,2848519376,1431240001,20121038,2846791826,4258488349,22374796,1428721923,2869185418,4286165765,67091092,1468154395,4280278855,2875336648,1474571865,60413654,53699088,1464769183,2882048782,4290079617,1462302429,55905874,4292020163,2880372556,4270222927,2868614848,1451073361,33581022,2862480002,4276093453,40242076,1444672275,1454458837,46972762,4266309323,2855751236,44749592,1456941975,2857443846,4264352393,1407508965,127474026,4213117179,2942494836,134182184,1401064871,2936308790,4219043001,4224960639,2947428592,1395145057,123060718,2949143730,4222985277,120827308,1397642531,107398176,1377516719,2929538366,4209036721,1383944429,100706402,4203127283,2935708028,2924604858,4197193013,111811748,1389880363,4199184759,2922873336,1387366505,114061542,4175473263,2895991520,1343970161,73835518,2902146722,4169582125,67162044,1350383411,1356301301,78281594,4163662571,2891024996,80484152,1353838519,2889344550,4165607081,2908917674,4179588901,93945524,1373931067,4185463655,2902778856,1367534201,100602614,89499184,1361600191,2913883950,4191399841,1364079357,87280242,4189438947,2915580780,2815017930,4088675141,254948052,1531955803,4090648327,2813308808,1529456153,257187478,268364368,1535316703,2802129742,4084786113,1541766813,261654034,4078866307,2808313612,4065060367,2788564608,1521489681,248377246,2790290114,4063070797,246121436,1524005715,1518129045,234960666,4068949643,2801452548,241654616,1511695319,2795285062,4074853065,214796352,1487958223,2755033438,4031480273,1490427021,212591618,4029541779,2756711708,2767888858,4035402069,201412804,1484564555,4041291031,2761739672,1478149129,208092294,1498393989,221402378,4055129243,2781455380,223623496,1495908807,2779760726,4057084121,4051207199,2768600208,1501787393,234786190,2774733010,4045334621,228123084,1508186435,4096598575,2689653408,1557582641,145435582,2687940322,4098575981,147671036,1555087219,1545210805,141030202,4108450475,2694578724,134324088,1551656951,2700766822,4102526697,2712602602,4124245861,156563188,1562971771,4122252071,2714332072,1565483577,154311350,160968304,1575343871,2707677038,4112394209,1568914109,167658034,4118301603,2701505324,1596549541,190091562,4157774011,2746179636,187891048,1599014375,2747862134,4155831545,4145954879,2741221552,1608888609,194529710,2735068402,4151848061,201205228,1602477411,178998368,1591129327,2723200382,4130162161,1588648109,181215266,4132121011,2721501500,2728158714,4141981045,174560484,1578789995,4136104247,2734295480,1585184809,167901350 },
    { 0,1249898853,2499797706,3732935599,739488613,1718370816,3102495151,4069761226,1478977226,307795887,3436741632,2259121509,1949619631,1045112010,3771414373,2863973888,2957954452,4197530865,615591774,1859051067,2623373041,3592589204,144874555,1121807710,3899239262,2719373883,2090224020,921286897,3296335931,2382752094,1350957809,452594580,1701965273,789454012,4052619027,3153198710,1231183548,52277209,3718102134,2548190483,1029081875,1999207030,2846452185,3822491836,289749110,1530579219,2243615420,3485805529,3577684045,2671825192,1103151751,197080034,4180448040,3008586317,1842573794,665616519,2367178375,3345463266,434611277,1402492200,2701915618,3950249095,905189160,2139874893,3403930546,2157718231,1578908024,342083613,3874515159,2895092146,1913621021,946895736,2462367096,3636153373,104554418,1279569623,3201764893,4104716152,707325143,1616321970,2058163750,819128131,3998414060,2754413961,1455334723,482432038,3259058057,2285811436,579498220,1760919945,3061158438,4228539203,244958089,1155937004,2590384451,3491352614,2945594987,3857565454,997053601,1897014724,2206303502,3388896363,394160068,1560385185,4155855009,3184173508,1665839723,691356430,3685147588,2446922401,1331233038,86437995,534576127,1436748442,2334333237,3244091472,869222554,2041625087,2804984400,3981400885,1207672117,226782288,3540287487,2575011482,1810378320,563601205,4279749786,3043507711,2418786709,3662950640,81011551,1319883322,3157816048,4131881877,684167226,1656250719,3356272479,2188596794,1559446933,378320112,3827242042,2925585759,1893791472,983500693,543493121,1780153700,3030052555,4276428718,209108836,1175014913,2559139246,3539381451,2017618635,842898350,3971844097,2797762916,1414650286,506341579,3232643940,2329004545,4116327500,3206929705,1638256262,735723491,3645480745,2469817932,1303805411,130649222,2910669446,3875716067,964864076,1945983273,2171533795,3406891142,361831209,1609493068,1158996440,258674877,3521839890,2610229879,1762087613,595108824,4260933751,3079094546,489916178,1464628855,2311874008,3283326141,824194167,2069873938,2782910141,4020250584,1523063335,280488770,3459774701,2219313544,1994107202,1017403431,3794029448,2824583917,49249517,1217432968,2517671463,3698290498,788320136,1686322925,3120770370,4034714663,3934705587,2700682966,2121872761,872858652,3331679446,2364183987,1382712860,404060025,2996941177,4175314972,643716019,1814143702,2662466076,3570267001,172875990,1077023155,1069152254,1975912091,2873496884,3778667601,329925787,1507177982,2270537297,3442104116,1738445108,769744977,4083250174,3105784475,1267540561,32690996,3748839579,2500669950,2415344234,3314076431,453564576,1366763973,2749663503,3919280234,924543941,2103745184,3620756640,2645536197,1127202410,156258063,4223922117,2981895840,1866206479,625212522 },
    { 0,633075163,1266150326,1858870893,2532300652,3008635575,3717741786,4163094785,674486313,227028466,1665414047,1191167556,3202092869,2607282846,4121683187,3490713896,1348972626,1977369993,454056932,1051438655,3330828094,3811807973,2382335112,2823059795,2018797691,1575984544,857965517,379090454,4005281559,3405793996,2781631649,2155323770,2697945252,2239010175,3954739986,3456335561,908113864,328942099,2102877310,1491904933,2298263693,2907131222,3280687931,3861948128,504590305,1000905274,1432650839,1893691788,4037595382,3574801709,3151969088,2657406619,1715931034,1140650561,758180908,143333879,3634039007,4246797572,2481775465,3059160754,1316282291,1808738920,84096005,548979166,1148368825,1640579682,252009487,717138388,3533529301,4146500878,2582285155,3159457464,1816227728,1241160267,657884198,42824189,4205754620,3742715175,2983809866,2489493137,336922603,833548848,1600318557,2061048198,2197475463,2806064476,3381476145,3963014890,1009180610,429730329,2001810548,1391116719,2865301678,2406677877,3787383576,3288667843,3837646621,3238404806,2949266603,2322712944,1917976689,1474950570,958786503,480124444,3431862068,3912628975,2281301122,2722238809,1516361816,2145004931,286667758,883803701,3034212175,2439090836,4289563897,3658905890,573943843,126764536,1765956501,1291431502,2632564582,3109178045,3617477840,4062552331,168192010,800955857,1097958332,1690990183,2296737650,2908658345,3281159364,3861475615,504018974,1001475525,1434276776,1892066931,2698426203,2238530176,3953220845,3457853750,909729847,327325164,2102299521,1492483674,3632455456,4248382203,2482320534,3058614605,1315768396,1809251735,85648378,547427873,4038133513,3574264530,3150376127,2658998628,1717489765,1139090878,757677011,143838728,673845206,227670541,1667097696,1189482939,3200637114,2608737633,4122096396,3490301655,1693695,631382564,1265515593,1859504530,2532704403,3008230728,3716279077,4164558590,2018361220,1576421983,859460658,377594345,4003621096,3407453491,2782233438,2154722949,1350461357,1975882358,453610523,1051883968,3331436737,3811198234,2380684151,2824711852,3432503499,3911986448,2279617405,2723923622,1517817767,2143550076,286254097,884216266,3835953378,3240097081,2949901140,2322079375,1917573006,1475355221,960248888,478661091,2633001113,3108740418,3615982383,4064048884,169852917,799296046,1097356355,1691591064,3032723632,2440578411,4290009862,3658460893,573335516,127373831,1767607402,1289779633,1817753711,1239633332,657413081,43296258,4206325507,3742145240,2982184117,2491117934,1147887686,1641059741,253529072,715619883,3531913002,4148118257,2582863004,3158878535,1010763837,428146150,2001265547,1391662672,2865815377,2406165130,3785831655,3290218812,336384020,834086351,1601911714,2059456121,2195916664,2807624355,3381980366,3962509589 }
};
