// $Id: epoch.h,v 1.4 2018/01/03 21:32:58 mkkuhner Exp $

/*
Copyright 2002-2005 Mary K. Kuhner, Peter Beerli, and Joseph Felsenstein

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

/* Authors: Mary Kuhner, Jon Yamato, and Joseph Felsenstein */


//------------------------------------------------------------------------------------

#ifndef EPOCH_H
#define EPOCH_H

#include <vector>

//------------------------------------------------------------------------------------

class Epoch
{
  public:
    Epoch(const std::vector<long>& here, const std::vector<long>& departing, long arriving);

    const std::vector<long>& PopulationsHere() const { return m_here; };
    const std::vector<long>& Departing() const { return m_departing; };
    long Arriving() const { return m_arriving; };

  private:
    std::vector<long> m_here;
    std::vector<long> m_departing;
    long m_arriving;
};

//------------------------------------------------------------------------------------

#endif

//____________________________________________________________________________________
