/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    private static ColorManager instance;
    protected Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);
    private Map<String, IToken> tokenTable = new HashMap<String, IToken>(10);
    private Map<String, String> styleTable = new HashMap<String, String>(10);
    private final IPreferenceStore preferenceStore;
    private StyledString.Styler operatorStyler;
    private StyledString.Styler prototypeStyler;
    private StyledString.Styler slotStyler;
    private StyledString.Styler variableStyler;

    public ColorManager(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
        instance = this;
        this.operatorStyler = new DefaultStyler("operator_color", "operator_style");
        this.prototypeStyler = new DefaultStyler("prototype_color", "prototype_style");
        this.slotStyler = new DefaultStyler("slot_color", "slot_style");
        this.variableStyler = new DefaultStyler("local_slot_color", "local_slot_style");
    }

    public static ColorManager getDefault() {
        return instance;
    }

    public void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public IToken getToken(String prefKey, String styleKey) {
        Token token = (Token)this.tokenTable.get(prefKey);
        int style = this.convertToStyle(styleKey);
        if (token == null) {
            String colorName = this.preferenceStore.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            token = new Token((Object)new TextAttribute(this.getColor(rgb), null, style));
            this.tokenTable.put(prefKey, (IToken)token);
            this.styleTable.put(styleKey, prefKey);
        } else {
            TextAttribute attrib = (TextAttribute)token.getData();
            if (attrib.getStyle() != style) {
                token = new Token((Object)new TextAttribute(attrib.getForeground(), null, style));
                this.tokenTable.put(prefKey, (IToken)token);
            }
        }
        return token;
    }

    public IToken getToken2(String prefKey, String prefKey2) {
        Token token = (Token)this.tokenTable.get(prefKey);
        if (token == null) {
            String colorName = this.preferenceStore.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            String colorName2 = this.preferenceStore.getString(prefKey2);
            RGB rgb2 = StringConverter.asRGB((String)colorName2);
            token = new Token((Object)new TextAttribute(this.getColor(rgb2), this.getColor(rgb), 0));
            this.tokenTable.put(prefKey, (IToken)token);
        }
        return token;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        Token token = (Token)this.tokenTable.get(event.getProperty());
        return token != null || this.styleTable.get(event.getProperty()) != null;
    }

    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String prefKey = event.getProperty();
        Token token = (Token)this.tokenTable.get(prefKey);
        if (token != null) {
            String colorName = this.preferenceStore.getString(prefKey);
            RGB rgb = StringConverter.asRGB((String)colorName);
            if (prefKey.equals("external_color")) {
                String colorName2 = this.preferenceStore.getString("local_slot_color");
                RGB rgb2 = StringConverter.asRGB((String)colorName2);
                token.setData((Object)new TextAttribute(this.getColor(rgb2), this.getColor(rgb), 0));
            } else {
                token.setData((Object)new TextAttribute(this.getColor(rgb)));
            }
        } else {
            String key = this.styleTable.get(prefKey);
            if (key != null && (token = (Token)this.tokenTable.get(key)) != null) {
                int style = this.convertToStyle(prefKey);
                TextAttribute attrib = (TextAttribute)token.getData();
                token.setData((Object)new TextAttribute(attrib.getForeground(), null, style));
            }
        }
    }

    public int convertToStyle(String prefKey) {
        String pref = this.preferenceStore.getString(prefKey);
        if (pref.equals("normal")) {
            return 0;
        }
        if (pref.equals("bold")) {
            return 1;
        }
        if (pref.equals("italic")) {
            return 2;
        }
        if (pref.equals("underline")) {
            return 0x40000000;
        }
        return 0;
    }

    public StyledString.Styler getOperatorStyler() {
        return this.operatorStyler;
    }

    public StyledString.Styler getPrototypeStyler() {
        return this.prototypeStyler;
    }

    public StyledString.Styler getSlotStyler() {
        return this.slotStyler;
    }

    public StyledString.Styler getVariableStyler() {
        return this.variableStyler;
    }

    private class DefaultStyler
    extends StyledString.Styler {
        String prefKey;
        String styleKey;

        public DefaultStyler(String prefKey, String styleKey) {
            this.prefKey = prefKey;
            this.styleKey = styleKey;
        }

        public void applyStyles(TextStyle textStyle) {
            IToken token = ColorManager.this.getToken(this.prefKey, this.styleKey);
            TextAttribute attrib = (TextAttribute)token.getData();
            textStyle.foreground = attrib.getForeground();
        }
    }
}

