/**************************************************************************\
 ibtk (Insomnia's Basic ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/
#include <stdio.h>
#include <string.h>
#include "version.h"

/*
 * Return IBTK version in the format "MMmmsspp"
 * MM: major version (two digits)
 * mm: minor version (two digits)
 * ss: sub version (two digits)
 * pp: pre version (two digits)
 */
char *get_ibtk_version(void) {
  static char buf[34];

  sprintf(buf, "%.2d%.2d%.2d%.2d", IBTK_MAJOR_VERSION, IBTK_MINOR_VERSION,
	  IBTK_SUB_VERSION, IBTK_PRE_VERSION);
  return buf;
  }

/*
 * Return the IBTK_VERSION_STRING
 */
char *get_ibtk_version_string(void) {
  static char buf[34];

  sprintf(buf, "%s", IBTK_VERSION_STRING);
  return buf;
  }

/*
 * Return the IBTK_FULL_VERSION_STRING
 */
char *get_ibtk_full_version_string(void) {
  static char buf[34];

  sprintf(buf, "%s", IBTK_FULL_VERSION_STRING);
  return buf;
  }

/*
 * Check if string version to control is
 * less or greater than the current version
 * of IBTK. Return 1 if (to_check>=current), 
 * and 0 if (to_check<current).
 */
int ibtk_required_version(char *checkwith) {

  if(strcmp(get_ibtk_version(), checkwith) >= 0) {
     /* Ok, ibtk version is equal or greater that required */
     return 1;
    } else {
     /* Humm, is less than required */
     return 0;
    }
  }

