.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtNew-String wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.ny0
.TH XtMalloc __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtMalloc, XtCalloc, XtRealloc, XtFree, XtNew, XtNewString \- memory management functions
.SH SYNTAX
.HP
char *XtMalloc(Cardinal \fIsize\fP);
.HP
char *XtCalloc(Cardinal \fInum\fP, Cardinal \fIsize\fP);
.HP
char *XtRealloc(char *\fIptr\fP, Cardinal \fInum\fP);
.HP
void XtFree(char *\fIptr\fP);
.HP
\fItype\fP *XtNew(\fItype\fP);
.HP
String XtNewString(String \fIstring\fP);
.HP
Cardinal XtAsprintf(String *\fInew_string\fP, const char *\fIformat\fP, ...);
.SH ARGUMENTS
.IP \fInum\fP 1i
Specifies the number of bytes or array elements.
.ds Po to the old storage or to the block of storage that is to be freed
.IP \fIptr\fP 1i
Specifies a pointer \*(Po.
.IP \fIsize\fP 1i
Specifies the size of an array element (in bytes) or the number of bytes
desired.
.IP \fIstring\fP 1i
Specifies a previously declared string.
.IP \fItype\fP 1i
Specifies a previously declared data type.
.IP \fInew_string\fP 1i
Specifies a pointer to write a newly allocated string to.
.IP \fIformat\fP 1i
Specifies a formatting string as defined by sprintf(3c)
.SH DESCRIPTION
The
.ZN XtMalloc
functions returns a pointer to a block of storage of at least
the specified size bytes.
If there is insufficient memory to allocate the new block,
.ZN XtMalloc
calls
.ZN XtErrorMsg .
.LP
The
.ZN XtCalloc
function allocates space for the specified number of array elements
of the specified size and initializes the space to zero.
If there is insufficient memory to allocate the new block,
.ZN XtCalloc
calls
.ZN XtErrorMsg .
.LP
The
.ZN XtRealloc
function changes the size of a block of storage (possibly moving it).
Then, it copies the old contents (or as much as will fit) into the new block
and frees the old block.
If there is insufficient memory to allocate the new block,
.ZN XtRealloc
calls
.ZN XtErrorMsg .
If ptr is NULL,
.ZN XtRealloc
allocates the new storage without copying the old contents;
that is, it simply calls
.ZN XtMalloc .
.LP
The
.ZN XtFree
function returns storage and allows it to be reused.
If ptr is NULL,
.ZN XtFree
returns immediately.
.LP
.ZN XtNew
returns a pointer to the allocated storage.
If there is insufficient memory to allocate the new block,
.ZN XtNew
calls
.ZN XtErrorMsg .
.ZN XtNew
is a convenience macro that calls
.ZN XtMalloc
with the following arguments specified:
.LP
.Ds
.TA .5i
.ta .5i
((type *) XtMalloc((unsigned) sizeof(type))
.De
.LP
.ZN XtNewString
returns a pointer to the allocated storage.
If there is insufficient memory to allocate the new block,
.ZN XtNewString
calls
.ZN XtErrorMsg .
.ZN XtNewString
is a convenience macro that calls
.ZN XtMalloc
with the following arguments specified:
.LP
.Ds
.TA .5i
.ta .5i
(strcpy(XtMalloc((unsigned) strlen(str) + 1), str))
.De
.LP
The
.ZN XtAsprintf
function allocates space for a string large enough to hold the string
specified by the sprintf(3c) format pattern when used with the remaining
arguments, and fills it with the formatted results.
The address of the allocated string is placed into the pointer passed as ret.
The length of the string (not including the terminating null byte) is returned.
If there is insufficient memory to allocate the new block,
.ZN XtAsprintf
calls
.ZN XtErrorMsg .
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
