/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.zoom;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JViewport;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingChangeEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.StandardDrawing;
import org.jhotdraw.standard.StandardDrawingView;
import org.jhotdraw.util.Geom;

public class ZoomDrawingView
extends StandardDrawingView {
    private double scale = 1.0;
    private double zoomSpeed = 2.0;

    public ZoomDrawingView(DrawingEditor drawingEditor) {
        this(drawingEditor, 400, 300);
    }

    public ZoomDrawingView(DrawingEditor drawingEditor, int n, int n2) {
        super(drawingEditor, n, n2);
    }

    public final double getScale() {
        return this.scale;
    }

    private void setScale(double d) {
        Dimension dimension = this.getUserSize();
        this.scale = d;
        this.setUserSize(dimension.width, dimension.height);
        this.centralize(this.drawing());
        this.forceRedraw();
    }

    private void forceRedraw() {
        this.drawingInvalidated(new DrawingChangeEvent(this.drawing(), new Rectangle(this.getSize())));
        this.repairDamage();
    }

    public void setUserSize(int n, int n2) {
        this.setSize((int)((double)n * this.getScale()), (int)((double)n2 * this.getScale()));
    }

    public void setUserSize(Dimension dimension) {
        this.setUserSize(dimension.width, dimension.height);
    }

    public Dimension getSize() {
        return super.getSize();
    }

    public Dimension getViewportSize() {
        return this.getParent().getSize();
    }

    protected boolean hasZoomSupport() {
        return this.getParent() instanceof JViewport;
    }

    public void setOriginPosition(Point point) {
        this.setViewPosition(point);
        this.forceRedraw();
    }

    protected void setViewPosition(Point point) {
        ((JViewport)this.getParent()).setViewPosition(point);
    }

    public Dimension getUserSize() {
        Dimension dimension = this.getSize();
        return new Dimension((int)((double)dimension.width / this.getScale()), (int)((double)dimension.height / this.getScale()));
    }

    public void zoom(int n, int n2, int n3, int n4) {
        if (!this.hasZoomSupport()) {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        Dimension dimension = this.getViewportSize();
        double d = (double)dimension.width / (double)n3;
        double d2 = (double)dimension.height / (double)n4;
        double d3 = Math.min(d, d2);
        Dimension dimension2 = this.getUserSize();
        this.scale = d3;
        this.setUserSize(dimension2);
        this.revalidate();
        this.setViewPosition(new Point((int)((double)n * this.getScale()), (int)((double)n2 * this.getScale())));
        this.forceRedraw();
    }

    public void zoom(float f) {
        int n;
        int n2;
        Dimension dimension;
        JViewport jViewport;
        if (this.hasZoomSupport()) {
            jViewport = (JViewport)this.getParent();
            Dimension dimension2 = jViewport.getSize();
            dimension = this.getUserSize();
            this.scale = f;
            Point point = jViewport.getViewPosition();
            point.x += dimension2.width / 2;
            point.y += dimension2.height / 2;
            int n3 = (int)((double)point.x * this.scale);
            int n4 = (int)((double)point.y * this.scale);
            n2 = n3 - dimension2.width / 2;
            n = n4 - dimension2.height / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 0) {
                n = 0;
            }
        } else {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.setUserSize(dimension);
        this.revalidate();
        jViewport.setViewPosition(new Point(n2, n));
        this.forceRedraw();
    }

    public void zoomOut(int n, int n2) {
        int n3;
        int n4;
        Dimension dimension;
        if (this.hasZoomSupport()) {
            Dimension dimension2 = this.getViewportSize();
            dimension = this.getUserSize();
            this.scale = this.getScale() / this.getZoomSpeed();
            int n5 = (int)((double)n * this.getScale());
            int n6 = (int)((double)n2 * this.getScale());
            n4 = n5 - dimension2.width / 2;
            n3 = n6 - dimension2.height / 2;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
        } else {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.setUserSize(dimension);
        this.revalidate();
        this.setViewPosition(new Point(n4, n3));
        this.forceRedraw();
    }

    public void zoomIn(int n, int n2) {
        int n3;
        int n4;
        Dimension dimension;
        JViewport jViewport;
        if (this.hasZoomSupport()) {
            jViewport = (JViewport)this.getParent();
            Dimension dimension2 = jViewport.getSize();
            dimension = this.getUserSize();
            this.scale = this.getScale() * this.getZoomSpeed();
            int n5 = (int)((double)n * this.getScale());
            int n6 = (int)((double)n2 * this.getScale());
            n4 = n5 - dimension2.width / 2;
            n3 = n6 - dimension2.height / 2;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
        } else {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.setUserSize(dimension);
        this.revalidate();
        jViewport.setViewPosition(new Point(n4, n3));
        this.forceRedraw();
    }

    public void deZoom(int n, int n2) {
        int n3;
        int n4;
        Dimension dimension;
        if (this.hasZoomSupport()) {
            Dimension dimension2 = this.getViewportSize();
            dimension = this.getUserSize();
            n4 = n - dimension2.width / 2;
            n3 = n2 - dimension2.height / 2;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
        } else {
            throw new RuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.scale = 1.0;
        this.setUserSize(dimension);
        this.revalidate();
        this.setViewPosition(new Point(n4, n3));
        this.forceRedraw();
    }

    public void paint(Graphics graphics) {
        super.paint(this.transformGraphics(graphics, this.getScale()));
    }

    public Graphics getGraphics() {
        return this.transformGraphics(super.getGraphics(), this.getScale());
    }

    private final Graphics transformGraphics(Graphics graphics, double d) {
        if (d != 1.0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.transform(AffineTransform.getScaleInstance(d, d));
        }
        return graphics;
    }

    protected Point constrainPoint(Point point) {
        Dimension dimension = this.getSize();
        point.x = Geom.range(1, (int)((double)dimension.width / this.getScale()), point.x);
        point.y = Geom.range(1, (int)((double)dimension.height / this.getScale()), point.y);
        if (this.getConstrainer() != null) {
            return this.getConstrainer().constrainPoint(point);
        }
        return point;
    }

    public void drawBackground(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, (int)((double)this.getBounds().width / this.getScale()), (int)((double)this.getBounds().height / this.getScale()));
    }

    private void centralize(Drawing drawing, Dimension dimension) {
        Point point = new Point(dimension.width / 2, dimension.height / 2);
        Rectangle rectangle = ((StandardDrawing)drawing).displayBox();
        Point point2 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        if (n != 0 || n2 != 0) {
            FigureEnumeration figureEnumeration = drawing.figures();
            while (figureEnumeration.hasNextFigure()) {
                figureEnumeration.nextFigure().moveBy(n, n2);
            }
        }
    }

    private void centralize(Drawing drawing) {
        this.centralize(drawing, this.getUserSize());
    }

    public void setDrawing(Drawing drawing) {
        super.setDrawing(drawing);
        Rectangle rectangle = ((StandardDrawing)drawing).displayBox();
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        if (this.getParent() != null) {
            dimension = this.getViewportSize();
        }
        super.setPreferredSize(dimension);
        super.setSize(dimension);
        this.revalidate();
    }

    public Dimension getMinimumSize() {
        return super.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void repairDamage() {
        Rectangle rectangle = this.getDamage();
        if (rectangle != null) {
            this.repaint((int)((double)rectangle.x * this.getScale()), (int)((double)rectangle.y * this.getScale()), (int)((double)rectangle.width * this.getScale()), (int)((double)rectangle.height * this.getScale()));
            this.setDamage(null);
        }
    }

    public void drawingInvalidated(DrawingChangeEvent drawingChangeEvent) {
        Rectangle rectangle = drawingChangeEvent.getInvalidatedRectangle();
        if (this.getDamage() == null) {
            this.setDamage(rectangle);
        } else {
            Rectangle rectangle2 = this.getDamage();
            rectangle2.add(rectangle);
            this.setDamage(rectangle2);
        }
    }

    private MouseEvent createScaledEvent(MouseEvent mouseEvent) {
        return new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (int)((double)mouseEvent.getX() / this.getScale()), (int)((double)mouseEvent.getY() / this.getScale()), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    protected MouseListener createMouseListener() {
        return new StandardDrawingView.DrawingViewMouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(ZoomDrawingView.this.createScaledEvent(mouseEvent));
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(ZoomDrawingView.this.createScaledEvent(mouseEvent));
            }
        };
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new StandardDrawingView.DrawingViewMouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                super.mouseDragged(ZoomDrawingView.this.createScaledEvent(mouseEvent));
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                super.mouseMoved(ZoomDrawingView.this.createScaledEvent(mouseEvent));
            }
        };
    }

    protected KeyListener createKeyListener() {
        return new StandardDrawingView.DrawingViewKeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                super.keyPressed(keyEvent);
                if (keyEvent.getKeyChar() == ' ') {
                    ZoomDrawingView.this.forceRedraw();
                } else if (keyEvent.getKeyChar() == 'o') {
                    ZoomDrawingView.this.setScale(ZoomDrawingView.this.getScale() / ZoomDrawingView.this.getZoomSpeed());
                } else if (keyEvent.getKeyChar() == 'i') {
                    ZoomDrawingView.this.setScale(ZoomDrawingView.this.getScale() * ZoomDrawingView.this.getZoomSpeed());
                } else if (keyEvent.getKeyChar() == 'c') {
                    ZoomDrawingView.this.centralize(ZoomDrawingView.this.drawing());
                } else {
                    super.keyPressed(keyEvent);
                }
            }
        };
    }

    public double getZoomSpeed() {
        return this.zoomSpeed;
    }

    public void setZoomSpeed(double d) {
        this.zoomSpeed = Math.max(1.1, d);
    }
}

