# PySNMP SMI module. Autogenerated from smidump -f python HOST-RESOURCES-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:03 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mib-2")
( AutonomousType, DateAndTime, DisplayString, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "DateAndTime", "DisplayString", "TextualConvention", "TruthValue")

# Types

class InternationalDisplayString(OctetString):
    pass

class KBytes(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)
    
class ProductID(ObjectIdentifier):
    pass


# Objects

host = MibIdentifier((1, 3, 6, 1, 2, 1, 25))
hrSystem = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 1))
hrSystemUptime = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 1), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemUptime.setDescription("The amount of time since this host was last\ninitialized.  Note that this is different from\nsysUpTime in the SNMPv2-MIB [RFC1907] because\nsysUpTime is the uptime of the network management\nportion of the system.")
hrSystemDate = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 2), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSystemDate.setDescription("The host's notion of the local date and time of day.")
hrSystemInitialLoadDevice = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSystemInitialLoadDevice.setDescription("The index of the hrDeviceEntry for the device from\nwhich this host is configured to load its initial\noperating system configuration (i.e., which operating\nsystem code and/or boot parameters).\n\nNote that writing to this object just changes the\nconfiguration that will be used the next time the\noperating system is loaded and does not actually cause\nthe reload to occur.")
hrSystemInitialLoadParameters = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 4), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSystemInitialLoadParameters.setDescription("This object contains the parameters (e.g. a pathname\nand parameter) supplied to the load device when\nrequesting the initial operating system configuration\nfrom that device.\n\nNote that writing to this object just changes the\nconfiguration that will be used the next time the\noperating system is loaded and does not actually cause\nthe reload to occur.")
hrSystemNumUsers = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemNumUsers.setDescription("The number of user sessions for which this host is\nstoring state information.  A session is a collection\nof processes requiring a single act of user\nauthentication and possibly subject to collective job\ncontrol.")
hrSystemProcesses = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemProcesses.setDescription("The number of process contexts currently loaded or\nrunning on this system.")
hrSystemMaxProcesses = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemMaxProcesses.setDescription("The maximum number of process contexts this system\ncan support.  If there is no fixed maximum, the value\nshould be zero.  On systems that have a fixed maximum,\nthis object can help diagnose failures that occur when\nthis maximum is reached.")
hrStorage = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 2))
hrStorageTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 2, 1))
hrMemorySize = MibScalar((1, 3, 6, 1, 2, 1, 25, 2, 2), KBytes()).setMaxAccess("readonly").setUnits("KBytes")
if mibBuilder.loadTexts: hrMemorySize.setDescription("The amount of physical read-write main memory,\ntypically RAM, contained by the host.")
hrStorageTable = MibTable((1, 3, 6, 1, 2, 1, 25, 2, 3))
if mibBuilder.loadTexts: hrStorageTable.setDescription("The (conceptual) table of logical storage areas on\nthe host.\n\nAn entry shall be placed in the storage table for each\nlogical area of storage that is allocated and has\nfixed resource limits.  The amount of storage\nrepresented in an entity is the amount actually usable\nby the requesting entity, and excludes loss due to\nformatting or file system reference information.\n\nThese entries are associated with logical storage\nareas, as might be seen by an application, rather than\nphysical storage entities which are typically seen by\nan operating system.  Storage such as tapes and\nfloppies without file systems on them are typically\nnot allocated in chunks by the operating system to\nrequesting applications, and therefore shouldn't\nappear in this table.  Examples of valid storage for\nthis table include disk partitions, file systems, ram\n(for some architectures this is further segmented into\nregular memory, extended memory, and so on), backing\nstore for virtual memory (`swap space').\n\nThis table is intended to be a useful diagnostic for\n`out of memory' and `out of buffers' types of\nfailures.  In addition, it can be a useful performance\nmonitoring tool for tracking memory, disk, or buffer\nusage.")
hrStorageEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 2, 3, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrStorageIndex"))
if mibBuilder.loadTexts: hrStorageEntry.setDescription("A (conceptual) entry for one logical storage area on\nthe host.  As an example, an instance of the\nhrStorageType object might be named hrStorageType.3")
hrStorageIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageIndex.setDescription("A unique value for each logical storage area\ncontained by the host.")
hrStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageType.setDescription("The type of storage represented by this entry.")
hrStorageDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 3), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageDescr.setDescription("A description of the type and instance of the storage\ndescribed by this entry.")
hrStorageAllocationUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageAllocationUnits.setDescription("The size, in bytes, of the data objects allocated\nfrom this pool.  If this entry is monitoring sectors,\nblocks, buffers, or packets, for example, this number\nwill commonly be greater than one.  Otherwise this\nnumber will typically be one.")
hrStorageSize = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrStorageSize.setDescription("The size of the storage represented by this entry, in\nunits of hrStorageAllocationUnits. This object is\nwritable to allow remote configuration of the size of\nthe storage area in those cases where such an\noperation makes sense and is possible on the\nunderlying system. For example, the amount of main\nmemory allocated to a buffer pool might be modified or\nthe amount of disk space allocated to virtual memory\nmight be modified.")
hrStorageUsed = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageUsed.setDescription("The amount of the storage represented by this entry\nthat is allocated, in units of\nhrStorageAllocationUnits.")
hrStorageAllocationFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageAllocationFailures.setDescription("The number of requests for storage represented by\nthis entry that could not be honored due to not enough\nstorage.  It should be noted that as this object has a\nSYNTAX of Counter32, that it does not have a defined\ninitial value.  However, it is recommended that this\nobject be initialized to zero, even though management\nstations must not depend on such an initialization.")
hrDevice = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 3))
hrDeviceTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 3, 1))
hrDeviceTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 2))
if mibBuilder.loadTexts: hrDeviceTable.setDescription("The (conceptual) table of devices contained by the\nhost.")
hrDeviceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 2, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrDeviceEntry.setDescription("A (conceptual) entry for one device contained by the\nhost.  As an example, an instance of the hrDeviceType\nobject might be named hrDeviceType.3")
hrDeviceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceIndex.setDescription("A unique value for each device contained by the host.\nThe value for each device must remain constant at\nleast from one re-initialization of the agent to the\nnext re-initialization.")
hrDeviceType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceType.setDescription("An indication of the type of device.\n\nIf this value is\n`hrDeviceProcessor { hrDeviceTypes 3 }' then an entry\nexists in the hrProcessorTable which corresponds to\nthis device.\n\nIf this value is\n`hrDeviceNetwork { hrDeviceTypes 4 }', then an entry\nexists in the hrNetworkTable which corresponds to this\ndevice.\n\nIf this value is\n`hrDevicePrinter { hrDeviceTypes 5 }', then an entry\nexists in the hrPrinterTable which corresponds to this\ndevice.\n\nIf this value is\n`hrDeviceDiskStorage { hrDeviceTypes 6 }', then an\nentry exists in the hrDiskStorageTable which\ncorresponds to this device.")
hrDeviceDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceDescr.setDescription("A textual description of this device, including the\ndevice's manufacturer and revision, and optionally,\nits serial number.")
hrDeviceID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 4), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceID.setDescription("The product ID for this device.")
hrDeviceStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,5,2,3,)).subtype(namedValues=NamedValues(("unknown", 1), ("running", 2), ("warning", 3), ("testing", 4), ("down", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceStatus.setDescription("The current operational state of the device described\nby this row of the table.  A value unknown(1)\nindicates that the current state of the device is\nunknown.  running(2) indicates that the device is up\nand running and that no unusual error conditions are\nknown.  The warning(3) state indicates that agent has\nbeen informed of an unusual error condition by the\noperational software (e.g., a disk device driver) but\nthat the device is still 'operational'.  An example\nwould be a high number of soft errors on a disk.  A\nvalue of testing(4), indicates that the device is not\navailable for use because it is in the testing state.\nThe state of down(5) is used only when the agent has\nbeen informed that the device is not available for any\nuse.")
hrDeviceErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceErrors.setDescription("The number of errors detected on this device.  It\nshould be noted that as this object has a SYNTAX of\nCounter32, that it does not have a defined initial\nvalue.  However, it is recommended that this object be\ninitialized to zero, even though management stations\nmust not depend on such an initialization.")
hrProcessorTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 3))
if mibBuilder.loadTexts: hrProcessorTable.setDescription("The (conceptual) table of processors contained by the\nhost.\n\nNote that this table is potentially sparse: a\n(conceptual) entry exists only if the correspondent\nvalue of the hrDeviceType object is\n`hrDeviceProcessor'.")
hrProcessorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 3, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrProcessorEntry.setDescription("A (conceptual) entry for one processor contained by\nthe host.  The hrDeviceIndex in the index represents\nthe entry in the hrDeviceTable that corresponds to the\nhrProcessorEntry.\n\nAs an example of how objects in this table are named,\nan instance of the hrProcessorFrwID object might be\nnamed hrProcessorFrwID.3")
hrProcessorFrwID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 3, 1, 1), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrProcessorFrwID.setDescription("The product ID of the firmware associated with the\nprocessor.")
hrProcessorLoad = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrProcessorLoad.setDescription("The average, over the last minute, of the percentage\nof time that this processor was not idle.\nImplementations may approximate this one minute\nsmoothing period if necessary.")
hrNetworkTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 4))
if mibBuilder.loadTexts: hrNetworkTable.setDescription("The (conceptual) table of network devices contained\nby the host.\nNote that this table is potentially sparse: a\n(conceptual) entry exists only if the correspondent\nvalue of the hrDeviceType object is\n`hrDeviceNetwork'.")
hrNetworkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 4, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrNetworkEntry.setDescription("A (conceptual) entry for one network device contained\nby the host.  The hrDeviceIndex in the index\nrepresents the entry in the hrDeviceTable that\ncorresponds to the hrNetworkEntry.\n\nAs an example of how objects in this table are named,\nan instance of the hrNetworkIfIndex object might be\nnamed hrNetworkIfIndex.3")
hrNetworkIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 4, 1, 1), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrNetworkIfIndex.setDescription("The value of ifIndex which corresponds to this\nnetwork device. If this device is not represented in\nthe ifTable, then this value shall be zero.")
hrPrinterTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 5))
if mibBuilder.loadTexts: hrPrinterTable.setDescription("The (conceptual) table of printers local to the host.\n\nNote that this table is potentially sparse: a\n(conceptual) entry exists only if the correspondent\nvalue of the hrDeviceType object is\n`hrDevicePrinter'.")
hrPrinterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 5, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrPrinterEntry.setDescription("A (conceptual) entry for one printer local to the\nhost.  The hrDeviceIndex in the index represents the\nentry in the hrDeviceTable that corresponds to the\nhrPrinterEntry.\n\nAs an example of how objects in this table are named,\nan instance of the hrPrinterStatus object might be\nnamed hrPrinterStatus.3")
hrPrinterStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 5, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(5,2,4,3,1,)).subtype(namedValues=NamedValues(("other", 1), ("unknown", 2), ("idle", 3), ("printing", 4), ("warmup", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPrinterStatus.setDescription("The current status of this printer device.")
hrPrinterDetectedErrorState = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 5, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPrinterDetectedErrorState.setDescription("This object represents any error conditions detected\nby the printer.  The error conditions are encoded as\nbits in an octet string, with the following\ndefinitions:\n\n     Condition         Bit #\n\n     lowPaper              0\n     noPaper               1\n     lowToner              2\n     noToner               3\n     doorOpen              4\n     jammed                5\n     offline               6\n     serviceRequested      7\n     inputTrayMissing      8\n     outputTrayMissing     9\n     markerSupplyMissing  10\n     outputNearFull       11\n     outputFull           12\n     inputTrayEmpty       13\n     overduePreventMaint  14\n\nBits are numbered starting with the most significant\nbit of the first byte being bit 0, the least\nsignificant bit of the first byte being bit 7, the\nmost significant bit of the second byte being bit 8,\nand so on.  A one bit encodes that the condition was\ndetected, while a zero bit encodes that the condition\nwas not detected.\n\nThis object is useful for alerting an operator to\nspecific warning or error conditions that may occur,\nespecially those requiring human intervention.")
hrDiskStorageTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 6))
if mibBuilder.loadTexts: hrDiskStorageTable.setDescription("The (conceptual) table of long-term storage devices\ncontained by the host.  In particular, disk devices\naccessed remotely over a network are not included\nhere.\n\nNote that this table is potentially sparse: a\n(conceptual) entry exists only if the correspondent\nvalue of the hrDeviceType object is\n`hrDeviceDiskStorage'.")
hrDiskStorageEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 6, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrDiskStorageEntry.setDescription("A (conceptual) entry for one long-term storage device\ncontained by the host.  The hrDeviceIndex in the index\nrepresents the entry in the hrDeviceTable that\ncorresponds to the hrDiskStorageEntry. As an example,\nan instance of the hrDiskStorageCapacity object might\nbe named hrDiskStorageCapacity.3")
hrDiskStorageAccess = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("readWrite", 1), ("readOnly", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageAccess.setDescription("An indication if this long-term storage device is\nreadable and writable or only readable.  This should\nreflect the media type, any write-protect mechanism,\nand any device configuration that affects the entire\ndevice.")
hrDiskStorageMedia = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(8,5,1,7,2,3,6,4,)).subtype(namedValues=NamedValues(("other", 1), ("unknown", 2), ("hardDisk", 3), ("floppyDisk", 4), ("opticalDiskROM", 5), ("opticalDiskWORM", 6), ("opticalDiskRW", 7), ("ramDisk", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageMedia.setDescription("An indication of the type of media used in this long-\nterm storage device.")
hrDiskStorageRemoveble = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageRemoveble.setDescription("Denotes whether or not the disk media may be removed\nfrom the drive.")
hrDiskStorageCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 4), KBytes()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageCapacity.setDescription("The total size for this long-term storage device. If\nthe media is removable and is currently removed, this\nvalue should be zero.")
hrPartitionTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 7))
if mibBuilder.loadTexts: hrPartitionTable.setDescription("The (conceptual) table of partitions for long-term\nstorage devices contained by the host.  In particular,\npartitions accessed remotely over a network are not\nincluded here.")
hrPartitionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 7, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "HOST-RESOURCES-MIB", "hrPartitionIndex"))
if mibBuilder.loadTexts: hrPartitionEntry.setDescription("A (conceptual) entry for one partition.  The\nhrDeviceIndex in the index represents the entry in the\nhrDeviceTable that corresponds to the\nhrPartitionEntry.\n\nAs an example of how objects in this table are named,\nan instance of the hrPartitionSize object might be\nnamed hrPartitionSize.3.1")
hrPartitionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionIndex.setDescription("A unique value for each partition on this long-term\nstorage device.  The value for each long-term storage\ndevice must remain constant at least from one re-\ninitialization of the agent to the next re-\ninitialization.")
hrPartitionLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionLabel.setDescription("A textual description of this partition.")
hrPartitionID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 3), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionID.setDescription("A descriptor which uniquely represents this partition\nto the responsible operating system.  On some systems,\nthis might take on a binary representation.")
hrPartitionSize = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 4), KBytes()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionSize.setDescription("The size of this partition.")
hrPartitionFSIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionFSIndex.setDescription("The index of the file system mounted on this\npartition.  If no file system is mounted on this\npartition, then this value shall be zero.  Note that\nmultiple partitions may point to one file system,\ndenoting that that file system resides on those\npartitions.  Multiple file systems may not reside on\none partition.")
hrFSTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 8))
if mibBuilder.loadTexts: hrFSTable.setDescription("The (conceptual) table of file systems local to this\nhost or remotely mounted from a file server.  File\nsystems that are in only one user's environment on a\nmulti-user system will not be included in this table.")
hrFSEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 8, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrFSIndex"))
if mibBuilder.loadTexts: hrFSEntry.setDescription("A (conceptual) entry for one file system local to\nthis host or remotely mounted from a file server.\nFile systems that are in only one user's environment\non a multi-user system will not be included in this\ntable.\n\nAs an example of how objects in this table are named,\nan instance of the hrFSMountPoint object might be\nnamed hrFSMountPoint.3")
hrFSIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSIndex.setDescription("A unique value for each file system local to this\nhost.  The value for each file system must remain\nconstant at least from one re-initialization of the\nagent to the next re-initialization.")
hrFSMountPoint = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSMountPoint.setDescription("The path name of the root of this file system.")
hrFSRemoteMountPoint = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 3), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSRemoteMountPoint.setDescription("A description of the name and/or address of the\nserver that this file system is mounted from.  This\nmay also include parameters such as the mount point on\nthe remote file system.  If this is not a remote file\nsystem, this string should have a length of zero.")
hrFSType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 4), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSType.setDescription("The value of this object identifies the type of this\nfile system.")
hrFSAccess = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("readWrite", 1), ("readOnly", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSAccess.setDescription("An indication if this file system is logically\nconfigured by the operating system to be readable and\nwritable or only readable.  This does not represent\nany local access-control policy, except one that is\napplied to the file system as a whole.")
hrFSBootable = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSBootable.setDescription("A flag indicating whether this file system is\nbootable.")
hrFSStorageIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSStorageIndex.setDescription("The index of the hrStorageEntry that represents\ninformation about this file system.  If there is no\nsuch information available, then this value shall be\nzero.  The relevant storage entry will be useful in\ntracking the percent usage of this file system and\ndiagnosing errors that may occur when it runs out of\nspace.")
hrFSLastFullBackupDate = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 8), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrFSLastFullBackupDate.setDescription("The last date at which this complete file system was\ncopied to another storage device for backup.  This\ninformation is useful for ensuring that backups are\nbeing performed regularly.\n\nIf this information is not known, then this variable\nshall have the value corresponding to January 1, year\n0000, 00:00:00.0, which is encoded as\n(hex)'00 00 01 01 00 00 00 00'.")
hrFSLastPartialBackupDate = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 9), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrFSLastPartialBackupDate.setDescription("The last date at which a portion of this file system\nwas copied to another storage device for backup.  This\ninformation is useful for ensuring that backups are\nbeing performed regularly.\n\nIf this information is not known, then this variable\nshall have the value corresponding to January 1, year\n0000, 00:00:00.0, which is encoded as\n(hex)'00 00 01 01 00 00 00 00'.")
hrFSTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 3, 9))
hrSWRun = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 4))
hrSWOSIndex = MibScalar((1, 3, 6, 1, 2, 1, 25, 4, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWOSIndex.setDescription("The value of the hrSWRunIndex for the hrSWRunEntry\nthat represents the primary operating system running\non this host.  This object is useful for quickly and\nuniquely identifying that primary operating system.")
hrSWRunTable = MibTable((1, 3, 6, 1, 2, 1, 25, 4, 2))
if mibBuilder.loadTexts: hrSWRunTable.setDescription("The (conceptual) table of software running on the\nhost.")
hrSWRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 4, 2, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrSWRunIndex"))
if mibBuilder.loadTexts: hrSWRunEntry.setDescription("A (conceptual) entry for one piece of software\nrunning on the host Note that because the installed\nsoftware table only contains information for software\nstored locally on this host, not every piece of\nrunning software will be found in the installed\nsoftware table.  This is true of software that was\nloaded and run from a non-local source, such as a\nnetwork-mounted file system.\n\nAs an example of how objects in this table are named,\nan instance of the hrSWRunName object might be named\nhrSWRunName.1287")
hrSWRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunIndex.setDescription("A unique value for each piece of software running on\nthe host.  Wherever possible, this should be the\nsystem's native, unique identification number.")
hrSWRunName = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunName.setDescription("A textual description of this running piece of\nsoftware, including the manufacturer, revision,  and\nthe name by which it is commonly known.  If this\nsoftware was installed locally, this should be the\nsame string as used in the corresponding\nhrSWInstalledName.")
hrSWRunID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 3), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunID.setDescription("The product ID of this running piece of software.")
hrSWRunPath = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 4), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunPath.setDescription("A description of the location on long-term storage\n(e.g. a disk drive) from which this software was\nloaded.")
hrSWRunParameters = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 5), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunParameters.setDescription("A description of the parameters supplied to this\nsoftware when it was initially loaded.")
hrSWRunType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,4,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("operatingSystem", 2), ("deviceDriver", 3), ("application", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunType.setDescription("The type of this software.")
hrSWRunStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,4,)).subtype(namedValues=NamedValues(("running", 1), ("runnable", 2), ("notRunnable", 3), ("invalid", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSWRunStatus.setDescription("The status of this running piece of software.\nSetting this value to invalid(4) shall cause this\nsoftware to stop running and to be unloaded. Sets to\nother values are not valid.")
hrSWRunPerf = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 5))
hrSWRunPerfTable = MibTable((1, 3, 6, 1, 2, 1, 25, 5, 1))
if mibBuilder.loadTexts: hrSWRunPerfTable.setDescription("The (conceptual) table of running software\nperformance metrics.")
hrSWRunPerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 5, 1, 1))
if mibBuilder.loadTexts: hrSWRunPerfEntry.setDescription("A (conceptual) entry containing software performance\nmetrics.  As an example, an instance of the\nhrSWRunPerfCPU object might be named\nhrSWRunPerfCPU.1287")
hrSWRunPerfCPU = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 5, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunPerfCPU.setDescription("The number of centi-seconds of the total system's CPU\nresources consumed by this process.  Note that on a\nmulti-processor system, this value may increment by\nmore than one centi-second in one centi-second of real\n(wall clock) time.")
hrSWRunPerfMem = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 5, 1, 1, 2), KBytes()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunPerfMem.setDescription("The total amount of real system memory allocated to\nthis process.")
hrSWInstalled = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 6))
hrSWInstalledLastChange = MibScalar((1, 3, 6, 1, 2, 1, 25, 6, 1), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledLastChange.setDescription("The value of sysUpTime when an entry in the\nhrSWInstalledTable was last added, renamed, or\ndeleted.  Because this table is likely to contain many\nentries, polling of this object allows a management\nstation to determine when re-downloading of the table\nmight be useful.")
hrSWInstalledLastUpdateTime = MibScalar((1, 3, 6, 1, 2, 1, 25, 6, 2), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledLastUpdateTime.setDescription("The value of sysUpTime when the hrSWInstalledTable\nwas last completely updated.  Because caching of this\ndata will be a popular implementation strategy,\nretrieval of this object allows a management station\nto obtain a guarantee that no data in this table is\nolder than the indicated time.")
hrSWInstalledTable = MibTable((1, 3, 6, 1, 2, 1, 25, 6, 3))
if mibBuilder.loadTexts: hrSWInstalledTable.setDescription("The (conceptual) table of software installed on this\nhost.")
hrSWInstalledEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 6, 3, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrSWInstalledIndex"))
if mibBuilder.loadTexts: hrSWInstalledEntry.setDescription("A (conceptual) entry for a piece of software\ninstalled on this host.\n\nAs an example of how objects in this table are named,\nan instance of the hrSWInstalledName object might be\nnamed hrSWInstalledName.96")
hrSWInstalledIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledIndex.setDescription("A unique value for each piece of software installed\non the host.  This value shall be in the range from 1\nto the number of pieces of software installed on the\nhost.")
hrSWInstalledName = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledName.setDescription("A textual description of this installed piece of\nsoftware, including the manufacturer, revision, the\nname by which it is commonly known, and optionally,\nits serial number.")
hrSWInstalledID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 3), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledID.setDescription("The product ID of this installed piece of software.")
hrSWInstalledType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,4,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("operatingSystem", 2), ("deviceDriver", 3), ("application", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledType.setDescription("The type of this software.")
hrSWInstalledDate = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledDate.setDescription("The last-modification date of this application as it\nwould appear in a directory listing.\n\nIf this information is not known, then this variable\nshall have the value corresponding to January 1, year\n0000, 00:00:00.0, which is encoded as\n(hex)'00 00 01 01 00 00 00 00'.")
hrMIBAdminInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 7))
hostResourcesMibModule = ModuleIdentity((1, 3, 6, 1, 2, 1, 25, 7, 1)).setRevisions(("2000-03-06 00:00","1999-10-20 22:00",))
if mibBuilder.loadTexts: hostResourcesMibModule.setOrganization("IETF Host Resources MIB Working Group")
if mibBuilder.loadTexts: hostResourcesMibModule.setContactInfo("Steve Waldbusser\nPostal: Lucent Technologies, Inc.\n        1213 Innsbruck Dr.\n        Sunnyvale, CA 94089\n        USA\nPhone:  650-318-1251\nFax:    650-318-1633\nEmail:  waldbusser@lucent.com\nIn addition, the Host Resources MIB mailing list is\ndedicated to discussion of this MIB. To join the\nmailing list, send a request message to\nhostmib-request@andrew.cmu.edu. The mailing list\naddress is hostmib@andrew.cmu.edu.")
if mibBuilder.loadTexts: hostResourcesMibModule.setDescription("This MIB is for use in managing host systems. The term\n`host' is construed to mean any computer that communicates\nwith other similar computers attached to the internet and\nthat is directly used by one or more human beings. Although\nthis MIB does not necessarily apply to devices whose primary\nfunction is communications services (e.g., terminal servers,\nrouters, bridges, monitoring equipment), such relevance is\nnot explicitly precluded.  This MIB instruments attributes\ncommon to all internet hosts including, for example, both\npersonal computers and systems that run variants of Unix.")
hrMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 7, 2))
hrMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 7, 3))

# Augmentions
hrSWRunEntry.registerAugmentions(("HOST-RESOURCES-MIB", "hrSWRunPerfEntry"))
hrSWRunPerfEntry.setIndexNames(*hrSWRunEntry.getIndexNames())

# Groups

hrSystemGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 1)).setObjects(*(("HOST-RESOURCES-MIB", "hrSystemMaxProcesses"), ("HOST-RESOURCES-MIB", "hrSystemDate"), ("HOST-RESOURCES-MIB", "hrSystemUptime"), ("HOST-RESOURCES-MIB", "hrSystemNumUsers"), ("HOST-RESOURCES-MIB", "hrSystemProcesses"), ("HOST-RESOURCES-MIB", "hrSystemInitialLoadParameters"), ("HOST-RESOURCES-MIB", "hrSystemInitialLoadDevice"), ) )
if mibBuilder.loadTexts: hrSystemGroup.setDescription("The Host Resources System Group.")
hrStorageGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 2)).setObjects(*(("HOST-RESOURCES-MIB", "hrStorageUsed"), ("HOST-RESOURCES-MIB", "hrStorageAllocationFailures"), ("HOST-RESOURCES-MIB", "hrStorageSize"), ("HOST-RESOURCES-MIB", "hrMemorySize"), ("HOST-RESOURCES-MIB", "hrStorageIndex"), ("HOST-RESOURCES-MIB", "hrStorageAllocationUnits"), ("HOST-RESOURCES-MIB", "hrStorageDescr"), ("HOST-RESOURCES-MIB", "hrStorageType"), ) )
if mibBuilder.loadTexts: hrStorageGroup.setDescription("The Host Resources Storage Group.")
hrDeviceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 3)).setObjects(*(("HOST-RESOURCES-MIB", "hrFSIndex"), ("HOST-RESOURCES-MIB", "hrFSMountPoint"), ("HOST-RESOURCES-MIB", "hrPrinterStatus"), ("HOST-RESOURCES-MIB", "hrPartitionID"), ("HOST-RESOURCES-MIB", "hrDiskStorageCapacity"), ("HOST-RESOURCES-MIB", "hrProcessorLoad"), ("HOST-RESOURCES-MIB", "hrFSRemoteMountPoint"), ("HOST-RESOURCES-MIB", "hrDiskStorageMedia"), ("HOST-RESOURCES-MIB", "hrDeviceDescr"), ("HOST-RESOURCES-MIB", "hrDeviceStatus"), ("HOST-RESOURCES-MIB", "hrNetworkIfIndex"), ("HOST-RESOURCES-MIB", "hrFSBootable"), ("HOST-RESOURCES-MIB", "hrPartitionIndex"), ("HOST-RESOURCES-MIB", "hrDeviceID"), ("HOST-RESOURCES-MIB", "hrDiskStorageRemoveble"), ("HOST-RESOURCES-MIB", "hrFSLastPartialBackupDate"), ("HOST-RESOURCES-MIB", "hrPrinterDetectedErrorState"), ("HOST-RESOURCES-MIB", "hrFSType"), ("HOST-RESOURCES-MIB", "hrProcessorFrwID"), ("HOST-RESOURCES-MIB", "hrPartitionFSIndex"), ("HOST-RESOURCES-MIB", "hrDeviceErrors"), ("HOST-RESOURCES-MIB", "hrDeviceType"), ("HOST-RESOURCES-MIB", "hrPartitionLabel"), ("HOST-RESOURCES-MIB", "hrFSStorageIndex"), ("HOST-RESOURCES-MIB", "hrFSAccess"), ("HOST-RESOURCES-MIB", "hrPartitionSize"), ("HOST-RESOURCES-MIB", "hrFSLastFullBackupDate"), ("HOST-RESOURCES-MIB", "hrDeviceIndex"), ("HOST-RESOURCES-MIB", "hrDiskStorageAccess"), ) )
if mibBuilder.loadTexts: hrDeviceGroup.setDescription("The Host Resources Device Group.")
hrSWRunGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 4)).setObjects(*(("HOST-RESOURCES-MIB", "hrSWOSIndex"), ("HOST-RESOURCES-MIB", "hrSWRunParameters"), ("HOST-RESOURCES-MIB", "hrSWRunType"), ("HOST-RESOURCES-MIB", "hrSWRunIndex"), ("HOST-RESOURCES-MIB", "hrSWRunID"), ("HOST-RESOURCES-MIB", "hrSWRunStatus"), ("HOST-RESOURCES-MIB", "hrSWRunName"), ("HOST-RESOURCES-MIB", "hrSWRunPath"), ) )
if mibBuilder.loadTexts: hrSWRunGroup.setDescription("The Host Resources Running Software Group.")
hrSWRunPerfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 5)).setObjects(*(("HOST-RESOURCES-MIB", "hrSWRunPerfCPU"), ("HOST-RESOURCES-MIB", "hrSWRunPerfMem"), ) )
if mibBuilder.loadTexts: hrSWRunPerfGroup.setDescription("The Host Resources Running Software\nPerformance Group.")
hrSWInstalledGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 6)).setObjects(*(("HOST-RESOURCES-MIB", "hrSWInstalledLastChange"), ("HOST-RESOURCES-MIB", "hrSWInstalledID"), ("HOST-RESOURCES-MIB", "hrSWInstalledIndex"), ("HOST-RESOURCES-MIB", "hrSWInstalledLastUpdateTime"), ("HOST-RESOURCES-MIB", "hrSWInstalledName"), ("HOST-RESOURCES-MIB", "hrSWInstalledDate"), ("HOST-RESOURCES-MIB", "hrSWInstalledType"), ) )
if mibBuilder.loadTexts: hrSWInstalledGroup.setDescription("The Host Resources Installed Software Group.")

# Compliances

hrMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 25, 7, 2, 1)).setObjects(*(("HOST-RESOURCES-MIB", "hrStorageGroup"), ("HOST-RESOURCES-MIB", "hrSWRunPerfGroup"), ("HOST-RESOURCES-MIB", "hrSWInstalledGroup"), ("HOST-RESOURCES-MIB", "hrSWRunGroup"), ("HOST-RESOURCES-MIB", "hrDeviceGroup"), ("HOST-RESOURCES-MIB", "hrSystemGroup"), ) )
if mibBuilder.loadTexts: hrMIBCompliance.setDescription("The requirements for conformance to the Host Resources MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("HOST-RESOURCES-MIB", PYSNMP_MODULE_ID=hostResourcesMibModule)

# Types
mibBuilder.exportSymbols("HOST-RESOURCES-MIB", InternationalDisplayString=InternationalDisplayString, KBytes=KBytes, ProductID=ProductID)

# Objects
mibBuilder.exportSymbols("HOST-RESOURCES-MIB", host=host, hrSystem=hrSystem, hrSystemUptime=hrSystemUptime, hrSystemDate=hrSystemDate, hrSystemInitialLoadDevice=hrSystemInitialLoadDevice, hrSystemInitialLoadParameters=hrSystemInitialLoadParameters, hrSystemNumUsers=hrSystemNumUsers, hrSystemProcesses=hrSystemProcesses, hrSystemMaxProcesses=hrSystemMaxProcesses, hrStorage=hrStorage, hrStorageTypes=hrStorageTypes, hrMemorySize=hrMemorySize, hrStorageTable=hrStorageTable, hrStorageEntry=hrStorageEntry, hrStorageIndex=hrStorageIndex, hrStorageType=hrStorageType, hrStorageDescr=hrStorageDescr, hrStorageAllocationUnits=hrStorageAllocationUnits, hrStorageSize=hrStorageSize, hrStorageUsed=hrStorageUsed, hrStorageAllocationFailures=hrStorageAllocationFailures, hrDevice=hrDevice, hrDeviceTypes=hrDeviceTypes, hrDeviceTable=hrDeviceTable, hrDeviceEntry=hrDeviceEntry, hrDeviceIndex=hrDeviceIndex, hrDeviceType=hrDeviceType, hrDeviceDescr=hrDeviceDescr, hrDeviceID=hrDeviceID, hrDeviceStatus=hrDeviceStatus, hrDeviceErrors=hrDeviceErrors, hrProcessorTable=hrProcessorTable, hrProcessorEntry=hrProcessorEntry, hrProcessorFrwID=hrProcessorFrwID, hrProcessorLoad=hrProcessorLoad, hrNetworkTable=hrNetworkTable, hrNetworkEntry=hrNetworkEntry, hrNetworkIfIndex=hrNetworkIfIndex, hrPrinterTable=hrPrinterTable, hrPrinterEntry=hrPrinterEntry, hrPrinterStatus=hrPrinterStatus, hrPrinterDetectedErrorState=hrPrinterDetectedErrorState, hrDiskStorageTable=hrDiskStorageTable, hrDiskStorageEntry=hrDiskStorageEntry, hrDiskStorageAccess=hrDiskStorageAccess, hrDiskStorageMedia=hrDiskStorageMedia, hrDiskStorageRemoveble=hrDiskStorageRemoveble, hrDiskStorageCapacity=hrDiskStorageCapacity, hrPartitionTable=hrPartitionTable, hrPartitionEntry=hrPartitionEntry, hrPartitionIndex=hrPartitionIndex, hrPartitionLabel=hrPartitionLabel, hrPartitionID=hrPartitionID, hrPartitionSize=hrPartitionSize, hrPartitionFSIndex=hrPartitionFSIndex, hrFSTable=hrFSTable, hrFSEntry=hrFSEntry, hrFSIndex=hrFSIndex, hrFSMountPoint=hrFSMountPoint, hrFSRemoteMountPoint=hrFSRemoteMountPoint, hrFSType=hrFSType, hrFSAccess=hrFSAccess, hrFSBootable=hrFSBootable, hrFSStorageIndex=hrFSStorageIndex, hrFSLastFullBackupDate=hrFSLastFullBackupDate, hrFSLastPartialBackupDate=hrFSLastPartialBackupDate, hrFSTypes=hrFSTypes, hrSWRun=hrSWRun, hrSWOSIndex=hrSWOSIndex, hrSWRunTable=hrSWRunTable, hrSWRunEntry=hrSWRunEntry, hrSWRunIndex=hrSWRunIndex, hrSWRunName=hrSWRunName, hrSWRunID=hrSWRunID, hrSWRunPath=hrSWRunPath, hrSWRunParameters=hrSWRunParameters, hrSWRunType=hrSWRunType, hrSWRunStatus=hrSWRunStatus, hrSWRunPerf=hrSWRunPerf, hrSWRunPerfTable=hrSWRunPerfTable, hrSWRunPerfEntry=hrSWRunPerfEntry, hrSWRunPerfCPU=hrSWRunPerfCPU, hrSWRunPerfMem=hrSWRunPerfMem, hrSWInstalled=hrSWInstalled, hrSWInstalledLastChange=hrSWInstalledLastChange, hrSWInstalledLastUpdateTime=hrSWInstalledLastUpdateTime, hrSWInstalledTable=hrSWInstalledTable, hrSWInstalledEntry=hrSWInstalledEntry, hrSWInstalledIndex=hrSWInstalledIndex, hrSWInstalledName=hrSWInstalledName, hrSWInstalledID=hrSWInstalledID, hrSWInstalledType=hrSWInstalledType, hrSWInstalledDate=hrSWInstalledDate, hrMIBAdminInfo=hrMIBAdminInfo, hostResourcesMibModule=hostResourcesMibModule, hrMIBCompliances=hrMIBCompliances, hrMIBGroups=hrMIBGroups)

# Groups
mibBuilder.exportSymbols("HOST-RESOURCES-MIB", hrSystemGroup=hrSystemGroup, hrStorageGroup=hrStorageGroup, hrDeviceGroup=hrDeviceGroup, hrSWRunGroup=hrSWRunGroup, hrSWRunPerfGroup=hrSWRunPerfGroup, hrSWInstalledGroup=hrSWInstalledGroup)

# Compliances
mibBuilder.exportSymbols("HOST-RESOURCES-MIB", hrMIBCompliance=hrMIBCompliance)
