% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.afex_aov.R
\name{afex_aov-methods}
\alias{afex_aov-methods}
\alias{anova.afex_aov}
\alias{print.afex_aov}
\alias{summary.afex_aov}
\alias{recover_data.afex_aov}
\alias{emm_basis.afex_aov}
\title{Methods for afex_aov objects}
\usage{
\method{anova}{afex_aov}(object, es = afex_options("es_aov"),
  observed = NULL, correction = afex_options("correction_aov"),
  MSE = TRUE, intercept = FALSE, p_adjust_method = NULL,
  sig_symbols = attr(object$anova_table, "sig_symbols"), ...)

\method{print}{afex_aov}(x, ...)

\method{summary}{afex_aov}(object, ...)

recover_data.afex_aov(object, ..., model = afex_options("emmeans_model"))

emm_basis.afex_aov(object, trms, xlev, grid, ...,
  model = afex_options("emmeans_model"))
}
\arguments{
\item{object, x}{object of class \code{afex_aov} as returned from \code{\link{aov_car}} and related functions.}

\item{es}{Effect Size to be reported. The default is given by
\code{afex_options("es_aov")}, which is initially set to \code{"ges"}
(i.e., reporting generalized eta-squared, see details). Also supported is
partial eta-squared (\code{"pes"}) or \code{"none"}.}

\item{observed}{character vector referring to the observed (i.e., non
manipulated) variables/effects in the design. Important for calculation of
generalized eta-squared (ignored if \code{es} is not \code{"ges"}), see
details.}

\item{correction}{Character. Which sphericity correction of the degrees of
freedom should be reported for the within-subject factors.  The default is
given by \code{afex_options("correction_aov")}, which is initially set to
\code{"GG"} corresponding to the Greenhouse-Geisser correction. Possible
values are \code{"GG"}, \code{"HF"} (i.e., Hyunh-Feldt correction), and
\code{"none"} (i.e., no correction).}

\item{MSE}{logical. Should the column containing the Mean Sqaured Error (MSE)
be displayed? Default is \code{TRUE}.}

\item{intercept}{logical. Should intercept (if present) be included in the
ANOVA table? Default is \code{FALSE} which hides the intercept.}

\item{p_adjust_method}{\code{character} indicating if p-values for individual effects should be adjusted for multiple comparisons (see \link[stats]{p.adjust} and details).}

\item{sig_symbols}{Character. What should be the symbols designating
significance? When entering an vector with \code{length(sig.symbol) < 4}
only those elements of the default (\code{c(" +", " *", " **", " ***")})
will be replaced. \code{sig_symbols = ""} will display the stars but not
the \code{+}, \code{sig_symbols = rep("", 4)} will display no symbols. The
default is given by \code{afex_options("sig_symbols")}.}

\item{...}{further arguments passed through, see description of return value for details.}

\item{model}{argument for \code{\link[emmeans]{emmeans}()} and rlated functions that allows to choose on which model the follow-up tests for ANOVAs with repeated-measures factors are based. \code{"univariate"} uses the \code{aov} model and \code{"multivariate"} uses the \code{lm} model. Default given by \code{afex_options("emmeans_mode")}. Multivariate tests likely provide a better correction for violations of sphericity.}

\item{trms, xlev, grid}{same as for \code{\link[emmeans]{emm_basis}}.}
}
\value{
\describe{
  \item{\code{anova}}{Returns an ANOVA table of class \code{c("anova", "data.frame")}. Information such as effect size (\code{es}) or df-correction are calculated each time this method is called.}
  \item{\code{summary}}{For ANOVAs containing within-subject factors it returns the full output of the within-subject tests: the uncorrected results, results containing Greenhousse-Geisser and Hyunh-Feldt correction, and the results of the Mauchly test of sphericity (all achieved via \code{summary.Anova.mlm}). For other ANOVAs, the \code{anova} table is simply returned.}
  \item{\code{print}}{Prints (and invisibly returns) the ANOVA table as constructed from \code{\link{nice}} (i.e., as strings rounded nicely). Arguments in \code{...} are passed to \code{nice} allowing to pass arguments such as \code{es} and \code{correction}.}
  \item{\code{recover_data} and \code{emm_basis}}{Provide the backbone for using \code{\link[emmeans]{emmeans}} and related functions from \pkg{emmeans} directly on \code{afex_aov} objects by returning a \code{\link[emmeans]{emmGrid-class}} object. Should not be called directly but through the functionality provided by \pkg{emmeans}.}
  
}
}
\description{
Methods defined for objects returned from the ANOVA functions \code{\link{aov_car}} et al. of class \code{afex_aov} containing both the ANOVA fitted via \code{car::Anova} and base R's \code{aov}.
}
\details{
Exploratory ANOVA, for which no detailed hypotheses have been specified a priori, harbor a multiple comparison problem (Cramer et al., 2015). To avoid an inflation of familywise Type I error rate, results need to be corrected for multiple comparisons using \code{p_adjust_method}.
\code{p_adjust_method} defaults to the method specified in the call to \code{\link{aov_car}} in \code{anova_table}. If no method was specified and \code{p_adjust_method = NULL} p-values are not adjusted.
}
\references{
Cramer, A. O. J., van Ravenzwaaij, D., Matzke, D., Steingroever, H., Wetzels, R., Grasman, R. P. P. P., ... Wagenmakers, E.-J. (2015). Hidden multiplicity in exploratory multiway ANOVA: Prevalence and remedies.  \emph{Psychonomic Bulletin & Review}, 1-8. doi:\href{http://doi.org/10.3758/s13423-015-0913-5}{10.3758/s13423-015-0913-5}
}
